/******************************************************************************
*
* FILE:          TunerDataHandler.h
* SW-COMPONENT:
* PROJECT:
* DESCRIPTION:   Data handling for Tuner
******************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#ifndef _TunerDataHandler_H_
#define _TunerDataHandler_H_

#include "ap-tuner-enums.h"


#include <stdlib.h>
#include <vector>
#include <string>
#include <glib.h>

typedef enum
{
    kSetBand = 0,
    kSetBandAndFreq,
    kSetBandNone
}ApSetBandType;

typedef struct
{
    ApTunerBand band;
    unsigned int u32Frequency;   //uint32
    unsigned int programID; // uint16
    unsigned char fieldStrength; //uint8
    std::string stationName;
    std::string stationText;
    unsigned int presetListID;   //uint16
    ApTunerProgramType programType;   //uint8
}stStationInfo;

class tclConfigSettings
{
private:
    bool bAMActive;
    bool bHDRadio;
    bool bRegion;
    bool bTA;
    bool bSeamlessSwitching;
    bool bTransportAnnouncement;
    bool bWarningAnnouncement;
    bool bNewsAnnouncement;
    bool bWeatherAnnouncement;
    bool bEventAnnouncement;
    bool bMusicalEventAnnouncement;
    bool bRadioInfoAnnouncement;
    bool bSportAnnouncement;
    bool bFinanceAnnouncement;
    bool bDABAvailability;

    static tclConfigSettings   *m_poConfigSettings;

public:
    static tclConfigSettings *getInstance();
    tclConfigSettings();
    ~tclConfigSettings();
    bool bGetAMActiveStatus() const;
    bool bGetHDRadioStatus() const;
    bool bGetRegionStatus() const;
    bool bGetTAStatus() const;
    bool bGetSeamlessSwitchingStatus() const;
    bool bGetTransportAnnouncementStatus() const;
    bool bGetWarningAnnouncementStatus() const;
    bool bGetNewsAnnouncementStatus() const;
    bool bGetWeatherAnnouncementStatus() const;
    bool bGetEventAnnouncementStatus() const;
    bool bGetMusicalEventAnnouncementStatus() const;
    bool bGeRadioInfoAnnouncementStatus() const;
    bool bGetSportAnnouncementStatus() const;
    bool bGetFinanceAnnouncementStatus() const;
    bool bGetDABAvailabilityStatus() const;


    void vSetAMActive(bool bStatus);
    void vSetHDRadio(bool bStatus);
    void vSetRegion(bool bStatus);
    void vSetTA(bool bStatus);
    void vSetSeamlessSwitching(bool bStatus);
    void vSetTransportAnnouncement(bool bStatus);
    void vSetWarningAnnouncement(bool bStatus);
    void vSetNewsAnnouncement(bool bStatus);
    void vSetWeatherAnnouncement(bool bStatus);
    void vSetEventAnnouncement(bool bStatus);
    void vSetMusicalEventAnnouncement(bool bStatus);
    void vSetRadioInfoAnnouncement(bool bStatus);
    void vSetSportAnnouncement(bool bStatus);
    void vSetFinanceAnnouncement(bool bStatus);
    void vSetDABAvailability(bool bStatus);
};

typedef struct
{
    ApTunerBand band;
    unsigned char index;
    unsigned int frequency;
    std::string stationName;
} stPresetElement;

void vUpdatePresetListDataHandler(std::vector<stPresetElement> presetList);
void vHandleGetStationListDataHandler(std::vector<unsigned int> stationList);
void vHandleUpdateStationListDataHandler(ApTunerBand eBand,
                                         std::vector<unsigned int> stationList);


void vUpdateStationInfo(stStationInfo arg_station_info);
void vUpdateConfigSettings(tclConfigSettings* arg_config_settings);
#endif
#endif //#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC