/*****************************************************************************
* FILE:         FC_Gateway_TunerDABClientHandler.h
* PROJECT:      G3G project
* SW-COMPONENT: genericgateway
* Template:     ClientHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#ifndef _FC_GATEWAY_TUNERDABCLIENTHANDLER_H_
#define _FC_GATEWAY_TUNERDABCLIENTHANDLER_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "ahl_BaseOneThreadClienthandler.h"
#include "procgenericgateway_tclMainApp.h"
#include "TunerDataHandler.h"

#define CMD_CNTR_SCAN_OPRN      101
#define CMD_CNTR_SETFREQ_OPRN   102

// FC_Gateway_TunerDABClientHandler_Include: user specific code start
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_STDVISITORS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_SERVICEINFO
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_ERRORCODES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_FI_TYPES

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_ext_fi_if.h"
// FC_Gateway_TunerDABClientHandler_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class ahl_tclBaseOneThreadClientHandler;
class procgenericgateway_tclMainApp;

class FC_Gateway_TunerDABClientHandler : public ahl_tclBaseOneThreadClientHandler
{

public:
    virtual const tChar* getName() const {
        return "FC_Gateway_TunerDABClientHandler"; };

    FC_Gateway_TunerDABClientHandler(procgenericgateway_tclMainApp* poMainAppl);
    virtual ~FC_Gateway_TunerDABClientHandler();

    static FC_Gateway_TunerDABClientHandler*
    getInstance(procgenericgateway_tclMainApp* poMainAppl);


    // FC_Gateway_TunerDABClientHandlerDeclarations: user specific code start
private:
    static FC_Gateway_TunerDABClientHandler*
    m_poFC_Gateway_TunerDABClientHandler;

    // FC_Gateway_TunerDABClientHandlerDeclarations: user specific code end

    /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class
   * 'FC_Gateway_TunerDABClientHandler' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
    FC_Gateway_TunerDABClientHandler& operator =
    (const FC_Gateway_TunerDABClientHandler &oClientHandler);

    /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
    virtual tVoid vOnServiceAvailable();
    virtual tVoid vOnServiceUnavailable();

public:

    /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/

    //virtual tBool sendFID_DAB_S_START_SCANMStart(tBool StartScan);
    virtual tBool sendFID_DAB_S_SRV_SELECTMStart(
            midw_ext_fi_tcl_e8_DAB_ChnSelectMode SelectMode,
            tU32 u32Value,
            tBool bNegative);

    virtual tBool sendFID_DAB_S_SEEK_SERVICEMStart(
            midw_ext_fi_tcl_e8_DAB_TuneCmd oTuneDirection);

    virtual tBool sendFID_DAB_S_TEST_OPERATIONMStart(
            midw_ext_fi_tcl_e8_DAB_TestOperation oTestOperation,
            tU32 u32Param1, tU32 u32Param2, tU32 u32Param3, 
			tU16 u16CmdCntr);

    bool bGetServiceList();
	
	tU32 u32GetCurrentFrequency();

private:
    /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/

    /*------------------------Status Updates---------------------------------*/
    virtual tVoid vHandleFID_DAB_G_TUNER_STATUSOpStatus(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleFID_DAB_G_AVAILABILITYOpStatus(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleFID_DAB_G_CHANNEL_INFOOpStatus(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleFID_DAB_G_LIST_UPDATEOpStatus(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleFID_DAB_G_ACTIVE_SERVICE_INFOOpStatus(
            amt_tclServiceData* poMessage);

    /*------------------------Method Result---------------------------------*/
    virtual tVoid vHandleFID_DAB_S_SEEK_SERVICEOpMResult(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleFID_DAB_S_TEST_OPERATIONOpMResult(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleFID_DAB_S_SRV_SELECTOpMResult(
            amt_tclServiceData* poMessage);

    /*--------------------Status Updates Handlers---------------------------*/
    virtual tVoid onFID_DAB_G_TUNER_STATUSStatus(
            midw_ext_fi_tcl_DAB_TunerStatus TunerStatus);

    virtual tVoid onFID_DAB_G_AVAILABILITYStatus(
            tBool bIsDABAvailable,
            midw_ext_fi_tcl_e8_DAB_SourceState e8SourceState);

    virtual tVoid onFID_DAB_G_CHANNEL_INFOStatus(
            midw_ext_fi_tcl_DAB_ChannelInfo &ChannelInfo);

    virtual tVoid onFID_DAB_G_ACTIVE_SERVICE_INFOStatus(
            midw_ext_fi_tcl_DAB_ServiceInfo &ServiceInfo);

    /*--------------------Method Result Handlers---------------------------*/
    virtual tVoid onFID_DAB_S_TEST_OPERATIONMResult(
            midw_ext_fi_tcl_e8_DAB_Response e8MethodResult,
			tU16 u16CmdCntr);

    virtual tVoid onFID_DAB_S_SRV_SELECTMResult(
            midw_ext_fi_tcl_e8_DAB_Response e8MethodResult);

    virtual tVoid onFID_DAB_S_SEEK_SERVICEMResult(
            midw_ext_fi_tcl_e8_DAB_Response oSeekResponse);

    virtual tVoid onFID_DAB_G_LIST_UPDATEStatus(
            midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus oStatus);

private:
    /***************************************************************************
   * value of each received status
   ***************************************************************************/

    std::vector <midw_ext_fi_tcl_DAB_ChnListElement,
    std::allocator<midw_ext_fi_tcl_DAB_ChnListElement> >
    _ChangedChnList_FID_DAB_G_LIST_UPDATEStatus;

    /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

    DECLARE_MSG_MAP(FC_Gateway_TunerDABClientHandler)

    /* FC_Gateway_TunerDABClientHandlerDeclarationsPart2:
       user specific code start*/

    private:
        //Main APP instance,
    procgenericgateway_tclMainApp *m_poMainApp;
    stStationInfo m_rStationInfo;
    bool m_bIsSeek;
    bool m_bIsScan;
    // FC_Gateway_TunerDABClientHandlerDeclarationsPart2: user specific code end

};

#endif // _FC_GATEWAY_TUNERDABCLIENTHANDLER_H_


#endif //#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
