/*******************************************************************************
*
* FILE:          FC_Gateway_TunerClientHandler.h
* SW-COMPONENT:  Tuner Gateway
* PROJECT:       Generic Gateay
* DESCRIPTION:   CCA client-handler for Tuner
*******************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#ifndef _FC_GATEWAY_TUNERCLIENTHANDLER_H_
#define _FC_GATEWAY_TUNERCLIENTHANDLER_H_


#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_midw_fi_EXTENSION
#include "ahl_if.h"

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_SERVICEINFO

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h"


#include "ahl_BaseOneThreadClienthandler.h"
#include "procgenericgateway_tclMainApp.h"
#include "ap-tuner-enums.h"
#include "TunerDataHandler.h"
#include "FC_Gateway_TunerMasterClientHandler.h"

class ahl_tclBaseOneThreadClientHandler;
class procgenericgateway_tclMainApp;

class FC_Gateway_TunerClientHandler     : public
        ahl_tclBaseOneThreadClientHandler
{
public:

    FC_Gateway_TunerClientHandler   (tVoid);
    FC_Gateway_TunerClientHandler   (procgenericgateway_tclMainApp* poMainAppl);

    virtual ~FC_Gateway_TunerClientHandler   ();

    // Overriding ahl_tclBaseOneThreadClientHandler methods.
    virtual tVoid vOnServiceAvailable();
    virtual tVoid vOnServiceUnavailable();

    static FC_Gateway_TunerClientHandler*
    getInstance(procgenericgateway_tclMainApp* poMainAppl);

    /* Registers with Service for properties status updates */
    tVoid vRegisterProperty();

    /* De-registers the  properties to stop receiving the status updates */
    tVoid vDeRegisterProperty();

    /* Registers with Service for properties status updates on HMI startup */
    tVoid vRegisterPropertyOnStartup();

    /* De-registers all the properties on termination */
    tVoid vDeRegisterAllProperty();
    
    void vSetSearchState(bool arg_bIsSearch)
    {
        m_bIsScan = arg_bIsSearch;
    }

    void vSetCancelState(bool arg_bIsCancel)
    {
        m_bIsCancel = arg_bIsCancel;
    }

    void vSetSeekState(bool arg_bIsSeek)
    {
        m_bIsSeek = arg_bIsSeek;
    }
	
	bool bGetSeekState()
    {
        return m_bIsSeek;
    }
	
	bool bGetSearchState()
    {
        return m_bIsScan;
    }

	bool bGetHDRadioStatus(tU8& u8HDRadioStatus); 
public:

    /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/

    virtual tBool sendFID_TUN_S_ATFREQUENCYMStart(
            midw_fi_tcl_e8_Tun_TunerHeader TunerHeader,
            midw_fi_tcl_TunerManualSingleStep TunerManualSingleStep,
            midw_fi_tcl_e8_Tun_AcceptAF u8AcceptAF);

    virtual tBool sendFID_TUN_S_ATSEEK_WITH_TUNERHEADERMStart(
            midw_fi_tcl_e8_Tun_TunerSeek u8TunerSeek,
            midw_fi_tcl_e8_Tun_TunerHeader u8TunerHeader,
            tU32 u32Frequency);

    virtual tBool sendFID_TUN_S_SET_FEATUREMStart(
            midw_fi_tcl_TunerFeature TunerFeature);

    virtual tBool sendFID_TUN_S_DIRECT_FREQUENCYMStart(
            tU32 u32Frequency,
            midw_fi_tcl_e8_Tun_TunerBand u8Band);

    virtual tBool sendFID_TUN_S_GET_CONFIG_LISTMStart(
            midw_fi_tcl_Tun_MakeConfigList TunMakeConfigList);

    virtual tBool sendFID_TUN_S_ANNOUNCEMENT_SWITCHMStart(
            midw_fi_tcl_b8_AnnoTypes b8AnnoType);

    virtual tBool sendFID_TUN_S_STATIONLIST_EXITMStart(
            midw_fi_tcl_e8_Tun_ConfigListID oConfigList);

    virtual tBool sendFID_TUN_S_SET_DEMODULATION_SWITCHMStart(
            midw_fi_tcl_b8_Tun_DemodSwitch DemodulationSwitch,
            midw_fi_tcl_b8_Tun_DemodSwitch b8DemodulationSwitchMask,
            midw_fi_tcl_b8_Tun_DemodSwitch b8DemodulationSwitchValue);
private:
    /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/

    /*------------------------Status Updates---------------------------------*/
    virtual tVoid vHandleFID_TUN_G_ATSTATIONINFOOpStatus(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleFID_TUN_G_RADIO_TEXTOpStatus(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleFID_TUN_G_LISTUPDATE_NOTIFICATIONOpStatus(
            amt_tclServiceData* poMessage);

    /*------------------------Method Result---------------------------------*/
    virtual tVoid vHandleFID_TUN_S_ATFREQUENCYOpMResult(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleFID_TUN_S_ATSEEK_WITH_TUNERHEADEROpMResult(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleFID_TUN_S_SET_FEATUREOpMResult(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleFID_TUN_S_DIRECT_FREQUENCYOpMResult(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleFID_TUN_S_GET_CONFIG_LISTOpMResult(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleFID_TUN_G_GET_CONFIG_LISTOpStatus(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleFID_TUN_S_ANNOUNCEMENT_SWITCHOpMResult(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleFID_TUN_S_SET_DEMODULATION_SWITCHOpMResult(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleFID_TUN_G_DEMODULATION_SWITCH_STATUSOpStatus(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleFID_TUN_G_SET_RDSREGOpStatus(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleFID_TUN_G_ATSEEKOpStatus(
            amt_tclServiceData* poMessage);


    /*--------------------Status Updates Handlers---------------------------*/
    virtual tVoid onFID_TUN_G_GET_CONFIG_LISTStatus(
            midw_fi_tcl_e8_Tun_ConfigListID e8ConfigListID,
            midw_fi_tcl_TunerConfigListElementList Tun_ConfigListElements);

    virtual tVoid onFID_TUN_G_ATSTATIONINFOStatus(
            midw_fi_tcl_Atstationinfo& Atstationinfo);

    virtual tVoid onFID_TUN_G_RADIO_TEXTStatus(
            midw_fi_tcl_TunerRadioText TunerRadioText);

    virtual tVoid onFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus(
            midw_fi_tcl_b8_Tun_DemodSwitch oDemodSwitch);

    virtual tVoid onFID_TUN_G_SET_RDSREGStatus(
            midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus oRegStatus);

    virtual tVoid onFID_TUN_G_ATSEEKStatus(
            midw_fi_tcl_e8_Tun_TunerSeek AtTunerSeek);



    /*--------------------Method Result Handlers---------------------------*/
    virtual tVoid onFID_TUN_S_ATFREQUENCYMResult(
            midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse);

    virtual tVoid onFID_TUN_S_ATSEEK_WITH_TUNERHEADERMResult(
            midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse);

    virtual tVoid onFID_TUN_S_SET_FEATUREMResult(
            midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse);

    virtual tVoid onFID_TUN_S_DIRECT_FREQUENCYMResult(
            midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse);

    virtual tVoid onFID_TUN_S_GET_CONFIG_LISTMResult(
            midw_fi_tcl_MakeConfigListElem TunMakeConfigListElem,
            midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse);

    virtual tVoid onFID_TUN_S_ANNOUNCEMENT_SWITCHMResult(
            midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse);

    virtual tVoid vHandleFID_TUN_S_STATIONLIST_EXITOpMResult(
            amt_tclServiceData* poMessage);

    virtual tVoid onFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus(bool bListUpdate);


private:
    //Private member variables
    stStationInfo                            _rStationInfo;
    bool m_bIsGetStationList;
    bool m_bIsStationListUpdate;
    bool m_bIsScan;
    bool m_bIsCancel;
    bool m_bIsSeek;

    /* Message map definition macro */
    DECLARE_MSG_MAP(FC_Gateway_TunerClientHandler);
    procgenericgateway_tclMainApp *m_poMainApp;

public:
    static FC_Gateway_TunerClientHandler   * m_poFC_Gateway_TunerClientHandler;
    void vSetGetStationListFlag(bool bStatus);
    void vSetHDRadio(bool bStatus);
    void vSetRegion(bool bRegVal);

};



#endif
#endif //#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
