/******************************************************************************
 *
 * FILE:          TunerControlDBusHandler.h
 *
 * PROJECT:       Generic Gateway
 *
 * DESCRIPTION:   Header file for Tuner DBus Server implementation
 *
 * AUTHOR:        BCP9KOR(RBEI/ECO2)
 *
 * COPYRIGHT:     (c) 2016 Robert Bosch GmbH, Hildesheim
 *
 *****************************************************************************/

#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#ifndef TUNER_CONTROL_DBUS_SERVER_IF_H
#define TUNER_CONTROL_DBUS_SERVER_IF_H

#include "Tuner_Control_generated.h"
#include <glib.h>

/* Handler for save preset method*/
gboolean handle_save_preset (TunerControl *object,
                             GDBusMethodInvocation *invocation,
                             guchar arg_index,
                             guchar arg_band,
                             guint arg_frequency,
                             guint arg_program_id,
                             guint arg_secondary_program_id);

/* Handler for tune method*/									 
gboolean handle_tune (TunerControl *object,
                      GDBusMethodInvocation *invocation,
                      guchar arg_direction,
                      guint arg_step_size);

/* Handler for cancel search method*/							
gboolean handle_cancel_search_stations (TunerControl *object,
                                        GDBusMethodInvocation *invocation);

/* Handler for cancel seek method*/														
gboolean handle_cancel_seek (TunerControl *object,
                             GDBusMethodInvocation *invocation);

/* Handler for search available stations method*/										  
gboolean handle_search_available_stations (TunerControl *object,
                                           GDBusMethodInvocation *invocation);

/* Handler for seek method*/															 
gboolean handle_seek (TunerControl *object,
                      GDBusMethodInvocation *invocation,
                      guchar arg_direction);

/* Handler for set band method*/								 
gboolean handle_set_band (TunerControl *object,
                          GDBusMethodInvocation *invocation,
                          guchar arg_band);

/* Handler for set configuration settings method*/	
gboolean handle_set_configuration_settings (TunerControl *object,
                                            GDBusMethodInvocation *invocation,
                                            GVariant *arg_settings);

/* Handler for set frequency method*/															  
gboolean handle_set_frequency (TunerControl *object,
                               GDBusMethodInvocation *invocation,
                               guchar arg_band,
                               guint arg_frequency);

/* Handler for tune to preset method*/											 
gboolean handle_tune_to_preset (TunerControl *object,
                                GDBusMethodInvocation *invocation,
                                GVariant *arg_preset_element);

/* Handler for tune to program ID method*/										  
gboolean handle_tune_to_program_id (TunerControl *object,
                                    GDBusMethodInvocation *invocation,
                                    guint arg_program_id);

#endif //TUNER_CONTROL_DBUS_SERVER_IF_H
#endif //#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC