/*****************************************************************************
* FILE:         FC_Gateway_TTSClientHandler.h
* PROJECT:      G3G project
* SW-COMPONENT: Generic Gateway
* DESCRIPTION:  TTS client handlers for the gateway           
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#ifndef _FC_GATEWAY_TTS_CLIENT_HANDLER_
#define _FC_GATEWAY_TTS_CLIENT_HANDLER_

#define SDS_FI_S_IMPORT_INTERFACE_SDS_TTSFI_TYPES
#define SDS_FI_S_IMPORT_INTERFACE_SDS_TTSFI_FUNCTIONIDS
#define SDS_FI_S_IMPORT_INTERFACE_SDS_TTSFI_ERRORCODES
#define SDS_FI_S_IMPORT_INTERFACE_SDS_TTSFI_SERVICEINFO

/*****************************************************************************/
/* INCLUDES                                                                  */
/*****************************************************************************/
#include "sds_fi_gen_if.h"
#include "ap-tts-enums.h"
#include "procgenericgateway_tclMainApp.h"


//class procgenericgateway_tclMainApp;
class most_fi_tcl_String;

/*****************************************************************************/
/*                                                                           */
/* CLASS DEFINITION                                                          */
/*                                                                           */
/*****************************************************************************/

class FC_Gateway_TTSClientHandler : public ahl_tclBaseOneThreadClientHandler
{
private:
    /* Private member variables*/
    procgenericgateway_tclMainApp* m_poMainApp;
    ApTtsState m_eCurrentTTSStatus;
    sds_ttsfi_tclMsgTTSStatusStatus m_oTTSStatus;

public:
    /*constructor*/
    FC_Gateway_TTSClientHandler(procgenericgateway_tclMainApp* poMainAppl);

    /*destructor*/
    virtual ~FC_Gateway_TTSClientHandler();


    /* Overriding ahl_tclBaseOneThreadClientHandler methods*/
    virtual tVoid vOnServiceAvailable();
    virtual tVoid vOnServiceUnavailable();

    /*Sends CCA Method start message*/
    tBool bPrepareVoiceOutput_MethodStart();
    tBool bSynthesizeSpeak_MethodStart(std::string sText);
    tBool bAbortPrompt_MethodStart();
    tBool bPausePrompt_MethodStart();
    tBool bContinuePrompt_MethodStart();

    /*Handlers for CCA method start result messages*/
    tVoid vHandlePrepareVoiceOutput(amt_tclServiceData* poMessage);
    tVoid vHandleSynthesizeSpeak(amt_tclServiceData* poMessage);
    tVoid vHandleAbortPrompt(amt_tclServiceData* poMessage);
    tVoid vHandlePausePrompt(amt_tclServiceData* poMessage);
    tVoid vHandleContinuePrompt(amt_tclServiceData* poMessage);
    tVoid vHandleTTsStatus(amt_tclServiceData* poMessage);

    /*Sends CCA Get message*/
    tBool bGetTTsStatus();

    /* Member variables*/
    static FC_Gateway_TTSClientHandler* m_poFC_Gateway_TTSClientHandler;


    /*Gets instance of handler object*/
    static FC_Gateway_TTSClientHandler*
    getInstance(procgenericgateway_tclMainApp* poMainAppl);

    sds_fi_tcl_e8_TTSStatus eGetCurrTTSStatus()
    {
        return m_oTTSStatus.TTSStatus;
    }


    /*Message map definition macro*/
    DECLARE_MSG_MAP (FC_Gateway_TTSClientHandler);
};


/*****************************************************************************/
/*                                                                           */
/* CLASS DEFINITION                                                          */
/*                                                                           */
/*****************************************************************************/
/* Class to store properties of speech */

class tclSpeechProperty
{
private:
    std::string m_sText;
    unsigned char m_cPriority;
    std::string m_sLanguage;
    int m_iVoiceRate;
    int m_iVolume;
    int m_iVoicePitch;
    unsigned char m_cVoiceCategory;
	int m_iPreferedVolume;
	int m_iPreferedVoiceRate;
public:
    /* constructor*/
    tclSpeechProperty();

    /* destructor*/
    ~tclSpeechProperty();

    /*Gets instance of speech property object*/
    static tclSpeechProperty* getInstance();

    static tclSpeechProperty* m_potclSpeechProperty;

    /* Setter function for speech property*/
    void vSetProperty(const char* arg_sText,
                      unsigned char arg_cPriority,
                      const char* arg_sLanguage,
                      int arg_iVoiceRate,
                      int arg_iVolume,
                      int arg_iVoicePitch,
                      unsigned char arg_cVoiceCategory);
	void vSetPreferences(int voice_rate,int volume);						
    /* Getter function for speech property*/
    std::string sGetText() const;
    unsigned char cGetPriority() const;
    std::string sGetLanguage() const;
    unsigned char cGetVoiceCategory()const;
    int iGetVoiceRate()const;
    int iVoicePitch()const;
    int iGetVolume()const;
   int iGetPreferedVolume() const;
   int iGetPreferedVoiceRate() const;
   bool bCheckVolumeRange() ;
};



#endif // _FC_GATEWAY_TTS_CLIENT_HANDLER_

#endif
