/******************************************************************************
 *
 * FILE:          TTSDBusHandler.h
 *
 * PROJECT:       Generic Gateway
 *
 * DESCRIPTION:   Header file for DBus Server implementation
 *
 * AUTHOR:        BCP9KOR(RBEI/ECO2)
 *
 * COPYRIGHT:     (c) 2015 Robert Bosch GmbH, Hildesheim
 *
 *****************************************************************************/

#ifndef TTS_DBUS_SERVER_IF_H
#define TTS_DBUS_SERVER_IF_H

#include "TextToSpeech_generated.h"

#include <glib.h>
#include <stdio.h>

/* Handler for request text to speech state method*/
gboolean
handle_request_text_to_speech (TextToSpeech *object,
                              GDBusMethodInvocation *invocation,
                              const gchar *arg_text_to_speak,
                              guchar arg_priority,
                              const gchar *arg_language,
                              gint arg_voice_rate,
                              gint arg_volume,
                              gint arg_voice_pitch,
                              guchar arg_voice_category);
                              
/* Handler for pause method*/
gboolean handle_pause (TextToSpeech *object,
                       GDBusMethodInvocation *invocation,
                       guint arg_session_id);
	 
/* Handler for resume method*/
gboolean handle_resume (TextToSpeech *object,
                        GDBusMethodInvocation *invocation,
                        guint arg_session_id);
/* Handler for cancel method*/
gboolean handle_cancel (TextToSpeech *object,
                        GDBusMethodInvocation *invocation,
                        guint arg_session_id);
 
/* Handler for set preferences*/
gboolean handle_set_preferences (TextToSpeech *object,
                                 GDBusMethodInvocation *invocation,
                                 GVariant *arg_preferences);
	 
/* Handler for get text to speech state method*/                    
gboolean
handle_get_text_to_speech_state(TextToSpeech *object,
                                  GDBusMethodInvocation *invocation,
                                  guint arg_session_id);

/******************************************************************************
 * Function:    vUninitializeTTS
 * Description: Unexports the interfaces and clears proxy object.
 * Parameters:  void
 * Return:      void
 *****************************************************************************/
void vUninitializeTTS();

#endif //TTS_DBUS_SERVER_IF_H
