/******************************************************************
*FILE: ap-sp-error-enums.c
*SW-COMPONENT: Internet
*DESCRIPTION: To register dbus error domain for tts manager.
*COPYRIGHT: © 20168 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#include <gio/gio.h>
#include "ap-sp-error-enums.h"

#define ERROR_PREFIX "com.bosch.AutomotiveProxy.SPError."

static const GDBusErrorEntry error_entries[] =
{
    {
     	        AP_SP_ERROR_INTERNAL,
        ERROR_PREFIX "Internal Error"
    },
    {
   		AP_SP_ERROR_SPMW_UNAVAILABLE,
        ERROR_PREFIX "SPMW Unavailable"
    },
};


GQuark
ap_sp_error_quark (void)
{
  static volatile gsize id = 0;

  g_dbus_error_register_error_domain ("ap-sp-error-quark", &id,
                                      error_entries,
                                      G_N_ELEMENTS (error_entries));

  return (GQuark) id;
}
