/******************************************************************************
*
* FILE:          MessageDataTyes.c
*
* PROJECT:       FC_GENERIC_GATEWAY
*
* DESCRIPTION:   Message data types utility 
*
* AUTHOR:        RHK6KOR(RBEI/ECO2)
*
* COPYRIGHT:     (c) 2016 Robert Bosch GmbH, Hildesheim
*
******************************************************************************/

#include "MessageDataTypes.h"

#include <stdlib.h>

#ifdef __cplusplus
extern "C"
{
#endif
void vInitializeSMSData(SMSData *arg_SMSData)
{
    arg_SMSData->u16DeviceHandle = 0;
    arg_SMSData->u16MessageHandle = 0;
    arg_SMSData->u16ListHandle = 0;
    arg_SMSData->poFromPhoneNumber = NULL;
    arg_SMSData->poTimeStamp = NULL;
    arg_SMSData->bRead = false;
    arg_SMSData->poToPhoneNumber = NULL;
    arg_SMSData->poMessage = NULL;
    arg_SMSData->eSMSState = AP_TELEPHONY_SMS_STATE_UNKOWN;
    arg_SMSData->eDeliveryState =
            AP_TELEPHONY_SMS_DELIVERY_STATUS_NOTAPPLICABLE;
    arg_SMSData->poDeliveryTimeStamp = NULL;
}
#ifdef __cplusplus
}
#endif //__cplusplus

void vCleanSMSData(SMSData *arg_SMSData)
{
    if(arg_SMSData->poFromPhoneNumber != NULL)
    {
        free(arg_SMSData->poFromPhoneNumber);
        arg_SMSData->poFromPhoneNumber = NULL;
    }

    if(arg_SMSData->poTimeStamp != NULL)
    {
        free(arg_SMSData->poTimeStamp);
        arg_SMSData->poTimeStamp = NULL;
    }

    if(arg_SMSData->poToPhoneNumber != NULL)
    {
        free(arg_SMSData->poToPhoneNumber);
        arg_SMSData->poToPhoneNumber = NULL;
    }

    if(arg_SMSData->poMessage != NULL)
    {
        free(arg_SMSData->poMessage);
        arg_SMSData->poMessage = NULL;
    }

    if(arg_SMSData->poDeliveryTimeStamp != NULL)
    {
        free(arg_SMSData->poDeliveryTimeStamp);
        arg_SMSData->poDeliveryTimeStamp = NULL;
    }
}
