/******************************************************************************
*
* FILE:          FC_Gateway_PhoneClientHandler.cpp
*
* SW-COMPONENT:  FC_GENERIC_GATEWAY phone
*
* PROJECT:       FC_GENERIC_GATEWAY
*
* AUTHOR:        KRJ5KOR(RBEI/ECO2)
*
* DESCRIPTION:   CCA client-handler for phone
* History :
*	Date 	    | Name 	                    |  Description
*   20-07-2016    Ashwini Savadi RBEI/ECO22    Added changes for SendMessage
                                               and GetMessage
*   16-09-2016    Ashwini Savadi RBEI/ECO22    a.Handled Callduration in
                                               vHandleCallStatusNoticeOpStatus()
                                               b.Added Method
                                          vHandleQueryTelephoneNumberOpMResult()
                                          vHandleQueryTelephoneNumberOpMError()
                                          vHandleCellSignalStrengthOpStatus()
                                          vHandleCellSignalStrengthOpError()
*******************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_ERRORCODES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_SERVICEINFO

#define FI_S_IMPORT_INTERFACE_FI_VERSION
#include "fi_msgfw_if.h"



#include "FC_Gateway_PhoneClientHandler.h"
#include "PhoneDataTypes.h"
#include "procgenericgateway_tclMainApp.h"
#include "Utility.h"
#include "Phone_ClientInterface.h"
//Dlt
#include "dlt/dlt.h"
//Dlt Context
DLT_IMPORT_CONTEXT(AGW_Phone);

fc_gateway_tcl_phoneclienthandler*
fc_gateway_tcl_phoneclienthandler::m_pofc_gateway_tcl_phoneclienthandler = NULL;

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

#define PHN_C_CMD_COUNTER 0
#define CALL_STATUS_NOTICE_FUNCTION_ID 514 //0x202 see the FI xml


/* CCA Message Map - Maps the Function ID, Opcode and Function handler */
BEGIN_MSG_MAP(fc_gateway_tcl_phoneclienthandler, ahl_tclBaseWork)

/* Phone Service method - Dial Call */
ON_MESSAGE_SVCDATA(MOST_TELFI_C_U16_DIAL,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vDialCallResult)

ON_MESSAGE_SVCDATA(MOST_TELFI_C_U16_DIAL,
                   AMT_C_U8_CCAMSG_OPCODE_ERROR,
                   vDialCallError)

/* Phone Service method - HangUpCall */
ON_MESSAGE_SVCDATA(MOST_TELFI_C_U16_HANGUPCALL,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHangUpCallResult)

ON_MESSAGE_SVCDATA(MOST_TELFI_C_U16_HANGUPCALL,
                   AMT_C_U8_CCAMSG_OPCODE_ERROR,
                   vHangUpCallError)

/* Phone Service method - Get TelephoneNumber */
ON_MESSAGE_SVCDATA(MOST_TELFI_C_U16_QUERYTELEPHONENUMBER,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHandleQueryTelephoneNumberOpMResult)
ON_MESSAGE_SVCDATA(MOST_TELFI_C_U16_QUERYTELEPHONENUMBER,
                   AMT_C_U8_CCAMSG_OPCODE_ERROR,
                   vHandleQueryTelephoneNumberOpMError)

/* Phone Service Status - CallStatusNotice */
ON_MESSAGE_SVCDATA(MOST_TELFI_C_U16_CALLSTATUSNOTICE,
                   AMT_C_U8_CCAMSG_OPCODE_STATUS ,
                   vHandleCallStatusNoticeOpStatus)

ON_MESSAGE_SVCDATA(MOST_TELFI_C_U16_CALLSTATUSNOTICE,
                   AMT_C_U8_CCAMSG_OPCODE_ERROR,
                   vHandleCallStatusNoticeOpError)

/* Phone Service Property - Cell Network Signal Strength */
ON_MESSAGE_SVCDATA(MOST_TELFI_C_U16_CELLSIGNALSTRENGTH,
                   AMT_C_U8_CCAMSG_OPCODE_STATUS,
                   vHandleCellSignalStrengthOpStatus)
ON_MESSAGE_SVCDATA(MOST_TELFI_C_U16_CELLSIGNALSTRENGTH,
                   AMT_C_U8_CCAMSG_OPCODE_ERROR,
                   vHandleCellSignalStrengthOpError)
END_MSG_MAP()

/******************************************************************************
* Function:    getInstance
* Description: singleton. Function to get phone client-handler instance
* Parameters:  main app pointer
* Return:      fc_gateway_tcl_phoneclienthandler instance pointer
******************************************************************************/

fc_gateway_tcl_phoneclienthandler*
fc_gateway_tcl_phoneclienthandler::getInstance(procgenericgateway_tclMainApp
                                               *poMainAppl)
{

    if(m_pofc_gateway_tcl_phoneclienthandler == NULL)
    {
        m_pofc_gateway_tcl_phoneclienthandler =
                new fc_gateway_tcl_phoneclienthandler(poMainAppl);
    }

    return m_pofc_gateway_tcl_phoneclienthandler;
}

/******************************************************************************
* Function:    fc_gateway_tcl_phoneclienthandler
* Description: Constructor
* Parameters:  main app pointer
* Return:      none
******************************************************************************/

fc_gateway_tcl_phoneclienthandler::fc_gateway_tcl_phoneclienthandler(
        procgenericgateway_tclMainApp *poMainAppl)
    :ahl_tclBaseOneThreadClientHandler(
          (ahl_tclBaseOneThreadApp*)poMainAppl,
          CCA_C_U16_SRV_FB_TELEPHONE,
          MOST_TELFI_C_U16_SERVICE_MAJORVERSION,
          MOST_TELFI_C_U16_SERVICE_MINORVERSION)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phoneclienthandler : "),
            DLT_STRING( __FUNCTION__));

    m_lastCallRequest = kNotifyCallStatus;
    m_bIsServiceAvailable = FALSE;
    for(int iItr = 0 ; iItr < AP_MAX_CALLS_ALLOWED; iItr++)
    {
        strTelePhoneNum[iItr].assign("");
    }

    vAddAutoRegisterForProperty(MOST_TELFI_C_U16_CALLSTATUSNOTICE);
    vAddAutoRegisterForProperty(MOST_TELFI_C_U16_CELLSIGNALSTRENGTH);
}

/******************************************************************************
* Function:    fc_gateway_tcl_phoneclienthandler
* Description: Destructor
* Parameters:  None
* Return:      None
******************************************************************************/

fc_gateway_tcl_phoneclienthandler::~fc_gateway_tcl_phoneclienthandler()
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phoneclienthandler Destructor :  "),
            DLT_STRING( __FUNCTION__));


    if(m_pofc_gateway_tcl_phoneclienthandler!= NULL)
    {
        delete m_pofc_gateway_tcl_phoneclienthandler;
        m_pofc_gateway_tcl_phoneclienthandler = NULL;
    }
    vRemoveAutoRegisterForProperty(MOST_TELFI_C_U16_CALLSTATUSNOTICE);
    vRemoveAutoRegisterForProperty(MOST_TELFI_C_U16_CELLSIGNALSTRENGTH);
}

/*******************************************************************************
 * Function:		bIsServiceAvailable
 * Description:		is Service available
 * Parameters:		tVoid
 * Return:			bool
 ******************************************************************************/
bool fc_gateway_tcl_phoneclienthandler::bIsPhnServiceAvailable()
{
    return m_bIsServiceAvailable;
}

/******************************************************************************
* Function:    vOnServiceAvailable
* Description: Over-riding base class function On service available
* Parameters:  None
* Return:      None
******************************************************************************/

tVoid fc_gateway_tcl_phoneclienthandler::vOnServiceAvailable()
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phoneclienthandler : "),
            DLT_STRING( __FUNCTION__));

    m_bIsServiceAvailable = TRUE;
    vExportCallManagerInterface();
    vExportContactManagerInterface();
}

/******************************************************************************
* Function:    vOnServiceUnavailable
* Description: Over-riding base class function On service unavailable
* Parameters:  None
* Return:      None
******************************************************************************/
tVoid fc_gateway_tcl_phoneclienthandler::vOnServiceUnavailable()
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phoneclienthandler : "),
            DLT_STRING( __FUNCTION__));

    m_bIsServiceAvailable = FALSE;
    vUnexportCallManagerInterface();
    vUnexportContactManagerInterface();
}

/******************************************************************************
* Function:    vDialCall_Method
* Description: Wrapper function to call Dail method of phone client-handler
* Parameters:  phone number
* Return:      boolean
******************************************************************************/
//FIXME: refactor the functions below
bool vDialCall_Method(const char *PhoneNumber)
{
    fc_gateway_tcl_phoneclienthandler*
            phoneObj = fc_gateway_tcl_phoneclienthandler::getInstance(
                procgenericgateway_tclMainApp::poGetInstance());

    phoneObj->vDialCall_MethodStart(PhoneNumber);
    return TRUE;
}

/******************************************************************************
* Function:    vDialCall_Method
* Description: Wrapper function to call Hangup method of phone client-handler
* Parameters:  call instance
* Return:      boolean
******************************************************************************/
bool vHangUpCall_Method(unsigned int u16callInstance)
{
    fc_gateway_tcl_phoneclienthandler*
            phoneObj = fc_gateway_tcl_phoneclienthandler::getInstance(
                procgenericgateway_tclMainApp::poGetInstance());

    phoneObj->vHangUpCall_MethodStart((tU16)u16callInstance);
    return TRUE;
}

/******************************************************************************
* Function:    vGetPhoneNumber
* Description: Gets phone number from call instance.
* Parameters:  call instance
* Return:      boolean
******************************************************************************/
void vGetPhoneNumber(unsigned int corfu16CallInstance)
{
    fc_gateway_tcl_phoneclienthandler*
            phoneObj = fc_gateway_tcl_phoneclienthandler::getInstance(
                procgenericgateway_tclMainApp::poGetInstance());

    phoneObj->vGetPhoneNumberStart((tU16)corfu16CallInstance);
}

/******************************************************************************
* Function:    fc_gateway_tcl_phoneclienthandler::vDialCall_MethodStart
* Parameters:  phone number
* Description: CCA client-handler method to post dail call to phone component
* Return:      boolean
*******************************************************************************/
bool fc_gateway_tcl_phoneclienthandler::vDialCall_MethodStart(const char*
                                                              PhoneNumber)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phoneclienthandler : "),
            DLT_STRING( __FUNCTION__));

    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("Telephone number : "),DLT_STRING( PhoneNumber));


    most_telfi_tclMsgDialMethodStart oMsgDialCallMethodStart;
    oMsgDialCallMethodStart.sTelephoneNumber.bSet (
                PhoneNumber,
                most_fi_tcl_String::FI_EN_UTF8);

    fi_tclVisitorMessage oVisitorMsg(oMsgDialCallMethodStart,
                                     MOST_TELFI_C_U16_SERVICE_MAJORVERSION);

    /* Sets the CCA message header fields */
    vInitServiceData(oVisitorMsg, // ServiceDataMsg
                     PHN_C_CMD_COUNTER, // CmdCounter
                     MOST_TELFI_C_U16_DIAL, // Function ID
                     AMT_C_U8_CCAMSG_OPCODE_METHODSTART); // Opcode

    if(NULL != _poMainAppl)
    {
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                DLT_STRING("fc_gateway_tcl_phoneclienthandler :"\
                           "Posting DialCall Method Start Msg"));


        ail_tenCommunicationError
                enResult = _poMainAppl->enPostMessage(&oVisitorMsg, TRUE);

        if (AIL_EN_N_NO_ERROR != enResult)
        {
            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                    DLT_STRING("fc_gateway_tcl_phoneclienthandler : DialCall"));
            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,DLT_STRING("Post Message Error = "),
                    DLT_INT(enResult));

            return FALSE;
        }
        else
        {
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                    DLT_STRING("fc_gateway_tcl_phoneclienthandler :"\
                               "successfully requested for Dial"));
        }
    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                DLT_STRING("F_gateway_tcl_phoneclienthandler:"));
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                DLT_STRING( __FUNCTION__));
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                DLT_STRING("_poMainAppl NULL Pointer"));


        return FALSE;
    }
    oMsgDialCallMethodStart.vDestroy();

    return TRUE;
}

/******************************************************************************
* Function:    fc_gateway_tcl_phoneclienthandler::vHangUpCall_MethodStart
* Parameters:  Call Instance
* Description: CCA client-handler method to post hangup call to phone component
* Return:      boolean
*******************************************************************************/
bool
fc_gateway_tcl_phoneclienthandler::vHangUpCall_MethodStart(tU16 u16CallInstance)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("btphn_tclPhoneClientHandler:"),
            DLT_STRING( __FUNCTION__));
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Call instance : "),
            DLT_INT( u16CallInstance));

    most_telfi_tclMsgHangUpCallMethodStart oMsgHangUpCallMethodStart;

    oMsgHangUpCallMethodStart.u16CallInstance = u16CallInstance;

    fi_tclVisitorMessage oVisitorMsg(oMsgHangUpCallMethodStart,
                                     MOST_TELFI_C_U16_SERVICE_MAJORVERSION);

    /* Sets the CCA message header fields */
    vInitServiceData(oVisitorMsg, // ServiceDataMsg
                     PHN_C_CMD_COUNTER, // CmdCounter
                     MOST_TELFI_C_U16_HANGUPCALL, // Function ID
                     AMT_C_U8_CCAMSG_OPCODE_METHODSTART); // Opcode

    if(NULL != _poMainAppl)
    {
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                DLT_STRING("fc_gateway_tcl_phoneclienthandler:"\
                           "Posting HangUp MethodStart Msg"));


        ail_tenCommunicationError
                enResult = _poMainAppl->enPostMessage(&oVisitorMsg, TRUE);

        if (AIL_EN_N_NO_ERROR != enResult)
        {
            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                    DLT_STRING("fc_gateway_tcl_phoneclienthandler:HangUpCall"));
            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                    DLT_STRING("MethodStart Post Message Error = "),
                    DLT_INT(enResult));

            return FALSE;
        }
        else
        {
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                    DLT_STRING("successfully requested for HangUp Call"));
        }
    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                DLT_STRING("fc_gateway_tcl_phoneclienthandler :"\
                           "_poMainAppl NULL Pointer"),
                DLT_STRING( __FUNCTION__));

        return FALSE;
    }
    oMsgHangUpCallMethodStart.vDestroy();
    return TRUE;

}

/*******************************************************************************
 * Function:     vGetPhoneNumberStart
 * Description:  Function to get phone number. (Calls CCA method)
 * Parameters:   tU16
 * Return:       void
 ******************************************************************************/
tVoid fc_gateway_tcl_phoneclienthandler::vGetPhoneNumberStart(
        tU16 corfu16CallInstance)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phoneclienthandler : "),
            DLT_STRING( __FUNCTION__));

    DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Call instance : "),
            DLT_INT( corfu16CallInstance));

    fc_gateway_tcl_phoneclienthandler*
            poMessageObj = fc_gateway_tcl_phoneclienthandler::getInstance(
                procgenericgateway_tclMainApp::poGetInstance());

    DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Service Availablity status : "),
            DLT_INT( poMessageObj->bIsPhnServiceAvailable()));

    most_telfi_tclMsgQueryTelephoneNumberMethodStart
            oMsgQueryTelephoneNumberMethodStart;

    if(poMessageObj->bIsPhnServiceAvailable())
    {
        oMsgQueryTelephoneNumberMethodStart.u16CallInstance =
                corfu16CallInstance;

        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,DLT_STRING("CallInstance = "),
                DLT_INT( oMsgQueryTelephoneNumberMethodStart.u16CallInstance));

        fi_tclVisitorMessage oVisitorMsg(oMsgQueryTelephoneNumberMethodStart,
                                         MOST_TELFI_C_U16_SERVICE_MAJORVERSION);

        /* Sets the CCA message header fields */
        vInitServiceData(oVisitorMsg, // ServiceDataMsg
                         PHN_C_CMD_COUNTER, // CmdCounter
                         MOST_TELFI_C_U16_QUERYTELEPHONENUMBER, // Function ID
                         AMT_C_U8_CCAMSG_OPCODE_METHODSTART); // Opcode

        if(NULL != _poMainAppl)
        {
            DLT_LOG(AGW_Phone,DLT_LOG_INFO
                    ,DLT_STRING("fc_gateway_tcl_phoneclienthandler :"\
                                "Posting GetTelephoneNumberMethodStart Msg"));

            ail_tenCommunicationError
                    enResult = _poMainAppl->enPostMessage(&oVisitorMsg, TRUE);

            if (AIL_EN_N_NO_ERROR != enResult)
            {
                DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                        DLT_STRING("fc_gateway_tcl_phoneclienthandler :"\
                                   "Post Message Error ="),DLT_INT(enResult));

                DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                        DLT_STRING( "unable to post getphone number message"));
            }
        }
    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                DLT_STRING("fc_gateway_tcl_phoneclienthandler :"\
                           "vGetPhoneNumberStart() Phone Service Unavailable"));

    }
    oMsgQueryTelephoneNumberMethodStart.vDestroy();
}
/******************************************************************************
* Function:    fc_gateway_tcl_phoneclienthandler::vRegisterProperty()
* Description: Register for a property
* Parameters:  void
* Return:      void
*******************************************************************************/
tVoid fc_gateway_tcl_phoneclienthandler::vRegisterProperty()
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phoneclienthandler : "),
            DLT_STRING( __FUNCTION__));
}

/******************************************************************************
* Function:    fc_gateway_tcl_phoneclienthandler::vDeRegisterProperty()
* Description: Unregister for a property
* Parameters:  void
* Return:      void
*******************************************************************************/
tVoid fc_gateway_tcl_phoneclienthandler::vDeRegisterProperty()
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phoneclienthandler : "),
            DLT_STRING( __FUNCTION__));
}

/******************************************************************************
* Function:    fc_gateway_tcl_phoneclienthandler::vRegisterPropertyOnStartup()
* Description: Register for a properties on start up
* Parameters:  void
* Return:      void
*******************************************************************************/
tVoid fc_gateway_tcl_phoneclienthandler::vRegisterPropertyOnStartup()
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phoneclienthandler : "),
            DLT_STRING( __FUNCTION__));

    /* Call Status Notice */
    vAddAutoRegisterForProperty(MOST_TELFI_C_U16_CALLSTATUSNOTICE);
}

/******************************************************************************
* Function:    fc_gateway_tcl_phoneclienthandler::vDeRegisterAllProperty()
* Description: Unregister for all property
* Parameters:  void
* Return:      void
*******************************************************************************/
tVoid fc_gateway_tcl_phoneclienthandler::vDeRegisterAllProperty()
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phoneclienthandler : "),
            DLT_STRING( __FUNCTION__));

    vDeRegisterProperty();
    vRemoveAutoRegisterForProperty(MOST_TELFI_C_U16_CALLSTATUSNOTICE);
}

/******************************************************************************
* Function:    fc_gateway_tcl_phoneclienthandler::vDialCallResult()
* Description: Dail call result callback
* Parameters:  amt_tclServiceData *poMessage
* Return:      void
*******************************************************************************/
tVoid fc_gateway_tcl_phoneclienthandler::vDialCallResult(
        amt_tclServiceData *poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phoneclienthandler : "),
            DLT_STRING( __FUNCTION__));


    fi_tclVisitorMessage oVisitorMsg(poMessage);
    most_telfi_tclMsgDialMethodResult oMsgDialCallMethodResult;

    /* Fills the CCA msg data from Phone service into
      oMsgResumeCallMethodResult */
    tS32 s32Result = oVisitorMsg.s32GetData(
                oMsgDialCallMethodResult,
                MOST_TELFI_C_U16_SERVICE_MAJORVERSION
                );
    if(OSAL_ERROR != s32Result)
    {
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Call Instance = "),
                DLT_INT(oMsgDialCallMethodResult.u16CallInstance),
                DLT_STRING("Call Status = "),
                DLT_INT(oMsgDialCallMethodResult.e8CallStatus.enType));

    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                DLT_STRING("fc_gateway_tcl_phoneclienthandler: vDialCallResult"\
                           "Retrieve Message Error = "),DLT_INT(s32Result));

    }
    oMsgDialCallMethodResult.vDestroy();
}


/******************************************************************************
* Function:    fc_gateway_tcl_phoneclienthandler::vDialCallError()
* Description: Dail call error callback
* Parameters:  amt_tclServiceData *poMessage
* Return:      void
*******************************************************************************/
tVoid
fc_gateway_tcl_phoneclienthandler::vDialCallError(amt_tclServiceData*
                                                  poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phoneclienthandler : "),
            DLT_STRING( __FUNCTION__));

    fi_tclVisitorMessage oVisitorMsg( poMessage );
    tU8 u8ErrorCode;

    most_telfi_tclMsgDialError oDialError;

    if(oVisitorMsg.s32GetData(oDialError, MOST_TELFI_C_U16_SERVICE_MINORVERSION)
            != OSAL_ERROR)
    {
        u8ErrorCode= (tU8)oDialError.e8ErrorCode.enType;


        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                DLT_STRING("Error Code received - "),DLT_INT( u8ErrorCode));
    }
    else
    {
        u8ErrorCode= CCA_C_U16_ERROR_VERSION_NOT_SUPPORTED;
    }

    oDialError.vDestroy();
}

/******************************************************************************
* Function:    fc_gateway_tcl_phoneclienthandler::vHangUpCallResult()
* Description: HangUpCall result callback
* Parameters:  amt_tclServiceData *poMessage
* Return:      void
*******************************************************************************/
tVoid fc_gateway_tcl_phoneclienthandler::vHangUpCallResult(amt_tclServiceData*
                                                           poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phoneclienthandler : "),
            DLT_STRING( __FUNCTION__));

    fi_tclVisitorMessage oVisitorMsg(poMessage);
    most_telfi_tclMsgHangUpCallMethodResult oMsgHangUpCallMethodResult;

    /* Fills the CCA msg data from Phone service into
      oMsgHangUpCallMethodResult */
    tS32 s32Result = oVisitorMsg.s32GetData(
                oMsgHangUpCallMethodResult,
                MOST_TELFI_C_U16_SERVICE_MAJORVERSION
                );
    if(OSAL_ERROR != s32Result)
    {
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Call Instance = "),
                DLT_INT(oMsgHangUpCallMethodResult.u16CallInstance));

        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Call Status = "),
                DLT_INT(oMsgHangUpCallMethodResult.e8CallStatus.enType));

        vHangUpMResult();
    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                DLT_STRING("fc_gateway_tcl_phoneclienthandler :"\
                           "vHangUpCallResult Retrieve Message Error = "),
                DLT_INT(s32Result));

    }
    oMsgHangUpCallMethodResult.vDestroy();
}

/******************************************************************************
* Function:    fc_gateway_tcl_phoneclienthandler::vHangUpCallError()
* Description: Error callback for hangup call
* Parameters:  amt_tclServiceData *poMessage
* Return:      void
*******************************************************************************/
tVoid fc_gateway_tcl_phoneclienthandler::vHangUpCallError(amt_tclServiceData*
                                                          poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phoneclienthandler : "),
            DLT_STRING( __FUNCTION__));

    fi_tclVisitorMessage oVisitorMsg( poMessage );
    tU8 u8ErrorCode;

    most_telfi_tclMsgHangUpCallError oHangUpError;

    if(oVisitorMsg.s32GetData(oHangUpError,
                              MOST_TELFI_C_U16_SERVICE_MINORVERSION)
            != OSAL_ERROR)
    {
        u8ErrorCode= (tU8)oHangUpError.e8ErrorCode.enType;
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Error Code received - "),
                DLT_INT( u8ErrorCode));

        switch(u8ErrorCode)
        {
        case MOST_TELFI_C_U16_ERROR_FBLOCKIDNOTAVAILABLE:
            vHangUpMError(AP_TELEPHONY_ERROR_UNKNOWN_SOURCE);
            break;
        case MOST_TELFI_C_U16_ERROR_INSTIDNOTAVAILABLE:
            vHangUpMError(AP_TELEPHONY_ERROR_UNKNOWN_SOURCE);
            break;
        case MOST_TELFI_C_U16_ERROR_FKTIDNOTAVAILABLE:
            vHangUpMError(AP_TELEPHONY_ERROR_UNKNOWN_SOURCE);
            break;
        case MOST_TELFI_C_U16_ERROR_OPTYPENOTAVAILABLE:
            vHangUpMError(AP_TELEPHONY_ERROR_UNKNOWN_SOURCE);
            break;
        case MOST_TELFI_C_U16_ERROR_INVALIDLENGTH:
            vHangUpMError(AP_TELEPHONY_ERROR_INVALID_ATTRIBUTE_VALUE);
            break;
        case MOST_TELFI_C_U16_ERROR_PARAMETERWRONG_OUTOFRANGE :
            vHangUpMError(AP_TELEPHONY_ERROR_INVALID_ATTRIBUTE_VALUE);
            break;
        case MOST_TELFI_C_U16_ERROR_PARAMETERNOTAVAILABLE :
            vHangUpMError(AP_TELEPHONY_ERROR_ATTRIBUTE_UNAVAILABLE);
            break;
        case MOST_TELFI_C_U16_ERROR_PARAMETERMISSING:
            vHangUpMError(AP_TELEPHONY_ERROR_ATTRIBUTE_UNAVAILABLE);
            break;
        case MOST_TELFI_C_U16_ERROR_TOOMANYPARAMETERS:
            vHangUpMError(AP_TELEPHONY_ERROR_BAD_CALL_INSTANCE);
            break;
        case MOST_TELFI_C_U16_ERROR_FUNCTIONSPECIFIC :
            vHangUpMError(AP_TELEPHONY_ERROR_INVALID_HANDLE);
            break;
        case MOST_TELFI_C_U16_ERROR_BUSY :
            vHangUpMError(AP_TELEPHONY_ERROR_INVALID_HANDLE);
            break;
        case MOST_TELFI_C_U16_ERROR_NOTAVAILABL :
            vHangUpMError(AP_TELEPHONY_ERROR_UNKNOWN_SOURCE);
            break;
        default:
            vHangUpMError(AP_TELEPHONY_ERROR_UNKNOWN_SOURCE);
            break;
        }
    }
    else
    {
        u8ErrorCode= CCA_C_U16_ERROR_VERSION_NOT_SUPPORTED;
    }

    oHangUpError.vDestroy();
}

/*******************************************************************************
 *
 * FUNCTION     :  eGetMappedStatus(..)
 *
 * DESCRIPTION  :  converts the component enum to gateway enum.
 *
 * PARAMETER    :  IN:most_fi_tcl_e8_TelCallStatus:
 *                 OUT: btphn_callStatusG (Gateway status)
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
ApTelephonyCallState fc_gateway_tcl_phoneclienthandler::
eConvertComponentStatusToGatewayStatus(most_fi_tcl_e8_TelCallStatus
                                       eComponentStatus)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phoneclienthandler : "),
            DLT_STRING( __FUNCTION__));

    switch(eComponentStatus.enType)
    {
    case most_fi_tcl_e8_TelCallStatus::FI_EN_E8IDLE:
        return AP_TELEPHONY_CALL_STATE_IDLE;
    case most_fi_tcl_e8_TelCallStatus::FI_EN_E8DIALING:
        return AP_TELEPHONY_CALL_STATE_DIALING;
    case most_fi_tcl_e8_TelCallStatus::FI_EN_E8ACTIVE:
        return AP_TELEPHONY_CALL_STATE_ACTIVE;
    case most_fi_tcl_e8_TelCallStatus::FI_EN_E8ON_HOLD:
        return AP_TELEPHONY_CALL_STATE_HOLDING;
    case most_fi_tcl_e8_TelCallStatus::FI_EN_E8DISCONNECTING:
        return AP_TELEPHONY_CALL_STATE_DISCONNECTING;
    case most_fi_tcl_e8_TelCallStatus::FI_EN_E8BUSY:
        return AP_TELEPHONY_CALL_STATE_DISCONNECTING;
    case most_fi_tcl_e8_TelCallStatus::FI_EN_E8CONFERENCE:
        return AP_TELEPHONY_CALL_STATE_CONFERENCE;
    case most_fi_tcl_e8_TelCallStatus::FI_EN_E8IN_VOICEMAIL:
        return AP_TELEPHONY_CALL_STATE_ACTIVE;
    case most_fi_tcl_e8_TelCallStatus::FI_EN_E8RINGTONE:
        return AP_TELEPHONY_CALL_STATE_ACTIVE;
    default:
        return AP_TELEPHONY_CALL_STATE_UNKOWN;
    }
    DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
            DLT_STRING("fc_gateway_tcl_phoneclienthandler :"\
                       "should not fall here: eGetMappedStatus"),
            DLT_INT(eComponentStatus.enType));


    return AP_TELEPHONY_CALL_STATE_UNKOWN;
}

/*******************************************************************************
*
* FUNCTION     :  vConvertCCAToGatewayDS(..)
*
* DESCRIPTION  :  converts the component datastructure to gateway DS.
*
* PARAMETER    :  IN:most_fi_tcl_e8_TelCallStatus:
*                 OUT: btphn_callStatusG (Gateway status)
*
* RETURNVALUE  :  None.
*
*******************************************************************************/
void fc_gateway_tcl_phoneclienthandler::vConvertCCAToGatewayDS(
        most_fi_tcl_TelCallStatusNoticeStreamItem
        l_most_fi_tcl_TelCallStatusNoticeStreamItem,
        btphn_callStatus& l_btphn_callStatus)
{

    l_btphn_callStatus.enCallStatus = eConvertComponentStatusToGatewayStatus(
                l_most_fi_tcl_TelCallStatusNoticeStreamItem.e8CallStatus);
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Call Status = "),
            DLT_INT(l_btphn_callStatus.enCallStatus));

    //CallInstance
    l_btphn_callStatus.u16CallInstance =
            l_most_fi_tcl_TelCallStatusNoticeStreamItem.u16CallInstance;
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Call Instance = "),
            DLT_INT( l_btphn_callStatus.u16CallInstance));
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING( "Call Instance = "),
            DLT_INT( l_btphn_callStatus.u16CallInstance));

    //CallDuration
    l_btphn_callStatus.u8CallDurationHr =
            l_most_fi_tcl_TelCallStatusNoticeStreamItem.u8CallDurationHr;
    l_btphn_callStatus.u8CallDurationMin =
            l_most_fi_tcl_TelCallStatusNoticeStreamItem.u8CallDurationMin;
    l_btphn_callStatus.u8CallDurationSec =
            l_most_fi_tcl_TelCallStatusNoticeStreamItem.u8CallDurationSec;

    DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Call duration is "),
            DLT_UINT32(l_btphn_callStatus.u8CallDurationHr),
            DLT_UINT32(l_btphn_callStatus.u8CallDurationMin),
            DLT_UINT32(l_btphn_callStatus.u8CallDurationSec));

    DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Call duration is "),
            DLT_UINT32(l_btphn_callStatus.u8CallDurationHr),
            DLT_UINT32(l_btphn_callStatus.u8CallDurationMin),
            DLT_UINT32(l_btphn_callStatus.u8CallDurationSec));



    if(l_btphn_callStatus.u16CallInstance < AP_MAX_CALLS_ALLOWED)
    {
        l_btphn_callStatus.pPhoneNum =
                (char*)malloc(
                    (strTelePhoneNum[l_btphn_callStatus.u16CallInstance].length()
                     +1) * sizeof(char));

        memset(l_btphn_callStatus.pPhoneNum, 0,
               strTelePhoneNum[l_btphn_callStatus.u16CallInstance].length()
               + 1);
        strncpy(l_btphn_callStatus.pPhoneNum,
                strTelePhoneNum[l_btphn_callStatus.u16CallInstance].c_str(),
                strTelePhoneNum[l_btphn_callStatus.u16CallInstance].length());

    }

    DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("PhoneNumber = "),
            DLT_STRING(l_btphn_callStatus.pPhoneNum));

    DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING( "PhoneNumber = "),
            DLT_STRING( l_btphn_callStatus.pPhoneNum));

    l_btphn_callStatus.bIsVehicleAudio =
            l_most_fi_tcl_TelCallStatusNoticeStreamItem.bUsingVehicleAudio;
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("UsingVehicleAudio = "),
            DLT_INT(
                l_most_fi_tcl_TelCallStatusNoticeStreamItem.e8CallStatus.enType));


}

/*******************************************************************************
*
* FUNCTION     :  vTriggerOnCallStateChangeSignal
*
* DESCRIPTION  :  Sends Call state signal to DbusHandlers.
*
* PARAMETER    :  IN:most_telfi_tclMsgCallStatusNoticeStatus&:
*
* RETURNVALUE  :  None.
*
*******************************************************************************/
void
fc_gateway_tcl_phoneclienthandler::vTriggerOnCallStateChangeSignal(
        most_telfi_tclMsgCallStatusNoticeStatus& l_CallStatusNoticeStatus)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phoneclienthandler : "),
            DLT_STRING( __FUNCTION__));

    std::vector<most_fi_tcl_TelCallStatusNoticeStreamItem,
            std::allocator<
            most_fi_tcl_TelCallStatusNoticeStreamItem>>::iterator Itr =
            l_CallStatusNoticeStatus.oCallStatusNoticeStream.oItems.begin();

    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING( "call status items size: "),
            DLT_INT(
                l_CallStatusNoticeStatus.oCallStatusNoticeStream.oItems.size()));

    while (Itr != l_CallStatusNoticeStatus.oCallStatusNoticeStream.oItems.end())
    {
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                DLT_STRING("oCallStatusNoticeStatus: call status - "),
                DLT_INT(Itr->e8CallStatus.enType));

        btphn_callStatus aCallStatus;
        memset(&aCallStatus, '\0', sizeof(btphn_callStatus));
        vConvertCCAToGatewayDS(*Itr, aCallStatus);

        std::string strCallStatus = strConvertEnumToString(
                    aCallStatus.enCallStatus);

        DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                DLT_STRING("call status notice state: "),
                DLT_STRING(strCallStatus.c_str()));

        vSendOnCallStateChangeSignal(aCallStatus);

        //Free up the resources.
        free(aCallStatus.pPhoneNum);
        Itr++;
    }
}

/*******************************************************************************
*
* FUNCTION     :  strConvertEnumToString(..)
*
* DESCRIPTION  :  Converts the enum to string for error code.
*
* PARAMETER    :  IN:ApTelephonyCallState:
*
* RETURNVALUE  :  None.
*
*******************************************************************************/

std::string
fc_gateway_tcl_phoneclienthandler::strConvertEnumToString(
        ApTelephonyCallState l_ApTelephonyCallState)
{
    switch (l_ApTelephonyCallState)
    {
    case AP_TELEPHONY_CALL_STATE_DIALING:
        return "AP_TELEPHONY_CALL_STATE_DIALING";
    case AP_TELEPHONY_CALL_STATE_CONNECTING:
        return "AP_TELEPHONY_CALL_STATE_CONNECTING";
    case AP_TELEPHONY_CALL_STATE_ALERTING:
        return "AP_TELEPHONY_CALL_STATE_ALERTING";
    case AP_TELEPHONY_CALL_STATE_RINGING:
        return "AP_TELEPHONY_CALL_STATE_RINGING";
    case AP_TELEPHONY_CALL_STATE_ACTIVE:
        return "AP_TELEPHONY_CALL_STATE_ACTIVE";
    case AP_TELEPHONY_CALL_STATE_CONFERENCE:
        return "AP_TELEPHONY_CALL_STATE_CONFERENCE";
    case AP_TELEPHONY_CALL_STATE_INCOMING:
        return "AP_TELEPHONY_CALL_STATE_INCOMING";
    case AP_TELEPHONY_CALL_STATE_WAITING:
        return "AP_TELEPHONY_CALL_STATE_WAITING";
    case AP_TELEPHONY_CALL_STATE_ACCEPTED:
        return "AP_TELEPHONY_CALL_STATE_ACCEPTED";
    case AP_TELEPHONY_CALL_STATE_HELD:
        return "AP_TELEPHONY_CALL_STATE_HELD";
    case AP_TELEPHONY_CALL_STATE_DISCONNECTED:
        return "AP_TELEPHONY_CALL_STATE_DISCONNECTED";
    case AP_TELEPHONY_CALL_STATE_HOLDING:
        return "AP_TELEPHONY_CALL_STATE_HOLDING";
    case AP_TELEPHONY_CALL_STATE_RESUMING:
        return "AP_TELEPHONY_CALL_STATE_RESUMING";
    case AP_TELEPHONY_CALL_STATE_REDIRECTING:
        return "AP_TELEPHONY_CALL_STATE_REDIRECTING";
    case AP_TELEPHONY_CALL_STATE_TRANSFERRING:
        return "AP_TELEPHONY_CALL_STATE_TRANSFERRING";
    case AP_TELEPHONY_CALL_STATE_DISCONNECTING:
        return "AP_TELEPHONY_CALL_STATE_DISCONNECTING";
    case AP_TELEPHONY_CALL_STATE_IDLE:
        return "AP_TELEPHONY_CALL_STATE_IDLE";
    case AP_TELEPHONY_CALL_STATE_UNKOWN:
        return "AP_TELEPHONY_CALL_STATE_UNKOWN";
    default:
        return "AP_TELEPHONY_CALL_STATE_UNKOWN";
    }
}
/*******************************************************************************
 *
 * FUNCTION     :  vHandle_CallStatusNotice_Status(..)
 *
 * DESCRIPTION  :  This is a handler function for CallStatusNotice
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid
fc_gateway_tcl_phoneclienthandler::vHandleCallStatusNoticeOpStatus(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phoneclienthandler : "),
            DLT_STRING( __FUNCTION__));

    fi_tclVisitorMessage oVisitorMsg(poMessage);

    most_telfi_tclMsgCallStatusNoticeStatus oCallStatusNoticeStatus;

    if (oVisitorMsg.s32GetData(
                oCallStatusNoticeStatus,
                MOST_TELFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
    {
        m_oCallStatusNoticeStatus = oCallStatusNoticeStatus;
        std::vector<most_fi_tcl_TelCallStatusNoticeStreamItem,
                std::allocator
                <most_fi_tcl_TelCallStatusNoticeStreamItem> >::iterator Itr =
                oCallStatusNoticeStatus.oCallStatusNoticeStream.oItems.begin();

        while (Itr !=
               oCallStatusNoticeStatus.oCallStatusNoticeStream.oItems.end())
        {
            //GetPhoneNumber, not good way of doing this. caution: async,rhk6kor
            vGetPhoneNumber(Itr->u16CallInstance);
            ++Itr;
        }

    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                DLT_STRING("oCallStatusNoticeStatus: Version mismatch"));
    }

    oCallStatusNoticeStatus.vDestroy();
}

/*******************************************************************************
 *
 * FUNCTION     :  vHandleCallStatusNoticeOpError(..)
 *
 * DESCRIPTION  :  This is a handler function for CallStatusNotice Error
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid
fc_gateway_tcl_phoneclienthandler::vHandleCallStatusNoticeOpError(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
            DLT_STRING("fc_gateway_tcl_phoneclienthandler : "),
            DLT_STRING( __FUNCTION__));

    (tVoid)poMessage;
}
/*******************************************************************************
 *
 * FUNCTION     :  vHandleQueryTelephoneNumberOpMResult(..)
 *
 * DESCRIPTION  :
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid fc_gateway_tcl_phoneclienthandler::vHandleQueryTelephoneNumberOpMResult(
        amt_tclServiceData *poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phoneclienthandler : "),
            DLT_STRING( __FUNCTION__));

    fi_tclVisitorMessage oVisitorMsg(poMessage);
    most_telfi_tclMsgQueryTelephoneNumberMethodResult
            oMsgQueryTelephoneNumberMethodResult;

    /* Fills the CCA msg data into oMsgQueryTelephoneNumberMethodResult */
    tS32 s32Result = oVisitorMsg.s32GetData(
                oMsgQueryTelephoneNumberMethodResult,
                MOST_TELFI_C_U16_SERVICE_MAJORVERSION);

    if(OSAL_ERROR != s32Result)
    {

        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Call Instance = "),
                DLT_INT( oMsgQueryTelephoneNumberMethodResult.u16CallInstance));

        DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                DLT_STRING( "from componenet phone number: "),
                DLT_STRING(
                    oMsgQueryTelephoneNumberMethodResult.sTelephoneNumber.szValue));

        unsigned int l_uCallInstance =
                oMsgQueryTelephoneNumberMethodResult.u16CallInstance;

        if(l_uCallInstance < AP_MAX_CALLS_ALLOWED)
        {
            strTelePhoneNum[l_uCallInstance].assign(
                        oMsgQueryTelephoneNumberMethodResult.sTelephoneNumber.szValue);
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                    DLT_STRING( "phone number: "),
                    DLT_STRING(strTelePhoneNum[l_uCallInstance].c_str()));
        }

        switch (m_lastCallRequest)
        {
        case kNotifyCallStatus:
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING( "kNotifyCallStatus"));
            vTriggerOnCallStateChangeSignal(m_oCallStatusNoticeStatus);
            break;
        case kGetActiveCall:
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING( "kGetActiveCall"));
            //vTriggerGetActiveCallResponse(m_oCallStatusNoticeStatus);
            break;
        case kGetCalls:
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING( "kGetCalls"));
            //vTriggerGetCallsResponse(m_oCallStatusNoticeStatus);
            break;
        default:
            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                    DLT_STRING("Orphan request: should not com here "),
                    DLT_INT( m_lastCallRequest));
        }

    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                DLT_STRING("fc_gateway_tcl_phoneclienthandler :"\
                           "vHandleQueryTelephoneNumberOpMResult Error Message")
                ,DLT_INT(s32Result));

    }
    oMsgQueryTelephoneNumberMethodResult.vDestroy();
}
/*******************************************************************************
 *
 * FUNCTION     :  vHandleQueryTelephoneNumberOpMError(..)
 *
 * DESCRIPTION  :
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid fc_gateway_tcl_phoneclienthandler::vHandleQueryTelephoneNumberOpMError(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phoneclienthandler : "),
            DLT_STRING( __FUNCTION__));

    (tVoid)poMessage;
}
/*******************************************************************************
 *
 * FUNCTION     :  vHandleCellSignalStrengthOpStatus(..)
 *
 * DESCRIPTION  :  Function to update CellSignalStatus
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid
fc_gateway_tcl_phoneclienthandler::vHandleCellSignalStrengthOpStatus(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phoneclienthandler : "),
            DLT_STRING( __FUNCTION__));

    fi_tclVisitorMessage oVisitorMsg(poMessage);
    most_telfi_tclMsgCellSignalStrengthStatus oMsgCellSignalStrengthStatus;

    /* Fills the CCA msg data into oMsgCellSignalStrengthStatus */
    tS32 s32Result =
            oVisitorMsg.s32GetData(oMsgCellSignalStrengthStatus,
                                   MOST_TELFI_C_U16_SERVICE_MAJORVERSION);
    if(OSAL_ERROR != s32Result)
    {
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Device Handle = "),
                DLT_INT( oMsgCellSignalStrengthStatus.u8DeviceHandle));

        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Signal Strength = "),
                DLT_INT( oMsgCellSignalStrengthStatus.u8SignalSrength));

        tU8 u8DeviceHandle = oMsgCellSignalStrengthStatus.u8DeviceHandle;
        tU8 u8Signalstrength = oMsgCellSignalStrengthStatus.u8SignalSrength;
        vUpdateSignalStrengthStatus(u8DeviceHandle, u8Signalstrength);
    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                DLT_STRING("fc_gateway_tcl_phoneclienthandler :"\
                           "CellSignalStrengthStatusError = "),
                DLT_INT(s32Result));

    }

    oMsgCellSignalStrengthStatus.vDestroy();
}
/*******************************************************************************
 *
 * FUNCTION     :  vHandleCellSignalStrengthOpError(..)
 *
 * DESCRIPTION  :  This is a handler function for CellSignalStrengthError
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid fc_gateway_tcl_phoneclienthandler::vHandleCellSignalStrengthOpError(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phoneclienthandler : "),
            DLT_STRING( __FUNCTION__));
    (tVoid)poMessage;
}

#ifdef __cplusplus

/******************************************************************************
* Function:    get_PhoneClientHandlerInstance
* Description: function to get phone instance
* Parameters:  void
* Return:      void
******************************************************************************/
fc_gateway_tcl_phoneclienthandler*
get_PhoneClientHandlerInstance(procgenericgateway_tclMainApp* poMainAppl)
{
    fc_gateway_tcl_phoneclienthandler* poPhoneObj  =
            fc_gateway_tcl_phoneclienthandler::getInstance(poMainAppl);

    return poPhoneObj;
}

#endif
#endif//VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC