/*******************************************************************************
*
* FILE:          FC_Gateway_PhoneBookClientHandler.cpp
* SW-COMPONENT:
* PROJECT:
* DESCRIPTION:   CCA client-handler for phonebook
* History : 
* Date 	     | Name 	                |   Description	
* 19-09-2016   Ashwini Savadi RBEI/ECO22    vHandleCreateCallHistoryListOpMResult()
*                                           vHandleCreateCallHistoryListOpError()   
*******************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

/* Defines for including the needed PhoneBook settings interface header files */
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_ERRORCODES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_SERVICEINFO

#define FI_S_IMPORT_INTERFACE_FI_VERSION
#include "fi_msgfw_if.h"

#define PHNBK_C_CMD_COUNTER 0

#include "FC_Gateway_PhoneBookClientHandler.h"
#include "PhoneDataTypes.h"
#include "procgenericgateway_tclMainApp.h"
#include "Utility.h"
#include "Phone_ClientInterface.h"
//Dlt
#include "dlt/dlt.h"
//Dlt Context
DLT_IMPORT_CONTEXT(AGW_Phone);

fc_gateway_tcl_phonebookclienthandler*
fc_gateway_tcl_phonebookclienthandler::m_pofc_gateway_tcl_phonebookclienthandler
= NULL;

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

/* CCA Message Map - Maps the Function ID, Opcode and Function handler */
BEGIN_MSG_MAP(fc_gateway_tcl_phonebookclienthandler, ahl_tclBaseWork)

/* PhoneBook Service method - CreateCallHistoryList */
ON_MESSAGE_SVCDATA(MOST_PHONBKFI_C_U16_CREATECALLHISTORYLIST,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHandleCreateCallHistoryListOpMResult)

ON_MESSAGE_SVCDATA(MOST_PHONBKFI_C_U16_CREATECALLHISTORYLIST,
                   AMT_C_U8_CCAMSG_OPCODE_ERROR,
                   vHandleCreateCallHistoryListOpError)

/* PhoneBook Service method - RequestSliceCallHistoryList */
ON_MESSAGE_SVCDATA(MOST_PHONBKFI_C_U16_REQUESTSLICECALLHISTORYLIST,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHandleRequestSliceCallHistoryListOpMResult)
ON_MESSAGE_SVCDATA(MOST_PHONBKFI_C_U16_REQUESTSLICECALLHISTORYLIST,
                   AMT_C_U8_CCAMSG_OPCODE_ERROR,
                   vHandleRequestSliceCallHistoryListOpMError)

/* PhoneBook Service method - CreateContactList */
ON_MESSAGE_SVCDATA(MOST_PHONBKFI_C_U16_CREATECONTACTLIST, 
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHandleCreateContactListOpMResult)
ON_MESSAGE_SVCDATA(MOST_PHONBKFI_C_U16_CREATECONTACTLIST,
                   AMT_C_U8_CCAMSG_OPCODE_ERROR,
                   vHandleCreateContactListOpMError)

/* PhoneBook Service method - RequestPhoneBookListSliceExtended */
ON_MESSAGE_SVCDATA(MOST_PHONBKFI_C_U16_REQUESTPHONEBOOKLISTSLICEEXTENDED,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHandleRequestPhoneBookListSliceExtendedOpMResult)
ON_MESSAGE_SVCDATA(MOST_PHONBKFI_C_U16_REQUESTPHONEBOOKLISTSLICEEXTENDED,
                   AMT_C_U8_CCAMSG_OPCODE_ERROR,
                   vHandleRequestPhoneBookListSliceExtendedOpMError)

END_MSG_MAP()

/******************************************************************************
* Function:    getInstance
* Description: singleton. Function to get phone client-handler instance
* Parameters:  main app pointer
* Return:      fc_gateway_tcl_phonebookclienthandler instance pointer
******************************************************************************/

fc_gateway_tcl_phonebookclienthandler*
fc_gateway_tcl_phonebookclienthandler::getInstance(
        procgenericgateway_tclMainApp *poMainAppl)
{
    if(m_pofc_gateway_tcl_phonebookclienthandler == NULL)
    {
        m_pofc_gateway_tcl_phonebookclienthandler =
                new fc_gateway_tcl_phonebookclienthandler(poMainAppl);
    }
    return m_pofc_gateway_tcl_phonebookclienthandler;
}

/******************************************************************************
* Function:    fc_gateway_tcl_phonebookclienthandler
* Description: Constructor
* Parameters:  main app pointer
* Return:      none
******************************************************************************/
fc_gateway_tcl_phonebookclienthandler::fc_gateway_tcl_phonebookclienthandler(
        procgenericgateway_tclMainApp *poMainAppl)
    :ahl_tclBaseOneThreadClientHandler((ahl_tclBaseOneThreadApp*)poMainAppl,
                                       CCA_C_U16_SRV_FB_PHONEBOOK,
                                       MOST_PHONBKFI_C_U16_SERVICE_MAJORVERSION,
                                       MOST_PHONBKFI_C_U16_SERVICE_MINORVERSION)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler : "),
            DLT_STRING( __FUNCTION__));

    m_pBTDeviceManager =
            fc_gateway_tcl_bluetoothclienthandler::getInstance(
                procgenericgateway_tclMainApp::poGetInstance());

    m_bIsServiceAvailable = FALSE;
}

/******************************************************************************
* Function:    fc_gateway_tcl_phonebookclienthandler
* Description: Destructor
* Parameters:  None
* Return:      None
******************************************************************************/

fc_gateway_tcl_phonebookclienthandler::~fc_gateway_tcl_phonebookclienthandler()
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler Destructor : "),
            DLT_STRING( __FUNCTION__));

    if(m_pofc_gateway_tcl_phonebookclienthandler!= NULL)
    {
        delete m_pofc_gateway_tcl_phonebookclienthandler;
        m_pofc_gateway_tcl_phonebookclienthandler = NULL;
    }
}

/*******************************************************************************
 * Function:		bIsServiceAvailable
 * Description:		is Service available
 * Parameters:		tVoid
 * Return:			bool
 ******************************************************************************/
bool fc_gateway_tcl_phonebookclienthandler::bIsPhnServiceAvailable()
{
    return m_bIsServiceAvailable;
}

/******************************************************************************
* Function:    vOnServiceAvailable
* Description: Over-riding base class function On service available 
* Parameters:  None
* Return:      None
******************************************************************************/

tVoid fc_gateway_tcl_phonebookclienthandler::vOnServiceAvailable()
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler : "),
            DLT_STRING( __FUNCTION__));

    m_bIsServiceAvailable = TRUE;
}

/******************************************************************************
* Function:    vOnServiceUnavailable
* Description: Over-riding base class function On service unavailable
* Parameters:  None
* Return:      None
******************************************************************************/
tVoid fc_gateway_tcl_phonebookclienthandler::vOnServiceUnavailable()
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler : "),
            DLT_STRING( __FUNCTION__));

}

/*******************************************************************************
 * Function:
* Description: Register for a property
* Parameters:  void
* Return:      void
*******************************************************************************/
tVoid fc_gateway_tcl_phonebookclienthandler::vRegisterProperty()
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler : "),
            DLT_STRING( __FUNCTION__));
}

/******************************************************************************
* Function:    fc_gateway_tcl_phonebookclienthandler::vDeRegisterProperty()
* Description: Unregister for a property
* Parameters:  void
* Return:      void
*******************************************************************************/
tVoid fc_gateway_tcl_phonebookclienthandler::vDeRegisterProperty()
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler : "),
            DLT_STRING( __FUNCTION__));
}

/******************************************************************************
* Function:    fc_gateway_tcl_phonebookclienthandler::
               vRegisterPropertyOnStartup()
* Description: Register for a properties on start up
* Parameters:  void
* Return:      void
*******************************************************************************/
tVoid fc_gateway_tcl_phonebookclienthandler::vRegisterPropertyOnStartup()
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler : "),
            DLT_STRING( __FUNCTION__));
}

/******************************************************************************
* Function:    fc_gateway_tcl_phonebookclienthandler::vDeRegisterAllProperty()
* Description: Unregister for all property
* Parameters:  void
* Return:      void
*******************************************************************************/
tVoid fc_gateway_tcl_phonebookclienthandler::vDeRegisterAllProperty()
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler : "),
            DLT_STRING( __FUNCTION__));
    vDeRegisterProperty();
}

/*******************************************************************************
 * Function:		poGetBTDeviceManagerPtr
 * Description:		get BTDeviceManager pointer
 * Parameters:		tVoid
 * Return:			fc_gateway_tcl_bluetoothclienthandler*
 ******************************************************************************/
fc_gateway_tcl_bluetoothclienthandler*
fc_gateway_tcl_phonebookclienthandler::poGetBTDeviceManagerPtr()
{
    return m_pBTDeviceManager;
}

/******************************************************************************
* Function:    sendCreateCallHistoryListMStart
* Description: 
* Parameters:  void
* Return:      void
*******************************************************************************/
tBool fc_gateway_tcl_phonebookclienthandler::sendCreateCallHistoryListMStart
(tU8 u8DeviceHandle, most_fi_tcl_e8_PhonBkCallHistoryType oMsgCallHistType)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler : "),
            DLT_STRING( __FUNCTION__));

    tBool bRetVal = FALSE;
    
    most_phonbkfi_tclMsgCreateCallHistoryListMethodStart
            oCreateCallHistoryListMStart;

    //the data content
    oCreateCallHistoryListMStart.u8DeviceHandle = u8DeviceHandle;
    oCreateCallHistoryListMStart.e8CallHistoryType = oMsgCallHistType;
    //oCreateCallHistoryListMStart.e8CallHistorySortType = oMsgCallHistSortType;

    fi_tclVisitorMessage oVisitorMsg(
                oCreateCallHistoryListMStart,
                MOST_PHONBKFI_C_U16_SERVICE_MAJORVERSION);

    vInitServiceData(oVisitorMsg, (tU16) 0,
                     (tU16) MOST_PHONBKFI_C_U16_CREATECALLHISTORYLIST,
                     (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

    if(NULL != _poMainAppl)
    {
        /* Post message - since the second parameter is true
           we need not explicitly delete the message*/

        ail_tenCommunicationError enResult =
                _poMainAppl->enPostMessage(&oVisitorMsg, TRUE);

        if (enResult != AIL_EN_N_NO_ERROR)
        {
            // Error situation:
            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                    DLT_STRING("sendCreateCallHistoryListMStart():"
                               "enPostMessage failed for FuncId - "),
                    DLT_UINT32(MOST_PHONBKFI_C_U16_CREATECALLHISTORYLIST));

            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                    DLT_STRING("ail_tenCommunicationError ="),
                    DLT_UINT32((tU32)enResult));
            
            bRetVal = FALSE;
        }
        else
        {
            bRetVal = TRUE;
        }
    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                DLT_STRING("fc_gateway_tcl_phoneclienthandler : "),
                DLT_STRING(__FUNCTION__),
                DLT_STRING("_poMainAppl NULL Pointer"));

        bRetVal = FALSE;
    }
    // Always destroy the FI data object before leaving its creation scope
    oCreateCallHistoryListMStart.vDestroy();

    return bRetVal;
}

/*******************************************************************************
 *
 * FUNCTION     :  vSendRequestSliceCallHistoryListMStart(..)
 *
 * DESCRIPTION  :  This is a function to RequestSliceCallHistoryList
 *
 * PARAMETER    :
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tBool 
fc_gateway_tcl_phonebookclienthandler::sendRequestSliceCallHistoryListMStart(
        tU16 u16ListHandle,
        tU32 u32WindowStart,
        tU16 u16WindowSize)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler : "),
            DLT_STRING( __FUNCTION__));

    tBool bRetVal = FALSE;

    most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart
            oRequestSliceCallHistoryListMStart;

    oRequestSliceCallHistoryListMStart.u16ListHandle = u16ListHandle;
    oRequestSliceCallHistoryListMStart.u32WindowStart = u32WindowStart;
    oRequestSliceCallHistoryListMStart.u16WindowSize = u16WindowSize;

    fi_tclVisitorMessage oVisitorMsg(
                oRequestSliceCallHistoryListMStart,
                MOST_PHONBKFI_C_U16_SERVICE_MAJORVERSION);

    vInitServiceData(oVisitorMsg, (tU16) 0,
                     (tU16) MOST_PHONBKFI_C_U16_REQUESTSLICECALLHISTORYLIST,
                     (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

    if(NULL != _poMainAppl)
    {
        /*Post message - since the second parameter is true
          we need not explicitly delete the message*/

        ail_tenCommunicationError
                enResult = _poMainAppl->enPostMessage(&oVisitorMsg, TRUE);

        if (enResult != AIL_EN_N_NO_ERROR)
        {
            // Error situation:
            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                    DLT_STRING("vSendRequestSliceCallHistoryListMStart():"
                               "enPostMessage failed for FuncId - "),
                    DLT_UINT32(
                        MOST_PHONBKFI_C_U16_REQUESTSLICECALLHISTORYLIST));

            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                    DLT_STRING("ail_tenCommunicationError = "),
                    DLT_UINT32((tU32)enResult));
            
            bRetVal = FALSE;
        }
        else
        {
            bRetVal = TRUE;
        }
    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                DLT_STRING("fc_gateway_tcl_phoneclienthandler : "),
                DLT_STRING( __FUNCTION__),
                DLT_STRING("_poMainAppl NULL Pointer"));
        
        bRetVal = FALSE;
        // Always destroy the FI data object before leaving its creation scope
    }
    oRequestSliceCallHistoryListMStart.vDestroy();
    return bRetVal;
}

/*******************************************************************************
 *
 * FUNCTION     :  sendCreateContactListMStart(..)
 *
 * DESCRIPTION  :  This is a function for CreatePhoneBookList
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tBool fc_gateway_tcl_phonebookclienthandler::sendCreateContactListMStart(
        tU8 u8DeviceHandle,
        most_fi_tcl_e8_PhonBkContactSortType e8PhoneBookContactSortType)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler : "),
            DLT_STRING( __FUNCTION__));

    tBool bRetVal = FALSE;

    most_phonbkfi_tclMsgCreateContactListMethodStart  oCreateContactListMStart;
    //the data content
    oCreateContactListMStart.u8DeviceHandle = u8DeviceHandle;
    oCreateContactListMStart.e8PhoneBkContactSortType =
            e8PhoneBookContactSortType;

    fi_tclVisitorMessage oVisitorMsg(oCreateContactListMStart,
                                     MOST_PHONBKFI_C_U16_SERVICE_MAJORVERSION);
    
    //Initialize the message with register id and so on
    vInitServiceData(oVisitorMsg, (tU16) 0,
                     (tU16) MOST_PHONBKFI_C_U16_CREATECONTACTLIST,
                     (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
    if(NULL != _poMainAppl)
    {
        /* Post message - since the second parameter is true
           we need not explicitly delete the message*/

        ail_tenCommunicationError enResult =
                _poMainAppl->enPostMessage(&oVisitorMsg, TRUE);

        if (enResult != AIL_EN_N_NO_ERROR)
        {
            // Error situation:
            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                    DLT_STRING("sendCreatePhoneBookListMStart(): enPostMessage"
                               "failed for FuncId"),
                    DLT_UINT32(MOST_PHONBKFI_C_U16_CREATECONTACTLIST));

            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                    DLT_STRING("ail_tenCommunicationError = "),
                    DLT_UINT32((tU32)enResult));
            
            bRetVal = FALSE;
        }
        else
        {
            bRetVal = TRUE;
        }
    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                DLT_STRING("fc_gateway_tcl_phoneclienthandler : "),
                DLT_STRING( __FUNCTION__),
                DLT_STRING("_poMainAppl NULL Pointer"));

        bRetVal = FALSE;
    }

    // Always destroy the FI data object before leaving its creation scope
    oCreateContactListMStart.vDestroy();
    return bRetVal;
}

/*******************************************************************************
 *
 * FUNCTION     :  sendRequestPhoneBookListSliceExtendedMStart(..)
 *
 * DESCRIPTION  :  This is a function for CreatePhoneBookList
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tBool
fc_gateway_tcl_phonebookclienthandler::sendRequestPhoneBookListSliceExtendedMStart(
        tU16 u16ListHandle,
        tU32 u32WindowStart,
        tU16 u16WindowSize)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler : "),
            DLT_STRING( __FUNCTION__));
    tBool bRetVal = FALSE;

    most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart
            oRequestPhoneBookListMStart;
    //the data content
    oRequestPhoneBookListMStart.u16ListHandle = u16ListHandle;
    oRequestPhoneBookListMStart.u32WindowStart = u32WindowStart;
    oRequestPhoneBookListMStart.u16WindowSize = u16WindowSize;
    
    fi_tclVisitorMessage oVisitorMsg(oRequestPhoneBookListMStart,
                                     MOST_PHONBKFI_C_U16_SERVICE_MAJORVERSION);
    
    //Initialize the message with register id and so on
    vInitServiceData(
                oVisitorMsg, (tU16) 0,
                (tU16) MOST_PHONBKFI_C_U16_REQUESTPHONEBOOKLISTSLICEEXTENDED,
                (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
    
    if(NULL != _poMainAppl)
    {
        /* Post message - since the second parameter is true
           we need not explicitly delete the message*/
        ail_tenCommunicationError
                enResult = _poMainAppl->enPostMessage(&oVisitorMsg, TRUE);

        if (enResult != AIL_EN_N_NO_ERROR) {
            // Error situation:
            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                    DLT_STRING("sendRequestPhoneBookListSliceExtendedMStart():"
                               "enPostMessage failed for FuncId - "),
                    DLT_UINT32(
                        MOST_PHONBKFI_C_U16_REQUESTPHONEBOOKLISTSLICEEXTENDED));
            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                    DLT_STRING("ail_tenCommunicationError = "),
                    DLT_UINT32((tU32)enResult));
            
            bRetVal = FALSE;
        }
        else {
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING(
                        "fc_gateway_tcl_messageclienthandler : Posting of"
                        "RequestPhoneBookSliceExtended Success"));
            bRetVal = TRUE;
        }
    }
    else{
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                DLT_STRING("fc_gateway_tcl_phoneclienthandler : "),
                DLT_STRING( __FUNCTION__),
                DLT_STRING("_poMainAppl NULL Pointer"));
        
        bRetVal = FALSE;
    }
    // Always destroy the FI data object before leaving its creation scope
    oRequestPhoneBookListMStart.vDestroy();
    return bRetVal;
}

/*******************************************************************************
 *
 * FUNCTION     :  vHandleCreateCallHistoryListOpMResult(..)
 *
 * DESCRIPTION  :  This is a function for CreateCallHistoryList
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid
fc_gateway_tcl_phonebookclienthandler::vHandleCreateCallHistoryListOpMResult(
        amt_tclServiceData *poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler : "),
            DLT_STRING( __FUNCTION__));

    fi_tclVisitorMessage oVisitorMsg(poMessage);
    most_phonbkfi_tclMsgCreateCallHistoryListMethodResult
            oMsgCreateCallHistoryListResult;

    /* Fills the CCA msg data into oMsgCreateCallListResult */
    tS32 s32Result = oVisitorMsg.s32GetData(
                oMsgCreateCallHistoryListResult,
                MOST_PHONBKFI_C_U16_CREATECALLHISTORYLIST);

    if(OSAL_ERROR != s32Result)
    {
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Device Handle = "),
                DLT_INT(oMsgCreateCallHistoryListResult.u8DeviceHandle));
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                DLT_STRING("Call History List Handle = "),
                DLT_INT(oMsgCreateCallHistoryListResult.u16ListHandle));
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                DLT_STRING("Call history list length = "),
                DLT_INT(oMsgCreateCallHistoryListResult.u16ListLength));

        vPrepareCallHistoryResult(
                    oMsgCreateCallHistoryListResult.u16ListLength,
                    oMsgCreateCallHistoryListResult.u16ListHandle);
    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,DLT_STRING(
                    "fc_gateway_tcl_phonebookclienthandler : "
                    "vHandleCreateCallHistoryListOpMResult Error Message = "),
                DLT_INT(s32Result));


        char
                sError[] = "Internal Error: Error in create call history";
        vPrepareCallHistoryError(AP_TELEPHONY_ERROR_ILLEGAL_BEHAVIOUR,
                                 sError);
    }
    oMsgCreateCallHistoryListResult.vDestroy();
}

/*******************************************************************************
 *
 * FUNCTION     :  vHandleCreateCallHistoryListOpError(..)
 *
 * DESCRIPTION  :  This is a handler function for CreateCallHistoryListOpError
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid
fc_gateway_tcl_phonebookclienthandler::vHandleCreateCallHistoryListOpError(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler : "),
            DLT_STRING( __FUNCTION__));
    (tVoid)poMessage;
    char
            sError[] = "Internal Error: Error in create call history";
    vPrepareCallHistoryError(AP_TELEPHONY_ERROR_ILLEGAL_BEHAVIOUR,
                             sError);
}

/*******************************************************************************
 *
 * FUNCTION     :  vHandleRequestSliceCallHistoryListOpMResult(..)
 *
 * DESCRIPTION  :  This is a function for RequestSliceCallHistoryList Result
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid
fc_gateway_tcl_phonebookclienthandler::vHandleRequestSliceCallHistoryListOpMResult(
        amt_tclServiceData *poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler : "),
            DLT_STRING( __FUNCTION__));
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult
            oMsgRequestSliceCallHistoryListResult;

    /* Fills the CCA msg data into oMsgRequestSliceCallListResult */

    tS32 s32Result = oVisitorMsg.s32GetData(
                oMsgRequestSliceCallHistoryListResult,
                MOST_PHONBKFI_C_U16_SERVICE_MAJORVERSION);

    if(OSAL_ERROR != s32Result)
    {
        onRequestSliceCallHistoryListMResult(
                    oMsgRequestSliceCallHistoryListResult.oCallHistoryListSliceResult);
    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,DLT_STRING(
                    "vHandleRequestSliceCallHistoryListOpMResult Error Message:")
                ,DLT_INT(s32Result));

        char error_msg[] =
                "Error while calling get call history:Internal Error";
        vGetCallHistoryInSliceError(AP_TELEPHONY_ERROR_ILLEGAL_BEHAVIOUR,
                                    error_msg);
    }
    oMsgRequestSliceCallHistoryListResult.vDestroy();
}

/*******************************************************************************
 *
 * FUNCTION     :  onRequestSliceCallHistoryListMResult(..)
 *
 * DESCRIPTION  :
 *
 * PARAMETER    :
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid
fc_gateway_tcl_phonebookclienthandler::onRequestSliceCallHistoryListMResult(
        most_fi_tcl_PhonBkCallHistoryListSliceResult
        oCallHistoryListSliceResult)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler : "),
            DLT_STRING( __FUNCTION__));

    std::vector<tclCallHistoryItem> aCallHistorySliceList;
    
    tclCallHistoryItem l_tclCallHistoryItem;

    std::vector<most_fi_tcl_PhonBkCallHistoryListSliceResultItem>::iterator
            itCallHistorySliceList =
            oCallHistoryListSliceResult.oItems.begin();

    for(;itCallHistorySliceList!=oCallHistoryListSliceResult.oItems.end();
        itCallHistorySliceList++)
    {
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("ContactHandle ="),
                DLT_UINT( itCallHistorySliceList->u32ContactHandle));

        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("First name = "),
                DLT_STRING( itCallHistorySliceList->sFirstName.szValue));

        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Last name = "),
                DLT_STRING( itCallHistorySliceList->sLastName.szValue));

        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Phone Number = "),
                DLT_STRING( itCallHistorySliceList->sPhoneNumber.szValue));

        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Call History Type ="),
                DLT_INT( itCallHistorySliceList->e8CallHistoryType.enType));

        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Phone Type ="),
                DLT_INT( itCallHistorySliceList->e8CallPhoneType.enType));

        ApTelephonyCallDirection
                l_enDirection = AP_TELEPHONY_CALL_DIRECTION_COMBINED;

        switch(itCallHistorySliceList->e8CallHistoryType.enType)
        {
        case most_fi_tcl_e8_PhonBkCallHistoryType::FI_EN_E8CCH:
            l_enDirection = AP_TELEPHONY_CALL_DIRECTION_COMBINED;
            break;
        case most_fi_tcl_e8_PhonBkCallHistoryType::FI_EN_E8MCH:
            l_enDirection = AP_TELEPHONY_CALL_DIRECTION_MISSED;
            break;
        case most_fi_tcl_e8_PhonBkCallHistoryType::FI_EN_E8OCH:
            l_enDirection = AP_TELEPHONY_CALL_DIRECTION_DIALED;
            break;
        case most_fi_tcl_e8_PhonBkCallHistoryType::FI_EN_E8ICH:
            l_enDirection = AP_TELEPHONY_CALL_DIRECTION_RECEIVED;
            break;
        default:
            // ignore
            break;
        }

        std::string l_sStartTime;
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Year = "),
                DLT_STRING(
                    itCallHistorySliceList->oCallDateTime.oCallDate.sCldrYear.szValue));

        l_sStartTime.assign(
                    itCallHistorySliceList->oCallDateTime.oCallDate.sCldrYear.szValue);

        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Month = "),
                DLT_STRING(
                    itCallHistorySliceList->oCallDateTime.oCallDate.sCldrMonth.szValue));
        l_sStartTime.assign(
                    l_sStartTime+"-"+
                    itCallHistorySliceList->oCallDateTime.oCallDate.sCldrMonth.szValue);

        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Day = "),
                DLT_STRING(
                    itCallHistorySliceList->oCallDateTime.oCallDate.sCldrDay.szValue));
        l_sStartTime.assign(
                    l_sStartTime+"-"+
                    itCallHistorySliceList->oCallDateTime.oCallDate.sCldrDay.szValue);

        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Hours = "),
                DLT_STRING(
                    itCallHistorySliceList->oCallDateTime.oCallTime.sHours.szValue));
        l_sStartTime.assign(
                    l_sStartTime+"T"+
                    itCallHistorySliceList->oCallDateTime.oCallTime.sHours.szValue);

        DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                DLT_STRING("Minutes = "),
                DLT_STRING(
                    itCallHistorySliceList->oCallDateTime.oCallTime.sMinutes.szValue));
        l_sStartTime.assign(
                    l_sStartTime+":"+
                    itCallHistorySliceList->oCallDateTime.oCallTime.sMinutes.szValue);

        DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                DLT_STRING("Seconds = "),
                DLT_STRING(
                    itCallHistorySliceList->oCallDateTime.oCallTime.sSeconds.szValue));
        l_sStartTime.assign(
                    l_sStartTime+":"+
                    itCallHistorySliceList->oCallDateTime.oCallTime.sSeconds.szValue);

        l_tclCallHistoryItem.vUpdateCallHistoryItem(
                    itCallHistorySliceList->u32ContactHandle,
                    itCallHistorySliceList->sPhoneNumber.szValue,
                    l_sStartTime,
                    l_enDirection);

        aCallHistorySliceList.push_back(l_tclCallHistoryItem);
    }
    vSendGetCallHistorySliceDataHandler(aCallHistorySliceList);
}

/*******************************************************************************
 *
 * FUNCTION     :  vHandleCreateCallHistoryListOpError(..)
 *
 * DESCRIPTION  :  This is a handler function for CreateCallHistoryListOpError
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid
fc_gateway_tcl_phonebookclienthandler::vHandleRequestSliceCallHistoryListOpMError(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler : "),
            DLT_STRING( __FUNCTION__));

    char sError[] = "Error while calling get call history: Internal Error";
    vGetCallHistoryInSliceError(AP_TELEPHONY_ERROR_ILLEGAL_BEHAVIOUR,
                                sError);
    (tVoid)poMessage;
}

/*******************************************************************************
 *
 * FUNCTION     :  vHandleCreateContactListOpMResult(..)
 *
 * DESCRIPTION  :  This is a function for CreatePhoneBookList Result
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid
fc_gateway_tcl_phonebookclienthandler::vHandleCreateContactListOpMResult(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler : "),
            DLT_STRING( __FUNCTION__));

    fi_tclVisitorMessage oVisitorMsg(poMessage);
    most_phonbkfi_tclMsgCreateContactListMethodResult
            oMsgCreateContactListResult;

    /* Fills the CCA msg data into oMsgCreateContactListResult */
    tS32 s32Result = oVisitorMsg.s32GetData(
                oMsgCreateContactListResult,
                MOST_PHONBKFI_C_U16_SERVICE_MAJORVERSION);
    if(OSAL_ERROR != s32Result)
    {
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Contact ListHandle = "),
                DLT_INT(oMsgCreateContactListResult.u16ListHandle));
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Contact ListLength = "),
                DLT_INT(oMsgCreateContactListResult.u16ListLength));

        onCreateContactListMResult(oMsgCreateContactListResult.u16ListHandle,
                                   oMsgCreateContactListResult.u16ListLength);
    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,DLT_STRING(
                    "vHandleCreatePhoneBookListOpMResult Error Message = "),
                DLT_INT(s32Result));

    }

    oMsgCreateContactListResult.vDestroy();
}

/*******************************************************************************
 *
 * FUNCTION     :  onCreateContactListMResult(..)
 *
 * DESCRIPTION  :
 *
 * PARAMETER    :
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid fc_gateway_tcl_phonebookclienthandler::onCreateContactListMResult(
        tU16 u16ListHandle, tU16 u16ListLength)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler : "),
            DLT_STRING( __FUNCTION__));
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("u16ListHandle"),
            DLT_INT(u16ListHandle),DLT_STRING("u16ListLength"),
            DLT_INT(u16ListLength));
    vPrepareContactListResult(u16ListHandle, u16ListLength);
}

/*******************************************************************************
 *
 * FUNCTION     :  vHandleCreatePhoneBookListOpMError(..)
 *
 * DESCRIPTION  :  This is a function for CreatePhoneBookList Error
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid
fc_gateway_tcl_phonebookclienthandler::vHandleCreateContactListOpMError(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler : "),
            DLT_STRING( __FUNCTION__));

    (tVoid)poMessage;
    char sError[] = "Internal error: Prepare contact list failed";
    vPrepareContactListError(AP_CONTACT_ERROR_ILLEGAL_BEHAVIOUR,
                             sError);
}

/*******************************************************************************
 *
 * FUNCTION     :  vHandleRequestPhoneBookListSliceOpMResult(..)
 *
 * DESCRIPTION  :  This is a function for
                   RequestPhoneBookListSliceExtended Result
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/

tVoid
fc_gateway_tcl_phonebookclienthandler::vHandleRequestPhoneBookListSliceExtendedOpMResult(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler : "),
            DLT_STRING( __FUNCTION__));

    fi_tclVisitorMessage oVisitorMsg(poMessage);
    
    most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult
            oMsgRequestPhoneBookListSliceExtendedResult;

    /* Fills the CCA msg data to oMsgRequestPhoneBookListSliceExtendedResult */
    tS32 s32Result = oVisitorMsg.s32GetData(
                oMsgRequestPhoneBookListSliceExtendedResult,
                MOST_PHONBKFI_C_U16_SERVICE_MAJORVERSION);

    if(OSAL_ERROR != s32Result)
    {
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING(
                    "vHandleRequestPhoneBookListSliceExtendedOpMResult():"));
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING(
                    "Method result update message received for"
                    "MOST_PHONBKFI_C_U16_REQUESTPHONEBOOKLISTSLICEEXTENDED"));
        
        onRequestPhoneBookListSliceMResultExtended(
                    oMsgRequestPhoneBookListSliceExtendedResult.oPhoneBookListSliceResultExtended);
    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING(
                    "vHandleRequestPhoneBookListSliceOpMResult Error Message:"),
                DLT_INT(s32Result));

    }
    oMsgRequestPhoneBookListSliceExtendedResult.vDestroy();

}
/*******************************************************************************
 *
 * FUNCTION     :  vHandleRequestPhoneBookListSliceOpMResult(..)
 *
 * DESCRIPTION  :  This is a function for RequestPhoneBookListSlice Result
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid
fc_gateway_tcl_phonebookclienthandler::vHandleRequestPhoneBookListSliceOpMResult(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler : "),
            DLT_STRING( __FUNCTION__));

    fi_tclVisitorMessage oVisitorMsg(poMessage);
    most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult
            oMsgRequestPhoneBookListSliceResult;

    /* Fills the CCA msg data to oMsgRequestPhoneBookListSliceResult */
    tS32 s32Result = oVisitorMsg.s32GetData(
                oMsgRequestPhoneBookListSliceResult,
                MOST_PHONBKFI_C_U16_SERVICE_MAJORVERSION);
    if(OSAL_ERROR != s32Result)
    {
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING(
                    "vHandleRequestPhoneBookListSliceOpMResult(): "));
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING(
                    "Method result update message received for"
                    "MOST_PHONBKFI_C_U16_REQUESTPHONEBOOKLISTSLICE"
                    "(FID: 0x222)!"));
        
    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                DLT_STRING(
                    "vHandleRequestPhoneBookListSliceOpMResult Error Message:"),
                DLT_INT(s32Result));


    }
    oMsgRequestPhoneBookListSliceResult.vDestroy();
}


tVoid
fc_gateway_tcl_phonebookclienthandler::onRequestPhoneBookListSliceMResultExtended(
        most_fi_tcl_PhonBkPhoneBookListSliceResultExtended
        oPhoneBookListSliceResultExtended)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler : "),
            DLT_STRING( __FUNCTION__));

    std::vector<most_fi_tcl_PhonBkPhoneBookListSliceResultExtendedItem,
            std::allocator
            <most_fi_tcl_PhonBkPhoneBookListSliceResultExtendedItem> >::iterator
            ItrContactList =
            oPhoneBookListSliceResultExtended.oItems.begin();

    int i_arrlen = oPhoneBookListSliceResultExtended.oItems.size();
    ContactInfo* l_ContactInfoItems =
            (ContactInfo*) malloc( i_arrlen * sizeof(ContactInfo));
    int iCount = 0;

    /* Populating the contact list entries */
    for( ; ItrContactList != oPhoneBookListSliceResultExtended.oItems.end();
         ItrContactList++)
    {
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Contact handle : "),
                DLT_INT(ItrContactList->u32ContactHandle));
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Contact Name Tag : "),
                DLT_INT(ItrContactList->u32ContactNameTag));
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("PhonBkContactType : "),
                DLT_INT(ItrContactList->e8ContactType.enType));

        l_ContactInfoItems[iCount].contactNameArray =
                (char**)malloc(2 * sizeof(char*));

        if(ItrContactList->sFirstName.szValue != NULL)
        {
            DLT_LOG(AGW_Phone, DLT_LOG_INFO, DLT_STRING("First Name : "),
                    DLT_STRING( ItrContactList->sFirstName.szValue));

            std::string strFirstName = ItrContactList->sFirstName.szValue;
            l_ContactInfoItems[iCount].contactNameArray[0] =
                    (char*)malloc((strFirstName.length()+1) * sizeof(char));
            memset(l_ContactInfoItems[iCount].contactNameArray[0], 0,
                   strFirstName.length() + 1);
            strncpy(l_ContactInfoItems[iCount].contactNameArray[0],
                    strFirstName.c_str(), strFirstName.length());
        }

        if(ItrContactList->sLastName.szValue != NULL)
        {
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Last Name : "),
                    DLT_STRING( ItrContactList->sLastName.szValue));

            std::string strLastName= ItrContactList->sLastName.szValue;
            l_ContactInfoItems[iCount].contactNameArray[1] =
                    (char*)malloc((strLastName.length()+1) * sizeof(char));
            memset(l_ContactInfoItems[iCount].contactNameArray[1], 0,
                   strLastName.length() + 1);
            strncpy(l_ContactInfoItems[iCount].contactNameArray[1],
                    strLastName.c_str(), strLastName.length());
        }

        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Phone Number count : "),
                DLT_UINT( ItrContactList->u8PhoneNumberCount));
        l_ContactInfoItems[iCount].phoneNumberArray =
                (char **)malloc(
                    ItrContactList->u8PhoneNumberCount * sizeof(char*));
        l_ContactInfoItems[iCount].ui_PhoneNumberCount =
                ItrContactList->u8PhoneNumberCount;

        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("POIName : "),
                DLT_STRING( ItrContactList->sPOIName.szValue));
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Quick Dial : "),
                DLT_INT( ItrContactList->bQuickDial));
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Quick Route : "),
                DLT_INT( ItrContactList->bQuickRoute));
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Quick Text : "),
                DLT_INT( ItrContactList->bQuickText));

        char* l_PhoneNum1 = ItrContactList->oPhoneNumber1.sNumber.szValue;
        if(l_PhoneNum1 != NULL && l_PhoneNum1[0] != '\0')
        {
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Phone Number1 : "),
                    DLT_STRING( l_PhoneNum1));
            l_ContactInfoItems[iCount].phoneNumberArray[0] =
                    (char*)malloc((strlen(l_PhoneNum1)+1) * sizeof(char));
            memset(l_ContactInfoItems[iCount].phoneNumberArray[0], 0,
                   strlen(l_PhoneNum1) + 1);
            strncpy(l_ContactInfoItems[iCount].phoneNumberArray[0],
                    l_PhoneNum1, strlen(l_PhoneNum1));
        }

        char* l_PhoneNum2 = ItrContactList->oPhoneNumber2.sNumber.szValue;
        if(l_PhoneNum2 != NULL && l_PhoneNum2[0] != '\0')
        {
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Phone Number2 : "),
                    DLT_STRING( l_PhoneNum2 ));
            l_ContactInfoItems[iCount].phoneNumberArray[1] =
                    (char*)malloc((strlen(l_PhoneNum2)+1) * sizeof(char));
            memset(l_ContactInfoItems[iCount].phoneNumberArray[1], 0,
                   strlen(l_PhoneNum2) + 1);
            strncpy(l_ContactInfoItems[iCount].phoneNumberArray[1],
                    l_PhoneNum2, strlen(l_PhoneNum2));
        }

        char* l_PhoneNum3 = ItrContactList->oPhoneNumber3.sNumber.szValue;
        if(l_PhoneNum3 != NULL && l_PhoneNum3[0] != '\0')
        {
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Phone Number1 : "),
                    DLT_STRING( l_PhoneNum3));
            l_ContactInfoItems[iCount].phoneNumberArray[2] =
                    (char*)malloc((strlen(l_PhoneNum3)+1) * sizeof(char));
            memset(l_ContactInfoItems[iCount].phoneNumberArray[2], 0,
                   strlen(l_PhoneNum3) + 1);
            strncpy(l_ContactInfoItems[iCount].phoneNumberArray[2],
                    l_PhoneNum3, strlen(l_PhoneNum3));
        }

        char* l_PhoneNum4 = ItrContactList->oPhoneNumber4.sNumber.szValue;
        if(l_PhoneNum4 != NULL && l_PhoneNum4[0] != '\0')
        {
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                    DLT_STRING("Phone Number1 : "),DLT_STRING( l_PhoneNum4));
            l_ContactInfoItems[iCount].phoneNumberArray[3] =
                    (char*)malloc((strlen(l_PhoneNum4)+1) * sizeof(char));
            memset(l_ContactInfoItems[iCount].phoneNumberArray[3],
                   0, strlen(l_PhoneNum4) + 1);
            strncpy(l_ContactInfoItems[iCount].phoneNumberArray[3],
                    l_PhoneNum4, strlen(l_PhoneNum4));
        }

        char* l_PhoneNum5 = ItrContactList->oPhoneNumber5.sNumber.szValue;
        if(l_PhoneNum5 != NULL && l_PhoneNum5[0] != '\0')
        {
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Phone Number1 : "),
                    DLT_STRING( l_PhoneNum5 ));
            l_ContactInfoItems[iCount].phoneNumberArray[4] =
                    (char*)malloc((strlen(l_PhoneNum5)+1) * sizeof(char));
            memset(l_ContactInfoItems[iCount].phoneNumberArray[4],
                   0, strlen(l_PhoneNum5) + 1);
            strncpy(l_ContactInfoItems[iCount].phoneNumberArray[4],
                    l_PhoneNum5, strlen(l_PhoneNum5));
        }

        char* l_PhoneNum6 = ItrContactList->oPhoneNumber6.sNumber.szValue;
        if(l_PhoneNum6 != NULL && l_PhoneNum6[0] != '\0')
        {
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                    DLT_STRING("Phone Number1 : "),DLT_STRING( l_PhoneNum6 ));
            l_ContactInfoItems[iCount].phoneNumberArray[5] =
                    (char*)malloc((strlen(l_PhoneNum6)+1) * sizeof(char));
            memset(l_ContactInfoItems[iCount].phoneNumberArray[5],
                   0, strlen(l_PhoneNum6) + 1);
            strncpy(l_ContactInfoItems[iCount].phoneNumberArray[5],
                    l_PhoneNum6, strlen(l_PhoneNum6));
        }

        char* l_PhoneNum7 = ItrContactList->oPhoneNumber7.sNumber.szValue;
        if(l_PhoneNum7 != NULL && l_PhoneNum7[0] != '\0')
        {
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Phone Number1 : "),
                    DLT_STRING( l_PhoneNum7 ));
            l_ContactInfoItems[iCount].phoneNumberArray[6] =
                    (char*)malloc((strlen(l_PhoneNum7)+1) * sizeof(char));
            memset(l_ContactInfoItems[iCount].phoneNumberArray[6], 0,
                   strlen(l_PhoneNum7) + 1);
            strncpy(l_ContactInfoItems[iCount].phoneNumberArray[6],
                    l_PhoneNum7,
                    strlen(l_PhoneNum7));
        }

        char* l_PhoneNum8 = ItrContactList->oPhoneNumber8.sNumber.szValue;
        if(l_PhoneNum8 != NULL && l_PhoneNum8[0] != '\0')
        {
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Phone Number1 : "),
                    DLT_STRING(l_PhoneNum8 ));

            l_ContactInfoItems[iCount].phoneNumberArray[7] =
                    (char*)malloc((strlen(l_PhoneNum8)+1) * sizeof(char));
            memset(l_ContactInfoItems[iCount].phoneNumberArray[7],
                   0, strlen(l_PhoneNum8) + 1);
            strncpy(l_ContactInfoItems[iCount].phoneNumberArray[7],
                    l_PhoneNum8,
                    strlen(l_PhoneNum8));
        }

        DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                DLT_STRING("Email count : \t"),
                DLT_UINT( ItrContactList->u8EmailCount));
        l_ContactInfoItems[iCount].emailAddressArray =
                (char **)malloc(ItrContactList->u8EmailCount * sizeof(char*));
        l_ContactInfoItems[iCount].ui_EmailAddressCount =
                ItrContactList->u8EmailCount;

        char* l_Email1 = ItrContactList->oEmailAddr1.szValue;
        if(l_Email1 != NULL && l_Email1[0] != '\0')
        {
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Email Address 1 : ")
                    ,DLT_STRING(l_Email1 ));
            l_ContactInfoItems[iCount].emailAddressArray[0] =
                    (char*)malloc((strlen(l_Email1)+1) * sizeof(char));
            memset(l_ContactInfoItems[iCount].emailAddressArray[0],
                   0, strlen(l_Email1) + 1);
            strncpy(l_ContactInfoItems[iCount].emailAddressArray[0],
                    l_Email1, strlen(l_Email1));
        }

        char* l_Email2 = ItrContactList->oEmailAddr2.szValue;
        if(l_Email2 != NULL && l_Email2[0] != '\0')
        {
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                    DLT_STRING("Email Address 2 : "),DLT_STRING(l_Email2 ));
            l_ContactInfoItems[iCount].emailAddressArray[1] =
                    (char*)malloc((strlen(l_Email2)+1) * sizeof(char));
            memset(l_ContactInfoItems[iCount].emailAddressArray[1],
                   0, strlen(l_Email2) + 1);
            strncpy(l_ContactInfoItems[iCount].emailAddressArray[1],
                    l_Email2, strlen(l_Email2));
        }

        char* l_Email3 = ItrContactList->oEmailAddr3.szValue;
        if(l_Email3 != NULL && l_Email3[0] != '\0')
        {
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                    DLT_STRING("Email Address 3 : "),DLT_STRING(l_Email3 ));
            l_ContactInfoItems[iCount].emailAddressArray[2] =
                    (char*)malloc((strlen(l_Email3)+1) * sizeof(char));
            memset(l_ContactInfoItems[iCount].emailAddressArray[2],
                   0, strlen(l_Email3) + 1);
            strncpy(l_ContactInfoItems[iCount].emailAddressArray[2],
                    l_Email3, strlen(l_Email3));
        }

        char sContactHandle[15];
        snprintf(sContactHandle, sizeof(sContactHandle),
                 "%u", ItrContactList->u32ContactHandle);
        l_ContactInfoItems[iCount].strContactHandle =
                (char*)malloc((strlen(sContactHandle)+1) * sizeof(char));
        memset(l_ContactInfoItems[iCount].strContactHandle,
               0, strlen(sContactHandle) + 1);
        strncpy(l_ContactInfoItems[iCount].strContactHandle,
                sContactHandle,
                strlen(sContactHandle));

        DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                DLT_STRING(l_ContactInfoItems[iCount].strContactHandle));
        iCount++;

        DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                DLT_STRING("Photo Available : \t"),
                DLT_INT( ItrContactList->bPhotoAvailable));
    }
    vGetContactsInSliceResult(l_ContactInfoItems, iCount);
}

/*******************************************************************************
 *
 * FUNCTION     :  vHandleRequestPhoneBookListSliceExtendedOpMError(..)
 *
 * DESCRIPTION  :  This is a function for RequestPhoneBookListSliceExtended Error
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid
fc_gateway_tcl_phonebookclienthandler::vHandleRequestPhoneBookListSliceExtendedOpMError(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler : "),
            DLT_STRING( __FUNCTION__));
    (tVoid)poMessage;

    char sError[] = "Error while calling get contacts in slice:Internal Error";
    vGetContactsInSliceError(AP_CONTACT_ERROR_ILLEGAL_BEHAVIOUR,
                             sError);
}

/*******************************************************************************
 *
 * FUNCTION     :  vHandleRequestPhoneBookListSliceOpMError(..)
 *
 * DESCRIPTION  :  This is a function for RequestPhoneBookListSlice Error
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid
fc_gateway_tcl_phonebookclienthandler::vHandleRequestPhoneBookListSliceOpMError(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler : "),
            DLT_STRING( __FUNCTION__));
    (tVoid)poMessage;
}

#ifdef __cplusplus
extern "C"
{
#endif
/******************************************************************************
* Function:    vPrepareCallHistoryList()
* Description: Wrapper function to call CreateCallHistoryList call method of 
               phonebook client-handler
* Parameters:  ApTelephonyCallDirection, unsigned short
* Return:      void
*******************************************************************************/
void vPrepareCallHistoryList(ApTelephonyCallDirection enCallHistoryType,
                             unsigned short uDeviceHandle)
//ApTelephonySortBy enCallHistorySortType)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler : "),
            DLT_STRING( __FUNCTION__));
    //Call History Type
    most_fi_tcl_e8_PhonBkCallHistoryType oMsgCallHistType;
    switch(enCallHistoryType)
    {
    case AP_TELEPHONY_CALL_DIRECTION_DIALED:
        oMsgCallHistType.enType = most_fi_tcl_e8_PhonBkCallHistoryType::FI_EN_E8OCH;
        break;
    case AP_TELEPHONY_CALL_DIRECTION_RECEIVED:
        oMsgCallHistType.enType = most_fi_tcl_e8_PhonBkCallHistoryType::FI_EN_E8ICH;
        break;
    case AP_TELEPHONY_CALL_DIRECTION_MISSED:
        oMsgCallHistType.enType = most_fi_tcl_e8_PhonBkCallHistoryType::FI_EN_E8MCH;
        break;
    case AP_TELEPHONY_CALL_DIRECTION_COMBINED:
        oMsgCallHistType.enType = most_fi_tcl_e8_PhonBkCallHistoryType::FI_EN_E8CCH;
        break;
    default:
    {
        char sError[] = "Error: Invalid attribute direction";
        vPrepareCallHistoryError(AP_TELEPHONY_ERROR_INVALID_ATTRIBUTE_VALUE,
                                 sError);
        return;
    }

    }

    bool bRet;
    fc_gateway_tcl_phonebookclienthandler*
            phoneBkObj = fc_gateway_tcl_phonebookclienthandler::getInstance(
                procgenericgateway_tclMainApp::poGetInstance());

    //Device Handle
    most_fi_tcl_MsgMessageHandle oMsgHandle;
    oMsgHandle.u8DeviceHandle = uDeviceHandle;

    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler : current BT"
                       "Device Handle: "),DLT_INT(oMsgHandle.u8DeviceHandle));

    oMsgHandle.u32MsgHandleUpper = 0;
    oMsgHandle.u32MsgHandleLower = 0;

    bRet = phoneBkObj->sendCreateCallHistoryListMStart(
                oMsgHandle.u8DeviceHandle,
                oMsgCallHistType);
    //oMsgCallHistSortType);
    if(!bRet)
    {
        char sError[] =
                "Error while calling prepare call history:Internal Error";
        vPrepareCallHistoryError(AP_TELEPHONY_ERROR_ILLEGAL_BEHAVIOUR,
                                 sError);
    }

}

/******************************************************************************
* Function:    vGetCallHistorySlice()
* Description: Wrapper function to call RequestSliceCallHistory call method of 
               phonebook client-handler
* Parameters:  int iHandle, unsigned int iWindowStart,
               unsigned short iWindowSize
* Return:      void
*******************************************************************************/
void vGetCallHistorySlice(int iHandle,
                          unsigned int iWindowStart,
                          unsigned short iWindowSize)
{
    bool bRet;
    fc_gateway_tcl_phonebookclienthandler*
            phoneBkObj = fc_gateway_tcl_phonebookclienthandler::getInstance(
                procgenericgateway_tclMainApp::poGetInstance());

    bRet = phoneBkObj->sendRequestSliceCallHistoryListMStart(iHandle,
                                                             iWindowStart,
                                                             iWindowSize);

    if(!bRet)
    {
        char sError[] = "Error while calling get call history:Internal Error";
        vGetCallHistoryInSliceError(AP_TELEPHONY_ERROR_ILLEGAL_BEHAVIOUR,
                                    sError);
    }
}

/******************************************************************************
 * Function:		vPrepareContactList
 * Description:	Wrapper function to call sendCreateContactListMStart method.
 * Parameters:		ApContactSortBy, unsigned int
 * Return:			void
 *****************************************************************************/
void vPrepareContactList(ApContactSortBy enSortBy, unsigned short uDeviceHandle)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_phonebookclienthandler:"
                       "vPrepareContactList SortType: "),DLT_INT(enSortBy));
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Device Handle"),
            DLT_UINT16(uDeviceHandle));


    //PhoneBook Sort Type
    most_fi_tcl_e8_PhonBkContactSortType oPhonBkContactSortType;

    switch(enSortBy)
    {
    case AP_CONTACT_SORTBY_FIRSTNAME:
        oPhonBkContactSortType.enType =
                most_fi_tcl_e8_PhonBkContactSortType::FI_EN_E8PB_LIST_SORT_FIRSTNAME;
        break;

    case AP_CONTACT_SORTBY_LASTNAME:
        oPhonBkContactSortType.enType =
                most_fi_tcl_e8_PhonBkContactSortType::FI_EN_E8PB_LIST_SORT_LASTNAME;
        break;

    case AP_CONTACT_SORTBY_ADDRESS:
        oPhonBkContactSortType.enType =
                most_fi_tcl_e8_PhonBkContactSortType::FI_EN_E8PB_LIST_SORT_ADDRESS_FIRSTNAME;
        break;

    case AP_CONTACT_SORTBY_EMAIL:
        oPhonBkContactSortType.enType =
                most_fi_tcl_e8_PhonBkContactSortType::FI_EN_E8PB_LIST_SORT_EMAIL_FIRSTNAME;
        break;

    case AP_CONTACT_SORTBY_NUMBER:
        oPhonBkContactSortType.enType =
                most_fi_tcl_e8_PhonBkContactSortType::FI_EN_E8PB_LIST_SORT_NUMBER_FIRSTNAME;
        break;

    case AP_CONTACT_SORTBY_CATEGORY:
        oPhonBkContactSortType.enType =
                most_fi_tcl_e8_PhonBkContactSortType::FI_EN_E8PB_LIST_SORT_CATEGORY_FIRSTNAME;
        break;

    case AP_CONTACT_SORTBY_BIRTHDAY:
    {
        char sError[] = "Error: Sort by birthday is not available";
        vPrepareContactListError(AP_CONTACT_ERROR_ATTRIBUTE_UNAVAILABLE,
                                 sError);
    }
        return;
    default:
    {
        char sError[] = "Error: Sort by parameter is invalid";
        vPrepareContactListError(AP_CONTACT_ERROR_INVALID_ATTRIBUTE_VALUE,
                                 sError);
    }
        return;
    }

    fc_gateway_tcl_phonebookclienthandler*
            phoneBkObj = fc_gateway_tcl_phonebookclienthandler::getInstance(
                procgenericgateway_tclMainApp::poGetInstance());

    tU8 u8DeviceHandle = uDeviceHandle;

    if(u8DeviceHandle == 0)
    {
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                DLT_STRING("vPrepareContactList : "\
                           "No Connected device found. Bad device handle"));

        char sError[] = "Internal Error: No phone connected";
        vPrepareContactListError(AP_CONTACT_ERROR_ILLEGAL_BEHAVIOUR,
                                 sError);
        return;
    }

    bool bRet = phoneBkObj->sendCreateContactListMStart(u8DeviceHandle,
                                                        oPhonBkContactSortType);
    if(!bRet)
    {
        char sError[] = "Internal Error: calling Prepare contact list failed";
        vPrepareContactListError(AP_CONTACT_ERROR_ILLEGAL_BEHAVIOUR,
                                 sError);
    }
}

/******************************************************************************
* Function:    vGetContactsInSlice()
* Description: Wrapper function to call RequestPhoneBookListSlice call method of 
               phonebook client-handler
* Parameters:  int, unsigned int, unsigned short
* Return:      void
*******************************************************************************/
void vGetContactsInSlice(int iHandle,
                         unsigned int iWindowStart,
                         unsigned short iWindowSize)
{
    bool bRet;
    fc_gateway_tcl_phonebookclienthandler*
            phoneBkObj = fc_gateway_tcl_phonebookclienthandler::getInstance(
                procgenericgateway_tclMainApp::poGetInstance());

    bRet = phoneBkObj->sendRequestPhoneBookListSliceExtendedMStart(iHandle,
                                                                   iWindowStart,
                                                                   iWindowSize);

    if(!bRet)
    {
        char sError[] =
                "Error while calling get contacts in slice:Internal Error";
        vGetContactsInSliceError(AP_CONTACT_ERROR_ILLEGAL_BEHAVIOUR,
                                 sError);
    }
}

#ifdef __cplusplus
}
#endif //__cplusplus

#ifdef __cplusplus

/******************************************************************************
* Function:    get_PhonebookClientHandlerInstance
* Description: function to get Phonebook instance
* Parameters:  void
* Return:      void
******************************************************************************/
fc_gateway_tcl_phonebookclienthandler*
get_PhonebookClientHandlerInstance(procgenericgateway_tclMainApp* poMainAppl)
{
    fc_gateway_tcl_phonebookclienthandler* poPhonebookObj  =
            fc_gateway_tcl_phonebookclienthandler::getInstance(poMainAppl);

    return poPhonebookObj;
}

#endif
#endif//VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC