/******************************************************************************
*
* FILE:          FC_Gateway_PhoneClientHandler.h
*
* PROJECT:       FC_GENERIC_GATEWAY
*
* DESCRIPTION:   CCA client handler for phone
*
* AUTHOR:        KRJ5KOR(RBEI/ECO2)
*
*   16-09-2016    Ashwini Savadi RBEI/ECO22     a.Handled Callduration in 
                                                  vHandleCallStatusNoticeOpStatus()
                                                b.Added Method vHandleQueryTelephoneNumberOpMResult()
                                                  vHandleQueryTelephoneNumberOpMError()
                                                  vHandleCellSignalStrengthOpStatus()
                                                  vHandleCellSignalStrengthOpError()
* COPYRIGHT:     (c) 2015 Robert Bosch GmbH, Hildesheim
*
******************************************************************************/

#ifndef _FC_GATEWAY_PHONECLIENTHANDLER_H_
#define _FC_GATEWAY_PHONECLIENTHANDLER_H_

/* Defines for including the needed interface header files */
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

/* Defines for including the needed Phone settings interface header files */
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_ERRORCODES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_SERVICEINFO

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON

#include "conn_most_fi_if.h"
#include "etrace_if.h"

#include "ahl_BaseOneThreadClienthandler.h"
#include "procgenericgateway_tclMainApp.h"
#include "PhoneDataTypes.h"
#include "ap-telephony-manager-enums.h"
#include "ap-telephony-error-enums.h"

#define AP_MAX_CALLS_ALLOWED 2

#ifdef __cplusplus
extern "C"
{
#endif
#include "PhoneDBusHandler.h"
#ifdef __cplusplus
}
#endif

enum lastCallRequest
{
    kGetCalls=0,
    kGetActiveCall,
    kNotifyCallStatus
};

class ahl_tclBaseOneThreadClientHandler;
class procgenericgateway_tclMainApp;

class fc_gateway_tcl_phoneclienthandler : public
        ahl_tclBaseOneThreadClientHandler
{
public:

    /* constructor*/
    fc_gateway_tcl_phoneclienthandler(tVoid);
    fc_gateway_tcl_phoneclienthandler(procgenericgateway_tclMainApp*
                                      poMainAppl);

    /* Destructor */
    virtual ~fc_gateway_tcl_phoneclienthandler();

    // Overriding ahl_tclBaseOneThreadClientHandler methods.
    virtual tVoid vOnServiceAvailable();
    virtual tVoid vOnServiceUnavailable();

    static
    fc_gateway_tcl_phoneclienthandler* getInstance(
            procgenericgateway_tclMainApp* poMainAppl);

    /* Method that sends request to Phone Service for Dial to given
      Telephone Number */

    bool vDialCall_MethodStart(const char* PhoneNumber);

    /* Method that sends request to Phone Service for Terminate Call */
    bool vHangUpCall_MethodStart(tU16 u16CallInstance);

    /* Method that sends request to Phone Service to get phone number */
    tVoid vGetPhoneNumberStart(tU16 corfu16CallInstance);

    /* Registers with Phone Service for properties status updates */
    tVoid vRegisterProperty();

    /* De-registers the Phone properties to stop receiving the status updates */
    tVoid vDeRegisterProperty();

    /*Registers with Phone Service for properties status updates on startup*/
    tVoid vRegisterPropertyOnStartup();

    /* De-registers all the Phone properties on termination */
    tVoid vDeRegisterAllProperty();

    bool bIsPhnServiceAvailable();

private:
    bool m_bIsServiceAvailable;

    /* Method that receives HangUp Call Result message from Phone service */
    tVoid vHangUpCallResult(amt_tclServiceData *poMessage);

    /* Method that receives Dial Call Result message from Phone service */
    tVoid vDialCallResult(amt_tclServiceData *poMessage);

    /* Handles the hang up call error message from Phone service */
    tVoid vHangUpCallError(amt_tclServiceData *poMessage);

    /* Handles the dial call error message from Phone service */
    tVoid vDialCallError(amt_tclServiceData *poMessage);

    tVoid vHandleCallStatusNoticeOpStatus(amt_tclServiceData* poMessage);

    tVoid vHandleCallStatusNoticeOpError(amt_tclServiceData* poMessage);

    /* Gets Phone Number from Phone service */
    tVoid vHandleQueryTelephoneNumberOpMResult(amt_tclServiceData *poMessage);

    /* Handle GetPhoneNumber error message from Phone service */
    tVoid vHandleQueryTelephoneNumberOpMError(amt_tclServiceData* poMessage);

    /* Updates Cell Signal Strength */
    tVoid vHandleCellSignalStrengthOpStatus(amt_tclServiceData* poMessage);

    /* Handles Cell Signal Strength Error */
    tVoid vHandleCellSignalStrengthOpError(amt_tclServiceData* poMessage);


    tVoid vTriggerGetCallsResponse(
            most_telfi_tclMsgCallStatusNoticeStatus oCallStatusNoticeStatus);

    tVoid vTriggerGetActiveCallResponse(
            most_telfi_tclMsgCallStatusNoticeStatus oCallStatusNoticeStatus);

    /* converts the component enum to gateway enums*/
    ApTelephonyCallState eConvertComponentStatusToGatewayStatus(
            most_fi_tcl_e8_TelCallStatus  eComponentStatus);

    void vConvertCCAToGatewayDS(
            most_fi_tcl_TelCallStatusNoticeStreamItem
            l_most_fi_tcl_TelCallStatusNoticeStreamItem,
            btphn_callStatus& l_btphn_callStatus);

    std::string strConvertEnumToString(ApTelephonyCallState
                                       l_ApTelephonyCallState);

    /* triggers action to send a DBus signal */
    tVoid vTriggerOnCallStateChangeSignal(
            most_telfi_tclMsgCallStatusNoticeStatus& l_CallStatusNoticeStatus);

    std::string strTelePhoneNum[AP_MAX_CALLS_ALLOWED];

    most_telfi_tclMsgCallStatusNoticeStatus m_oCallStatusNoticeStatus;
    /* Stores the last state of the callstatusnotice */
    lastCallRequest m_lastCallRequest;

public:

    bool bGetActiveCall_MethodStart();
    bool bGetCalls_MethodStart();


    /* Message map definition macro */
    DECLARE_MSG_MAP(fc_gateway_tcl_phoneclienthandler);

    /*member pointer for phoneclienthandler */
    static
    fc_gateway_tcl_phoneclienthandler* m_pofc_gateway_tcl_phoneclienthandler;

};

#endif
