/*******************************************************************************
*
* FILE:          FC_Gateway_PhoneBookClientHandler.h
* SW-COMPONENT:
* PROJECT:
* DESCRIPTION:   CCA client-handler for phonebook
* History : 
* Date 	     | Name 	                |   Description	
* 19-09-2016   Ashwini Savadi RBEI/ECO22    vHandleCreateCallHistoryListOpMResult()
*                                           vHandleCreateCallHistoryListOpError()   
*******************************************************************************/

#ifndef _FC_GATEWAY_PHONEBOOKCLIENTHANDLER_H_
#define _FC_GATEWAY_PHONEBOOKCLIENTHANDLER_H_

/* Defines for including the needed interface header files */
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

/* Defines for including the needed Phone settings interface header files */
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_ERRORCODES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_SERVICEINFO

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON

#include "conn_most_fi_if.h"
#include "etrace_if.h"

#include "ahl_BaseOneThreadClienthandler.h"
#include "procgenericgateway_tclMainApp.h"
#include "PhoneDataTypes.h"
#include "PhoneDataHandler.h"
#include "FC_Gateway_BluetoothClientHandler.h"


class ahl_tclBaseOneThreadClientHandler;
class procgenericgateway_tclMainApp;

class fc_gateway_tcl_phonebookclienthandler  : public
        ahl_tclBaseOneThreadClientHandler
{
public:

    /* constructor*/
    fc_gateway_tcl_phonebookclienthandler(tVoid);
    fc_gateway_tcl_phonebookclienthandler(procgenericgateway_tclMainApp*
                                          poMainAppl);

    /* Destructor */
    virtual ~fc_gateway_tcl_phonebookclienthandler();

    // Overriding ahl_tclBaseOneThreadClientHandler methods.
    virtual tVoid vOnServiceAvailable();
    virtual tVoid vOnServiceUnavailable();

    static
    fc_gateway_tcl_phonebookclienthandler* getInstance(
            procgenericgateway_tclMainApp* poMainAppl);

    /* Registers with Phone Service for properties status updates */
    tVoid vRegisterProperty();

    /* De-registers the Phone properties to stop receiving the status updates */
    tVoid vDeRegisterProperty();

    /*Registers with Phone Service for properties status updates on startup*/
    tVoid vRegisterPropertyOnStartup();

    /* De-registers all the Phone properties on termination */
    tVoid vDeRegisterAllProperty();

    bool bIsPhnServiceAvailable();

    virtual tBool sendCreateCallHistoryListMStart(
            tU8 u8DeviceHandle,
            most_fi_tcl_e8_PhonBkCallHistoryType oMsgCallHistType);

    virtual tBool sendRequestPhoneBookListSliceExtendedMStart(
            tU16 u16ListHandle,
            tU32 u32WindowStart,
            tU16 u16WindowSize);

    virtual tBool sendRequestSliceCallHistoryListMStart(tU16 u16ListHandle,
                                                        tU32 u32WindowStart,
                                                        tU16 u16WindowSize);

    virtual tBool sendCreateContactListMStart(
            tU8 u8DeviceHandle,
            most_fi_tcl_e8_PhonBkContactSortType e8PhoneBookContactSortType);

    fc_gateway_tcl_bluetoothclienthandler* m_pBTDeviceManager;

    fc_gateway_tcl_bluetoothclienthandler* poGetBTDeviceManagerPtr();


private:
    bool m_bIsServiceAvailable;

    /* Handles CreateCallHistoryList Result */
    tVoid vHandleCreateCallHistoryListOpMResult(amt_tclServiceData *poMessage);

    /* Handles CreateCallHistoryList Error*/
    tVoid vHandleCreateCallHistoryListOpError(amt_tclServiceData* poMessage);

    /* Handles RequestSliceCallHistoryList Result */
    tVoid vHandleRequestSliceCallHistoryListOpMResult(
            amt_tclServiceData *poMessage);

    /* Handles RequestSliceCallHistoryList Error*/
    tVoid vHandleRequestSliceCallHistoryListOpMError(
            amt_tclServiceData* poMessage);

    /* Handles CreateContactList Result */
    tVoid vHandleCreateContactListOpMResult(amt_tclServiceData* poMessage);

    /* Handles CreateContactList Error */
    tVoid vHandleCreateContactListOpMError(amt_tclServiceData* poMessage);

    tVoid vHandleRequestPhoneBookListSliceExtendedOpMResult(
            amt_tclServiceData* poMessage);

    tVoid vHandleRequestPhoneBookListSliceExtendedOpMError(
            amt_tclServiceData* poMessage);

    /* Handles RequestPhoneBookListSlice Result */
    tVoid vHandleRequestPhoneBookListSliceOpMResult(
            amt_tclServiceData* poMessage);

    /* Handles RequestPhoneBookListSlice Error */
    tVoid vHandleRequestPhoneBookListSliceOpMError(
            amt_tclServiceData* poMessage);

    
    virtual tVoid onRequestSliceCallHistoryListMResult(
            most_fi_tcl_PhonBkCallHistoryListSliceResult
            oCallHistoryListSliceResult);

    virtual tVoid onCreateContactListMResult(tU16 u16ListHandle,
                                             tU16 u16ListLength);

    virtual tVoid onRequestPhoneBookListSliceMResultExtended(
            most_fi_tcl_PhonBkPhoneBookListSliceResultExtended
            oPhoneBookListSliceResultExtended);

public:
    /* Message map definition macro */
    DECLARE_MSG_MAP(fc_gateway_tcl_phonebookclienthandler);

    /*member pointer for phoneclienthandler */
    static
    fc_gateway_tcl_phonebookclienthandler*
    m_pofc_gateway_tcl_phonebookclienthandler;

};


#endif
