/*!
*******************************************************************************
* @file             : Phone_ClientInterface.h
*******************************************************************************
*  - PROJECT:       : fc_genericproxy
*  - SW-COMPONENT   : Gateway - Phone
*  - DESCRIPTION    : C Wrapper for DBus and Phone client handler
*  - COPYRIGHT      : &copy; 2015 Robert Bosch Engineering & Business Solutions
*  - Documents      : Give link of relevant documents
*  - HISTORY
*
*  Date     | Name          |  Version | Modification
* ----------|---------------|--------------------------|----------------------
*  30.12.2015 | KRJ5KOR (RBEI/ECP2) | 1.0.0 | C Wrapper for DBus and 
*  20-07-2016 | Ashwini Savadi RBEI/ECO22  |	   | C Wrapper for GetMessage,SendMessage and CallStatus
******************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#ifndef _PHONEDBUS_WRAPPER_H_
#define _PHONEDBUS_WRAPPER_H_

#include <stdbool.h>
#include <stdint.h>
#include "PhoneDataTypes.h"
#include "MessageDataTypes.h"
#include "ap-telephony-error-enums.h"
#include "ap-contact-enums.h"
#include "ap-contact-error-enums.h"

//For CPP Headers
#ifdef __cplusplus
#include "FC_Gateway_PhoneBookClientHandler.h"
#include "FC_Gateway_PhoneClientHandler.h"
#include "FC_Gateway_MessageClientHandler.h"
#endif

//Phone D-Bus WRAPPERS
#ifdef __cplusplus
extern "C"
{
#endif

//Wrapper functions.
/**
@brief     Wrapper function for Dial Method.
@param     const char
@return    bool
*/
bool vDialCall_Method(const char *PhoneNumber);

/**
@brief     Wrapper function for HangUp Call.
@param     unsigned
@return    bool
*/
bool vHangUpCall_Method(unsigned int u16CallInstance);

/**
 @brief     Wrapper function to CreateMessage
 @param     char*, char*
 @return    void
 */
void vCreateMessageMethod(const char *poPhoneNumber, const char *poTextMessage);

/**
 @brief     Wrapper function to send error message
 @param     MessagingError
 @return    void
 */
void vNotifySMSErrorMessage(MessagingError eErrMsg);

/**
 @brief     Wrapper function to CreateMessage
 @param     char*, char*
 @return    void
 */
void vPrepareMessagesList(unsigned short iDeviceHandle);

/**
 @brief     Wrapper function to get Contacts in slice
 @param     int, unsigned int, unsigned int
 @return    void
 */
void vGetMessagesListSlice(unsigned short iHandle,
                           unsigned int iWindowStart,
                           unsigned short iWindowSize);


/**
 @brief     Wrapper function to update CellSignalStrength
 @param     unsigned int, unsigned int
 @return    void
 */
void vUpdateSignalStrengthStatus(unsigned short u8DeviceHandle,
                                 unsigned short u8SignalStrengthStatus);

/**
 @brief     Wrapper function to create CallHistoryList
 @param     ApTelephonyCallDirection, ApTelephonySortBy
 @return    void
 */
void vPrepareCallHistoryList(ApTelephonyCallDirection enCallHistoryType,
                             unsigned short uDeviceHandle);

/**
 @brief     Wrapper function to get CallHistory in slice
 @param     unsigned int, unsigned int
 @return    void
 */
void vGetCallHistorySlice(int iHandle,
                          unsigned int iWindowStart,
                          unsigned short iWindowSize);

/**
 @brief     Wrapper function to create contacts list
 @param     ApContactSortBy, uDeviceHandle
 @return    void
 */
void vPrepareContactList(ApContactSortBy enSortBy,
                         unsigned short uDeviceHandle);

/**
 @brief     Wrapper function to get Contacts in slice
 @param     int, unsigned int, unsigned int
 @return    void
 */
void vGetContactsInSlice(int iHandle,
                         unsigned int iWindowStart,
                         unsigned short iWindowSize);

/**
 @brief     vPrepareCallHistoryResult
 @param     gint32, gint32
 @return    void
 */
void vPrepareCallHistoryResult(gint32 iNumOfCallHist,
                               gint32 iListHandle);

/**
 @brief     vPrepareCallHistoryError
 @param     APTelephonyError, error_msg
 @return    void
 */
void vPrepareCallHistoryError(APTelephonyError enError,
                              const gchar* error_msg);

/**
 @brief     vGetCallHistoryInSliceResult
 @param     call_history_entries, list_size
 @return    void
 */
void vGetCallHistoryInSliceResult(CallHistoryInfo* call_history_entries,
                                  int list_size);

/**
 @brief     vGetCallHistoryInSliceError
 @param     APTelephonyError, error_msg
 @return    void
 */
void vGetCallHistoryInSliceError(APTelephonyError enError,
                                 const gchar* error_msg);


/**
 @brief     vPrepareContactListResult
 @param     int ,int
 @return    void
 */
void vPrepareContactListResult(int iListHandle, int iNumOfContacts);

/**
 @brief     vPrepareContactListError
 @param     APContactError, error_msg
 @return    void
 */
void vPrepareContactListError(APContactError enError, const gchar* error_msg);

/**
 @brief     vGetContactsInSliceResult
 @param     GVariant*
 @return    void
 */
void vGetContactsInSliceResult(ContactInfo* contacts_list, int list_size);

/**
 @brief     vGetContactsInSliceError
 @param     APContactError, error_msg
 @return    void
 */
void vGetContactsInSliceError(APContactError enError, const gchar* error_msg);

/**
 @brief     vHangUpMResult
 @param     void
 @return    void
 */
void vHangUpMResult();

/**
 @brief     vHangUpMError
 @param     APContactError
 @return    void
 */
void vHangUpMError(APTelephonyError enError);

/**
 @brief     vGetMessagesListResult
 @param     messages_list
 @return    void
 */
void vGetMessagesListResult(unsigned short iListHandle,
                            unsigned short iNumOfMessages);

/**
 @brief     vGetMessagesListSliceResult
 @param     messages_list
 @return    void
 */
void vGetMessagesListSliceResult(SMSData* messages_list, gint32 list_size);

/**
 @brief     vPrepareGetMessagesList_Error
 @param     APTelephonyError, error_msg
 @return    void
 */
void vPrepareGetMessagesList_Error(APTelephonyError enError,
                                   const gchar* error_msg);

/**
 @brief     vGetMessagesListSlice_Error
 @param     APTelephonyError, error_msg
 @return    void
 */
void vGetMessagesListSlice_Error(APTelephonyError enError,
                                 const gchar* error_msg);

/**
 @brief     vReadMessage
 @param     uint16_t, uint16_t, uint16_t
 @return    void
 */
void vReadMessage(uint16_t u16DeviceHandle,
                  uint16_t u16MessageID,
                  uint16_t u16ListID);

/**
 @brief     vReadMessageResult
 @param     SMSData*
 @return    void
 */
void vReadMessageResult(SMSData* message_details);

/**
 @brief     vReadMessageError
 @param     APTelephonyError, error_msg
 @return    void
 */
void vReadMessageError(APTelephonyError enError, const gchar* error_msg);

/**
 @brief     vExportSMSManagerInterface
 @param     void
 @return    void
 */
void vExportSMSManagerInterface();

/**
 @brief     vUnexportSMSManagerInterface
 @param     void
 @return    void
 */
void vUnexportSMSManagerInterface();

/**
 @brief     vExportCallManagerInterface
 @param     void
 @return    void
 */
void vExportCallManagerInterface();

/**
 @brief     vUnexportCallManagerInterface
 @param     void
 @return    void
 */
void vUnexportCallManagerInterface();


/**
 @brief     vExportContactManagerInterface
 @param     void
 @return    void
 */
void vExportContactManagerInterface();

/**
 @brief     vUnexportContactManagerInterface
 @param     void
 @return    void
 */
void vUnexportContactManagerInterface();

#ifdef __cplusplus
}
#endif //__cplusplus

//For CPP Wrapper Functions
#ifdef __cplusplus

/**
 @brief     get_PhoneClientHandlerInstance
 @param
 @return    fc_gateway_tcl_phoneclienthandler*
 */
fc_gateway_tcl_phoneclienthandler*
get_PhoneClientHandlerInstance(procgenericgateway_tclMainApp *poMainAppl);

/**
 @brief     get_PhonebookClientHandlerInstance
 @param
 @return    fc_gateway_tcl_phonebookclienthandler*
 */
fc_gateway_tcl_phonebookclienthandler*
get_PhonebookClientHandlerInstance(procgenericgateway_tclMainApp *poMainAppl);

/**
 @brief     get_MessageClientHandlerInstance
 @param
 @return    fc_gateway_tcl_messageclienthandler*
 */
fc_gateway_tcl_messageclienthandler*
get_MessageClientHandlerInstance(procgenericgateway_tclMainApp *poMainAppl);

#endif
#endif //_PHONEDBUS_WRAPPER_H_
#endif//VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC