/******************************************************************************
*
* FILE:          MessageDataTyes.h
*
* PROJECT:       FC_GENERIC_GATEWAY
*
* DESCRIPTION:   Phone data types and enums are defined
*
* AUTHOR:        RHK6KOR(RBEI/ECO2)
*
* COPYRIGHT:     (c) 2016 Robert Bosch GmbH, Hildesheim
*
******************************************************************************/
#ifndef _FC_GATEWAY_MESSAGEDATATYPES_H_
#define _FC_GATEWAY_MESSAGEDATATYPES_H_

#include "ap-telephony-manager-enums.h"

#include <stdbool.h>
#include <stdint.h>

enum SMSNotifyType
{
    kReceived = 0,
    kSent,
    kDeliverySuccess,
    kDeliveryFailure,
    kSentFailure,
    kUnkown
};

typedef struct
{
    uint16_t      u16DeviceHandle;
    uint16_t      u16MessageHandle;
    uint16_t      u16ListHandle;
    char*         poFromPhoneNumber;
    char*         poTimeStamp;
    bool          bRead;
    char*         poToPhoneNumber;
    char*         poMessage;
    ApTelephonySmsState eSMSState;
    ApTelephonySmsDeliveryStatus eDeliveryState;
    char*         poDeliveryTimeStamp;
} SMSData;

#ifdef __cplusplus
extern "C"
{
#endif
void vInitializeSMSData(SMSData *arg_SMSData);
#ifdef __cplusplus
}
#endif //__cplusplus

void vCleanSMSData(SMSData *arg_SMSData);

#endif //_FC_GATEWAY_MESSAGEDATATYPES_H_
