/******************************************************************************
 *
 * FILE:          MediaPlayerDbusHandler.h
 *
 * PROJECT:       Generic Gateway
 *
 * DESCRIPTION:   Header file for DBus Server implementation
 *
 * AUTHOR:        KRJ5KOR(RBEI/ECO2)
 *
 * COPYRIGHT:     (c) 2015 Robert Bosch GmbH, Hildesheim
 *
 *****************************************************************************/

#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#ifndef MEDIAPLAYER_DBUS_SERVER_IF_H
#define MEDIAPLAYER_DBUS_SERVER_IF_H

#include "MediaPlayer_Player_generated.h"

#include <glib.h>
#include <stdio.h>

/* Handler for pause method*/
gboolean handle_media_play (MediaPlayerPlayer *object,
                       GDBusMethodInvocation *invocation);

/* Handler for pause method*/
gboolean handle_media_pause (MediaPlayerPlayer *object,
                       GDBusMethodInvocation *invocation);

/* Handler for pause method*/
gboolean handle_media_stop (MediaPlayerPlayer *object,
                       GDBusMethodInvocation *invocation);

/* Handler for pause method*/
gboolean handle_media_seek (MediaPlayerPlayer *object,
                       GDBusMethodInvocation *invocation,
                       gint64 arg_offset);

/* Handler for pause method*/
gboolean handle_media_next (MediaPlayerPlayer *object,
                       GDBusMethodInvocation *invocation);

/* Handler for pause method*/
gboolean handle_media_prev (MediaPlayerPlayer *object,
                       GDBusMethodInvocation *invocation);

/* Handler for get current playing track method*/
gboolean handle_media_get_current_playing_track (MediaPlayerPlayer *object,
                       GDBusMethodInvocation *invocation);

#endif //MEDIAPLAYER_DBUS_SERVER_IF_H
#endif