/*!
*******************************************************************************
* @file             : DBusToMPlayProxyWrapper.h
*******************************************************************************
*  - PROJECT:       : 
*  - SW-COMPONENT   : Gateway - Vehicle
*  - DESCRIPTION    : C Wrapper for DBus and MPlay Client Handler.
*  - COPYRIGHT      : &copy; 2015 Robert Bosch Engineering & Business Solutions
*  - Documents      : Give link of relevant documents
*  - HISTORY
*
*  Date      | Name          |  Version | Modification
* -----------|---------------|--------------------------|----------------------
*  02-01-2017 | KAVYA RAJKUMAR (RBEI/ECP2) | 1.0.0 | C Wrapper for DBus and
                                                     MediaPlay Client Handler
*
******************************************************************************/

#ifndef _MPLAYDBUS_WRAPPER_H_
#define _MPLAYDBUS_WRAPPER_H_

#include <stdbool.h>

//MPLAY D-Bus WRAPPERS
#ifdef __cplusplus
extern "C"
{
#endif
#include "ap-media-player-enums.h"
#include "ap-media-player-error-enums.h"
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C"
{
#endif

	bool bMediaInterface_play();
	bool bMediaInterface_pause();
	bool bMediaInterface_stop();
	bool bMediaInterface_next();
	bool bMediaInterface_prev();
	bool bMediaInterface_seekTo(int arg_iSeekPosition);
	bool bMediaInterface_getCurrentPlayingTrack();  

	void vRequestPlayMResult();
	void vRequestPauseMResult();
	void vRequestStopMResult();
	void vRequestNextMResult();
	void vRequestPrevMResult();
	void vSeekToMResult();

	void vRequestPlayMError(ApMplayerError eState);
	void vRequestPauseMError(ApMplayerError eState);
	void vRequestStopMError(ApMplayerError eState);
	void vRequestNextMError(ApMplayerError eState);
	void vRequestPrevMError(ApMplayerError eState);
	void vSeekToMError(ApMplayerError eState);
	void vPlaytimeOpMError(ApMplayerError eState);
	void vPlaybackStateOpMError(ApMplayerError eState);
	void vPlaybackModeOpMError(ApMplayerError eState);
	void vRepeatModeOpMError(ApMplayerError eState);
	void vCurrentPlayingTrackInfoError(ApMplayerError eState);

	void vSendPlayTimeStatus(unsigned int currentPlaytime);
	void vSendPlaybackStatus(ApMPlayerState estate);
	void vSendShuffleStatus(gboolean status);
	void vSendLoopStatus(ApMPlayerLoopStatus estatus);
	void vNotifyCurrentFolderPath(char * currFolderPath, int iListHandle);
	void vNotifyTrackChanged(int iTrackId);
	void vNotifyCurrentPlayingInfo(GVariant *currentTrackInfo);


/**
@brief  function to expose Media player methods & signals
@param  void
@return void
*/
   void vExportAGWMediaPlayerInterface();

/**
@brief  function to unexpose Media player interface
@param  void
@return void
*/
   void vUnexportAGWMediaPlayerInterface();

#ifdef __cplusplus
}
#endif //__cplusplus
#endif //_MPLAYDBUS_WRAPPER_H_