/******************************************************************************
 *
 * FILE:          FactoryResetDBusHandler.h
 *
 * PROJECT:       Generic Gateway
 *
 * DESCRIPTION:   Header file for Factory Reset DBus Server implementation
 *
 * AUTHOR:        BCP9KOR(RBEI/ECO2)
 *
 * COPYRIGHT:     (c) 2017 Robert Bosch GmbH, Hildesheim
 *
 *****************************************************************************/

#ifndef FACTORY_RESET_DBUS_SERVER_IF_H
#define FACTORY_RESET_DBUS_SERVER_IF_H

#include "SettingsProvider_FactoryReset_generated.h"
#include "AutomDBusServer.h"

#include <glib.h>
#include <stdio.h>

/* Handler for factory reset request complete method*/
gboolean 
handle_factory_reset_request_complete(SettingsProviderFactoryReset *object,
                                      GDBusMethodInvocation *invocation,
                                      guint arg_register_id,
                                      guchar arg_state,
                                      guchar arg_system_id,
                                      guchar arg_reset_type,
                                      guint arg_return_code);

/* Handler for register for factory reset method*/
gboolean 
handle_register_for_factory_reset(SettingsProviderFactoryReset *object,
                                  GDBusMethodInvocation *invocation,
                                  GVariant *arg_credentials);



#endif //FACTORY_RESET_DBUS_SERVER_IF_H
