/******************************************************************
*FILE: ap-ecm-enums.c
*SW-COMPONENT: Internet
*DESCRIPTION: To register dbus error domain for Bluetooth manager.
*COPYRIGHT: © 2016 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#include <gio/gio.h>
#include "ap-ecm-enums.h"

#define ERROR_PREFIX "com.bosch.AutomotiveProxy.ECM."

static const GDBusErrorEntry error_entries[] =
{
    {
        AP_ECM_NO_ERROR,
        ERROR_PREFIX "NoError"
    },
	{
		AP_ECM_CERT_SUCCESS,
		ERROR_PREFIX "CertSuccess"
	},
	{
		AP_ECM_CERT_PUSH_SUCCESS,
		ERROR_PREFIX "CertPushSuccess"
	},
	{
		AP_ECM_SECURE_TIME_UNAVAILABLE,
		ERROR_PREFIX "Secure-TimeUnavailable"
	},
	{
		AP_ECM_NOT_CERTIFICATE,
		ERROR_PREFIX "NotCertificate"
	},
	{
		AP_ECM_NOT_CRL,
		ERROR_PREFIX "NotCrl"
	},
	{
		AP_ECM_CERT_NOT_PRESENT,
		ERROR_PREFIX "CertNotPresent"
	},
	{
		AP_ECM_CERT_NOT_VALID_YET,
		ERROR_PREFIX "CertNotValidYet"
	},
	{
		AP_ECM_CERT_EXPIRED,
		ERROR_PREFIX "CertExpired"
	},
	{
		AP_ECM_CERT_INVALID,
		ERROR_PREFIX "CertInvalid"
	},
	{
		AP_ECM_CERT_REVOKED,
		ERROR_PREFIX "CertRevoked"
	},
	{
		AP_ECM_CRL_NOT_PRESENT,
		ERROR_PREFIX "CrlNotPresent"
	},
	{
		AP_ECM_CRL_NOT_VALID_YET,
		ERROR_PREFIX "CrlNotValidYet"
	},
	{
		AP_ECM_CRL_EXPIRED,
		ERROR_PREFIX "CrlExpired"
	},
	{
		AP_ECM_CRL_INVALID,
		ERROR_PREFIX "CrlInvalid"
	}
};

GQuark
ap_ecm_error_quark (void)
{
  static volatile gsize id = 0;

  g_dbus_error_register_error_domain ("ap-ecm-error-quark", &id,
                                      error_entries,
                                      G_N_ELEMENTS (error_entries));

  return (GQuark) id;
}
