/*!
********************************************************************************
* @file             : ECMClientHandler.h
********************************************************************************
*  - PROJECT:       : ECM Client Handler Header
*  - SW-COMPONENT   : Gateway
*  - DESCRIPTION    : Dbus client to connect to ECM
*  - COPYRIGHT      : &copy; 2017 Robert Bosch Engineering & Business Solutions
*  - Documents      : -
*  - HISTORY
*
*  Date     | Name          |  Version | Modification
* ----------|---------------|--------------------------|-----------------------
*23.3.2017 | IPD5KOR(RBEI/ECO2) | 1.0.0 | Dbus client impl. to connect to ECM
*******************************************************************************/

#ifndef ECM_CLIENTHANDLER_H
#define ECM_CLIENTHANDLER_H
#include <glib.h>
#include <gio/gio.h>

/******************************************************************
 * Function:     vECMClientProxyCallBack
 * Description:  This is call back function for ECM proxy
                 object creation
 * Parameters:   source_object, res, user_data
 * Return:       void
 ******************************************************************/
void vECMClientProxyCallBack( GObject *source_object,
                        GAsyncResult *res,
                        gpointer user_data );

/****************************************************************************
 * Function:    ecm_service_appeared
 * Description: Name appeared call back for ECM
 * Parameters:  connection , service_name , owner_name, userdata
 * Return:      void
 *****************************************************************************/
void
ecm_service_appeared (GDBusConnection *connection, const gchar *name,
               const gchar *name_owner, gpointer user_data);

/****************************************************************************
 * Function:    ecm_service_vanished
 * Description: Name disappeared call back for ECM service
 * Parameters:  connection, service_name, user_data
 * Return:      void
 *****************************************************************************/
void
ecm_service_vanished (GDBusConnection *connection,
                      const gchar *service_name,
                      gpointer user_data);

/******************************************************************************
 * Function:      clearGatewayECMClientProxy
 * Description:   This function clears the AGW ECM Proxy
 * Parameters:    void
 * Return:        void
 ******************************************************************************/
void clearGatewayECMClientProxy();

/******************************************************************************
 * Function:      vCheckCertResult
 * Description:   This function handles the result of CheckCert
                  non-blocking DBus call
 * Parameters:    resObject, result sync pointer, user_data
 * Return:        void
 ******************************************************************************/
void vCheckCertResult(GObject* pObj,
                     GAsyncResult *res,
                     gpointer user_data);

/******************************************************************************
 * Function:      vPushCertResult
 * Description:   This function handles the result of pushCert
                  non-blocking DBus call
 * Parameters:    resObject, result sync pointer, user_data
 * Return:        void
 ******************************************************************************/
void vPushCertResult( GObject* pObj,
                      GAsyncResult *res,
                      gpointer user_data );

/******************************************************************************
 * Function:      vPushCrlResult
 * Description:   This function handles the result of pushCrl
                  non-blocking DBus call
 * Parameters:    resObject, result sync pointer, user_data
 * Return:        void
 ******************************************************************************/
void vPushCrlResult( GObject* pObj,
                      GAsyncResult *res,
                      gpointer user_data );

/******************************************************************************
 * Function:      vGetCrlNextUpdtResult
 * Description:   This function handles the result of getCrlNextUpd
                  non-blocking DBus call
 * Parameters:    resObject, result sync pointer, user_data
 * Return:        void
 ******************************************************************************/
void vGetCrlNextUpdResult( GObject* pObj,
                      GAsyncResult *res,
                      gpointer user_data );

#endif //ECM_CLIENTHANDLER_H
