/******************************************************************************
*
* FILE:          ECMDbusHandler.h
*
* PROJECT:       FC_GENERIC_GATEWAY
*
* DESCRIPTION:   DBUS service handler for ECM.
*
* AUTHOR:        IPD5KOR(RBEI/ECO2)
*
* COPYRIGHT:     (c) 2017 Robert Bosch GmbH, Hildesheim
*
******************************************************************************/
#ifndef ECM_DBUS_HANDLER_H
#define ECM_DBUS_HANDLER_H

#include "CertificateManager_generated.h"

#include <glib.h>

/******************************************************************************
* Function:    handle_push_certificate
* Description: used to push the certificate 
* Parameters:  proxy object, invocation pointer, certificate,
*              certificateSize, user data
* Return:      gboolean
*****************************************************************************/
gboolean
handle_push_certificate (CertificateManager *object,
                         GDBusMethodInvocation *invocation,
                         GVariant *certificate,
                         guint32  certificateSize,
                         gpointer user_data);

/******************************************************************************
* Function:    handle_push_crl
* Description: used to push the revocation list into head unit
* Parameters:  proxy object, invocation pointer, crl, crlSize, user data
* Return:      gboolean
*****************************************************************************/
gboolean
handle_push_crl ( CertificateManager *object,
                  GDBusMethodInvocation *invocation,
                  GVariant *crl,
                  guint32 crlSize,
                  gpointer user_data );

/******************************************************************************
* Function:    handle_get_crlvalidity
* Description: Gives the validity state of a CRL. 
* Parameters:  proxy object, invocation pointer, crl_type, user data
* Return:      gboolean
*****************************************************************************/
gboolean
handle_get_crlvalidity ( CertificateManager *object,
                         GDBusMethodInvocation *invocation,
                         guchar crl_type,
                         gpointer user_data );

/******************************************************************************
* Function:    handle_get_device_cert
* Description: This method provides certificate 
               for the device specific key in PEM format
* Parameters:  proxy object, invocation pointer,
*              certData, certSize, user data
* Return:      gboolean
*****************************************************************************/
gboolean
handle_get_device_cert ( CertificateManager *object,
                         GDBusMethodInvocation *invocation,
                         GVariant*    certData,
                         guint32      certSize,
                         gpointer user_data );

/******************************************************************************
* Function:    handle_check_cert
* Description: This method takes a DER encoded 
               certificate and check if it`s valid and if
               the chain is valid up to the root certifcate.
* Parameters:  proxy object, invocation pointer,
*              certData, certSize, user data
* Return:      gboolean
*****************************************************************************/
gboolean
handle_check_cert ( CertificateManager *object,
                    GDBusMethodInvocation *invocation,
                    GVariant*    certData, 
                    guint32      certSize,
                    gpointer     user_data );

/***************************************************************************
 * Function:    isValidECMError
 * Description: This method checks whether error code is part
                of ApEcmError
 * Parameters:  errorCode
 * Returns:     gboolean
******************************************************************************/
gboolean isValidECMError(gint errorCode);

/******************************************************************************
* Function:    bInitialize
* Description: Initializes the plugin by creating skeleton object
* Parameters:  void 
* Return:      gboolean - TRUE when skeleteon creation is success,
                          FALSE when skeleton creation fails
*****************************************************************************/
gboolean bInitializeECM();

/******************************************************************************
* Function:    uninitialize
* Description: This method unintializes the ECM gateway component
* Parameters:  void
* Return:      void
*****************************************************************************/
void uninitializeECM();

/******************************************************************************
* Function:    poGetCertificateProxyObj
* Description: Gives the Proxy object of Certificate Handler
* Parameters:  void
* Return:      CertificateManager *
*****************************************************************************/
CertificateManager *poGetCertManagerProxyObj();

#endif //ECM_DBUS_HANDLER_H
