/***********************************************************************
*FILE: ConfigDataClientHandler.h
*SW-COMPONENT: Internet
*DESCRIPTION: Header to ConfigDataClientHandler.c
*COPYRIGHT: Ã© 2017 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
***********************************************************************/

#ifndef CONFIG_DATA_CLIENT_HANDLER_H
#define CONFIG_DATA_CLIENT_HANDLER_H
#include <gio/gio.h>
#include <glib.h>

 /******************************************************************
 * Function:     vConfigDataProxyCallBack
 * Description:  Proxy Call back for Config management
 * Parameters:   source_object, res, user_data
 * Return:       void
 ******************************************************************/
 void vConfigDataProxyCallBack( GObject*      source_object,
                                GAsyncResult* res,
                                gpointer      user_data );

 /****************************************************************************
 * Function:    config_data_service_appeared
 * Description: Service appeared call back of config management
 * Parameters:  connection , service name , owner name, userdata
 * Returns:     void
 *****************************************************************************/
 void
 config_data_service_appeared( GDBusConnection* connection,
                               const    gchar*  name,
                               const    gchar*  owner_name,
                               gpointer         user_data );

 /********************************************************************
  * Function:    vSetPrivateItemCallBack
  * Description: Callback for SetPrivateItem result
  * Parameters:  GObject*, GAsyncResult*, gpointer
  * Return:      void
  ********************************************************************/
 void vSetPrivateItemCallBack( GDBusConnection* pObject,
                               GAsyncResult*    res,
                               gpointer         user_data );

 /********************************************************************
  * Function:    vGetPrivateItemCallBack
  * Description: Callback for GetPrivateItem result
  * Parameters:  GObject*, GAsyncResult*, gpointer
  * Return:      void
  ********************************************************************/
 void vGetPrivateItemCallBack( GDBusConnection* pObject,
                               GAsyncResult*    res,
                               gpointer         user_data );

 /********************************************************************
  * Function:    vUpdatePublicItemCallBack
  * Description: Callback for UpdatePublicItemResult result
  * Parameters:  GDBusConnection*, GAsyncResult*, gpointer
  * Return:      void
  ********************************************************************/
 void  vUpdatePublicItemCallBack( GDBusConnection* pObject,
                                  GAsyncResult*    res,
                                  gpointer         user_data );

 /********************************************************************
  * Function:    vExchangeDescmoCallBack
  * Description: Callback for ExchangeDescmo result
  * Parameters:  GDBusConnection*, GAsyncResult*, gpointer
  * Return:      void
  ********************************************************************/
 void vExchangeDescmoCallBack( GDBusConnection* pObject,
                               GAsyncResult*    res,
                               gpointer         user_data );

#endif
