/***********************************************************************
*FILE: ConfigDataClientInterface.h
*SW-COMPONENT: Internet
*DESCRIPTION:  Interface file for Config 
               data client plugin
*COPYRIGHT: Ã© 2017 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
***********************************************************************/

#ifndef CONFIG_DATA_CLIENT_INTERFACE_H
#define CONFIG_DATA_CLIENT_INTERFACE_H

#include <gio/gio.h>
#include <glib.h>
#include "ap-cm-enums.h"

 /***************************************************************
 * Function:    watch_config_data
 * Description: Connects to Obigo Config data Dbus service
 * Parameters:  void
 * Returns:     void
 ***************************************************************/
 void watch_config_data();

 /****************************************************************
  * Function:    vSetPrivateItem
  * Description: Sets the requested private config item data
  * Parameters:  itemName, itemData, user_data
  * Return:      void
  ***************************************************************/
 void vSetPrivateItem (gchar*    itemName,
                       GVariant* itemData,
                       gpointer  user_data );


 /****************************************************************
  * Function:    vGetPrivateItem
  * Description: Gets the requested private config item data
  * Parameters:  itemName, user_data
  * Return:      void
  ***************************************************************/
 void vGetPrivateItem ( gchar*    itemName,
                        gpointer  user_data );


 /****************************************************************
  * Function:    vUpdatePublicItem
  * Description: Updates the public config item
  * Parameters:  itemName, itemData, updateType, user_data
  * Return:      void
  ***************************************************************/
 void vUpdatePublicItem ( gchar*    itemName,
                          GVariant* itemData,
                          guint     updateType,
                          gpointer  user_data );

 /****************************************************************
  * Function:    vExchangeDescmo
  * Description: SET / GET of private config in XML format
  * Parameters:  itemName, itemXML, signatureXML, user_data
  * Return:      void
  ***************************************************************/
 void vExchangeDescmo( gchar*    itemName,
                       gchar*    itemXML,
                       gchar*    signatureXML,
                       gpointer  user_data );

/******************************************************************
 * Function:    vExportConfigDataInterface
 * Description: Exposes the config data
                interface of gateway
 * Parameters:  void
 * Returns:     void
 ******************************************************************/
void vExportConfigDataInterface();

 /* Callbacks from client */

/***************************************************************************
 * Function:    vHandleSetPrivateItemResult
 * Description: Handles the result of SetPrivateConfigItem
 * Parameters:  status, user_data
 * Returns:     void
 **************************************************************************/
void vHandleSetPrivateItemResult( guint    status,
                                  gpointer user_data );

/***************************************************************************
 * Function:    vHandleGetPrivateItemResult
 * Description: Handles the result of GetPrivateConfigItem
 * Parameters:  item, status, user_data
 * Returns:     void
 **************************************************************************/
void vHandleGetPrivateItemResult( GVariant* item,
                                  guint     status,
                                  gpointer  user_data );

/***************************************************************************
 * Function:    vHandleUpdatePublicItemResult
 * Description: Handles the result of UpdatePublicConfigItem
 * Parameters:  user_data
 * Returns:     void
 **************************************************************************/
void vHandleUpdatePublicItemResult(gpointer  user_data );

/***************************************************************************
 * Function:    vHandleExchangeDescmoResult
 * Description: Handles the result of ExchangeDescmo
 * Parameters:  outXML, status, user_data
 * Returns:     void
 **************************************************************************/
void vHandleExchangeDescmoResult( gchar*    outXML,
                                  guint     status,
                                  gpointer  user_data );

extern GDBusConnection*  poGetGDBusConnection();

#endif
