/*!
*******************************************************************************
* @file             : bluetooth-manager.h
*******************************************************************************
*  - PROJECT:       : Automotive D-Bus server
*  - SW-COMPONENT   : Gateway
*  - DESCRIPTION    : Manager of Bluetooth D-Bus gateway interfaces
*  - COPYRIGHT      : &copy; 2016 Robert Bosch Engineering & Business Solutions
*  - Documents      : Give link of relevant documents
*  - HISTORY
*
*  Date     | Name          |  Version | Modification
* ----------|---------------|--------------------------|-----------------------
* 02.12.2016 | Nagaraj      | 1.0.0 | methods for start Bluetooth DBus
******************************************************************************/
#ifndef BLUETOOTH_MANAGER_H_
#define BLUETOOTH_MANAGER_H_

#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "ap-bluetooth-error-enums.h"
#include "ap-contact-error-enums.h"
#include "DBusToBTProxyWrapper.h"


#include "BluetoothManager_generated.h"
#include "ContactManager_generated.h"
#include "bluetooth-manager-client-handler.h"

void initialise_bluetooth_manager( GDBusConnection *connection,
                                   gpointer        user_data );
void un_initialise_bluetooth_manager();

gboolean handle_get_services_cb(BluetoothManager *object,
	GDBusMethodInvocation *invocation, gpointer user_data);


/**
@brief     vGetServicesMethodResult
@param     void
@return    void
*/
void vGetServicesMethodResult(GVariant* result);

/**
@brief     vGetServiceMethodError
@param     void
@return    void
*/
void vGetServiceMethodError(APBluetoothError eState);

/**
@brief     emit_device_added_signal
@param     const gchar*, GVariant*
@return    void
*/
void emit_device_added_signal(const gchar *device_id, GVariant *properties);

/**
@brief     emit_device_removed_signal
@param     const gchar*
@return    void
*/
void emit_device_removed_signal(const gchar *device_id);

/**
@brief     emit_properties_changed_signal
@param     gchar*, GVariant*
@return    void
*/
void emit_properties_changed_signal(gchar *device_id, GVariant *properties);

/**
@brief     emit_source_removed_signal
@param     const gchar*
@return    void
*/
void emit_source_removed_signal(const gchar *device_id);

/**
@brief     emit_source_added_signal
@param     const gchar*, GVariant*
@return    void
*/
void emit_source_added_signal(const gchar *device_id, GVariant *properties);

BluetoothManager* poGetBtManager();

/**
@brief     handle_get_sources - Handler for get sources
@param     SourceManager, GDBusMethodInvocation
@return    bool
*/
gboolean 
handle_get_sources (SourceManager *object,
                    GDBusMethodInvocation *invocation);   
                    
/**
@brief     vGetSourcesMethodResult
@param     GVariant
@return    void
*/
void vGetSourcesMethodResult(GVariant* result);

/**
@brief     vGetSourcesMethodError
@param     APContactError
@return    void
*/
void vGetSourcesMethodError(APContactError eState);
                    

#endif /* BLUETOOTH_MANAGER_H_ */
