/*!
*******************************************************************************
* @file             : bluetooth-manager-client-handler.h
*******************************************************************************
*  - PROJECT:       : Automotive D-Bus server
*  - SW-COMPONENT   : Gateway
*  - DESCRIPTION    : Client Handler to FC_Bluetooth Component
*  - COPYRIGHT      : &copy; 2016 Robert Bosch Engineering & Business Solutions
*  - Documents      : Give link of relevant documents
*  - HISTORY
*
*  Date      | Name          |  Version | Modification
* -----------|---------------|-------------------------------------------------
* 02.12.2016 | RHK6KOR       | 1.0.0    | methods for Bluetooth Client Handler
******************************************************************************/

#ifndef _FC_GATEWAY_BLUETOOTHCLIENTHANDLER_H_
#define _FC_GATEWAY_BLUETOOTHCLIENTHANDLER_H_

/* Defines for including the needed interface header files */
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

//Include FI interface of Blue Tooth Settings
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_ERRORCODES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_SERVICEINFO

#include "conn_most_fi_if.h"
#include "etrace_if.h"
#include "etg_if.h"


#include "ahl_BaseOneThreadClienthandler.h"
#include "procgenericgateway_tclMainApp.h"
#include "PhoneDataTypes.h"

#ifdef __cplusplus
extern "C"
{
#endif
#include "bluetooth-manager.h"
#ifdef __cplusplus
}
#endif

#define BT_MAXDEVICENAME_LENGTH 255

class ahl_tclBaseOneThreadClientHandler;
class procgenericgateway_tclMainApp;

class
	fc_gateway_tcl_bluetoothclienthandler : public ahl_tclBaseOneThreadClientHandler
{

public:

	static fc_gateway_tcl_bluetoothclienthandler* m_poBluetoothClientHandler;

	fc_gateway_tcl_bluetoothclienthandler(procgenericgateway_tclMainApp*
		poMainAppl);

	static fc_gateway_tcl_bluetoothclienthandler* 
	          getInstance(procgenericgateway_tclMainApp	*poMainAppl);

	/* Destructor */
	virtual ~fc_gateway_tcl_bluetoothclienthandler();


	virtual tVoid vOnServiceAvailable();
	virtual tVoid vOnServiceUnavailable();

    //CCA client handler functions.
	tVoid vHandle_DeviceListExtended_Status(amt_tclServiceData* poMessage);

	//utility functions
	GVariant* vGetSupportedProfileNames(
	     const most_fi_tcl_BTSetSupportedProfiles & 
	            l_most_fi_tcl_BTSetSupportedProfiles);

	bool bGetServices_MethodStart();

	tVoid vHandleDeviceListStatusChange(
	     const most_btsetfi_tclMsgDeviceListExtendedStatus& 
		                          oDeviceListExtendedStatus);

	tVoid vHandleGetServicesMethod(
	     const most_btsetfi_tclMsgDeviceListExtendedStatus& 
		                         oDeviceListExtendedStatus);

   tVoid vHandleGetSourcesMethod(
       const most_btsetfi_tclMsgDeviceListExtendedStatus& 
	                            oDeviceListExtendedStatus);
	tVoid vOnServiceError(amt_tclServiceData *poMessage);

	tU8 getCurrentBTDeviceHandle();

	tU8 m_u8ChangedDeviceHandle;

   bool m_bIsLastRequestIsMethodCall;
   
   bool m_bIsGetSourcesMethodCall;
   
   void vHandleDeviceListChange(
     tU8 u8DeviceHandle,
     const most_fi_tcl_BTSetDeviceListExtendedResult oDeviceListExtendedResult,
	 bool bIsAdded
	 );
   
	/* Message map definition macro */
	DECLARE_MSG_MAP(fc_gateway_tcl_bluetoothclienthandler);
private:
	bool m_bIsBTServiceAvailable;
	most_fi_tcl_BTSetDeviceListExtendedResult m_oDeviceListExtendedResult;
};

#endif //_FC_GATEWAY_BLUETOOTHCLIENTHANDLER_H_