/*!
*******************************************************************************
* @file             : ECNR_ClientHandler.c
*******************************************************************************
*  - PROJECT:       : Automotive Gateway G3G
*  - SW-COMPONENT   : Gateway - Audio
*  - DESCRIPTION    : Handler for ECNR.
*  - COPYRIGHT      : &copy; 2018 Robert Bosch Engineering & Business Solutions
*  - Documents      : Give link of relevant documents
*  - HISTORY
*
*  Date     | Name               |  Version | Modification
* ----------|--------------------|--------------------------|-------------------
* 24.05.2018 | BCP9KOR(RBEI/ECO2) |1.0.0 | Handler for ECNR
*******************************************************************************/

//! Defines for ECNR DBus service
#define ECNR_OBJECT_PATH "/"
#define ECNR_SERVICE_NAME "org.bosch.ecnr.service"
#define ECNR_INTERFACE_NAME "org.bosch.ecnr.service"
#define ECNR_ALSA_INTERFACE_NAME "org.bosch.ecnr.alsa"

//Include from ecnr config is not working.
#define ECNR_APPID_WEB (unsigned char) 5
#define WEB_DATASET_1  (unsigned short) 801

#include "AudioManager_ClientInterface.h"
#include "ECNR_ClientHandler.h"

//Dlt
#include "dlt/dlt.h"
//Dlt Context
DLT_IMPORT_CONTEXT(AGW_Audio);

static const guchar cECNRStartMode = 0;

static void
vInitECNRCallback (GObject *source_object,
                        GAsyncResult *res,
                        gpointer user_data);
						
static void
vUnInitECNRCallback (GObject *source_object,
                        GAsyncResult *res,
                        gpointer user_data);
						
static void
vStartECNRCallback (GObject *source_object,
                        GAsyncResult *res,
                        gpointer user_data);
						
static void
vStopECNRCallback (GObject *source_object,
                        GAsyncResult *res,
                        gpointer user_data);
						
						
static GDBusConnection *poConnection = NULL;		
/******************************************************************************
*
* FUNCTION:    poGetSystemBusConnectionPointer
*
* DESCRIPTION: get system bus connection pointer.
*
* PARAMETER:   void
*
* RETURNVALUE: GDBusConnection*
*
******************************************************************************/						
GDBusConnection* poGetSystemBusConnectionPointer()
{
	GError* error = NULL;
  if(!poConnection)	
  {
	poConnection = g_bus_get_sync(G_BUS_TYPE_SYSTEM,NULL,&error);
    if(poConnection == NULL)
	{
		 if(error != NULL)
        {
            DLT_LOG(AGW_Audio,DLT_LOG_ERROR,DLT_STRING(
                        "ECNR_ClientHandler system bus connection error ::")
                    ,DLT_STRING(error->message));
            g_clear_error(&error);
        }
		
	}	
  }
	return poConnection;
}	

/******************************************************************************
*
* FUNCTION:    vCallECNRFuntion
*
* DESCRIPTION: Calls function at ECNR dbus service.
*
* PARAMETER:   const char*, GVariant*, GAsyncReadyCallback 
*
* RETURNVALUE: static void
*
******************************************************************************/						
static void vCallECNRFuntion(const char* sFunctionName, 
                      GVariant* varParams,
					  GAsyncReadyCallback callback)
{
	DLT_LOG(AGW_Audio,DLT_LOG_INFO,
            DLT_STRING("vCallECNRFuntion() entered"));
	
	
    if (NULL != poGetSystemBusConnectionPointer())
    {

        g_dbus_connection_call ( poGetSystemBusConnectionPointer(),
                             ECNR_SERVICE_NAME,
                             ECNR_OBJECT_PATH,
                             ECNR_INTERFACE_NAME,
                             sFunctionName,
                             varParams,
                             NULL,
                             G_DBUS_CALL_FLAGS_NONE,
                             -1,
                             NULL,
                             callback,
                             NULL );

    }
}


/******************************************************************************
*
* FUNCTION:    vInitializeECNR
*
* DESCRIPTION: Calls ecnrInitialize dbus method at ECNR dbus service
*
* PARAMETER:   void 
*
* RETURNVALUE: void
*
******************************************************************************/
void vInitializeECNR()
{
    DLT_LOG(AGW_Audio,DLT_LOG_INFO,
            DLT_STRING("vInitializeECNR() entered"));
	
    GVariant* params = g_variant_new ("(yu)",(guchar)ECNR_APPID_WEB,
							 (guint)WEB_DATASET_1);
							 
    GVariant* params_ref = g_variant_ref_sink(params);							 
    vCallECNRFuntion("ecnrInitialize", params_ref, vInitECNRCallback);
	g_variant_unref(params_ref);
    DLT_LOG(AGW_Audio,DLT_LOG_INFO,
            DLT_STRING("vInitializeECNR() left"));
}

/******************************************************************************
*
* FUNCTION:    vInitECNRCallback 
*
* DESCRIPTION: Callback function ecnrInitialize dbus method.
*
* PARAMETER:   GObject*, GAsyncResult*, gpointer 
*
* RETURNVALUE: void
*
******************************************************************************/
void
vInitECNRCallback (GObject *source_object,
                        GAsyncResult *res,
                        gpointer user_data)
{
	DLT_LOG(AGW_Audio,DLT_LOG_INFO,
            DLT_STRING("vInitECNRCallback"));
    
  
	
	if (NULL != poGetSystemBusConnectionPointer())
    {
	GError *poError = NULL;
	GVariant *varResult = 
    g_dbus_connection_call_finish (poGetSystemBusConnectionPointer(),
                               res,
                               &poError);
	if (NULL != poError)
    {
        DLT_LOG(AGW_Audio,DLT_LOG_INFO,
            DLT_STRING("vInitECNRCallback  Error:"),
            DLT_STRING(poError->message));
			
        g_clear_error (&poError);
    }
	else
	{
		g_variant_unref(varResult);
	}
	
	}
	else
	{
	DLT_LOG(AGW_Audio,DLT_LOG_ERROR,DLT_STRING(
                        "ECNR_ClientHandler system bus connection error ::"));
	}
	
}
/******************************************************************************
*
* FUNCTION:    vUnitializeECNR
*
* DESCRIPTION: Calls ecnrDestroy dbus method at ECNR dbus service
*
* PARAMETER:   void 
*
* RETURNVALUE: void
*
******************************************************************************/
void vUnitializeECNR()
{
    DLT_LOG(AGW_Audio,DLT_LOG_INFO,
            DLT_STRING("vUnitializeECNR entered"));
    GVariant* params = g_variant_new ("(y)",(guchar)ECNR_APPID_WEB);
							 
    GVariant* params_ref = g_variant_ref_sink(params);							 
    vCallECNRFuntion("ecnrDestroy", params_ref, vUnInitECNRCallback);
	g_variant_unref(params_ref);
    DLT_LOG(AGW_Audio,DLT_LOG_INFO,
            DLT_STRING("vUnitializeECNR left"));

}

/******************************************************************************
*
* FUNCTION:    vUnInitECNRCallback 
*
* DESCRIPTION: Callback function ecnrDestroy dbus method.
*
* PARAMETER:   GObject*, GAsyncResult*, gpointer 
*
* RETURNVALUE: void
*
******************************************************************************/
void
vUnInitECNRCallback (GObject *source_object,
                        GAsyncResult *res,
                        gpointer user_data)
{
	DLT_LOG(AGW_Audio,DLT_LOG_INFO,
            DLT_STRING("vUnInitECNRCallback"));
    
	if (NULL != poGetSystemBusConnectionPointer())
    {
	GError *poError = NULL;
	
	GVariant *varResult = 
    g_dbus_connection_call_finish (poGetSystemBusConnectionPointer(),
                               res,
                               &poError);
	if (NULL != poError)
    {
        DLT_LOG(AGW_Audio,DLT_LOG_INFO,
            DLT_STRING("vUnInitECNRCallback  Error:"),
            DLT_STRING(poError->message));
			
        g_clear_error (&poError);
    }
	else
	{
		g_variant_unref(varResult);
	}
	}
	else
	{
		DLT_LOG(AGW_Audio,DLT_LOG_ERROR,DLT_STRING(
                        "ECNR_ClientHandler system bus connection error ::"));
	}
}

/******************************************************************************
*
* FUNCTION:    vStartECNR
*
* DESCRIPTION: Calls ecnrStartAudioExt dbus method at ECNR dbus service
*
* PARAMETER:   void 
*
* RETURNVALUE: void
*
******************************************************************************/
void vStartECNR()
{
   DLT_LOG(AGW_Audio,DLT_LOG_INFO,
            DLT_STRING("StartECNR() entered"));
    
    GVariant* params = g_variant_new ("(yy)",(guchar)ECNR_APPID_WEB,cECNRStartMode);
							 
    GVariant* params_ref = g_variant_ref_sink(params);							 
    vCallECNRFuntion("ecnrStartAudioExt", params_ref, vStartECNRCallback);
	g_variant_unref(params_ref);
    DLT_LOG(AGW_Audio,DLT_LOG_INFO,
            DLT_STRING("vStartECNR left"));
}

/******************************************************************************
*
* FUNCTION:    vStartECNRCallback 
*
* DESCRIPTION: Callback function ecnrStartAudioExt dbus method.
*
* PARAMETER:   GObject*, GAsyncResult*, gpointer 
*
* RETURNVALUE: void
*
******************************************************************************/
void
vStartECNRCallback (GObject *source_object,
                        GAsyncResult *res,
                        gpointer user_data)
{
	DLT_LOG(AGW_Audio,DLT_LOG_INFO,
            DLT_STRING("vStartECNRCallback"));
    
	if (NULL != poGetSystemBusConnectionPointer())
    {
	GError *poError = NULL;
	GVariant *varResult = 
    g_dbus_connection_call_finish (poGetSystemBusConnectionPointer(),
                               res,
                               &poError);
	if (NULL != poError)
    {
        DLT_LOG(AGW_Audio,DLT_LOG_INFO,
            DLT_STRING("vStartECNRCallback  Error:"),
            DLT_STRING(poError->message));
			
        g_clear_error (&poError);
    }
	else
	{
		g_variant_unref(varResult);
	}
	}
	else
	{
		DLT_LOG(AGW_Audio,DLT_LOG_ERROR,DLT_STRING(
                        "ECNR_ClientHandler system bus connection error ::"));
	}
	
}


/******************************************************************************
*
* FUNCTION:    vStopECNR
*
* DESCRIPTION: Calls ecnrStopAudio dbus method at ECNR dbus service
*
* PARAMETER:   void 
*
* RETURNVALUE: void
*
******************************************************************************/
void vStopECNR()
{
   DLT_LOG(AGW_Audio,DLT_LOG_INFO,
            DLT_STRING("StartECNR entered"));
    GVariant* params = g_variant_new ("(y)",(guchar)ECNR_APPID_WEB);
							 
    GVariant* params_ref = g_variant_ref_sink(params);							 
    vCallECNRFuntion("ecnrStopAudio", params_ref, vStopECNRCallback);
	g_variant_unref(params_ref);
    DLT_LOG(AGW_Audio,DLT_LOG_INFO,
            DLT_STRING("vStopECNR left"));
}


/******************************************************************************
*
* FUNCTION:    vStopECNRCallback 
*
* DESCRIPTION: Callback function ecnrStopAudio dbus method.
*
* PARAMETER:   GObject*, GAsyncResult*, gpointer 
*
* RETURNVALUE: void
*
******************************************************************************/
void
vStopECNRCallback (GObject *source_object,
                        GAsyncResult *res,
                        gpointer user_data)
{
	DLT_LOG(AGW_Audio,DLT_LOG_INFO,
            DLT_STRING("vStopECNRCallback"));
    
    if (NULL != poGetSystemBusConnectionPointer())
    {
	GError *poError = NULL;
	GVariant *varResult = 
    g_dbus_connection_call_finish (poGetSystemBusConnectionPointer(),
                               res,
                               &poError);
	if (NULL != poError)
    {
        DLT_LOG(AGW_Audio,DLT_LOG_INFO,
            DLT_STRING("vStopECNRCallback  Error:"),
            DLT_STRING(poError->message));
			
        g_clear_error (&poError);
    }
	else
	{
		g_variant_unref(varResult);
	}
	}
	else
	{
		DLT_LOG(AGW_Audio,DLT_LOG_ERROR,DLT_STRING(
                        "ECNR_ClientHandler system bus connection error ::"));
	}
	
	DLT_LOG(AGW_Audio,DLT_LOG_INFO,
            DLT_STRING("vStopECNRCallback left"));
}

