/*!
*******************************************************************************
* @file             : FC_Gateway_AudioRouteHandler.h
*******************************************************************************
*  - PROJECT:       : ARL handler inside Gateway
*  - SW-COMPONENT   : Gateway - Audio
*  - DESCRIPTION    : Handler for ARL.
*  - COPYRIGHT      : &copy; 2015 Robert Bosch Engineering & Business Solutions
*  - Documents      : Give link of relevant documents
*  - HISTORY
*
*  Date     | Name          |  Version | Modification
* ----------|---------------|--------------------------|----------------------
*  18.11.2015 | Deepa Jose  | 1.0.0 | Handler for ARL
*  26.10.2016 | RHK6KOR     | 1.1.0 | Compiler switch for player engine calls.
******************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#ifndef _FC_GATEWAY_AUDIOROUTEHANDLER_H_
#define _FC_GATEWAY_AUDIOROUTEHANDLER_H_

/******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/

// include for audio routing lib
#ifndef ARL_S_IMPORT_INTERFACE_GENERIC
#define ARL_S_IMPORT_INTERFACE_GENERIC
#include "audio_routing_lib.h"
#endif

#include "ap-audio-manager-enums.h"
#include <gio/gio.h>


#define TTS_AUDIO_SOURCE ARL_SRC_WEB_TTS

class procgenericgateway_tclMainApp;

class fc_gateway_tclAudioRouteHandler : public arl_tclISource
{

private:

    procgenericgateway_tclMainApp* m_poMainApp;

protected:

    fc_gateway_tclAudioRouteHandler();

public:

    /**
   @brief     Constructor of the class fc_gateway_tclAudioRouteHandler
   @param     poMainApp - pointer instance of the main application
   @return    void
   */
    static fc_gateway_tclAudioRouteHandler*
    getInstance(procgenericgateway_tclMainApp* poMainAppl);

    /**
   @brief     Constructor of the class fc_gateway_tclAudioRouteHandler
   @param     poMainApp - pointer instance of the main application
   @return    void
   */
    fc_gateway_tclAudioRouteHandler(procgenericgateway_tclMainApp* poMainApp);

    /**
   @brief    Destructor of the class fc_gateway_tclAudioRouteHandler
   @param     void
   @return    void
   */
    virtual ~fc_gateway_tclAudioRouteHandler();

    /******************* FUCNTIONS TO CALL ARL INTERFACE **************/
    /**
   @brief     Handler function for SetSourceAvailablity.
   @param     enSrcAvailability    - State of Availability
   @param     enAvailabilityReason - Reason for Availability
   @param     enSource             - Source name
   @param     u16SubSource         - Sub Source name
   @return    void
   */
    tBool
    bSetSourceAvailabilityReq(arl_tenSrcAvailability enSrcAvailability,
                              arl_tenAvailabilityReason enAvailabilityReason,
                              arl_tenSource enSource,
                              tU16 u16SubSource = 0);

    /**
   @brief     Handler function for AudioRouteRequest.
   @param     enSrcNum         - Source name
   @return    bool
   */
    tBool bAudioRouteRequest(arl_tenSource enSrcNum);

    /**
   @brief    Handler function for bAudioReleaseRequest.
   @param     enSrcNum         - Source name
   @return    bool
   */
    tBool bAudioReleaseRequest(arl_tenSource enSrcNum);

    /**
   @brief    Handler function for bMuteStateRequest.
   @param     enSrcNum         - Source name
   @param     enMuteAction     - Mute / De-Mute
   @return    bool
   */
    tBool bMuteStateRequest(arl_tenSource enSrcNum,
                            arl_tenMuteAction enMuteAction);

    /**
   @brief    Handler function for SourceActivityResult.
   @param     enSrcNum         - Source name
   @param     ApAudioSourceStatus     - ON / OFF/PAUSE
   @return    bool
   */
    tBool bAudioSourceActivityResult(arl_tenSource enSrcNum,
                                     ApAudioSourceStatus enStatus);

    /******************* UTILITY FUCNTIONS FOR CONVERSIONS **************/
    /**
   @brief    Gets arl source number from ApAudioSource
   @param    ApAudioSource - gateway source number
   @param    arl_tenSource - arl source number
   @return    bool
   */
    bool  bGetArlSrcNumber(ApAudioSource enApSrcNum,
                           arl_tenSource& enArlSrcNum);

    /**
   @brief    Gets ApAudioSource from arl source number
    @param    arl_tenSource - arl source number
   @param    ApAudioSource - gateway source number
   @return    bool
   */
    bool  bGetGatewayAudioSrcNumber(arl_tenSource enArlSrcNUm,
                                    ApAudioSource& enApSrcNum);


    /******************* OVERLOADED ARL CALLBACK FUCNTIONS **************/

    /**
   @brief    Handler function for OnAllocate.
   @param     enSrcNum         - Source name
   @param     rfcoAllocRoute   - Structure contains info regarding ALSA
   @return    bool
   */
    virtual tBool bOnAllocate(arl_tenSource enSrcNum,
                              const arl_tAllocRouteResult& rfcoAllocRoute);

    /**
   @brief     Handler function for OnDeAllocate.
   @param     enSrcNum         - Source name
   @return    bool
   */
    virtual tBool bOnDeAllocate(arl_tenSource enSrcNum);

    /**
   @brief     Handler function for SrcActivity
   @param     enSrcNum         - Source name
   @param     rfcoAllocRoute   - Structure contains info regarding ALSA
   @return    bool
   */
    virtual tBool bOnSrcActivity(arl_tenSource enSrcNum,
                                 const arl_tSrcActivity& rfcoSrcActivity);

    /**
   @brief     Handler function for MuteState.
   @param     enSrcNum         - Source name
   @param     enMuteState      - ON / OFF MUTE
   @return    bool
   */
    virtual tBool
    bOnMuteState(arl_tenSource enSrcNum, arl_tenMuteState enMuteState);

    /******************* OVERLOADED ARL CALLBACK FUCNTIONS ENDS**************/

    static fc_gateway_tclAudioRouteHandler* m_pofc_gateway_tclAudioRouteHandler;
};


#endif //_FC_GATEWAY_AUDIOROUTEHANDLER_H_
#endif //VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
