/*!
*******************************************************************************
* @file             : ECNR_ClientHandler.h
*******************************************************************************
*  - PROJECT:       : Automotive Gateway G3G
*  - SW-COMPONENT   : Gateway - Audio
*  - DESCRIPTION    : Handler for ECNR.
*  - COPYRIGHT      : &copy; 2018 Robert Bosch Engineering & Business Solutions
*  - Documents      : Give link of relevant documents
*  - HISTORY
*
*  Date     | Name               |  Version | Modification
* ----------|--------------------|--------------------------|-------------------
* 24.05.2018 | BCP9KOR(RBEI/ECO2) |1.0.0 | Handler for ECNR
*******************************************************************************/
#include <gio/gio.h>

#ifdef __cplusplus
extern "C"
{
#endif

/******************************************************************************
* FUNCTION:    vInitializeECNR
* DESCRIPTION: Calls ecnrInitialize dbus method at ECNR dbus service
* PARAMETER:   void 
* RETURNVALUE: void
******************************************************************************/
void vInitializeECNR();

/******************************************************************************
* FUNCTION:    vUnitializeECNR
* DESCRIPTION: Calls ecnrDestroy dbus method at ECNR dbus service
* PARAMETER:   void 
* RETURNVALUE: void
******************************************************************************/
void vUnitializeECNR();

/******************************************************************************
* FUNCTION:    vStartECNR
* DESCRIPTION: Calls ecnrStartAudioExt dbus method at ECNR dbus service
* PARAMETER:   void 
* RETURNVALUE: void
******************************************************************************/
void vStartECNR();

/******************************************************************************
* FUNCTION:    vStopECNR
* DESCRIPTION: Calls ecnrStopAudio dbus method at ECNR dbus service
* PARAMETER:   void 
* RETURNVALUE: void
******************************************************************************/
void vStopECNR();

#ifdef __cplusplus
}
#endif //__cplusplus