/*!
*******************************************************************************
* @file             : Audio_DBusHandler.h
*******************************************************************************
*  - PROJECT:       : Audio functionality for Automotive D-Bus server
*  - SW-COMPONENT   : Gateway
*  - DESCRIPTION    : D-Bus server for automotive API's
*  - COPYRIGHT      : &copy; 2015 Robert Bosch Engineering & Business Solutions
*  - Documents      : Give link of relevant documents
*  - HISTORY
*
*  Date     | Name          |  Version | Modification
* ----------|---------------|--------------------------|------------------------
*11.30.2015 | DJS5KOR(RBEI/ECO2) | 1.0.0 | methods for Automotive D-Bus Server
*10.03.2015 | RHK6KOR(RBEI/ECO2) | 1.1.0 | code refactor for common DBus server
******************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#ifndef AUDIO_DBUS_HANDLER_H
#define AUDIO_DBUS_HANDLER_H

#include <glib.h>
#include <stdio.h>

#include "AudioManager_generated.h"
#include "ap-audio-manager-enums.h"
#include "AutomDBusServer.h"

/**
@brief     handles the mute state from D-Bus.
@param     AudioManager object, GDBusMethodInvocation, 
           guchar, gboolean, gpointer
@return    gboolean
*/
gboolean
handle_mute_state_method (AudioManager *object,
                          GDBusMethodInvocation *invocation,
                          guchar arg_Source,
                          gboolean arg_StateRequired,
                          gpointer user_data);

/**
@brief     handles the audio route request method from D-Bus
@param     AudioManager object, GDBusMethodInvocation, 
           guchar, guchar, gpointer
@return    gboolean
*/                 
gboolean
handle_audio_route_request_method (AudioManager *object,
                                   GDBusMethodInvocation *invocation,
                                   guchar arg_Source,
                                   guchar arg_StateRequired,
                                   gpointer user_data);

/**
@brief     handles the audio route request method from D-Bus
@param     AudioManager object, GDBusMethodInvocation, 
           guchar, guchar, gpointer
@return    gboolean
*/                                     
gboolean
handle_source_availability_method (AudioManager *object,
                                   GDBusMethodInvocation *invocation,
                                   guchar arg_Source,
                                   guchar arg_Availability,
                                   gpointer user_data);
/**
@brief     handles the audio route request method from D-Bus
@param     AudioManager object, GDBusMethodInvocation, 
           guchar, guint, gpointer
@return    gboolean
*/                                     
gboolean
handle_source_activity_result_method(AudioManager *object,
                                     GDBusMethodInvocation *invocation,
                                     guchar arg_Source,
                                     guint arg_Status,
                                     gpointer user_data);
#endif //AUDIO_DBUS_HANDLER_H
#endif //#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC