/*!
*******************************************************************************
* @file             : Utility.h
*******************************************************************************
*  - PROJECT:       : Automotive Gateway
*  - SW-COMPONENT   : Utility Functiond
*  - DESCRIPTION    : Utility functions which can be used by multiple components.
*  - COPYRIGHT      : &copy; 2017 Robert Bosch Engineering & Business Solutions
*  - Documents      : Give link of relevant documents
*  - HISTORY
*
*  Date     | Name          |  Version | Modification
* ----------|---------------|--------------------------|-----------------------
* 8.3.2017 | BCP9KOR(RBEI/ECO2) | 1.0.0 | methods for Utility. 
******************************************************************************/
#ifndef _UTILITY_H
#define _UTILITY_H

#include <glib.h>

#define PRINT_GVARIANT(arg , strContext) if(arg != NULL){\
    char* strVal = g_variant_print(arg , TRUE); \
    if(strVal != NULL)\
{\
    DLT_LOG(strContext,DLT_LOG_INFO,DLT_STRING("Variant String:"),DLT_STRING(strVal));\
    g_free(strVal);\
    }\
    }

#define GATEWAY_NULL_POINTER_CHECK(poClass) \
    if (poClass == NULL) {\
    return 0;\
    }

/*****************************************************************************
 * Function:    trim_leading_space
 * Description: Trims out the leading white spaces on both
                sides of the input string
 * Parameters:  input string to be trimmed
 * Return:      TRUE, when input in trimmed
                FALSE, when input is not altered.
******************************************************************************/
gboolean trim_leading_space(gchar* input_str);

/*****************************************************************************
 * Function:    GetDoubleFromVariant
 * Description: Finds out the type of Variant and returns the value in 
 				gdouble
 * Parameters:  GVariant*
 * Return:      gdouble
 *****************************************************************************/
void   DecimalToHexValue(int n);

/******************************************************************************
* Function:    GetDoubleFromVariant
* Description:
* Parameters:  GVariant*
* Return:      gdouble
*****************************************************************************/
gdouble GetDoubleFromVariant(GVariant *variant);

/******************************************************************************
 * Function:       checkIfFileExists
 * Description:    Function to check if file exists
 * Parameters:     gchar*, file path
 * Return:         gboolean
 *****************************************************************************/
gboolean checkIfFileExists(gchar* fname);

/******************************************************************************
 * Function:       DefusePngchildCreation
 * Description:    Function to create child of defuse png
 * Parameters:     char*
 * Return:         int
 *****************************************************************************/
int DefusePngchildCreation(char* in_arg[]);


#endif //_UTILITY_H