/*!
*******************************************************************************
* @file             : GatewayLCMClient.c
*******************************************************************************
*  - PROJECT:       : Automotive Gateway
*  - SW-COMPONENT   : Gateway
*  - DESCRIPTION    : D-Bus server for LCM Clients (container/domain) 
*  - COPYRIGHT      : &copy; 2017 Robert Bosch Engineering & Business Solutions
*  - Documents      : Give link of relevant documents
*  - HISTORY
*
*  Date      | Name          |  Version | Modification
* -----------|---------------|--------------------------|-----------------------
* 09.01.2017 | RHK6KOR(RBEI/ECO2) | 0.1.0 | methods for Gateway LCM API to cont.
******************************************************************************/

#include "GatewayLCMClient.h"
//Dlt
#include "dlt/dlt.h"
//Dlt Context
DLT_DECLARE_CONTEXT(AGW_LCM);  //LCM
static LifeCycleManager* poLCMProxyObj=NULL;
/******************************************************************************
 * Function:    bDoLCMDBusServerSetup
 * Description: setups the Automotive LCM server
 * Parameters:  GDBusConnection*
 * Return:      bool
 *****************************************************************************/

bool       bDoLCMDBusServerSetup(GDBusConnection *pConnection)
{
    DLT_REGISTER_CONTEXT(AGW_LCM,"GWLCM","LCM context for DLT Logging");
    GError *error = NULL;
    if (!g_dbus_interface_skeleton_export (
                G_DBUS_INTERFACE_SKELETON (
                    (LifeCycleManager*)poGetLCMServerProxy()),
                pConnection,
                "/com/bosch/AutomotiveProxy/LifeCycleManager",
                &error))
    {
        DLT_LOG(AGW_LCM,DLT_LOG_ERROR,
                DLT_STRING("LCM Interface skeleton export error:"),
                DLT_STRING(error->message));
        g_clear_error (&error);
        return FALSE;
    }

    /* method for handling LCM calls*/ //FIXME: leaking handles --rhk6kor
    g_signal_connect ((LifeCycleManager*)poGetLCMServerProxy(),
                      "handle-register",
                      G_CALLBACK (handle_register), NULL);

    g_signal_connect ((LifeCycleManager*)poGetLCMServerProxy(),
                      "handle-lifecycle-request-complete",
                      G_CALLBACK (handle_lifecycle_request_complete), NULL);

    //Create a hash table for the shutdown clients.
    do_init_shutdown_client_hash_table();

    return TRUE;

}

/******************************************************************************
 * Function:    vDoLCMServerTearDown
 * Description: tears down the Automotive LCM server
 * Parameters:  void
 * Return:      void
 *****************************************************************************/

void       vDoLCMDBusServerTearDown()
{
    DLT_UNREGISTER_CONTEXT(AGW_LCM);

    if(poLCMProxyObj!=NULL){
        g_dbus_interface_skeleton_unexport(
                    G_DBUS_INTERFACE_SKELETON(poLCMProxyObj));
        g_clear_object (&poLCMProxyObj);
    }
    destroy_shutdown_client_hash_table();
}

/******************************************************************************
 * Function:    poGetLCMServerProxy
 * Description: Creates and gets the LCM server Proxy pointer
 * Parameters:  void
 * Return:      void
 *****************************************************************************/

LifeCycleManager* poGetLCMServerProxy()
{
    DLT_LOG(AGW_LCM,DLT_LOG_INFO,DLT_STRING( "+poGetLCMServerProxy"));

    if(poLCMProxyObj == NULL)
    {
        poLCMProxyObj = life_cycle_manager_skeleton_new ();
    }

    return poLCMProxyObj;
}
