/******************************************************************
*FILE: ap-tts-error-enums.h
*SW-COMPONENT: Internet
*DESCRIPTION: This file contains the error enums related to
*             com.bosch.AutomotiveProxy.TextToSpeech interface.
*COPYRIGHT: © 2016 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#ifndef AP_TTS_ERROR_H
#define AP_TTS_ERROR_H

#include <glib.h>

G_BEGIN_DECLS

/**
 * AP_TTS_ERROR:
 *
 * Error domain for #ApTtsError.
 *
 * Since: 0.1.0
 */
#define AP_TTS_ERROR ap_tts_error_quark ()
GQuark ap_tts_error_quark (void);

/**
 * ApTtsError:
 * @AP_TTS_ERROR_TTS_ENGINE_NOT_STARTED: Text to speech engine is not started.
 * @AP_TTS_ERROR_TEXT_LENGTH_EXCEEDED: Maximum length of text exceeded.
 * @AP_TTS_ERROR_SPEECH_PLAY_FAILED: Error occured while playing speech.
 * @AP_TTS_ERROR_OUT_OF_MEMORY: No memory in the system.
 * @AP_TTS_ERROR_INVALID_PARAMETERS : Invalid input parameters.
 * @AP_TTS_ERROR_UNKNOWN: Unrecognised error.
 *
 * Errors from operations on text to speech manager.
 *
 * Since: 0.1.0
 */
typedef enum
{
  AP_TTS_ERROR_TTS_ENGINE_NOT_STARTED,
  AP_TTS_ERROR_TEXT_LENGTH_EXCEEDED,
  AP_TTS_ERROR_SPEECH_PLAY_FAILED,
  AP_TTS_ERROR_OUT_OF_MEMORY,
  AP_TTS_ERROR_INVALID_PARAMETERS,
  AP_TTS_ERROR_UNKNOWN,
  AP_TTS_PREFERENCES_NOT_SET,
  /*< private >*/
  AP_TTS_MANAGER_ERRORS /*< skip >*/
} ApTtsError;

G_END_DECLS

#endif /* !AP_TTS_ERROR_H */
