/******************************************************************
*FILE: ap-tts-enums.h
*SW-COMPONENT: Internet
*DESCRIPTION: This file contains the enums related to
*             com.bosch.AutomotiveProxy.TextToSpeech interface.
*COPYRIGHT: © 2016 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#ifndef __AP_TTS_ENUMS__
#define __AP_TTS_ENUMS__

/**
* ApTtsState:
* @AP_TTS_STATE_IDLE: Idle state.
* @AP_TTS_STATE_PLAYING: Text to speech is in progress.
* @AP_TTS_STATE_PAUSED: Text to speech is paused.
* @AP_TTS_STATE_CANCELLED: Text to speech is cancelled.
* @AP_TTS_STATE_FAILED: Text to speech is failed.
* @AP_TTS_STATE_FINISHED: Text to speech is finished.
*
* It represents different states of text to speech request.
*
* Since: 0.1.0
*/
typedef enum
{
  AP_TTS_STATE_IDLE,
  AP_TTS_STATE_PLAYING,
  AP_TTS_STATE_PAUSED,
  AP_TTS_STATE_CANCELLED,
  AP_TTS_STATE_FAILED,
  AP_TTS_STATE_FINISHED
} ApTtsState;

/**
* ApTtsPriority:
* @AP_TTS_PRIORITY_IMPORTANT: Priority is of type important.
* @AP_TTS_PRIORITY_MESSAGE: Priority is of type message.
* @AP_TTS_PRIORITY_TEXT: Priority is of type text.
* @AP_TTS_PRIORITY_NOTIFICATION: Priority is of type notification.
* @AP_TTS_PRIORITY_IN_PROGRESS: Priority is of type progress.
*
* It represents priority of text to speech request.
*
* Since: 0.1.0
*/
typedef enum
{
  AP_TTS_PRIORITY_IMPORTANT,
  AP_TTS_PRIORITY_MESSAGE,
  AP_TTS_PRIORITY_TEXT,
  AP_TTS_PRIORITY_NOTIFICATION,
  AP_TTS_PRIORITY_IN_PROGRESS
} ApTtsPriority;

/**
* ApTtsVoiceType:
* @AP_TTS_VOICE_TYPE_MALE: Voice type is male.
* @AP_TTS_VOICE_TYPE_FEMALE: Voice type is female.
* @AP_TTS_VOICE_TYPE_CHILD: Voice type is child.
*
* It represents voice type to be used during text to speech synthesis.
*
* Since: 0.1.0
*/
typedef enum
{
  AP_TTS_VOICE_TYPE_MALE,
  AP_TTS_VOICE_TYPE_FEMALE,
  AP_TTS_VOICE_TYPE_CHILD
} ApTtsVoiceType;

/**
* ApTtsPunctuation:
* @AP_TTS_PUNCTUATION_ALL: Punctuate all.
* @AP_TTS_PUNCTUATION_NONE: Punctuate none.
* @AP_TTS_PUNCTUATION_SOME: Punctuate some.
*
* It indicates punctuation mode.
*
* Since: 0.1.0
*/
typedef enum
{
  AP_TTS_PUNCTUATION_ALL,
  AP_TTS_PUNCTUATION_NONE,
  AP_TTS_PUNCTUATION_SOME
} ApTtsPunctuation;

/**
* ApTtsVoiceRate:
* @AP_TTS_VOICE_RATE_SLOW: Voice rate is slow.
* @AP_TTS_VOICE_RATE_NORMAL: Voice rate is normal.
* @AP_TTS_VOICE_RATE_FAST: Voice rate is fast.
*
* It controls how fast the synthesizer is going to speak.
*
* Since: 0.1.0
*/
typedef enum
{
  AP_TTS_VOICE_RATE_SLOW = 50,
  AP_TTS_VOICE_RATE_NORMAL = 100,
  AP_TTS_VOICE_RATE_FAST = 150
} ApTtsVoiceRate;

/**
* ApTtsVolume:
* @AP_TTS_VOLUME_NORMAL: Volume is normal.
* @AP_TTS_VOLUME_EMPHASIZED: Volume is emphasized.
* @AP_TTS_VOLUME_DEEMPHASIZED: Volume is deemphasized.
*
* It controls the volume of the voice.
*
* Since: 0.1.0
*/
typedef enum
{
  AP_TTS_VOLUME_DEEMPHASIZED = -100,
  AP_TTS_VOLUME_NORMAL = 100,
  AP_TTS_VOLUME_EMPHASIZED = 140
} ApTtsVolume;

/**
* ApTtsPitch:
* @AP_TTS_PITCH_LOW: Pitch is low.
* @AP_TTS_PITCH_NORMAL: Pitch is normal.
* @AP_TTS_PITCH_HIGH: Pitch is high.
*
* It controls the pitch of the synthesized voice.
*
* Since: 0.1.0
*/
typedef enum
{
  AP_TTS_PITCH_LOW = -100,
  AP_TTS_PITCH_NORMAL = 0,
  AP_TTS_PITCH_HIGH = 100
} ApTtsPitch;

#endif
