/******************************************************************
*FILE: ap-telephony-manager-enums.h 
*SW-COMPONENT: Internet
*DESCRIPTION: This file contains the enums related to telephony manager
*COPYRIGHT: © 2016 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#ifndef __AP_TELEPHONY_MANAGER_ENUMS__
#define __AP_TELEPHONY_MANAGER_ENUMS__

/**
 * ApTelephonyCallDirection:
 * @AP_TELEPHONY_CALL_DIRECTION_DIALED: Dialed calls.
 * @AP_TELEPHONY_CALL_DIRECTION_RECEIVED: Received calls.
 * @AP_TELEPHONY_CALL_DIRECTION_MISSED: Missed calls.
 * @AP_TELEPHONY_CALL_DIRECTION_COMBINED: Combined list.
 *
 * It represents different values for call direction.
 *
 * Since: 0.1.0
 */

typedef enum
{
  AP_TELEPHONY_CALL_DIRECTION_DIALED,
  AP_TELEPHONY_CALL_DIRECTION_RECEIVED,
  AP_TELEPHONY_CALL_DIRECTION_MISSED,
  AP_TELEPHONY_CALL_DIRECTION_COMBINED
} ApTelephonyCallDirection;

/**
 * ApTelephonyCallDisconnectReason:
 * @AP_TELEPHONY_CALL_DISCONNECT_REASON_LOCAL: The call was disconnected by the user, or the device, and no more specific reason is known 
 * @AP_TELEPHONY_CALL_DISCONNECT_REASON_REMOTE: The call was disconnected by the remote party, and no more specific reason is known.   
 * @AP_TELEPHONY_CALL_DISCONNECT_REASON_NETWORK: The call was disconnected by the network, and no more specific reason is known. 
 * @AP_TELEPHONY_CALL_DISCONNECT_REASON_BUSY: The call was disconnected by the network, because the remote party was busy. 
 * @AP_TELEPHONY_CALL_DISCONNECT_REASON_REJECTED: The call was disconnected because the remote party rejected the call. 
 * @AP_TELEPHONY_CALL_DISCONNECT_REASON_REDIRECTED: The call has been redirected to another subscriber.
 * @AP_TELEPHONY_CALL_DISCONNECT_REASON_UNREACHABLE: The call was disconnected by the network, because the remote party was unreachable by the network. 
 * @AP_TELEPHONY_CALL_DISCONNECT_REASON_NOANSWER: The call was disconnected by the network, because the remote party has not answered and the call has timed out. 
 * @AP_TELEPHONY_CALL_DISCONNECT_REASON_NETWORKUNREACHABLE: The call was disconnected because the network was unreachable. 
 * @AP_TELEPHONY_CALL_DISCONNECT_REASON_BARRED: The call was disconnected because it was barred.
 * @AP_TELEPHONY_CALL_DISCONNECT_REASON_NOSERVICE: The call was not made because there is no telephony service set up and enabled (e.g. no SIM card). 
 * @AP_TELEPHONY_CALL_DISCONNECT_REASON_INVALIDNUMBER: The call was disconnected by the network, because the remote party identifier was invalid. 
 * @AP_TELEPHONY_CALL_DISCONNECT_REASON_NULL: The proper call. 
 *
 * Enums indicating call disconnect reasons.
 *
 * Since: 0.1.0
 */

typedef enum
{
  AP_TELEPHONY_CALL_DISCONNECT_REASON_LOCAL,
  AP_TELEPHONY_CALL_DISCONNECT_REASON_REMOTE,
  AP_TELEPHONY_CALL_DISCONNECT_REASON_NETWORK,
  AP_TELEPHONY_CALL_DISCONNECT_REASON_BUSY,
  AP_TELEPHONY_CALL_DISCONNECT_REASON_REJECTED,
  AP_TELEPHONY_CALL_DISCONNECT_REASON_REDIRECTED,
  AP_TELEPHONY_CALL_DISCONNECT_REASON_UNREACHABLE,
  AP_TELEPHONY_CALL_DISCONNECT_REASON_NOANSWER,
  AP_TELEPHONY_CALL_DISCONNECT_REASON_NETWORKUNREACHABLE,
  AP_TELEPHONY_CALL_DISCONNECT_REASON_BARRED,
  AP_TELEPHONY_CALL_DISCONNECT_REASON_NOSERVICE,
  AP_TELEPHONY_CALL_DISCONNECT_REASON_INVALIDNUMBER,
  AP_TELEPHONY_CALL_DISCONNECT_REASON_NULL,
  AP_TELEPHONY_CALL_DISCONNECT_REASON_UNKOWN
} ApTelephonyCallDisconnectReason;


/**
 * ApTelephonyCallState:
 * @AP_TELEPHONY_CALL_STATE_DIALING: An outbound call is being dialed by a telephony manager.
 * @AP_TELEPHONY_CALL_STATE_CONNECTING: A request to establish the outbound call has been made and it is progressing.
 * @AP_TELEPHONY_CALL_STATE_ALERTING: The destination number has been reached and alerting is taking place in an outbound call. 
 * @AP_TELEPHONY_CALL_STATE_RINGING: An inbound call is locally alerting (by beep, vibration pattern, ringing, or by other means), 
 *				     and the network can notify the remote party with the alerting state.
 * @AP_TELEPHONY_CALL_STATE_ACTIVE: The call is connected and media channels are attached.
 * @AP_TELEPHONY_CALL_STATE_CONFERENCE: The call is active, i.e. connected and media channels are attached, as part of a conference call.
 * @AP_TELEPHONY_CALL_STATE_INCOMING: An incoming call is being received whilst no other call is progressing. 
 * @AP_TELEPHONY_CALL_STATE_WAITING: An incoming call that has been received whilst there was another call progressing, and the call waiting service is active.
 * @AP_TELEPHONY_CALL_STATE_ACCEPTED: An incoming call has been accepted by the remote party and is being connected.
 * @AP_TELEPHONY_CALL_STATE_HELD: The call has been put on hold by the network.
 * @AP_TELEPHONY_CALL_STATE_DISCONNECTED: The call has been disconnected by the network and this callId is invalid for call control. 
 * @AP_TELEPHONY_CALL_STATE_HOLDING: The call is being put on hold.
 * @AP_TELEPHONY_CALL_STATE_RESUMING: The call, which was on hold, is being resumed.
 * @AP_TELEPHONY_CALL_STATE_REDIRECTING: The call is being redirected (deflected) to another remote party.
 * @AP_TELEPHONY_CALL_STATE_TRANSFERRING: The call is being transferred to another remote party.
 * @AP_TELEPHONY_CALL_STATE_DISCONNECTING: A request to disconnect the call has been made and it is progressing. 
 *
 * It represents different values for call state.
 *
 * Since: 0.1.0
 */

typedef enum
{
  AP_TELEPHONY_CALL_STATE_DIALING,
  AP_TELEPHONY_CALL_STATE_CONNECTING,
  AP_TELEPHONY_CALL_STATE_ALERTING,
  AP_TELEPHONY_CALL_STATE_RINGING,
  AP_TELEPHONY_CALL_STATE_ACTIVE,
  AP_TELEPHONY_CALL_STATE_CONFERENCE,
  AP_TELEPHONY_CALL_STATE_INCOMING,
  AP_TELEPHONY_CALL_STATE_WAITING,
  AP_TELEPHONY_CALL_STATE_ACCEPTED,
  AP_TELEPHONY_CALL_STATE_HELD,
  AP_TELEPHONY_CALL_STATE_DISCONNECTED,
  AP_TELEPHONY_CALL_STATE_HOLDING,
  AP_TELEPHONY_CALL_STATE_RESUMING,
  AP_TELEPHONY_CALL_STATE_REDIRECTING,
  AP_TELEPHONY_CALL_STATE_TRANSFERRING,
  AP_TELEPHONY_CALL_STATE_DISCONNECTING,
  AP_TELEPHONY_CALL_STATE_IDLE,  
  AP_TELEPHONY_CALL_STATE_UNKOWN
} ApTelephonyCallState;

/**
 * ApTelephonyTechnology:
 * @AP_TELEPHONY_TECHNOLOGY_GSM: gsm.
 * @AP_TELEPHONY_TECHNOLOGY_CDMA: cdma.
 * @AP_TELEPHONY_TECHNOLOGY_EDGE: edge.
 * @AP_TELEPHONY_TECHNOLOGY_UMTS: umts.
 * @AP_TELEPHONY_TECHNOLOGY_HSPS: hspa.
 * @AP_TELEPHONY_TECHNOLOGY_LTE: lte.
 *
 * It represents different values for telephony technology.
 *
 * Since: 0.1.0
 */

typedef enum
{
  AP_TELEPHONY_TECHNOLOGY_GSM,
  AP_TELEPHONY_TECHNOLOGY_CDMA,
  AP_TELEPHONY_TECHNOLOGY_EDGE,
  AP_TELEPHONY_TECHNOLOGY_UMTS,
  AP_TELEPHONY_TECHNOLOGY_HSPS,
  AP_TELEPHONY_TECHNOLOGY_LTE,
  AP_TELEPHONY_TECHNOLOGY_UNKOWN
} ApTelephonyTechnology;

/**
 * ApTelephonySmsState:
 * @AP_TELEPHONY_SMS_STATE_RECEIVED: The message is an inbound message. 
 * @AP_TELEPHONY_SMS_STATE_SENDING: The message is in process of being sent. 
 * @AP_TELEPHONY_SMS_STATE_SENT: The message has been successfully sent. 
 * @AP_TELEPHONY_SMS_STATE_DELIVERED : The message has been 
                                       successfully delivered.
 * @AP_TELEPHONY_SMS_STATE_FAILED: The message is an outbound message 
                                   whose submission has failed. 
 *
 * It represents different values for SMS state.
 *
 * Since: 0.1.0
 */

typedef enum
{
  AP_TELEPHONY_SMS_STATE_RECEIVED,
  AP_TELEPHONY_SMS_STATE_SENDING,
  AP_TELEPHONY_SMS_STATE_SENT,
  AP_TELEPHONY_SMS_STATE_DELIVERED,
  AP_TELEPHONY_SMS_STATE_FAILED,
  AP_TELEPHONY_SMS_STATE_UNKOWN
} ApTelephonySmsState;

/**
 * ApTelephonySmsDeliveryStatus:
 * @AP_TELEPHONY_SMS_DELIVERY_STATUS_SUCCESS: The message has been succesfully delivered to the recipient. 
 * @AP_TELEPHONY_SMS_DELIVERY_STATUS_PENDING: The message is pending delivery. 
 * @AP_TELEPHONY_SMS_DELIVERY_STATUS_ERROR: The delivery of the message has failed. 
 * @AP_TELEPHONY_SMS_DELIVERY_STATUS_NOTAPPLICABLE: The delivery status is not applicable either because a delivery 
 *						    report has not been requested or because the message is an inbound message.
 *
 * It represents different values for SMS delivery status.
 *
 * Since: 0.1.0
 */

typedef enum
{
  AP_TELEPHONY_SMS_DELIVERY_STATUS_SUCCESS,
  AP_TELEPHONY_SMS_DELIVERY_STATUS_PENDING,
  AP_TELEPHONY_SMS_DELIVERY_STATUS_ERROR,
  AP_TELEPHONY_SMS_DELIVERY_STATUS_NOTAPPLICABLE
} ApTelephonySmsDeliveryStatus;

/**
* ApTelephonySortBy:
* @AP_TELEPHONY_SORTBY_FIRSTNAME: Sort by first name.
* @AP_TELEPHONY_SORTBY_LASTNAME: Sort by last name.
* @AP_TELEPHONY_SORTBY_ADDRESS: Sort by address.
* @AP_TELEPHONY_SORTBY_EMAIL: Sort by email.
* @AP_TELEPHONY_SORTBY_NUMBER: Sort by phone number.
* @AP_TELEPHONY_SORTBY_CATEGORY: Sort by category.
* @AP_TELEPHONY_SORTBY_TIMESTAMP: Sort by Timestamp.
*
* It represents different values for SortBy.
*
* Since: 0.1.0
*/
typedef enum
{
  AP_TELEPHONY_SORTBY_FIRSTNAME,
  AP_TELEPHONY_SORTBY_LASTNAME,
  AP_TELEPHONY_SORTBY_ADDRESS,
  AP_TELEPHONY_SORTBY_EMAIL,
  AP_TELEPHONY_SORTBY_NUMBER,
  AP_TELEPHONY_SORTBY_CATEGORY,
  AP_TELEPHONY_SORTBY_TIMESTAMP,
  AP_TELEPHONY_SORTBY_FINISHED
} ApTelephonySortBy;

/**
* ApTelephonySortOrder:
* @AP_TELEPHONY_SORT_ORDER_ASCENDING: Sort order is ascending.
* @AP_TELEPHONY_SORT_ORDER_DESCENDING: Sort order is descending.
*
* It represents different values for SortOrder.
*
* Since: 0.1.0
*/
typedef enum
{
  AP_TELEPHONY_SORT_ORDER_ASCENDING,
  AP_TELEPHONY_SORT_ORDER_DESCENDING,
  AP_TELEPHONY_SORT_ORDER_FINISHED
} ApTelephonySortOrder;

/**
* ApTelephonyDurationOperation:
* @AP_TELEPHONY_DURATION_OPERATION_EQUAL: Equal to.
* @AP_TELEPHONY_DURATION_OPERATION_LESSTHAN: Less than.
* @AP_TELEPHONY_DURATION_OPERATION_MORETHAN: More than.
* @AP_TELEPHONY_DURATION_OPERATION_LESSTHANOREQUAL: Less than or equal.
* @AP_TELEPHONY_DURATION_OPERATION_MORETHANOREQUAL: More than or equal.
*
* It represents different values for telephony duration operation.
*
* Since: 0.1.0
*/

typedef enum
{
  AP_TELEPHONY_DURATION_OPERATION_EQUAL,
  AP_TELEPHONY_DURATION_OPERATION_LESSTHAN,
  AP_TELEPHONY_DURATION_OPERATION_MORETHAN,
  AP_TELEPHONY_DURATION_OPERATION_LESSTHANOREQUAL,
  AP_TELEPHONY_DURATION_OPERATION_MORETHANOREQUAL
} ApTelephonyDurationOperation;


#endif
