/******************************************************************
*FILE: ap-telephony-error-enums.h
*SW-COMPONENT: Internet
*DESCRIPTION: Telephony manager error enums
*COPYRIGHT: © 2016 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#ifndef AP_TELEPHONY_ERROR_H
#define AP_TELEPHONY_ERROR_H

#include <glib.h>

G_BEGIN_DECLS

/**
 * AP_TELEPHONY_ERROR:
 *
 * Error domain for #APTelephonyError.
 *
 * Since: 0.1.0
 */
#define AP_TELEPHONY_ERROR ap_telephony_error_quark ()
GQuark ap_telephony_error_quark (void);

/**
 * APTelephonyError:
 * @AP_TELEPHONY_ERROR_UNKNOWN_SOURCE: The given source does not exist in this
 *    system.
 * @AP_TELEPHONY_ERROR_UNKNOWN_ATTRIBUTE: The given attribute does not exist in
 *    this system.
 * @AP_TELEPHONY_ERROR_INVALID_ATTRIBUTE_VALUE: Attribute value is invalid.
 * @AP_TELEPHONY_ERROR_ATTRIBUTE_UNAVAILABLE: Attribute is not currently available
 *    for access.
 * @AP_TELEPHONY_ERROR_ILLEGAL_BEHAVIOUR: The given telephony implementation
 *    broke the interface definition.
 * @AP_TELEPHONY_ERROR_INVALID_HANDLE: The given handle is invalid.
 * @AP_TELEPHONY_ERROR_BAD_CALL_INSTANCE: The given call instance is invalid.
 * @AP_TELEPHONY_ERROR_INTERNAL: Internal Error.
 *
 * Errors from operations on telephony manager.
 *
 * Since: 0.1.0
 */
typedef enum
{
  AP_TELEPHONY_ERROR_UNKNOWN_SOURCE,
  AP_TELEPHONY_ERROR_UNKNOWN_ATTRIBUTE,
  AP_TELEPHONY_ERROR_INVALID_ATTRIBUTE_VALUE,
  AP_TELEPHONY_ERROR_ATTRIBUTE_UNAVAILABLE,
  AP_TELEPHONY_ERROR_ILLEGAL_BEHAVIOUR,
  AP_TELEPHONY_ERROR_INVALID_HANDLE,
  AP_TELEPHONY_ERROR_BAD_CALL_INSTANCE,
  AP_TELEPHONY_ERROR_INTERNAL,
  /*< private >*/
  AP_TELEPHONY_N_MANAGER_ERRORS /*< skip >*/
} APTelephonyError;

G_END_DECLS

#endif /* !AP_TELEPHONY_ERROR_H */
