/******************************************************************
*FILE: ap-sdc-enums.h
*SW-COMPONENT: SDC
*DESCRIPTION: SDC enum definitions
*COPYRIGHT: 2017 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#ifndef AP_SDC_ENUMS_H
#define AP_SDC_ENUMS_H

#include <glib.h>

G_BEGIN_DECLS

/**
 * AP_SDC_ERROR:
 *
 * Error domain for #APSDCError.
 *
 * Since: 0.1.0
 */
#define AP_SDC_ERROR ap_sdc_error_quark ()
GQuark ap_sdc_error_quark (void);

/**
 * APBluetoothError:
 * @AP_SDC_ERROR_UNKNOWN: Some unknown or unidentified error
 * @AP_SDC_ERROR_BAD_DATA: libsdc returns bad data like bad signature 
                           or bad plaindata
 *    this device.
 * @AP_SDC_ERROR_INVALID_INPUT: gateway sdc methods are called with some 
                                invalid input like NULL data
 * Since: 0.1.0
 */
typedef enum
{
  AP_SDC_ERROR_UNKNOWN,
  AP_SDC_ERROR_BAD_DATA,
  AP_SDC_ERROR_INVALID_INPUT
} APSDCError;
/**
  ApCheckCertResult: Possible results of check cert
   * @AP_CC_SUCCESS:           Check Cert Success
   * @AP_CC_CERT_NOT_PRESENT:  Device cert is not available
   * @AP_CC_INVALID_CERT:      Certificate is not valid
   * @AP_CC_CERT_FORMAT_ERROR: Input data is not in proper
	                            cert format
   * @AP_CC_CRL_NOT_VALID:     CRL is not valid
   * @AP_CC_SECURE_TIME_ERROR: Secure time is not available
   *
   * Since: 0.1.1
   */ 
typedef enum
{
   	AP_CC_SUCCESS,
	AP_CC_CERT_NOT_PRESENT,
	AP_CC_INVALID_CERT,
	AP_CC_CERT_FORMAT_ERROR,
	AP_CC_CRL_NOT_VALID,
	AP_CC_SECURE_TIME_ERROR
}ApCheckCertResult;

G_END_DECLS

/**
 * \brief Automotive Gateway Convenience Library error codes
 */
typedef enum {
    AP_AGWCL_OK = 0,
    AP_SDC_ERR_BASE = 0,
    /* if error is in range 0 - 0x100 - it is an SDC error code */
    AP_AGWCL_ERR_BASE = 0x100,
    /* if error is 0x100 and larger - it is an AGWCL error code */

    AP_AGWCL_NO_MEM = AP_AGWCL_ERR_BASE,
    AP_AGWCL_INVALID_INPUT,
    AP_AGWCL_ERR_FLAG_KEY_ALG,
    AP_AGWCL_ERR_FLAG_HASH_ALG,
    AP_AGWCL_ERR_FLAG_FORMAT,
    AP_AGWCL_ERR_FLAG_ENCODING,
    AP_AGWCL_ERR_CONF_FILE_NOT_ACCESSIBLE,
    AP_AGWCL_ERR_CONF_PARAM_NOT_FOUND,
    AP_AGWCL_ERR_WRAPPED_FILE_NOT_ACCESSIBLE,
    AP_AGWCL_ERR_CERT_FORMAT,
    AP_AGWCL_ERR_PKCS7_FORMAT,
    AP_AGWCL_ERR_DECRYPT,
    AP_AGWCL_ERR_CREATE_PKCS7_ATTRIBUTE,
    AP_AGWCL_ERR_UNKNOWN = -1,
} ApAgwclResult;

/**
 * \brief Command flags for algorithm
 */
/* key algorithm */
#define AGW_F_SIG_RSA         0x01
/* hash algorithm */
#define AGW_F_SIG_MD5         0x10
#define AGW_F_SIG_SHA1        0x20
#define AGW_F_SIG_SHA224      0x30
#define AGW_F_SIG_SHA256      0x40
#define AGW_F_SIG_SHA384      0x50
#define AGW_F_SIG_SHA512      0x60
/* output signature format */
#define AGW_F_SIG_PKCS1       0x200
#define AGW_F_SIG_PKCS7       0x300
/* output signature encoding */
#define AGW_F_SIG_DER         0x2000
#define AGW_F_SIG_SMIME       0x4000

/* Signature type (optional) */
#define AGWCL_F_SIG_MSG                 0x00000
#define AGWCL_F_SIG_PRECOMPUTED_HASH    0x10000

/**
 * \brief Command flags for decrypt_with_device_key
 */
/* key algorithm */
#define AGW_F_DEC_RSA         0x01
/* input encrypted data format */
#define AGW_F_DEC_PLAIN       0x100
#define AGW_F_DEC_PKCS7       0x300
/* input encrypted data encoding */
#define AGW_F_DEC_NOENC       0x1000
#define AGW_F_DEC_SMIME       0x4000

/**
 * \brief Command flags for get_client_cert
 */
/* output certificate encoding */
#define AGW_F_CERT_PEM         0x3000

#endif /* !AP_SDC_ENUMS_H */

