/******************************************************************
*FILE: ap-managedapp-service-enums.h
*SW-COMPONENT: Internet
*DESCRIPTION: This file contains the enums related to
*             com.bosch.AutomotiveProxy.ManagedAppService.
*COPYRIGHT: © 2017 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#ifndef __AP_MANAGEDAPP_SERVICE_ENUMS__
#define __AP_MANAGEDAPP_SERVICE_ENUMS__

/**
* ApAppState:
* @AP_MANAPP_STARTABLE:        App is ready to start
* @AP_MANAPP_INSTALLED:        App is installed
  @AP_MANAPP_INSTALL_AWAITED:  App installation in progress
*
* It represents the current state of the managed app
*
* Since: 1.0
*/
typedef enum
{
  AP_MANAPP_STARTABLE = 0,
  AP_MANAPP_INSTALLED,
  AP_MANAPP_INSTALL_AWAITED
} ApAppState;

/**
* ApSendIntentResult:
* This enum represents the return result of sendAppIntent method
*
* Since: 1.0
*/
typedef enum
{
  AP_MANAPP_NO_ERROR = 0,
  AP_MANAPP_INTENT_UNKNOWN,
  AP_MANAPP_PARAMETER_INVALID
} ApSendIntentResult;

#endif //__AP_MANAGEDAPP_SERVICE_ENUMS__
