/******************************************************************
*FILE: ap-lifecycle-manager-enums.h
*SW-COMPONENT: Life cycle manager
*DESCRIPTION: This file contains the enums related to life cycle manager
*COPYRIGHT: © 2016 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#ifndef __AP_LIFECYCLE_MANAGER_ENUMS__
#define __AP_LIFECYCLE_MANAGER_ENUMS__

/**
 * ApLifeCycleManagerMode:
 * @AP_LIFECYCLE_MANAGER_MODE_SHUTDOWNTYPE_NORMAL: Client registered for normal shutdown.
 * @AP_LIFECYCLE_MANAGER_MODE_SHUTDOWNTYPE_FAST: Client registered for fast shutdown.
 * @AP_LIFECYCLE_MANAGER_MODE_SHUTDOWNTYPE_RUNUP: Clients which are registered and have been shut down,
 * 						  will automatically be informed about the "run up", when system startup
 *
 * It represents different values for shutdown mode.
 *
 * Since: 0.1.0
 */

typedef enum
{
  AP_LIFECYCLE_MANAGER_MODE_SHUTDOWNTYPE_NORMAL,
  AP_LIFECYCLE_MANAGER_MODE_SHUTDOWNTYPE_FAST,
  AP_LIFECYCLE_MANAGER_MODE_SHUTDOWNTYPE_RUNUP
} ApLifeCycleManagerMode;

#endif
