/******************************************************************
*FILE: ap-factory-reset-error-enums.c
*SW-COMPONENT: Internet
*DESCRIPTION: To register dbus error domain for factory reset.
*COPYRIGHT:  2017 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#include <gio/gio.h>
#include "ap-factory-reset-error-enums.h"

#define ERROR_PREFIX "com.bosch.AutomotiveProxy.SettingsProvider.FactoryResetError."

static const GDBusErrorEntry error_entries[] =
{
    {
        AP_FACTORY_RESET_UNKNOWN_ERR,
        ERROR_PREFIX "Unknown"
    },
    {
        AP_FACTORY_RESET_BAD_PARAMS_ERR,
        ERROR_PREFIX "InvalidParameterValue"
    },
    {
        AP_FACTORY_RESET_FUNC_NOT_SUPPORTED_ERR,
        ERROR_PREFIX "FunctionNotSupported"
    },
    {
        AP_FACTORY_RESET_INTERNAL_ENGINE_ERR,
        ERROR_PREFIX "InternalEngineError"
    },
};


GQuark
ap_factory_reset_error_quark (void)
{
    static volatile gsize id = 0;

    g_dbus_error_register_error_domain ("ap-factory-reset-error-quark", &id,
                                        error_entries,
                                        G_N_ELEMENTS (error_entries));

    return (GQuark) id;
}
