/******************************************************************
*FILE: ap-ecm-enums.h
*SW-COMPONENT: Internet
*DESCRIPTION: This file contains the enums related to ECM
*COPYRIGHT: © 2017 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#ifndef __AP_ECM_ENUMS__
#define __AP_ECM_ENUMS__

#include <glib.h>

G_BEGIN_DECLS

/**
 * AP_ECM_ERROR:
 *
 * Error domain for #APECMError.
 *
 * Since: 0.1.0
 */
#define AP_ECM_ERROR ap_ecm_error_quark ()
GQuark ap_ecm_error_quark (void);
/**
 * ApECMError:
 * @AP_ECM_NO_ERROR:
 * @AP_ECM_CERT_SUCCESS:
 * @AP_ECM_CERT_PUSH_SUCCESS:
 * @AP_ECM_CRL_PUSH_SUCCESS:
 * @AP_ECM_SECURE_TIME_UNAVAILABLE:
 * @AP_ECM_NOT_CERTIFICATE:
 * @AP_ECM_NOT_CRL:
 * @AP_ECM_CERT_NOT_PRESENT:
 * @AP_ECM_CERT_NOT_VALID_YET:
 * @AP_ECM_CERT_EXPIRED:
 * @AP_ECM_CERT_INVALID:
 * @AP_ECM_CERT_REVOKED:
 * @AP_ECM_CRL_NOT_PRESENT:
 * @AP_ECM_CRL_NOT_VALID_YET:
 * @AP_ECM_CRL_EXPIRED:
 * @AP_ECM_CRL_INVALID
 * @AP_ECM_ERROR_UNKNOWN
 *
 * It represents possible error codes from Automotive Gateway for ECM.
 *
 * Since: 1.0
 */
typedef enum
{
  AP_ECM_NO_ERROR = 0,
  AP_ECM_CERT_SUCCESS = 10,
  AP_ECM_CERT_PUSH_SUCCESS = 11,
  AP_ECM_CRL_PUSH_SUCCESS = 12,
  AP_ECM_SECURE_TIME_UNAVAILABLE = 20,
  AP_ECM_NOT_CERTIFICATE = 21,
  AP_ECM_NOT_CRL = 22,
  AP_ECM_CERT_FORMAT_ERROR = 30,
  AP_ECM_CERT_NOT_PRESENT = 101,
  AP_ECM_CERT_NOT_VALID_YET = 102,
  AP_ECM_CERT_EXPIRED = 103,
  AP_ECM_CERT_INVALID = 104,
  AP_ECM_CERT_REVOKED = 105,
  AP_ECM_CRL_NOT_PRESENT = 201,
  AP_ECM_CRL_NOT_VALID_YET = 202,
  AP_ECM_CRL_EXPIRED = 203,
  AP_ECM_CRL_INVALID = 204,
  AP_ECM_ERROR_UNKNOWN = 500
} ApECMError;

/**
 * ApECMCRLType:
 * @AP_ECM_CRL_ROOT:
 * @AP_ECM_CRL_IC:
 *
 * It represents possible CRL types.
 *
 * Since: 1.0
 */
typedef enum
{
  AP_ECM_CRL_ROOT,
  AP_ECM_CRL_IC
} ApECMCRLType;

#endif
