/******************************************************************
*FILE: ap-audio-route-enums.h 
*SW-COMPONENT: Internet
*DESCRIPTION: This file contains the enums related to
*             com.bosch.AutomotiveProxy.AudioManager interface.
*COPYRIGHT: © 2016 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#ifndef __AP_AUDIO_MANAGER_ENUMS__
#define __AP_AUDIO_MANAGER_ENUMS__

/**
 * ApAudioSource:
 * @AP_AUDIO_SRC_MAIN_1: Main audio source
 * @AP_AUDIO_SRC_MIXED_1: Mixed audio source
 * @AP_AUDIO_SRC_INTR_1: Interrupt audio source1
 * @AP_AUDIO_SRC_INTR_2: Interrupt audio source2
 * @AP_AUDIO_SRC_SDS: Speech source
 * @AP_AUDIO_SRC_EXT_NAV: external navigation source
 *
 * Audio sources which can be requested to automotive domain.
 *
 * Since: 0.1.0
 */
typedef enum
{
	AP_AUDIO_SRC_NONE = 0,
    AP_AUDIO_SRC_MAIN_1 = 1,
    AP_AUDIO_SRC_MIXED_1,
    AP_AUDIO_SRC_INTR_1,
    AP_AUDIO_SRC_INTR_2,
    AP_AUDIO_SRC_SDS,
	AP_AUDIO_SRC_EXT_NAV
} ApAudioSource;

/**
 * ApAudioSourceStatus:
 * @AP_AUDIO_SRC_ACT_OFF: audio source state OFF
 * @AP_AUDIO_SRC_ACT_ON: audio source state ON
 * @AP_AUDIO_SRC_ACT_PAUSE: audio source state PAUSE
 *
 * Enums indicating status of audio source.
 *
 * Since: 0.1.0
 */
typedef enum
{
    AP_AUDIO_SRC_ACT_OFF = 0,
    AP_AUDIO_SRC_ACT_ON,
    AP_AUDIO_SRC_ACT_PAUSE
} ApAudioSourceStatus;


/**
 * ApAudioMuteStatus:
 * @AP_AUDIO_MUTESTATE_DEMUTE: Audio is audible.
 * @AP_AUDIO_MUTESTATE_MUTE: Audio is NOT audible.
 * @AP_AUDIO_MUTESTATE_DEMUTE_RUNNING:  Demute Ramp is running,
 *                                      audio is getting audible
 *
 * Enums indicating status of mute.
 *
 * Since: 0.1.0
 */
typedef enum
{
    AP_AUDIO_MUTESTATE_DEMUTE = 0,
    AP_AUDIO_MUTESTATE_MUTE,
    AP_AUDIO_MUTESTATE_DEMUTE_RUNNING
} ApAudioMuteStatus;


/**
 * ApAudioManagerError:
 * @AP_AUDIO_KSUCCESS: Method invocation success.
 * @AP_AUDIO_KFAIL: Method invocation failed.
 *
 * Enums indicating status of method invocation.
 *
 */
typedef enum
{
    AP_AUDIO_KSUCCESS = 0,
    AP_AUDIO_KFAIL
} ApAudioManagerError;

/**
 * ApAudioManagerDevType:
 * @AP_AUDIO_INPUT: device type is input.
 * @AP_AUDIO_OUTPUT: device type is output.
 *
 * Enums indicating type of ALSA devices.
 *
 */
typedef enum
{
    AP_AUDIO_INPUT = 0,
    AP_AUDIO_OUTPUT
} ApAudioManagerDevType;


#endif
