/*******************************************************************************
*
* FILE:          FC_AudioRouteMgr_service_AudioRouteMgr.h
*
* SW-COMPONENT:  FC_AudioRouteMgr application
*
* PROJECT:       NISSAN LCN2KAI
*
* DESCRIPTION:   CCA service AudioRouteMgr.
*
* AUTHOR:        Ravindra Kumar Rajendran (RBEI/ECV4)
*
* COPYRIGHT:    (c) 2012 RBEI
*
*******************************************************************************/

#ifndef _FC_AUDIOROUTEMGR_SERVICE_AUDIOROUTEMGR_H_
#define _FC_AUDIOROUTEMGR_SERVICE_AUDIOROUTEMGR_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

                                            // Include Application Help Library.
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION_DEMO
#include "ahl_if.h"

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

           // Loop back message defines to be processed by vOnLoopbackService().

            /* Definition of internal Function IDs (iFIDs) and message        */
            /* content IDs (MSGID) which are not public and therefore are     */
            /* not in the public FI of our service. Such internal function    */
            /* and message content IDs are necessary for 'loopback' messages, */
            /* i.e. messages the application sends itself. These internal     */
            /* function IDs must be different to the ones from the public FI. */
            /* The developer has to take care about that. To have a maximum   */
            /* separation of the public and the internal FIDs we start the    */
            /* definition for the internal ones nearly at the end of the      */
            /* possible range and then count downwards.*/

                                                // Internal function ID defines.
#define AUDIOROUTEMGR_C_U16_IFID_EXAMPLE_1 0xFFF0

                                                  // Message content ID defines.
#define AUDIOROUTEMGR_C_U32_MSGID_EXAMPLE_1 0x00000001

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class ahl_tclBaseOneThreadService;

class fc_audioroutemgr_tclService_AudioRouteMgr : public ahl_tclBaseOneThreadService,
                          public fc_audioroutemgr_tclTraceInput
{
  public:

    fc_audioroutemgr_tclService_AudioRouteMgr();
    fc_audioroutemgr_tclService_AudioRouteMgr(fc_audioroutemgr_tclApp* poMainAppl,fc_audioroutemgr_tclresourcemanager* poResourceMgr, fc_audioroutemgr_tclsourcefactory* poSourceFactory);
    virtual ~fc_audioroutemgr_tclService_AudioRouteMgr();

    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
    ail_tenCommunicationError updateClients(tU16 u16FunctionId);
    tVoid vOnLoopbackService(amt_tclServiceData* poMessage) const;
    tVoid vProcessTimer(tU16 u16TimerId) const;
    tVoid vSetSourceRouteActivity(amt_tclServiceData* poMessage);
  tVoid vLoadSourceSettings(amt_tclServiceData* poMessage);
    tVoid vSendSourceRouteActivityStatusOff(tU8 u8Source, tU8 u8NextSource, tU16 u16SubSource=0, tU8 u8Resource=1, tU8 u8Activity=0);
    tVoid vSendSourceRouteActivityStatusOn(tU8 u8Source, tU8 u8NextSource, tU16 u16SubSource=0, tU8 u8Resource=1, tU8 u8Activity=1);
    tVoid vSendSourceRouteActivityStatusPause(tU8 u8Source, tU8 u8NextSource, tU16 u16SubSource=0, tU8 u8Resource=1, tU8 u8Activity=2);
    tVoid vSendErrorStatusMessage(tU8 Src, tU16 SubSource, tU16 Error);
    tVoid vAudioManagerAvailable();
    tVoid vSendErrorMsg(const amt_tclServiceData* poMessage, tU16 errorcode);
    tVoid vSendStatusMessage(tU8 u8curSrc, tU8 u8posNextSrc, tU16 u16SubSource,tU8 u8Resource , tU8 u8Activity);
    tVoid vSetAudioRouteRequestReject(amt_tclServiceData* poMessage);
  protected:

    /***************************************************************************
    * Overriding ahl_tclBaseOneThreadService methods.
    ***************************************************************************/
    virtual tVoid vOnServiceAvailable();
    virtual tVoid vOnServiceUnavailable();
    virtual tBool bStatusMessageFactory(tU16 u16FunctionId,
                                        amt_tclServiceData& roOutMsg,
                                        amt_tclServiceData* poInMsg);
    virtual tBool bProcessSet(amt_tclServiceData* poMessage,
                              tBool& bPropertyChanged,
                              tU16& u16Error);

    // inbox for TTFis
    virtual tVoid vTraceRx(tU32 size, tPCUChar pcu8Data);
    /***************************************************************************
    * Handler function declarations used by message map.
    ***************************************************************************/

    // Add your CCA message handler function prototypes here.

    /***************************************************************************
    * Message map definition macro
    ***************************************************************************/
  private:

    tU16 m_u16TargetAppID;
    tU16 m_u16RegisterID;
    tU16 m_u16CmdCounter;

    tU8 m_u8CurSource;
    tU8 m_u8PosNextSource;
    tU16 m_u16SubSource;
    tU8 m_u8Activity;
    tU8 m_u8Resource;
    fc_audioroutemgr_tclresourcemanager* m_poResourceMgr;
    fc_audioroutemgr_tclsourcefactory* m_poSourceFactory;
    fc_audioroutemgr_tclApp* m_poMainAppl;
    tVoid vTraceInputSourceRouteActivity(tU8 u8Source, tU8 u8NextSource, tU8 u8Resource, tU8 u8Activity, tU16 u16SubSource=0);
    tU16 u16GetTargetAppID();
    tU16 u16GetTargetRegisterID();
    tU16 u16GetTargetCmdCounter();

    DECLARE_MSG_MAP(fc_audioroutemgr_tclService_AudioRouteMgr)
};

#endif // _FC_AUDIOROUTEMGR_SERVICE_AUDIOROUTEMGR_H_

