/*******************************************************************************
*
* FILE:          FC_AudioRouteMgr_main.h
*
* SW-COMPONENT:  FC_AudioRouteMgr application
*
* PROJECT:       NISSAN LCN2KAI
*
* DESCRIPTION:   CCA Application.
*
* AUTHOR:        Ravindra Kumar Rajendran (RBEI/ECV4)
*
* COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

#ifndef _FC_AUDIOROUTEMGR_MAIN_H_
#define _FC_AUDIOROUTEMGR_MAIN_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#pragma once

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

#include "Trace/fc_audioroutemgr_trace_input.h"
/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
// check why this is not known here from tri_types.h (di_trace)

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class ahl_tclBaseOneThreadApp;
class fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc;
class fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter;
class fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute;
class fc_audioroutemgr_tclService_AudioRouteMgr;
class fc_audioroutemgr_tclTraceChannel;
class fc_audioroutemgr_tclresourcemanager;
class fc_audioroutemgr_tclsourcefactory;



enum
{
   UNKNOWN_ERROR = 0x0100UL,
   ALLOCATE_ERROR = 0x0101UL,
   DEALLOCATE_ERROR = 0x0102UL,
   SRCACTIVITY_ERROR = 0x0103UL
};

enum
{
   REQUEST_NONE = 0,
   REQUEST_ALLOCATE = 1,
   REQUEST_SRC_ACT_ON = 2,
   REQUEST_ALLOCATEROUTE = 3,
   REQUEST_SETPLAY =4,
   REQUEST_SRC_ACT_PAUSE =5
};


class fc_audioroutemgr_tclApp : public ahl_tclBaseOneThreadApp, public fc_audioroutemgr_tclTraceInput
{
  static fc_audioroutemgr_tclApp* m_poMainAppInstance;

  public:

    fc_audioroutemgr_tclApp(tVoid);
    virtual ~fc_audioroutemgr_tclApp(tVoid);

  static fc_audioroutemgr_tclApp* theServer();

    /**************************************************************************
    * Assingment Operater, will not be implemented.
    * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class
    * 'fc_audioroutemgr_tclApp' which has no assignment operator.
    * NOTE: This is a technique to disable the assignment operator for this
    * class. So if an attempt for the assignment is made compiler complains.
    **************************************************************************/
    fc_audioroutemgr_tclApp& operator= (const fc_audioroutemgr_tclApp &oFC_AudioRouteMgr);

    /**************************************************************************
    * Copy Constructor, will not be implemented.
    * Avoids Lint Prio 3 warning:Info 1733: new in constructor for class
    * 'fc_audioroutemgr_tclApp' which has no copy constructor.
    * NOTE: This is a technique to disable the copy constructor for this
    * class. So if an attempt for the assignment is made compiler complains.
    **************************************************************************/
    fc_audioroutemgr_tclApp(const fc_audioroutemgr_tclApp &oFC_AudioRouteMgr);

    /**************************************************************************
    * Overriding ahl_tclBaseOneThreadApp methods.
    **************************************************************************/
    virtual tBool bOnInit();
    virtual tVoid vOnApplicationClose();
    virtual tVoid vOnTimer(tU16 nTimerId);
    virtual tVoid vOnLoadSettings();
    virtual tVoid vOnSaveSettings();
    virtual tVoid vOnNewAppStateNotify(tU32 u32OldAppState, tU32 u32AppState);
    using ahl_tclBaseOneThreadApp::vOnLoopback;
    virtual tVoid vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage);

    // register all trace channels
    tVoid vRegisterTraceInputs(tVoid);

    tVoid vAudioManagerAvailable(tVoid);
    // inbox for TTFis
    virtual tVoid vTraceRx(tU32 size, tPCUChar pcu8Data);
    virtual fc_audioroutemgr_tclresourcemanager* poGetResourceManager(tVoid);
    virtual fc_audioroutemgr_tclsourcefactory* poGetSourceFactory(tVoid);
    virtual fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc* poGetAudioFuncClientHandler(tVoid);
    virtual fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter* poGetStreamRouterClientHandler(tVoid);
   virtual fc_audioroutemgr_tclService_AudioRouteMgr* poGetAudioRouteMgrServiceHandler(tVoid);
  fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc* m_poClientHandlerAudioRouteMgr_AudioFunc;

    private:

  fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter* m_poClientHandlerAudioRouteMgr_StreamRouter;


    fc_audioroutemgr_tclService_AudioRouteMgr* m_poAudioRouteMgr;

    fc_audioroutemgr_tclresourcemanager* m_poResourceManager;

    fc_audioroutemgr_tclsourcefactory*  m_posourcefactory;

    // trace input channel
    fc_audioroutemgr_tclTraceChannel* m_poTrace;
};

#endif //_FC_AUDIOROUTEMGR_MAIN_H_

