/************************************************************************
 * FILE:         fc_audioroutemgr__trace.h
 * PROJECT:      NISSAN LCN2KAI
 * SW-COMPONENT: Audio Routing Manager
 *----------------------------------------------------------------------
 *
 * DESCRIPTION: handle trace outputs efficiently
 * This class is used as template for all middleware server to provide
 * trace output in an efficient way.
 *
 *
 *************************************************************************/
#ifndef FC_AUDIO_ROUTE_MGR_TCLTRACE_H
#define FC_AUDIO_ROUTE_MGR_TCLTRACE_H

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#ifndef TR_COMP_AUDIO_ROUTER_MGMT
#define TR_COMP_AUDIO_ROUTER_MGMT    ((256 * 127) + 192)
#endif

#ifndef TR_TTFIS_AUDIO_ROUTER_MGMT
#define TR_TTFIS_AUDIO_ROUTER_MGMT ((TR_tenTraceChan)113)
#endif

#include "fc_audioroutemgr_trace_macros.h"

/******************************************************************************/
enum tenTrcTraceClassFC_AudioRouteMgr {
  TR_CLASS_FC_AUDIOROUTEMGR_APPLICATION = TR_COMP_AUDIO_ROUTER_MGMT + 0,
  TR_CLASS_FC_AUDIOROUTEMGR_CLIENTHANDLER_AUDIOFUNC = TR_COMP_AUDIO_ROUTER_MGMT + 0 + 1,
  TR_CLASS_FC_AUDIOROUTEMGR_CLIENTHANDLER_STREAMROUTER = TR_COMP_AUDIO_ROUTER_MGMT + 0 + 2,
  TR_CLASS_FC_AUDIOROUTEMGR_CLIENTHANDLER_AUDSRCROUTE = TR_COMP_AUDIO_ROUTER_MGMT + 0 + 3,
  TR_CLASS_FC_AUDIOROUTEMGR_SERVICE_AUDIOROUTEMGR = TR_COMP_AUDIO_ROUTER_MGMT + 0 + 4,
  TR_CLASS_FC_AUDIOROUTEMGR_TRACE = TR_COMP_AUDIO_ROUTER_MGMT + 0 + 5,
  TR_CLASS_FC_AUDIOROUTEMGR_RESOURCE_MGR = TR_COMP_AUDIO_ROUTER_MGMT + 0 + 6,
  TR_CLASS_FC_AUDIOROUTEMGR_SOURCEFACTORY = TR_COMP_AUDIO_ROUTER_MGMT + 0 + 7,
  TR_CLASS_FC_AUDIOROUTEMGR_CLIENTHANDLER_MEDIAPLAYER = TR_COMP_AUDIO_ROUTER_MGMT + 0 + 8
};

class fc_audioroutemgr_tclTraceInput; // interface for receiving TTFis inputs
/*----------------------------------- trace channel comunication-------------------*/
class fc_audioroutemgr_tclTraceChannel {
public:
   fc_audioroutemgr_tclTraceChannel();
   virtual ~fc_audioroutemgr_tclTraceChannel();

   // Receive the data
   static tVoid vTrace_Rx_Callback(tPCUChar pcu8Data);
   static tVoid vTrace_Rx(tU32 size, tPCUChar pcu8Data);

   // at runtime application adds intefaces to the call back interface
   tVoid vRegisterTraceService(tU32 uInputNum, fc_audioroutemgr_tclTraceInput* pclInput) const;

   // at runtime application activates the trace channel with the right id
   tVoid vRegisterTraceCallBack(TR_tenTraceChan eChan );

   // when closing the applicaiton call back and trace channel are closed with it
   tVoid vUnregisterTraceCallBack(tVoid) const;

private:

   //forbidden
   fc_audioroutemgr_tclTraceChannel(const fc_audioroutemgr_tclTraceChannel& rhs); //lint !e1704 prio3 reviewed: constructor has private access specification: its use is forbidden
   fc_audioroutemgr_tclTraceChannel& operator=(const fc_audioroutemgr_tclTraceChannel& rhs);

   // channel number is stored to be able to close without second time transmitting
   // the parameter
   TR_tenTraceChan _eChannel;

   // the channel is reentrant however the second instance will have to close
   // the first channel because we have foreseen only one.
   static OSAL_tIODescriptor _fdTrace;

   // trace input interface list
   // used to switch into the different services, clienthandler or main class
   // number is fixed because we know where we want to use it
   static fc_audioroutemgr_tclTraceInput* _paReceiver[TRC::TRC_MAX_CLASS_NAMES];

}; // class trace channel


#endif // FC_AUDIO_ROUTE_MGR_TCLTRACE_H
