/*******************************************************************************
*
* FILE:          FC_AudioRouteMgr_resourcemanager.h
*
* SW-COMPONENT:  FC_AudioRouteMgr application
*
* PROJECT:       NISSAN LCN2KAI
*
* DESCRIPTION:   StateController Class, MuteConfigurationCheck Class,
                                         AllocConfigurationCheck Class
*
* AUTHOR:    Vaijayanti Vadiraj (RBEI/ECV4), Ravindra Kumar Rajendran (RBEI/ECV4)
*
* COPYRIGHT:    (c) 2012 RBEI
*
*******************************************************************************/
#ifndef _FC_AUDIOROUTEMGR_STATECONTROLLER_H
#define _FC_AUDIOROUTEMGR_STATECONTROLLER_H
/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include "../fc_audioroutemgr_main.h"
#include "fc_audioroutemgr_sourcefactory.h"
#include "fc_audioroutemgr_statecontrol.h"

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION--- MuteConfigCheck                                        */
/*                                                                            */
/******************************************************************************/

class muteConfigCheck
{
public:

  tU8 src1;
  tU8 src2;

  //Constructor
  muteConfigCheck(tU8 Src1, tU8 Src2):src1(Src1), src2(Src2)
  {
  }

  ~muteConfigCheck(){}
};

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION--- AllocConfigCheck                                       */
/*                                                                            */
/******************************************************************************/

struct tsSourceActivityCall
{

    tU8 Source;
    tU8 PossibleNextSource;
    tU16 Activity;
    tU16 SubSource;
    tU16 Resource;
};
typedef struct tsSourceActivityCall SrcActivityCall;

class stateController
{

 public:

    /***********CONSTRUCTOR*************/
  stateController(fc_audioroutemgr_tclApp* pCcaMainApp,fc_audioroutemgr_tclresourcemanager* poResourceMgr, fc_audioroutemgr_tclsourcefactory* poSourceFactory);

    /************DESTRUCTOR*************/
    virtual ~ stateController()
    {
      m_poCcaMainApp = OSAL_NULL;
      m_poSourceFactory = OSAL_NULL;
      m_poResourceMgr = OSAL_NULL;
    }

    /******ENUMS*****/

  typedef enum
  {
    DEALLOCATED = 0,
    ALLOCATE_IP = 1,
    SRC_ACT_ON_IP = 2,
    SRC_ACT_OFF_IP = 3,
    DEALLOCATE_IP = 4,
    MUTE_IP = 5,
    DEMUTE_IP =6,
    DEMUTED = 7,
  ALLOCATED =8,
  OFF_MUTE_ONLY = 9,
  PAUSE_MUTE_ONLY = 10,
  WAIT_AMP_DEV_RES = 11

  }enState;

  typedef enum
  {
    EVENT_UNDEF = 0,
    EVENT_SET_SRCROUTEACTIVITTY_OFF =1,
    EVENT_SET_SRCROUTEACTIVITTY_ON =2,
    EVENT_SET_SRCROUTEACTIVITTY_PAUSE =3,
    EVENT_RESULT_ALLOCATE =4,
    EVENT_RESULT_DEALLOCATE =5,
    EVENT_RESULT_SRCACTIVITY_OFF =6,
    EVENT_RESULT_SRCACTIVITY_ON =7,
    EVENT_RESULT_SRCACTIVITY_PAUSE =8,
    EVENT_RESULT_MUTE_ON =9,
  EVENT_RESULT_MUTE_OFF=10,
  EVENT_SET_SRCROUTEACTIVITTY_OFF_NO_DEALLOC=11,
  EVENT_SET_SRCROUTEACTIVITTY_PAUSE_NO_DEALLOC=12,
  EVENT_RESULT_AMP_DEV=13
  }enEvent;

     typedef enum
     {
       GUARD_UNDEF = 0,
       GUARD_SAME_SRC=1,
       GUARD_MUTE_REQUIRED=2,
       GUARD_MUTE_NOT_REQUIRED=3,
       GUARD_ROUTECHANGE_REQUIRED=4,
       GUARD_ROUTECHANGE_NOT_REQUIRED=5,
       GUARD_DEMUTE_REQUIRED=6,
       GUARD_DEMUTE_NOT_REQUIRED=7,
       GUARD_MIX_SOURCE=8,
       GUARD_ENT_SOURCE=9,
       GUARD_SRCACT_OFF =10,
       GUARD_SRCACT_PAUSE =11,
       GUARD_NOT_A_SPEECH_SRC = 12,
       GUARD_SPEECH_SRC = 13,
       GUARD_ALLOCATE_INITIATED = 14,
       GUARD_ALLOCATE_NOT_INITIATED = 15,
       GUARD_OFF_REQ_SAME_SOURCE = 16,
       GUARD_TUNER_SOURCE = 17,
       GUARD_NEW_SINK = 18,
       GUARD_NEW_SINK_OTHERSOURCE = 19,
       GUARD_NOT_A_SPEECH_SRC_BUT_ALLOCATED = 20
     }enGuardResult;

     typedef enum
     {
       STABLE_STATE = 0,
       INTERMEDIATE_STATE

     }enStateStability;


     typedef enum
     {
        STATE_MUTED = 1UL,
        STATE_DEMUTED = 2UL,
        STATE_DEMUTERUNNING = 3UL

     }enMuteState;

    typedef enum
     {
        PAUSE = 2UL,
        ON = 1UL,
        OFF = 0UL

     }enSrcAct;

     typedef enum
     {
       EXCLUSIVE = 1,
       MIX       = 2,
     MIX2     = 3
     }enChannel;

   typedef enum
   {
     EVENT_HMI_SRC_NONE = 0,
     EVENT_HMI_SRC_START = 1,
     EVENT_HMI_SRC_STOP = 2,
     EVENT_HMI_SRC_PAUSE = 3
   }enHMIEvent;

/***************************************************************************
        * Class methods.
 ***************************************************************************/

   tVoid vChangeState(stateController::enEvent Event, tU8 CurSrc, tU8 PosNextSrc, tU16 SubSource, tU16 Sink);
   tVoid vChangeState(stateController::enEvent Event, tU8 CurSrc, tU8 PosNextSrc, tU16 SubSource);
   tU16  tU16GetState(tVoid) const;
   tVoid vResetState(tU16 SM_state,tU16 Sink = 1);
   tBool bCheckIfSrcSameasSrcInFrontofQueue(tU8 Src);
   tU8 u8GetFrontCurSourceInQueue();
   tU8 u8GetFrontCurSourceInQueue(tU8 u8Source);
   tU16 u8GetFrontCurResourceSourceInQueue(tU16 Resource);

   tU8 u8GetFrontPossibleNextSourceInQueue();
   tU8 u8GetFrontPossibleNextSourceInQueue(tU8 u8Source);

   tU16 u16GetFrontActivityInQueue();
   tU16 u16GetFrontActivityInQueue(tU8 u8Source);

   tU16 u16GetFrontSubSourceInQueue();
   tU16 u16GetFrontSubSourceInQueue(tU8 u8Source);

   tU16 u16GetFrontSinkInQueue();
   tU16 u16GetFrontSinkInQueue(tU8 u8Source);

   tU16 u16GetSinkInQueueForActivityOn(tU8 u8Source);

   tVoid vResetDQueueSrcActivityCall();

   void dumpQueueSrcActivityCall();
   void u16SetSinkState(tU16 Sink, tU16 enState);
   tU16 u16GetSinkState(tU16 Sink);
 /***************************************************************************
           * Vectors.
 ***************************************************************************/
   vector<muteConfigCheck*> muteConfigCheckVector;
   vector<stateControl*> stateControlVector;
   deque<SrcActivityCall> QueueSrcActivityCall;
   map<enSrcAct, enEvent> Activitymap;
   tU16 u8activity;
   tU8 u8curSrc;
   tU8 u8posNextSrc;
   tU16 u16SubSource;
   tU16 u16Sink;
   tU16 enState_Sink1;
   tU16 enState_Sink2;
   tU16 enState_Sink17;

   std::map<tU16,enState> m_mapLastStateOfSink;
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
   friend class stateControllerTest;
#endif

 private:
  tU16 m_u16State;
  tU16 m_u16Event;
    fc_audioroutemgr_tclApp* m_poCcaMainApp;
    fc_audioroutemgr_tclsourcefactory* m_poSourceFactory;
    fc_audioroutemgr_tclresourcemanager* m_poResourceMgr;
};
#endif
