/*******************************************************************************
*
* FILE:          FC_AudioRouteMgr_resourcemanager.h
*
* SW-COMPONENT:  FC_AudioRouteMgr application
*
* PROJECT:       NISSAN LCN2KAI
*
* DESCRIPTION:   StateControl Class
*
* AUTHOR:     Vaijayanti Vadiraj (RBEI/ECV4), Ravindra Kumar Rajendran (RBEI/ECV4)
*
* COPYRIGHT:    (c) 2012 RBEI
*
*******************************************************************************/
#ifndef _FC_AUDIOROUTEMGR_STATECONTROL_H
#define _FC_AUDIOROUTEMGR_STATECONTROL_H
/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include "../fc_audioroutemgr_main.h"
#include "fc_audioroutemgr_sourcefactory.h"
#include "fc_audioroutemgr_resourcemanager.h"

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION--- StateControl                                           */
/*                                                                            */
/******************************************************************************/
class stateController;
class stateControl
{
public:

  //Constructors
  stateControl(tU16 tUState, tU16 tUevent, tU16 tUnextState, tU16 (stateControl::*someguard) (tU8,tU8),
      tU16 tUguardResult, tVoid (stateControl::*someaction) (tU8,tU8,tU16,tU16) const, tU16 tUstateStability, fc_audioroutemgr_tclApp* pCcaMainapp,fc_audioroutemgr_tclresourcemanager* poResourceMgr,fc_audioroutemgr_tclsourcefactory* posourcefactory);

  //Destructor
  virtual ~stateControl()
    {
    m_poCcaMainApp = OSAL_NULL;
    m_poResourceMgr = OSAL_NULL;
    m_posourcefactory = OSAL_NULL;
    }

  /***************************************************************************
        * Class methods.
   ***************************************************************************/

  tVoid vSendPerformMute(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource=0) const;
  tVoid vSendPerformMute(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink) const;
  tVoid vSendPerformSrcActOff(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource=0) const;
  tVoid vSendPerformSrcActOff(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink) const;
  tVoid vSendPerformSrcActOffAndRemoveReqFromQueue(tU8,tU8,tU16 SubSource=0) const;
  tVoid vSendPerformSrcActOffAndRemoveReqFromQueue(tU8,tU8,tU16 SubSource, tU16 Sink) const;
  tVoid vSendPerformSrcActPauseAndRemoveReqFromQueue(tU8,tU8,tU16 SubSource=0) const;
  tVoid vSendPerformSrcActPauseAndRemoveReqFromQueue(tU8,tU8,tU16 SubSource, tU16 Sink) const;
  tVoid vSendPerformSrcActPause(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource=0) const;
  tVoid vSendPerformSrcActPause(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink) const;
  tVoid vSendPerformDemute(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource=0) const;
  tVoid vSendPerformDemute(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink) const;
  tVoid vSendPerformDeallocate(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource=0) const;
  tVoid vSendPerformDeallocate(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink) const;
  tVoid vSendPerformSrcActOn(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource=0) const;
  tVoid vSendPerformSrcActOn(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink) const;
  tVoid vSendPerformAmpDevAudioRoute(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink) const;
  tVoid vPerformDemuteAndNotifyHMI(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource=0) const;
  tVoid vPerformDemuteAndNotifyHMI(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink) const;
  tVoid vNotifyHMIOn(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource=0) const;
  tVoid vNotifyHMIOn(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink) const;
  tVoid vNotifyHMIOff(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource=0) const;
  tVoid vNotifyHMIOff(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink) const;
  tVoid vNotifyHMIPause(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource=0) const;
  tVoid vNotifyHMIPause(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink) const;
  tVoid vPerformAllocateAndSetSource(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource=0) const;
  tVoid vPerformAllocateAndSetSource(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink) const;
  tVoid vPerformSrcActOnAndSetSource(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource=0) const;
  tVoid vPerformSrcActOnAndSetSource(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink) const;
  tVoid vSetRouteDemuteAndNotifyHMI(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink) const;

  tU16 u16ReturnGuardBasedOnSrcState(tU8 CurSrc,tU8 PosNextSrc, tU16 MuteGuardValue) const;
  tU16 u16ReturnGuardBasedOnSrcCompMuteState(tU8 CurSrc, tU16) const;
  tVoid vProcessSrcActivityCallsInQueue(tU8 Src, tU16 SinkID, tU8 Activity) const;
  tU16 vGuardIsSrcActOfforPause(tU8 CurSrc, tU8 PosNextSrc);
  tU16 vGuardIsMuteRequired(tU8 CurSrc, tU8 PosNextSrc) ;
  tU16 vGuardIsDeMuteRequired(tU8 CurSrc, tU8 PosNextSrc);
  tU16 vGuardIsMixSource(tU8 CurSrc, tU8 PosNextSrc) ;
  tU16 vGuardIsSpeechSrc(tU8 CurSrc, tU8 PosNextSrc) ;
  tU16 vGuardIsAllocateInitiated(tU8 CurSrc, tU8 PosNextSrc);
  tU16 u16GuardIsOffReqForSameSrc(tU8 CurSrc, tU8 PosNextSrc);
    tU16 u16GuardIsTunerSource(tU8 CurSrc, tU8 PosNextSrc);
    tU16 u16GuardIsNewSink(tU8 CurSrc, tU8 PosNextSrc);
  typedef tVoid (stateControl::*Action)(tU8,tU8,tU16,tU16) const;
  typedef tU16 (stateControl::*Guard)(tU8,tU8);

  Action action;
  Guard guard;

  tU16 state;
  tU16 event;
  tU16 nextState;
  tU16 guardResult;
  tU16 stateStability;

private:
  fc_audioroutemgr_tclresourcemanager* m_poResourceMgr;
  fc_audioroutemgr_tclsourcefactory* m_posourcefactory;
  fc_audioroutemgr_tclApp* m_poCcaMainApp;
};

#endif
