/*******************************************************************************
*
* FILE:          FC_AudioRouteMgr_sourcefactory.cpp
*
* SW-COMPONENT:  FC_AudioRouteMgr application
*
* PROJECT:       NISSAN LCN2KAI
*
* DESCRIPTION:   Source Factory Class
*
* AUTHOR:       Vaijayanti Vadiraj (RBEI/ECV4), Ravindra Kumar Rajendran (RBEI/ECV4)
*
* COPYRIGHT:    (c) 2012 RBEI
*
*******************************************************************************/
#include "fc_audioroutemgr_sourcefactory.h"
#include "../fc_audioroutemgr_main.h"
#include "fc_audioroutemgr_resourcemanager.h"
#include "../ClientHandler/fc_audioroutemgr_clienthandler_audiofunc.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#include "../Trace/fc_audioroutemgr_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOROUTEMGR_SOURCEFACTORY
#include "trcGenProj/Header/fc_audioroutemgr_sourcefactory.cpp.trc.h"
#endif

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"

#define EXTERNALAMP_BOSE2CH_MCAN 4
#define EXTERNALAMP_BOSE_5_1CH_MCAN 6

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclsourcefactory::fc_audioroutemgr_tclsourcefactory(tVoid)
*
*
* DESCRIPTION: Constructor.
*
* PARAMETER:   None.
*
* RETURNVALUE: None.
*
*******************************************************************************/

fc_audioroutemgr_tclsourcefactory::fc_audioroutemgr_tclsourcefactory(fc_audioroutemgr_tclApp* pCcaMainApp)
{
  if(sourceVector.empty() && pCcaMainApp != OSAL_NULL)
    {
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
    tU8 u8Amplifier = 0;
      //read item from the KDS key's bytes- stream
    if ((DP_S32_NO_ERR == DP_s32GetConfigItem("SystemConfiguration1", "OutputInformation",&u8Amplifier, 1)))
  {
    ETG_TRACE_USR4(("bMCanBoseAmplifierConnected,Amplifier value  : %d", u8Amplifier));

      if(u8Amplifier == EXTERNALAMP_BOSE2CH_MCAN || u8Amplifier == EXTERNALAMP_BOSE_5_1CH_MCAN)
        {
    #define AUDIO_SOURCES_INTERFACES_CONFIG
    #define audiosources(Source,SrcType,MuteRamp,Interface,UCID,AppID) sourceVector.push_back(new source((tU16)Source, (tU8)SrcType, (tU16)MuteRamp, FALSE, source::SRC_DEMUTE, source::SRC_STATE_OFF, (tU16)Interface, UCID, AppID, source::ACT_OFF, (tU8)0x00, source::SRC_DEMUTE, (tU16)midw_fi_tcl_e8_AudSource::FI_EN_NONE, (tU8)midw_fi_tcl_e8_SrcAvailability::FI_EN_NOT_AVAILABLE, (tU8)midw_fi_tcl_e8_SrcAvailabilityReason::FI_EN_NO_CONTENT, source::VOLUMELOCK_OFF, pCcaMainApp));
          #if defined (VARIANT_S_FTR_ENABLE_CONFIG_AUDIO_A2S1)
    	       #include "../Config/fc_audioroutemgr_audiosources_a2s1_bose.conf"
    	  #else
               #include "../Config/fc_audioroutemgr_audiosources_rnaivi_bose.conf"
          #endif
    #undef audiosources
    #undef AUDIO_SOURCES_INTERFACES_CONFIG
        }
      else
        {
        vCreateNormalSourceInstances(pCcaMainApp);
        }
  }
      else
  {
    ETG_TRACE_USR4(("KDS OutputInfo Read Error.. Creating Normal project source config instances..."));
        vCreateNormalSourceInstances(pCcaMainApp);
  }
#else
      vCreateNormalSourceInstances(pCcaMainApp);
#endif

  }
  else
  {
    ETG_TRACE_USR4(("sourceVector not Empty"));
  }

  m_poCcaMainApp = pCcaMainApp;
  vector<source*>::iterator srcVectorIterator = sourceVector.begin();
  vector<tU16> tempVector;
  vector<tU16>::iterator tempVectorIter;
  for(;srcVectorIterator != sourceVector.end(); srcVectorIterator++)
  {
    if((*srcVectorIterator)->u16GetRoutingIf() == source::SRCROUTE_INTERFACE )
    {
      tempVector.push_back((*srcVectorIterator)->u16GetAppID());
    }
  }

  sort(tempVector.begin(), tempVector.end());
  tempVector.erase(unique(tempVector.begin(), tempVector.end()), tempVector.end());

  for(tempVectorIter = tempVector.begin(); tempVectorIter != tempVector.end(); tempVectorIter++)
  {
     clientHandlerVector.push_back(new fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute(pCcaMainApp,*tempVectorIter,this));
  }
  tempVector.clear();
}
 /*******************************************************************************/
tBool fc_audioroutemgr_tclsourcefactory::bAddSinkToSource(tU8 CurSrc, tU16 Sink)
{
  tBool bSuccess = false;
  source* pSrc = poSourcePtr(CurSrc);
  if(pSrc != NULL)
  {
    if(pSrc->bAddSink(Sink)== true)
    {
      bSuccess = true;
    }
  }
  return (bSuccess);
}
/*******************************************************************************/
tBool fc_audioroutemgr_tclsourcefactory::bRemoveSinkFromSource(tU8 CurSrc, tU16 Sink)
{
  tBool bSuccess = false;
  source* pSrc = poSourcePtr(CurSrc);
  if(pSrc != NULL)
  {
    if(pSrc->bRemoveSink(Sink)== true)
    {
      bSuccess = true;
    }
  }
  return (bSuccess);
}
/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclsourcefactory::getClientHandler(tU16 u16AppID)
*
*
* DESCRIPTION: Returns the Corresponding matching Appids of the sources.
*
* PARAMETER:   u16AppID.
*
* RETURNVALUE: Pointer.
*
*******************************************************************************/
fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute* fc_audioroutemgr_tclsourcefactory::getClientHandler(tU16 u16AppID)
{
  vector<fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute*>::iterator clientIterator;

  for(clientIterator=clientHandlerVector.begin();clientIterator!=clientHandlerVector.end();++clientIterator)
  {
    if((*clientIterator)->u16GetServerAppID() == u16AppID)
    {
			ETG_TRACE_USR4(("APPID : 0x%x",u16AppID));
      break;
    }
    else
    {
      //do nothing
    }
  }

  if(clientIterator == clientHandlerVector.end())
  {
        return OSAL_NULL;
  }
  else
  {
  return *clientIterator;
  }
}

/*****************************************************************************************************
*
* FUNCTION:    tVoid fc_audioroutemgr_tclsourcefactory::vSendReqRouteList
               (std::vector<midw_fi_tcl_RequestAudioRouteItem, std::allocator<midw_fi_tcl_RequestAudioRouteItem> >& ReqAudioRouteList)
*
*
* DESCRIPTION: Get the ReqAudioRouteList from ARL.
*
* PARAMETER:   std::vector<midw_fi_tcl_RequestAudioRouteItem, std::allocator<midw_fi_tcl_RequestAudioRouteItem> >..
*
* RETURNVALUE: None.
*
******************************************************************************************************/
tVoid fc_audioroutemgr_tclsourcefactory::vSendReqRouteList(std::vector<midw_fi_tcl_RequestAudioRouteItem, std::allocator<midw_fi_tcl_RequestAudioRouteItem> >& ReqAudioRouteList)
{
    m_ReqAudRouteList = ReqAudioRouteList;
}

/*****************************************************************************************************
*
* FUNCTION:   tVoid fc_audioroutemgr_tclsourcefactory::vSendSrcAvailabilityList
              (std::vector<midw_fi_tcl_SourceAvailablityItem, std::allocator<midw_fi_tcl_SourceAvailablityItem> >& SrcAvailabilityList)
*
*
* DESCRIPTION: Gets the SourceAvailability List from ARL.
*
* PARAMETER:   std::vector<midw_fi_tcl_SourceAvailablityItem, std::allocator<midw_fi_tcl_SourceAvailablityItem> >..
*
* RETURNVALUE: None.
*
******************************************************************************************************/
tVoid fc_audioroutemgr_tclsourcefactory::vSendSrcAvailabilityList(std::vector<midw_fi_tcl_SourceAvailablityItem, std::allocator<midw_fi_tcl_SourceAvailablityItem> >& SrcAvailabilityList)
{
   vector<midw_fi_tcl_SourceAvailablityItem>::const_iterator SrcAvailIterator;

   for(SrcAvailIterator = SrcAvailabilityList.begin();SrcAvailIterator != SrcAvailabilityList.end(); SrcAvailIterator++)
   {
      tsSrcAvailability SrcAvailItem;

      tU8 Source = (tU8)(*SrcAvailIterator).u8Source.enType;
      SrcAvailItem.SubSource = (tU16)(*SrcAvailIterator).u16SubSource;
      SrcAvailItem.SrcAvailability = (tU8)(*SrcAvailIterator).e8Availability.enType;
      SrcAvailItem.SrcAvailReason = (tU8)(*SrcAvailIterator).e8Reason.enType;

      vInsertItemsToSrcAvailMap(Source, SrcAvailItem);
   }

   multimap< tU8, tsSrcAvailability >::iterator tempIter = m_SrcAvailMap.begin();

   for(;tempIter != m_SrcAvailMap.end();tempIter++)
   {
     ETG_TRACE_USR4(("SourceAvailabilityList, Source : %d, SubSource :%d, Reason : %d, Availability : %d",
         ETG_ENUM(AudioSourceNo, tempIter->first), tempIter->second.SubSource,
         ETG_ENUM(AvailabilityReason, tempIter->second.SrcAvailReason),
         ETG_ENUM(Availability, tempIter->second.SrcAvailability)));
   }
}
/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclsourcefactory::vTraceRx(tPCUChar pcu8Data)
*
* DESCRIPTION: Receives TTFis Trace Commands.
*
* PARAMETER:   tPCUChar pcu8Data.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclsourcefactory::vTraceRx(tU32 size, tPCUChar pcu8Data)
{
   ETG_TRACE_USR4(("fc_audioroutemgr_tclsourcefactory vTraceRx() entered."));
   if(pcu8Data == OSAL_NULL) return;
   // pcu8Data[0] == my file number
   // pcu8Data[1] == the command
   // pcu8Data[2] == the 1. parameter
   // rest is defined here

   if(m_poCcaMainApp != NULL)
   {
    fc_audioroutemgr_tclresourcemanager* poResourceMgr = m_poCcaMainApp->poGetResourceManager();

        ETG_TRACE_USR4(("vTraceRx() size=%u",size));
        if (size > 1)
        {
         ETG_TRACE_USR4(("vTraceRx() pcu8Data[0] [1] =%u %u",(tU16)pcu8Data[0],(tU16)pcu8Data[1]));
           switch ( pcu8Data[1] )
           {
           case TRC::NotifySrcActivity:
            {
            ETG_TRACE_USR4(("TTFis Rx NotifySrcActivity"));
              if (size > 3)
                {
                   if(poResourceMgr != NULL)
                   {
                     poResourceMgr->vNotifySourceActivity(pcu8Data[2],pcu8Data[3]);
                   }
                }
              else
                ETG_TRACE_USR4(("NotifySrcActivity too few params %u",size));
              break;
            }
           case TRC::NotifyAllocate:
            {
             ETG_TRACE_USR4(("TTFis Rx NotifyAllocate"));
              if (size > 2)
              {
                if(poResourceMgr != NULL)
                {
                 poResourceMgr->vNotifyAllocate(pcu8Data[2]);
                }
              }
              else
                ETG_TRACE_USR4(("NotifyAllocate too few params %u",size));
              break;
            }
           case TRC::NotifyDeallocate:
           {
             ETG_TRACE_USR4(("TTFis Rx NotifyDeallocate"));
              if (size > 2)
              {
                if(poResourceMgr != NULL)
                 {
               poResourceMgr->vNotifyDeAllocate(pcu8Data[2]);
                 }
              }
              else
                ETG_TRACE_USR4(("NotifyDeallocate too few params %u",size));
              break;
           }
          case TRC::StatusMuteRequest:
           {
                ETG_TRACE_USR4(("TTFis Rx StatusMuteRequest"));
                 if (size > 4 && poSourcePtr(pcu8Data[2]) !=  NULL)
                 {
                     getClientHandler(poSourcePtr(pcu8Data[2])->u16GetAppID())->vTraceInputMuteRequestStatus(pcu8Data[2],pcu8Data[3],pcu8Data[4]);
                 }
                 else
                      ETG_TRACE_USR4(("StatusMuteRequest too few params %u",size));
                    break;
            }
          case TRC::StatusRouteReq:
           {
                ETG_TRACE_USR4(("TTFis Rx StatusRouteReq"));
                 if (size > 3 && poSourcePtr(pcu8Data[2]) !=  NULL)
                 {
                     getClientHandler(poSourcePtr(pcu8Data[2])->u16GetAppID())->vTraceInputRequestAudioRoute(pcu8Data[2],pcu8Data[3]);
                 }
                 else
                      ETG_TRACE_USR4(("StatusRouteReq too few params %u",size));
                    break;
           }

          case TRC::StatusSrcAvail:
           {
                ETG_TRACE_USR4(("TTFis Rx StatusSrcAvail"));
                 if (size > 3 && poSourcePtr(pcu8Data[2]) !=  NULL)
                 {
                     getClientHandler(poSourcePtr(pcu8Data[2])->u16GetAppID())->vTraceInputRequestSrcAvailability(pcu8Data[2],pcu8Data[3]);
                 }
                 else
                      ETG_TRACE_USR4(("StatusSrcAvail too few params %u",size));
                    break;
           }

          case TRC::SetAudioProperty:
           {
                ETG_TRACE_USR4(("TTFis Rx SetAudioProperty"));
                 if (size > 4 && poSourcePtr(pcu8Data[2]) !=  NULL)
                 {
                     getClientHandler(poSourcePtr(pcu8Data[2])->u16GetAppID())->vTraceInputSetAudioRoute(pcu8Data[2],pcu8Data[3], pcu8Data[4]);
                 }
                 else
                      ETG_TRACE_USR4(("SetAudioProperty too few params %u",size));
                    break;
           }
      default:
        ETG_TRACE_USR4(("default"));
       break;
      }
        }
   }
}
/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclsourcefactory::vReqRouteList()
*
* DESCRIPTION: Returns ReqAudioRouteList.
*
* PARAMETER:   None.
*
* RETURNVALUE: std::vector<midw_fi_tcl_RequestAudioRouteItem, std::allocator<midw_fi_tcl_RequestAudioRouteItem> >.
*
*******************************************************************************/
std::vector<midw_fi_tcl_RequestAudioRouteItem, std::allocator<midw_fi_tcl_RequestAudioRouteItem> > fc_audioroutemgr_tclsourcefactory::vReqRouteList()
{
  return m_ReqAudRouteList;
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclsourcefactory::vSrcAvailabilityList()
*
* DESCRIPTION: Returns SrcAvailabilityList.
*
* PARAMETER:   None.
*
* RETURNVALUE: std::vector<midw_fi_tcl_SourceAvailablityItem, std::allocator<midw_fi_tcl_SourceAvailablityItem> >
*
*******************************************************************************/
std::vector<midw_fi_tcl_SourceAvailablityItem, std::allocator<midw_fi_tcl_SourceAvailablityItem> > fc_audioroutemgr_tclsourcefactory::vSrcAvailabilityList()
{
  std::vector<midw_fi_tcl_SourceAvailablityItem, std::allocator<midw_fi_tcl_SourceAvailablityItem> > SrcAvailList;

  midw_fi_tcl_SourceAvailablityItem Items;

  multimap< tU8, tsSrcAvailability >::const_iterator tempIter;

  tempIter = m_SrcAvailMap.begin();

  for(;tempIter != m_SrcAvailMap.end(); tempIter++)
  {
    Items.u8Source.enType = (midw_fi_tcl_e8_AudSource::tenType)tempIter->first;
    Items.u16SubSource = tempIter->second.SubSource;
    Items.e8Reason.enType = (midw_fi_tcl_e8_SrcAvailabilityReason::tenType)tempIter->second.SrcAvailReason;
    Items.e8Availability.enType = (midw_fi_tcl_e8_SrcAvailability::tenType)tempIter->second.SrcAvailability;

    SrcAvailList.push_back(Items);
  }

  return SrcAvailList;
}
/*******************************************************************************
*
* FUNCTION:    tVoid fc_audioroutemgr_tclsourcefactory::poSourcePtr(tU8 Src)
*
* DESCRIPTION: Returns the corresponding Source pointer.
*
* PARAMETER:   tU8 Src
*
* RETURNVALUE: source*
*
*******************************************************************************/
source* fc_audioroutemgr_tclsourcefactory::poSourcePtr(tU8 Src)
{
  vector<source*>::iterator it = sourceVector.begin();
  ETG_TRACE_USR4(("Source size :%d",sourceVector.size()));
  for ( ; it != sourceVector.end(); it++)
  {
    if((*it)->u8GetSourceID() == Src)
    {
      ETG_TRACE_USR4(("Source Found :%d ",(*it)->u8GetSourceID()));
      return *it;
    }
  }
  return NULL;
}

/*******************************************************************************
*
* FUNCTION:    tVoid fc_audioroutemgr_tclsourcefactory::
*              vInsertItemsToSrcAvailMap(tU8 Source, tsSrcAvailability SrcAvailItem)
*
* DESCRIPTION: Inserts the source availability items received to the multimap
*
* PARAMETER:   tU8 Source, tsSrcAvailability SrcAvailItem
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclsourcefactory::vInsertItemsToSrcAvailMap(tU8 Source, tsSrcAvailability SrcAvailItem)
{
  if(m_SrcAvailMap.empty())
  {
    // Insertion of First availability message
    m_SrcAvailMap.insert(make_pair(Source, SrcAvailItem));
  }
  else
  {
    multimap< tU8, tsSrcAvailability >::iterator tempIter;

    tempIter = m_SrcAvailMap.find(Source);

    if(tempIter == m_SrcAvailMap.end())
    {
       // Insertion of new availability message
       m_SrcAvailMap.insert(make_pair(Source, SrcAvailItem));
    }
    else
    {
       tU8 u8count = (tU8)m_SrcAvailMap.count(Source);

       tBool bSubSourceMatched = false;

        for (tU8 i = 0; i < u8count; i++)
        {
          //Modification of already existing availability message
          if(tempIter->second.SubSource == SrcAvailItem.SubSource)
          {
            bSubSourceMatched = true;
            tempIter->second.SrcAvailability = SrcAvailItem.SrcAvailability;
            tempIter->second.SrcAvailReason = SrcAvailItem.SrcAvailReason;
            break;
          }
            ++tempIter;
        }

        if(!bSubSourceMatched)
        {
          // Insertion of availability message with already existing Source but with new subsource.
          m_SrcAvailMap.insert(make_pair(Source,SrcAvailItem));
        }
    }
  }
}

/*******************************************************************************
*
* FUNCTION:    tVoid fc_audioroutemgr_tclsourcefactory::
*              vCreateNormalSourceConfig
*
* DESCRIPTION: Creates Source instances from source config based on project filter
*
* PARAMETER:   None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclsourcefactory::vCreateNormalSourceInstances(fc_audioroutemgr_tclApp* pCcaMainApp)
{
    #define AUDIO_SOURCES_INTERFACES_CONFIG
    #define audiosources(Source,SrcType,MuteRamp,Interface,UCID,AppID) sourceVector.push_back(new source((tU16)Source, (tU8)SrcType, (tU16)MuteRamp, FALSE, source::SRC_DEMUTE, source::SRC_STATE_OFF, (tU16)Interface, UCID, AppID, source::ACT_OFF, (tU8)0x00, source::SRC_DEMUTE, (tU16)midw_fi_tcl_e8_AudSource::FI_EN_NONE, (tU8)midw_fi_tcl_e8_SrcAvailability::FI_EN_NOT_AVAILABLE, (tU8)midw_fi_tcl_e8_SrcAvailabilityReason::FI_EN_NO_CONTENT, source::VOLUMELOCK_OFF, pCcaMainApp));
    #include "../Config/fc_audioroutemgr_audiosources.conf"
    #undef audiosources
    #undef AUDIO_SOURCES_INTERFACES_CONFIG
}
