/*
* FILE:          FC_AudioRouteMgr_resourcemanager.cpp
*
* SW-COMPONENT:  FC_AudioRouteMgr application
*
* PROJECT:       NISSAN LCN2KAI
*
* DESCRIPTION:   Resource Manager Class, Behavior Class, StateControl Class, StateController Class,
*                MuteConfigurationCheck Class, AllocConfigurationCheck Class
*
* AUTHOR:     Vaijayanti Vadiraj (RBEI/ECV4), Ravindra Kumar Rajendran (RBEI/ECV4)
*
* COPYRIGHT:    (c) 2012 RBEI
*
*******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#include "fc_audioroutemgr_audiosource.h"
#include "../ClientHandler/fc_audioroutemgr_clienthandler_audiofunc.h"
#include "../ClientHandler/fc_audioroutemgr_clienthandler_srcroute.h"
#include "../ClientHandler/fc_audioroutemgr_clienthandler_streamrouter.h"
#include "../fc_audioroutemgr_service_audioroutemgr.h"
#include "fc_audioroutemgr_sourcefactory.h"
#include "fc_audioroutemgr_resourcemanager.h"
#include "fc_audioroutemgr_statecontrol.h"
#include "fc_audioroutemgr_statecontroller.h"

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUD_SRC_ROUTEFI_TYPES
#include <midw_fi_if.h>

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#include "../Trace/fc_audioroutemgr_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOROUTEMGR_RESOURCE_MGR
#include "trcGenProj/Header/fc_audioroutemgr_resourcemanager.cpp.trc.h"
#endif

#define SINK1 1
#define SINK2 2
#define SINK17 17

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclresourcemanager::fc_audioroutemgr_tclresourcemanager(fc_audioroutemgr_tclApp* poMainAppl)
*
*
* DESCRIPTION: Constructor.
*
* PARAMETER:   poMainAppl - Pointer to Main App
*
* RETURNVALUE: None.
*
*******************************************************************************/

fc_audioroutemgr_tclresourcemanager::fc_audioroutemgr_tclresourcemanager(fc_audioroutemgr_tclApp* poMainAppl,fc_audioroutemgr_tclsourcefactory* poSourceFactory)
{
  ETG_TRACE_USR4(("Entered fc_audioroutemgr_tclresourcemanager() constructor"));

  m_poCcaMainApp = poMainAppl;
  postateControllerEnt = OSAL_NEW stateController(poMainAppl,this, poSourceFactory);
  postateControllerMix = OSAL_NEW stateController(poMainAppl,this, poSourceFactory);
  postateControllerMix2 = OSAL_NEW stateController(poMainAppl,this, poSourceFactory);
	postateControllerMix3 = OSAL_NEW stateController(poMainAppl,this, poSourceFactory);
  m_poSourceFactory = poSourceFactory;
  postateController = OSAL_NULL;
}

//daw2hi
//ToDO: check how this function have to be changed to fit to new version
tBool fc_audioroutemgr_tclresourcemanager::bAddSinkToSource(tU8 CurSrc, tU16 Sink)
{
  ETG_TRACE_USR4(("Entered bAddSinkToSource Source %d, Sink %d",CurSrc, Sink));
  return m_poSourceFactory->bAddSinkToSource(CurSrc, Sink);
}

tBool fc_audioroutemgr_tclresourcemanager::bRemoveSinkFromSource(tU8 CurSrc, tU16 Sink)
{
  ETG_TRACE_USR4(("Entered bRemoveSinkFromSource Source %d, Sink %d",CurSrc, Sink));
  return m_poSourceFactory->bRemoveSinkFromSource(CurSrc, Sink);
}

tBool fc_audioroutemgr_tclresourcemanager::bIsSinkVectorEmpty(tU8 CurSrc)
{
  ETG_TRACE_USR4(("Entered bIsSinkVectorEmpty Source %d",CurSrc));
  tBool bRet = true;
  if(m_poSourceFactory->poSourcePtr(CurSrc) != NULL)
  //if(m_poSourceFactory->poGetSource(CurSrc) != NULL)
  {
    //return m_poSourceFactory->poGetSource(CurSrc)->bIsSinkVectorEmpty();
    bRet =  m_poSourceFactory->poSourcePtr(CurSrc)->bIsSinkVectorEmpty();
    if(bRet)
    {
      ETG_TRACE_USR4(("bIsSinkVectorEmpty Yes"));
    }
    else
    {
      ETG_TRACE_USR4(("Entered bIsSinkVectorEmpty No"));
    }
  }
  return bRet; //coverity fix
}

tBool fc_audioroutemgr_tclresourcemanager::bIsSourceAllocated(tU8 CurSrc)
{
  ETG_TRACE_USR4(("Entered bIsSourceAllocated Source %d",CurSrc));
  //source* pSource = m_poSourceFactory->poGetSource(CurSrc);
  source* pSource = m_poSourceFactory->poSourcePtr(CurSrc);
  if(pSource != NULL)
  {
      std::vector<tU16> sinkList = pSource->getSinkList();
      ETG_TRACE_USR4(("Added bIsSourceAllocated Src is in state %d",pSource->enGetState()));
      if((pSource->enGetState() == source::SRC_STATE_ON) || (sinkList.size()!= 0))
      {
          ETG_TRACE_USR4(("bIsSourceAllocated Src is in  state %d  OR sink list = %d",pSource->enGetState(),sinkList.size()));
          if(CurSrc == (tU8)midw_fi_tcl_e8_AudSource::FI_EN_PHONE)
          return true;
      }

  }
  return false;
}
/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclresourcemanager::vStartSource(tU8 newSrc1, tU8 newSrc2)
*
*
* DESCRIPTION: Triggers State Change on receiving Source Route Activity ON
*
* PARAMETER:   newSrc1,newSrc2.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclresourcemanager::vProcessSourceActivityRequest(tU8 src,tU8 posnxtsrc,tU16 activity, tU16 resource, tU16 subsrc)
{
    SrcActivityCall srcactcall;
    srcactcall.Source = src;
    srcactcall.PossibleNextSource = posnxtsrc;
    srcactcall.Activity = activity;
    srcactcall.Resource = resource;
    srcactcall.SubSource = subsrc;

    source* poSourcePtr = OSAL_NULL;
    postateController = poselStateController(src);

    if(OSAL_NULL != m_poSourceFactory)
    poSourcePtr= m_poSourceFactory->poSourcePtr(src);

    if((OSAL_NULL != poSourcePtr) && (activity ==0 ))
    {//RTC1-2444855 To Avoid Entering NotifyMute if ComponentMute is Active.
      ETG_TRACE_USR4(("Activity is 0 Set Component MUte to FALSE"));
      poSourcePtr->vSetisComponentMuteActive(resource,false);
    }

    if( (postateController==postateControllerEnt) && (resource != postateController->u16Sink) )
    {
        if(postateController->m_mapLastStateOfSink.find(resource)!=postateController->m_mapLastStateOfSink.end())
        {
            ETG_TRACE_USR4((" ADDED Sink change (%d -> %d) on Entertainment state controller, reset to previous state %d",
                    postateController->u16Sink,resource,
                    (int)postateController->m_mapLastStateOfSink[resource]));
	    if(((int)postateController->m_mapLastStateOfSink[resource] == stateController::MUTE_IP) && (activity ==1))
	    {//MUTE_IP is invaid satte here hence for Activity ON modified previous state to DEALLOCATEDstate
               ETG_TRACE_USR4(("HACK added here Activity %d",activity))
               postateController->vResetState(stateController::DEALLOCATED);
	    }
            else if(((int)postateController->m_mapLastStateOfSink[resource] == stateController::DEMUTED) && (activity ==1))
            {// BUGS:RTC1-2038555,RTC1-2113528,RTC1-2184831 Intercom and Telephony during mode change
               ETG_TRACE_USR4(("HACK added here Activity %d",activity))
               postateController->vResetState(stateController::DEALLOCATED);
            }
            else if(((int)postateController->m_mapLastStateOfSink[resource] == stateController::SRC_ACT_OFF_IP)
                   && ((activity ==0) ||  (activity == 2)))
            {//RTC1-2444855 To Avoid Entering NotifyMute if ComponentMute is Active.
               ETG_TRACE_USR4(("HACK here for Activity %d",activity))
               postateController->vResetState(stateController::DEMUTED);
            }
            else if(((int)postateController->m_mapLastStateOfSink[resource] == stateController::DEMUTE_IP) && (activity ==0))
            {
               ETG_TRACE_USR4(("ADDED: DEMUTED_IP %d",activity))
               postateController->vResetState(stateController::DEMUTED);
            }
	    else if(((int)postateController->m_mapLastStateOfSink[resource] == stateController::DEALLOCATE_IP)
                   && ((activity ==0) || (activity ==2)))
	    {//RTC1-2444855 To Avoid Entering invalid state when triggered USB via SDS
	       ETG_TRACE_USR4(("HACK added here Activity %d for SDS and Source Switch",activity))
	       postateController->vResetState(stateController::DEALLOCATED);
	    }
	    else
               postateController->vResetState((tU16)postateController->m_mapLastStateOfSink[resource],resource);
               //should we assign resource here for: Bug_1143463
            postateController->u16Sink = resource;
        }
    }

    ETG_TRACE_USR4(("Activity %d Request for sink %d and postateController->u16Sink = %d in state %d",activity,resource,
            postateController->u16Sink,
            postateController->tU16GetState()));
    if(OSAL_NULL != postateController)
    {

      /* If there is already a source request for the same source, remove the request from Queue*/

     if(!postateController->QueueSrcActivityCall.empty())
      {
       deque<SrcActivityCall>::iterator iter = postateController->QueueSrcActivityCall.begin();
       for(;iter != postateController->QueueSrcActivityCall.end();++iter)
       {
         ETG_TRACE_USR4(("Src : %d SubSource : %d, Sink: %d, Activity : %d", iter->Source, iter->SubSource, iter->Resource,iter->Activity));
       }

       deque<SrcActivityCall>::iterator it = postateController->QueueSrcActivityCall.begin();

       if(postateController->QueueSrcActivityCall.front().Source == src &&
          postateController->QueueSrcActivityCall.front().SubSource == subsrc &&
      postateController->QueueSrcActivityCall.front().Resource == resource)
       {
        ++it;
       }

       for(;it != postateController->QueueSrcActivityCall.end();)
       {
        if((it->Source == src) && (it->SubSource == subsrc) && (it->Resource == resource))
        {
          ETG_TRACE_USR4(("Src : %d/%d for sink %d request removed", it->Source, it->SubSource, it->Resource));
          it = postateController->QueueSrcActivityCall.erase(it);

        }
        else
        {
          ++it;
        }
       }
      }
      if(activity == 1 && ((int)postateController->m_mapLastStateOfSink[resource] == stateController::MUTE_IP))
      {//MUTE_IN is invalid state hence modified state to DEALLOCATED
         ETG_TRACE_USR4(("Reset state to Deallocated as MUTE_IP is invalid here %d",activity));
         postateController->vResetState(stateController::DEALLOCATED);
      }

      if(activity == 0 && ((int)postateController->m_mapLastStateOfSink[resource] == stateController::SRC_ACT_OFF_IP))
      {//SRC_ACT_OFF_IP is invalid state hence modified state to DEMUTED
         ETG_TRACE_USR4(("Reset state to DEMUTED as SRC_ACT_OFF_IP is invalid here %d",activity));
         postateController->vResetState(stateController::DEMUTED);
      }
      postateController->QueueSrcActivityCall.push_back(srcactcall);
      vCalltoChangeState(srcactcall);
    }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclresourcemanager::vCalltoChangeState
*                                                    (SrcActivityCall SrcActreq)
*
* DESCRIPTION:  Changes the State Machine state based on the request.
*
* PARAMETER:    SrcActivityCall SrcActreq.
*
* RETURNVALUE:  None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclresourcemanager::vCalltoChangeState(SrcActivityCall SrcActreq)
{
  if(OSAL_NULL != postateController)
  {
      // Need a Hack here to generate different event
          //source* pSource = m_poSourceFactory->poGetSource(SrcActreq.Source);
    source* pSource = m_poSourceFactory->poSourcePtr(SrcActreq.Source);
  if( pSource!=NULL) //coverity fix
  {
      std::vector<tU16> sinkList = pSource->getSinkList();
      bool bRequestedSinkIsActive=false;
      for(unsigned int i=0;i<sinkList.size();i++)
      {
          ETG_TRACE_USR4(("Active Sink %d Number of Sinks %d",sinkList[i],pSource->pGetNumberOfSinks()));
          if(sinkList[i]==SrcActreq.Resource) bRequestedSinkIsActive=true;
      }

      if((SrcActreq.Activity == midw_fi_tcl_e8_SrcActivity::FI_EN_PAUSE) && (pSource->pGetNumberOfSinks() >1))
      {//To Avoid wrong state when VR is Done and resuming USB/BT music
          postateController->vResetState(stateController::DEMUTED);
          ETG_TRACE_USR4(("vCalltoChangeState to DEMUTED because  Activity = %d and Number of Sinks = %d",SrcActreq.Activity,pSource->pGetNumberOfSinks()));
      }

      if((SrcActreq.Activity == midw_fi_tcl_e8_SrcActivity::FI_EN_ON) && (postateController->tU16GetState() == stateController::SRC_ACT_OFF_IP))
      {//To Avoid wrong state when VR is Done and resuming USB_BT play again
          postateController->vResetState(stateController::DEALLOCATED);
          ETG_TRACE_USR4(("vCalltoChangeState to DEALLOCATED where  Activity = %d and Number of Sinks = %d",SrcActreq.Activity,pSource->pGetNumberOfSinks()));
      }
      /*else if((SrcActreq.Activity == midw_fi_tcl_e8_SrcActivity::FI_EN_ON) && (postateController->tU16GetState() == stateController::MUTE_IP))
      {//To Avoid wrong state when VR is Done and resuming Phone Call during Private_mode_2
          postateController->vResetState(stateController::DEALLOCATED);
          ETG_TRACE_USR4(("vCalltoChangeState to DEALLOCATED where  Activity = %d and Number of Sinks = %d",SrcActreq.Activity,pSource->pGetNumberOfSinks()));
      }*/

      if((postateController->tU16GetState() == stateController::DEMUTED)
             && (SrcActreq.Activity == midw_fi_tcl_e8_SrcActivity::FI_EN_OFF)
             && (pSource->pGetNumberOfSinks() >1))
      {//Above Aux2 This change is required for Phone and Audio USB switches
        postateController->vChangeState(stateController::EVENT_SET_SRCROUTEACTIVITTY_OFF_NO_DEALLOC,
             SrcActreq.Source,
             SrcActreq.PossibleNextSource,
             SrcActreq.SubSource,
             SrcActreq.Resource);
      }
      else if((postateController->tU16GetState() == stateController::DEMUTED)
             && (SrcActreq.Activity == midw_fi_tcl_e8_SrcActivity::FI_EN_PAUSE)
             && (pSource->pGetNumberOfSinks() >1))
      {
        postateController->vChangeState(stateController::EVENT_SET_SRCROUTEACTIVITTY_PAUSE_NO_DEALLOC,
             SrcActreq.Source,
             SrcActreq.PossibleNextSource,
             SrcActreq.SubSource,
             SrcActreq.Resource);
      }
      else if(   (SrcActreq.Activity == midw_fi_tcl_e8_SrcActivity::FI_EN_OFF)
              && (bRequestedSinkIsActive == false)
              && (pSource->pGetNumberOfSinks() >0)
      )
      {
           ETG_TRACE_USR4(("vCalltoChangeState: no action if this sink is not active but other sink is present"));
      }
      else if((SrcActreq.Activity == midw_fi_tcl_e8_SrcActivity::FI_EN_PAUSE) && (SrcActreq.Source == SrcActreq.PossibleNextSource) && (pSource->pGetNumberOfSinks()!=0))
      {//To Avoid wrong state when VR is Done and resuming USB/BT music
          postateController->vResetState(stateController::DEALLOCATED);
          ETG_TRACE_USR4(("vCalltoChangeState to DEALLOCATED because  Activity = %d and Number of Sinks = %d",SrcActreq.Activity,pSource->pGetNumberOfSinks()));
          SrcActreq.Activity = midw_fi_tcl_e8_SrcActivity::FI_EN_ON;
          postateController->vChangeState( stateController::EVENT_SET_SRCROUTEACTIVITTY_ON, SrcActreq.Source, SrcActreq.PossibleNextSource, SrcActreq.SubSource, SrcActreq.Resource);
      }
      else
      {
          auto itr = postateController->Activitymap.find((stateController::enSrcAct)SrcActreq.Activity);
          if(itr != postateController->Activitymap.end())
              postateController->vChangeState( itr->second, SrcActreq.Source, SrcActreq.PossibleNextSource, SrcActreq.SubSource, SrcActreq.Resource);
  }
  }
  }
}

/*******************************************************************************/
tVoid fc_audioroutemgr_tclresourcemanager::vNotifyAmpDevAudioRouteResult(tU8 CurSrc, tU16 SubSource, tU16 Sink, tU16 handle)
{
   ETG_TRACE_USR4(("Entered vNotifyAmpDevAudioRouteResult CurSrc %d, SubSrc %d, Sink %d, handle %d",CurSrc,SubSource,Sink,handle));

   stateController *postateControllr = poselStateController(CurSrc);
   if(postateControllr != OSAL_NULL)
   {
      ETG_TRACE_USR4(("Inside vNotifyAmpDevAudioRouteResult, postateControllr->u8posNextSrc = %d",postateControllr->u8posNextSrc));
      ETG_TRACE_USR4(("postateControllr->u16GetFrontSinkInQueue(CurSrc) gives %d, size is ",postateControllr->u16GetFrontSinkInQueue(CurSrc)));
      //only debug
      postateControllr->dumpQueueSrcActivityCall();
      //end
      postateControllr->u8curSrc= CurSrc;
      postateControllr->u8posNextSrc = postateControllr->u8GetFrontPossibleNextSourceInQueue(CurSrc);
      postateControllr->u16Sink = postateControllr->u16GetFrontSinkInQueue(CurSrc);
      postateController->vResetState(stateController::WAIT_AMP_DEV_RES,Sink);//ADDED to avoid different state for EVENT_RESULT_AMP_DEV State
      postateControllr->vChangeState( stateController::EVENT_RESULT_AMP_DEV,
                                    postateControllr->u8curSrc,
                                    postateControllr->u8posNextSrc,
                                    SubSource,
                                    //postateControllr->u16Sink);
                  Sink); //daw2hi modified

      ETG_TRACE_USR4(("Entered vNotifyAmpDevAudioRouteResult change state called with Src %d, SubSrc %d, posNextSrc %d, Sink %d",
            postateControllr->u8curSrc, SubSource, postateControllr->u8posNextSrc, Sink));
   }
}
/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclresourcemanager::vNotifyAllocate(tU8 CurSrc)
*
*
* DESCRIPTION: Triggers State Change on Allocate Notification
*
* PARAMETER:   CurSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclresourcemanager::vNotifyAllocate(tU8 CurSrc, tU16 SubSource)
{
    ETG_TRACE_USR4(("Entered Notify Allocate CurSrc %d",ETG_ENUM(AudioSourceNo,CurSrc)));

    stateController *postateControllr = poselStateController(CurSrc);

    if(postateControllr != OSAL_NULL)
    {
        tU16 u16Resource = postateControllr->u16GetSinkInQueueForActivityOn(CurSrc);
        if(u16Resource==0)
        {
            u16Resource = postateControllr->u16GetFrontSinkInQueue(CurSrc);
            ETG_TRACE_ERR(("ERROR: u16GetSinkInQueueForActivityOn gave sink 0, falling back to u16GetFrontSinkInQueue got sink %d",u16Resource));
        }
        if(postateControllr->u8GetFrontCurSourceInQueue(CurSrc)==0)
        {
            ETG_TRACE_ERR(("ERROR: Src %d, Notify got delayed to allocated sink %d",postateControllr->u8GetFrontCurSourceInQueue(CurSrc),u16Resource));
            return;
        }
        ETG_TRACE_USR4(("Inside Notify Allocate src %d, subsource %d, posNextSrc %d, sink %d",
                postateControllr->u8GetFrontCurSourceInQueue(CurSrc),
                SubSource,
                postateControllr->u8GetFrontPossibleNextSourceInQueue(CurSrc),
                //postateControllr->u16GetSinkInQueueForActivityOn(CurSrc)
                u16Resource));

        postateControllr->u8curSrc = postateControllr->u8GetFrontCurSourceInQueue(CurSrc);
        postateControllr->u8posNextSrc = postateControllr->u8GetFrontPossibleNextSourceInQueue(CurSrc);
        // postateControllr->u16SubSource = postateControllr->u16GetFrontSubSourceInQueue(CurSrc);
        postateControllr->u16SubSource = SubSource;
        //postateControllr->u16Sink = postateControllr->u16GetSinkInQueueForActivityOn(CurSrc);
        postateControllr->u16Sink = u16Resource;

        if((postateControllr->tU16GetState() != stateController::ALLOCATE_IP) ||
                     (postateControllr->tU16GetState() != stateController::DEALLOCATED))
    {
       ETG_TRACE_USR4(("vNotifyAllocate : vResetState to ALLOCATE_IP if not ALLOCATE_IP or DEALLOCATED"));
       postateControllr->vResetState(stateController::ALLOCATE_IP);
    }
        postateControllr->vChangeState( stateController::EVENT_RESULT_ALLOCATE,
                postateControllr->u8curSrc,
                postateControllr->u8posNextSrc,
                postateControllr->u16SubSource,
                postateControllr->u16Sink);
    }
}
/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclresourcemanager::vNotifyAllocateRoute(tVoid)
*
*
* DESCRIPTION: Triggers State Change on Allocate Notification
*
* PARAMETER:   CurSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid fc_audioroutemgr_tclresourcemanager::vNotifyAllocateRoute(tU16 u16UCID)
{
    ETG_TRACE_USR4(("Entered Notify AllocateRoute u16UCID %d (0x%x) for source %d",u16UCID,u16UCID,u8UCIDtoSource(u16UCID)));

    stateController *postateControllr = pGetStateControllerPtrFromUCID(u16UCID);
    if(postateControllr==NULL)
    {
        ETG_TRACE_ERR(("ERROR postateControllr is NULL!!!!"));
        return;
    }

    tU8 u8Source=0;
    std::vector<tU8> allSources = u8UCIDtoSourceAll(u16UCID);
    for(unsigned int i=0;i<allSources.size();i++)
    {
        if(0 !=postateControllr->u8GetFrontCurSourceInQueue(allSources[i]))
        {
            u8Source=postateControllr->u8GetFrontCurSourceInQueue(allSources[i]);
            ETG_TRACE_USR4(("found valid source %d",u8Source));
            break;
        }
    }
    if((postateControllr->tU16GetState() != stateController::ALLOCATE_IP) ||
		    (postateControllr->tU16GetState() != stateController::DEALLOCATED))
    {
       ETG_TRACE_USR4(("vResetState to ALLOCATE_IP if not ALLOCATE_IP or DEALLOCATED"));
       postateControllr->vResetState(stateController::ALLOCATE_IP);
    }
    postateControllr->u8curSrc = postateControllr->u8GetFrontCurSourceInQueue(u8Source);
    postateControllr->u8posNextSrc = postateControllr->u8GetFrontPossibleNextSourceInQueue(u8Source);
    postateControllr->u16Sink = postateControllr->u16GetFrontSinkInQueue(u8Source);
    postateControllr->vChangeState( stateController::EVENT_RESULT_ALLOCATE,
            postateControllr->u8curSrc,
            postateControllr->u8posNextSrc,
            0, // SubSource added as default
            postateControllr->u16Sink);
}


/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclresourcemanager::vNotifyDeAllocate(tU8 CurSrc)
*
*
* DESCRIPTION: Triggers State Change on Allocate Notification
*
* PARAMETER:   CurSrc.
*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid fc_audioroutemgr_tclresourcemanager::vNotifyDeAllocate(tU8 CurSrc, tU16 SubSource)
{
    ETG_TRACE_USR4(("Entered Notify DeAllocate CurSrc %d",ETG_ENUM(AudioSourceNo,CurSrc)));

    stateController *postateControllr = poselStateController(CurSrc);
    if(postateControllr != OSAL_NULL)
    {
         //RTC1-2577476 RTC1-2602247 RTC1-2584486 RTC1-2602866 Fix for Audio USB source is stuck in HMI, and campport metadata unkown
        if (!bIsSourceFoundInQueue(postateControllr, CurSrc, SubSource))
        {
            ETG_TRACE_USR4(("vNotifyDeAllocate: Source %d not found in QueueSrcActivityCall, nothing to remove", CurSrc));
            return;
        }

        if(postateControllr->u8GetFrontCurSourceInQueue(CurSrc) == 0)
        {
            ETG_TRACE_USR2(("Warning: Entered NotifyDeAllocate CurSrc %d ,postateControllr->u8curSrc %d ,hence returned with delayed",
                                              CurSrc,postateControllr->u8GetFrontCurSourceInQueue(CurSrc)));
            return;
        }
        if(CurSrc != postateControllr->u8GetFrontCurSourceInQueue())
        {
            ETG_TRACE_USR2(("Warning: Entered Notify DeAllocate CurSrc %d != SrcFromQueue %d",CurSrc,postateControllr->u8GetFrontCurSourceInQueue()));
        }

        tU16 u16Resource = postateControllr->u16GetFrontSinkInQueue(CurSrc);

        tU16 sinkState = postateController->u16GetSinkState(u16Resource);
        if (((CurSrc != (tU8)midw_fi_tcl_e8_AudSource::FI_EN_NAVI) ||
            (CurSrc != (tU8)midw_fi_tcl_e8_AudSource::FI_EN_VRU) ||
            (CurSrc != (tU8)midw_fi_tcl_e8_AudSource::FI_EN_NAVI_BY_SDS)) &&
            (sinkState == stateController::ALLOCATE_IP || sinkState == stateController::SRC_ACT_ON_IP)
        )
        {
            ETG_TRACE_USR4(("vNotifyDeAllocate: ALLOCATE_IP or SRC_ACT_ON_IP in progress for sink %d, returning", u16Resource));
            return;
        }

        postateController->vResetState(stateController::DEALLOCATE_IP);
        ETG_TRACE_USR2(("Warning: DEALLOCATE_IP as postateController gave sink = %d, but in CurrSrc Sink = %d",postateControllr->u16Sink,u16Resource));

        postateControllr->u8curSrc = postateControllr->u8GetFrontCurSourceInQueue(CurSrc);
        postateControllr->u8posNextSrc = postateControllr->u8GetFrontPossibleNextSourceInQueue(CurSrc);
        postateControllr->u16SubSource = postateControllr->u16GetFrontSubSourceInQueue(CurSrc);
        postateControllr->u16Sink = postateControllr->u16GetFrontSinkInQueue(CurSrc); //7.11.2017 daw2hi
        postateControllr->vChangeState( stateController::EVENT_RESULT_DEALLOCATE,
                postateControllr->u8curSrc,
                postateControllr->u8posNextSrc,
                postateControllr->u16SubSource,
                postateControllr->u16Sink);
    }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclresourcemanager::vNotifyDeAllocateRoute(tVoid)
*
*
* DESCRIPTION: Triggers State Change on Allocate Notification
*
* PARAMETER:   CurSrc.
*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid fc_audioroutemgr_tclresourcemanager::vNotifyDeAllocateRoute(tU16 u16UCID)
{
    ETG_TRACE_USR4(("Entered Notify DeAllocateRoute u16UCID %d (0x%x) ",u16UCID,u16UCID));
    stateController *postateControllr = pGetStateControllerPtrFromUCID(u16UCID);
    if(postateControllr==NULL)
    {
        ETG_TRACE_FATAL(("ERROR postateControllr is NULL!!!!"));
        return;
    }

    tU8 u8Source=0;
    std::vector<tU8> allSources = u8UCIDtoSourceAll(u16UCID);
    for(unsigned int i=0;i<allSources.size();i++)
    {
        if(0 !=postateControllr->u8GetFrontCurSourceInQueue(allSources[i]))
        {
            u8Source=postateControllr->u8GetFrontCurSourceInQueue(allSources[i]);
            ETG_TRACE_USR4(("found valid source %d",u8Source));
            break;
        }
    }

    if(u8Source != postateControllr->u8GetFrontCurSourceInQueue())
    {
        ETG_TRACE_USR2(("Warning: u8Source (%d) != postateControllr->u8GetFrontCurSourceInQueue() (%d)",
                u8Source,postateControllr->u8GetFrontCurSourceInQueue()));
    }

    postateControllr->u8curSrc = postateControllr->u8GetFrontCurSourceInQueue(u8Source);
    postateControllr->u8posNextSrc = postateControllr->u8GetFrontPossibleNextSourceInQueue(u8Source);
    postateControllr->vChangeState( stateController::EVENT_RESULT_DEALLOCATE,
            postateControllr->u8curSrc,
            postateControllr->u8posNextSrc,
            0, // SubSource added as default
            postateControllr->u16Sink
    );
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclresourcemanager::vNotifySetPlay()
*
*
* DESCRIPTION: Triggers State Change on SetPlay Notification
*
* PARAMETER:   None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclresourcemanager::vNotifySetPlay(tU16 u16UCID)
{
  ETG_TRACE_USR4(("Entered Notify Set Play u16UCID %d (0x%x)",u16UCID,u16UCID));

  stateController *postateControllr = pGetStateControllerPtrFromUCID(u16UCID);
  if(postateControllr != OSAL_NULL)
  {
        tU8 u8Source=0;
        std::vector<tU8> allSources = u8UCIDtoSourceAll(u16UCID);
        for(unsigned int i=0;i<allSources.size();i++)
        {
            if(0 !=postateControllr->u8GetFrontCurSourceInQueue(allSources[i]))
            {
                u8Source=postateControllr->u8GetFrontCurSourceInQueue(allSources[i]);
                ETG_TRACE_USR4(("found valid source %d",u8Source));
                break;
            }
        }
    postateControllr->u8curSrc = postateControllr->u8GetFrontCurSourceInQueue(u8Source);
    postateControllr->u8posNextSrc = postateControllr->u8GetFrontPossibleNextSourceInQueue(u8Source);
    postateControllr->vChangeState( stateController::EVENT_RESULT_SRCACTIVITY_ON,
                            postateControllr->u8curSrc,
                            postateControllr->u8posNextSrc,
                            0, // SubSOurce added as default
                            postateControllr->u16Sink
                            );
  }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclresourcemanager::vNotifySetStop()
*
*
* DESCRIPTION: Triggers State Change on SetPlay Notification
*
* PARAMETER:   None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclresourcemanager::vNotifySetStop(tU16 u16UCID)
{
  ETG_TRACE_USR4(("Entered Notify Set Stop u16UCID %d (0x%x)",u16UCID,u16UCID));

  stateController *postateControllr = pGetStateControllerPtrFromUCID(u16UCID);
  if(postateControllr != OSAL_NULL)
  {
        tU8 u8Source=0;
        std::vector<tU8> allSources = u8UCIDtoSourceAll(u16UCID);
        for(unsigned int i=0;i<allSources.size();i++)
        {
            if(0 !=postateControllr->u8GetFrontCurSourceInQueue(allSources[i]))
            {
                u8Source=postateControllr->u8GetFrontCurSourceInQueue(allSources[i]);
                ETG_TRACE_USR4(("found valid source %d",u8Source));
                break;
            }
        }
    postateControllr->u8curSrc = postateControllr->u8GetFrontCurSourceInQueue(u8Source);
    // we have to check if Sink was set and if not use 1 (default)
    if(postateControllr->u16Sink == 0)
    {
      ETG_TRACE_USR4(("Sink is 0 change it to 1"));
      postateControllr->u16Sink=1;
    }
    postateControllr->u8posNextSrc = postateControllr->u8GetFrontPossibleNextSourceInQueue(u8Source);
    ETG_TRACE_USR4(("Entered Notify Set Stop postateControllr->u16Sink %d",postateControllr->u16Sink));
    postateControllr->u16Sink = postateControllr->u16GetFrontSinkInQueue();
    ETG_TRACE_USR4(("Entered Notify Set Stop after fetch from Queue: postateControllr->u16Sink %d",postateControllr->u16Sink));
    postateControllr->vChangeState( stateController::EVENT_RESULT_SRCACTIVITY_OFF,
                            postateControllr->u8curSrc,
                            postateControllr->u8posNextSrc,
                            0, // SubSource added as default
                            postateControllr->u16Sink
                            );
  }
}
/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclresourcemanager::vNotifyMute(tU32 Mute_State)
*
*
* DESCRIPTION: Triggers State Change on Mute Notification
*
* PARAMETER:   None.
*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid fc_audioroutemgr_tclresourcemanager::vNotifyMute(tU8 Source,tU16 /*subsource*/, tU8 Mute_State, tU8 Channel,tU16 Resource)
{
  ETG_TRACE_USR4(("Entered Notify Mute() Source %d Resource %d",Source,Resource));
   (tVoid)Source;
  ETG_TRACE_USR4(("MuteState: %d, Channel: %d",Mute_State,Channel));
  if(OSAL_NULL != postateControllerMix && OSAL_NULL != postateControllerMix2 && OSAL_NULL != postateControllerEnt)
   {
  switch(Mute_State)
  {
    case (tU8)stateController:: STATE_MUTED:
    {
      switch(Channel)
      {
         case (tU8)stateController::MIX:
         {
           ETG_TRACE_USR4(("Mix Channel--Mute"));
             postateControllerMix->u8curSrc = postateControllerMix->u8GetFrontCurSourceInQueue();
           postateControllerMix->u8posNextSrc = postateControllerMix->u8GetFrontPossibleNextSourceInQueue();
           postateControllerMix->u16SubSource = postateControllerMix->u16GetFrontSubSourceInQueue();
           postateControllerMix->vChangeState( stateController::EVENT_RESULT_MUTE_ON,
                             postateControllerMix->u8curSrc,
                             postateControllerMix->u8posNextSrc,
                             postateControllerMix->u16SubSource);
           break;
         }
         case (tU8)stateController::MIX2:
           {
           ETG_TRACE_USR4(("Mix2 Channel--Mute"));
               postateControllerMix2->u8curSrc = postateControllerMix2->u8GetFrontCurSourceInQueue();
           postateControllerMix2->u8posNextSrc = postateControllerMix2->u8GetFrontPossibleNextSourceInQueue();
           postateControllerMix2->u16SubSource = postateControllerMix2->u16GetFrontSubSourceInQueue();
           postateControllerMix2->vChangeState( stateController::EVENT_RESULT_MUTE_ON,
                                            postateControllerMix2->u8curSrc,
                                            postateControllerMix2->u8posNextSrc,
                                            postateControllerMix2->u16SubSource);
           break;
           }
         case (tU8)stateController::EXCLUSIVE:
         {
            ETG_TRACE_USR4(("ADDED Exc Channel--Mute State %d for SinkState %d",postateControllerEnt->tU16GetState(),postateControllerEnt->u16GetSinkState(postateControllerEnt->u16GetFrontSinkInQueue())));
            ETG_TRACE_USR4(("ADDED Mute_IP to avoid conflict in state for Exc Channel--Mute"));
            ETG_TRACE_USR4(("Exc Channel--Mute"));
            if((postateControllerEnt->u16GetSinkState(postateControllerEnt->u16GetFrontSinkInQueue()) == stateController::SRC_ACT_ON_IP) && Resource == 17)
            {//Bug_1647113 No Audio after Removal of USB-Stick 
                ETG_TRACE_USR4(("Nothing to Process Since,Sink17 as invalid State to process now as Other Sink is in SRC_ACT_ON_IP"));
                return;
            }
            if((postateControllerEnt->u16GetSinkState(postateControllerEnt->u16GetFrontSinkInQueue()) == stateController::ALLOCATE_IP) && Resource == 17)
            {//RTC1-2444855 To avoid invalid state ALLOCATE_IP
              ETG_TRACE_USR4(("Nothing to Process Since,Sink17 as invalid State to process now as Other Sink is in ALLOCATE_IP"));
              return;
            }

            if((postateControllerEnt->u8GetFrontCurSourceInQueue(Resource) == 0) &&
              (postateControllerEnt->u8curSrc == postateControllerEnt->u8GetFrontPossibleNextSourceInQueue()) &&
              (postateControllerEnt->u16GetSinkState(postateControllerEnt->u16GetFrontSinkInQueue()) == stateController::ALLOCATE_IP))
            {//To avoid proggress mute for invalid sources and sink
              ETG_TRACE_USR4(("To avoid proggress mute for invalid sources and sink"));
              return;
            }

            if(Resource == 2 || (Resource == 1 && (postateControllerEnt->u8GetFrontCurResourceSourceInQueue(Resource) == (tU8)midw_fi_tcl_e8_AudSource::FI_EN_VRU)))
            {
                ETG_TRACE_USR4(("Exc Channel--Mute for resource 2 or VRU"));
                postateControllerEnt->u8curSrc = postateControllerEnt->u8GetFrontCurResourceSourceInQueue(Resource);
                ETG_TRACE_USR4(("Exc Channel--Mute for resource 2 or 1 and source %d",postateControllerEnt->u8curSrc));
                if(postateControllerEnt->u8curSrc == 0)
                {
                    ETG_TRACE_USR4(("Exc Channel--Mute Notify but No Source Found for resource 2"));
                }
            }
            else
            {
                postateControllerEnt->u8curSrc = postateControllerEnt->u8GetFrontCurSourceInQueue();
            }
            stateController *postateControllr = poselStateController(postateControllerEnt->u8GetFrontCurSourceInQueue());
             source* poSourcePtr = OSAL_NULL;
             if(OSAL_NULL != m_poSourceFactory && (postateControllr != OSAL_NULL))
             {
                ETG_TRACE_USR4(("ADDED:Exc Channel--Mute "));
                poSourcePtr = m_poSourceFactory->poSourcePtr(postateControllerEnt->u8GetFrontCurSourceInQueue());
                ETG_TRACE_USR4(("ComponentMute is not active"));
                if((postateControllerEnt->tU16GetState() == stateController::SRC_ACT_ON_IP) ||
                (postateControllerEnt->tU16GetState()== stateController::DEMUTED))
                {
                     // BUGS:RTC1-2038555,RTC1-2113528,RTC1-2184831 Intercom and Telephony during mode changeee
                     ETG_TRACE_USR4(("Reset to MUTE_IP as source is not in MUTE state"));
                     if((postateControllerEnt->u16GetSinkState(Resource) != stateController::OFF_MUTE_ONLY))
                     postateController->vResetState(stateController::MUTE_IP,Resource);
                }

                if((postateControllerEnt->u16GetSinkState(Resource) == stateController::OFF_MUTE_ONLY))
                {
                  ETG_TRACE_USR4(("ADDED: Resource Reset state OFF_MUTE ONLY"));
                  postateController->vResetState(stateController::OFF_MUTE_ONLY, Resource);
                }
                else if((postateControllerEnt->u16GetSinkState(Resource) == stateController::PAUSE_MUTE_ONLY))
                {
                  ETG_TRACE_USR4(("ADDED: Resource Reset state PAUSE_MUTE_ONLY"));
                  postateController->vResetState(stateController::PAUSE_MUTE_ONLY, Resource);
                }
                //RTC1-2577476 RTC1-2602247 RTC1-2584486 RTC1-2602866 Fix for Audio USB source is stuck in HMI, and campport metadata unkown
                else
                {
                  ETG_TRACE_USR4(("ADDED: Resource Reset state MUTE_IP"));
                  postateController->vResetState(stateController::MUTE_IP, Resource);
                }
            }
            ETG_TRACE_USR4(("vNotifyMute source %d",postateControllerEnt->u8GetFrontCurSourceInQueue(Resource)));
            postateControllerEnt->vChangeState( stateController::EVENT_RESULT_MUTE_ON,
                                                        postateControllerEnt->u8curSrc,
                                                        postateControllerEnt->u8GetFrontPossibleNextSourceInQueue(),
                                                        postateControllerEnt->u16GetFrontSubSourceInQueue(),
                                                        Resource);
           break;
          }
         default:
           break;
      }
      break;
    }
    case (tU8)stateController::STATE_DEMUTED:
      {
      switch(Channel)
      {
         case (tU8)stateController::MIX:
         {
           ETG_TRACE_USR4(("Mix Channel--DeMute"));

           postateControllerMix->vChangeState( stateController::EVENT_RESULT_MUTE_OFF,
                             postateControllerMix->u8curSrc,
                             postateControllerMix->u8posNextSrc,
                             postateControllerMix->u16SubSource);

           break;
         }
         case (tU8)stateController::MIX2:
           {
           ETG_TRACE_USR4(("Mix2 Channel--DeMute"));

           postateControllerMix2->vChangeState( stateController::EVENT_RESULT_MUTE_OFF,
                             postateControllerMix2->u8curSrc,
                             postateControllerMix2->u8posNextSrc,
                             postateControllerMix2->u16SubSource);
           break;
           }
         case (tU8)stateController::EXCLUSIVE:
         {
          ETG_TRACE_USR4(("Exc Channel--DeMute"));
         if((!((postateControllerEnt->u8GetFrontCurResourceSourceInQueue(Resource) == (tU8)midw_fi_tcl_e8_AudSource::FI_EN_VRU)  ||
         (postateControllerEnt->u8GetFrontCurResourceSourceInQueue(Resource) == (tU8)midw_fi_tcl_e8_AudSource::FI_EN_NAVI) ||
         (postateControllerEnt->u8GetFrontCurResourceSourceInQueue(Resource) == (tU8)midw_fi_tcl_e8_AudSource::FI_EN_SMS)  ||
         (postateControllerEnt->u8GetFrontCurResourceSourceInQueue(Resource) == (tU8)midw_fi_tcl_e8_AudSource::FI_EN_SPI_TTS)))&&
         (postateControllerEnt->u16GetFrontSinkInQueue() != stateController::DEMUTE_IP))
          {
            ETG_TRACE_USR4(("Reset to DEMUTED"));// BUGS:RTC1-2038555,RTC1-2113528,RTC1-2184831 Intercom and Telephony during mode change
            postateController->vResetState(stateController::DEMUTED, Resource);
          }
          else
          ETG_TRACE_USR4(("DEMUTE NOT REQUIRED FOR VRU"));
          postateControllerEnt->vChangeState( stateController::EVENT_RESULT_MUTE_OFF,
                              postateControllerEnt->u8curSrc,
                              postateControllerEnt->u8posNextSrc,
                              postateControllerEnt->u16SubSource,
                              Resource);
           break;
         }
         default:
           break;
       }
      break;
       }
    default:
      break;
   }
   }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclresourcemanager::vNotifySourceActivity(tU8 Source, tU16 SrcActivity)
*
*
* DESCRIPTION: Triggers State Change on Source Activity Notification
*
* PARAMETER:   Source, SourceActivity.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclresourcemanager::vNotifySourceActivity(tU8 Source, tU16 SrcActivity, tU16 SubSource)
{
  ETG_TRACE_USR4(("Entered Notify Source Activity Source %d, SrcActivity %d",ETG_ENUM(AudioSourceNo,Source),SrcActivity));

  stateController *postateControllr = this->poselStateController(Source);

  if(OSAL_NULL != postateControllr)
  {//Modifed to notify the Activity based on Source received
   postateControllr->u8curSrc = Source; //postateControllr->u8GetFrontCurSourceInQueue();
   postateControllr->u8posNextSrc = postateControllr->u8GetFrontPossibleNextSourceInQueue(Source);
   postateControllr->u16SubSource = postateControllr->u16GetFrontSubSourceInQueue(Source);
   postateControllr->u16Sink = postateControllr->u16GetFrontSinkInQueue(Source);
   postateControllr->u8activity = postateControllr->u16GetFrontActivityInQueue(Source);

   ETG_TRACE_USR4(("vNotifySourceActivity: u8curSrc=%d, u8posNextSrc=%d, u16SubSource=%d, u16Sink=%d, u8activity=%d",
      postateControllr->u8curSrc,
      postateControllr->u8posNextSrc,
      postateControllr->u16SubSource,
      postateControllr->u16Sink,
      postateControllr->u8activity));

   //RTC1-2577476 RTC1-2602247 RTC1-2584486 RTC1-2602866 Fix for Audio USB source is stuck in HMI, and campport metadata unkown
   if (!bIsSourceFoundInQueue(postateControllr, Source, SubSource))
   {
      ETG_TRACE_USR4(("vNotifySourceActivity: Source %d not found in QueueSrcActivityCall, nothing to remove", Source));
      return;
   }

   switch(SrcActivity)
    {
      case (tU16)stateController::OFF:
      {
       tU16 u16Resource = postateControllr->u16GetFrontSinkInQueue(Source);

       if((postateControllr == postateControllerEnt)) //&& (u16Resource != postateControllr->u16Sink))
       {
    	    postateControllr->vResetState(stateController::SRC_ACT_OFF_IP);
            ETG_TRACE_USR2(("vNotifySourceActivity: DEALLOCATE_IP as postateController gave sink = %d, but in CurrSrc Sink = %d",postateControllr->u16Sink,u16Resource));
       }
       postateControllr->vChangeState( stateController::EVENT_RESULT_SRCACTIVITY_OFF,
                                  postateControllr->u8curSrc,
                                  postateControllr->u8posNextSrc,
                                  postateControllr->u16SubSource,
                                  postateControllr->u16Sink);
      break;
      }
      case (tU16)stateController::ON:
      {
         tU16 u16Resource = postateControllr->u16GetFrontSinkInQueue(Source);
         if((postateController == postateControllerEnt))
         {
            postateControllr->vResetState(stateController::SRC_ACT_ON_IP);
            ETG_TRACE_USR2(("vNotifySourceActivity: ALLOCATE_IP as postateController gave sink = %d, but in CurrSrc Sink = %d",postateControllr->u16Sink,u16Resource));
         }
         postateControllr->vChangeState( stateController::EVENT_RESULT_SRCACTIVITY_ON,
                                  postateControllr->u8curSrc,
                                  postateControllr->u8posNextSrc,
                                  postateControllr->u16SubSource,
                                  postateControllr->u16Sink);
        break;
      }
      case (tU16)stateController::PAUSE:
      {
        tU16 u16Resource = postateControllr->u16GetFrontSinkInQueue(Source);
        ETG_TRACE_USR2(("vNotifySourceActivity: ADDED Always reset state to SRC_ACT_OFF_IP for ALLOCATE_PAUSE as postateController gave sink = %d, but in CurrSrc Sink = %d",postateControllr->u16Sink,u16Resource));
        postateControllr->vResetState(stateController::SRC_ACT_OFF_IP);
        postateControllr->vChangeState( stateController::EVENT_RESULT_SRCACTIVITY_PAUSE,
                                  postateControllr->u8curSrc,
                                  postateControllr->u8posNextSrc,
                                  postateControllr->u16SubSource,
                                  postateControllr->u16Sink);
      break;
      }
      default:
      {
        break;
      }
    }
  }
}
/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclresourcemanager::vGetSnapshot(tVoid)
*
* DESCRIPTION: Gives the Snapshot of Resource Manager
*
* PARAMETER:
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclresourcemanager::vGetSnapshot(tVoid)
{
    ETG_TRACE_USR4(("------ vGetSnapshot Start ------"));
    if((OSAL_NULL != postateControllerEnt) && (OSAL_NULL != postateControllerMix) && ((OSAL_NULL != postateControllerMix2)))
    {
        ETG_TRACE_USR4(("EntSrcState: %d, MixSrcState : %d, Mix2SrcState : %d, CurrentEntSource: %d, PosNextEntSrc: %d CurrentMixSrc : %d, PosNxrMixSrc : %d\
            CurrentMix2Src : %d, PosNxrMix2Src : %d",
            ETG_CENUM(stateController::enState, postateControllerEnt->tU16GetState()),
            ETG_CENUM(stateController::enState, postateControllerMix->tU16GetState()),
            ETG_CENUM(stateController::enState, postateControllerMix2->tU16GetState()),
            ETG_ENUM(AudioSourceNo, postateControllerEnt->u8curSrc),
            ETG_ENUM(AudioSourceNo, postateControllerEnt->u8posNextSrc),
            ETG_ENUM(AudioSourceNo, postateControllerMix->u8curSrc),
            ETG_ENUM(AudioSourceNo, postateControllerMix->u8posNextSrc),
            ETG_ENUM(AudioSourceNo, postateControllerMix2->u8curSrc),
            ETG_ENUM(AudioSourceNo, postateControllerMix2->u8posNextSrc)));

        //Dump all Queues
        ETG_TRACE_USR4(("Dump Ent Queue"));
        postateControllerEnt->dumpQueueSrcActivityCall();
        ETG_TRACE_USR4(("Dump Mix1 Queue"));
        postateControllerMix->dumpQueueSrcActivityCall();
        ETG_TRACE_USR4(("Dump Mix2 Queue"));
        postateControllerMix2->dumpQueueSrcActivityCall();
        ETG_TRACE_USR4(("Dump Mix3 Queue"));
        postateControllerMix3->dumpQueueSrcActivityCall();
    }
    ETG_TRACE_USR4(("------ vGetSnapshot End ------"));
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclresourcemanager::u8GetCurSrcinSM(tU8 Stream) const
*
* DESCRIPTION: Returns the Current Source
*
* PARAMETER:
*
* RETURNVALUE: tU16.
*
*******************************************************************************/

tU8 fc_audioroutemgr_tclresourcemanager::u8GetCurSrcinSM(tU8 Stream) const
{
  switch(Stream)
  {
  case (tU8)source::STREAM_MAIN:
      if(postateControllerEnt)
  return postateControllerEnt->u8curSrc;
      break;
  case (tU8)source::STREAM_MIX1:
      if(postateControllerMix)
        return postateControllerMix->u8curSrc;
      break;
  case (tU8)source::STREAM_MIX2:
      if(postateControllerMix2)
        return postateControllerMix2->u8curSrc;
      break;
	case (tU8)source::STREAM_MIX3:
			if(postateControllerMix3)
				return postateControllerMix3->u8curSrc;
	break;
  default:
    return (tU8)midw_fi_tcl_e8_AudSource::FI_EN_NONE;
      break;
  }
  return (tU8)midw_fi_tcl_e8_AudSource::FI_EN_NONE;
}
/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclresourcemanager::u8GetNextSrc(tU8 Stream)
*
* DESCRIPTION: Returns the Next Possible Source
*
* PARAMETER:
*
* RETURNVALUE: tU16.
*
*******************************************************************************/
tU8 fc_audioroutemgr_tclresourcemanager::u8GetNextSrcinSM(tU8 Stream) const
{
  switch(Stream)
  {
  case (tU8)source::STREAM_MAIN:
      if(postateControllerEnt)
  return postateControllerEnt->u8posNextSrc;
      break;
  case (tU8)source::STREAM_MIX1:
      if(postateControllerMix)
        return postateControllerMix->u8posNextSrc;
      break;
  case (tU8)source::STREAM_MIX2:
      if(postateControllerMix2)
        return postateControllerMix2->u8posNextSrc;
      break;
  default:
    return (tU8)midw_fi_tcl_e8_AudSource::FI_EN_NONE;
      break;
  }
  return (tU8)midw_fi_tcl_e8_AudSource::FI_EN_NONE;
}

/*******************************************************************************
*
* FUNCTION: tU8 fc_audioroutemgr_tclresourcemanager::
*                  u8UCIDtoSource(tU16 UCID, stateController::enEvent event)
*
* DESCRIPTION: Converts UCID to corresponding source no.
*
* PARAMETER:
*
* RETURNVALUE: tU8.
*
*******************************************************************************/
tU8 fc_audioroutemgr_tclresourcemanager::u8UCIDtoSource(tU16 UCID)
{
  ETG_TRACE_USR4(("Entered u8UCIDtoSource UCID %d",UCID));
  vector<source*>::iterator sourceIterator;

  if( OSAL_NULL != m_poSourceFactory)
  {
     for(sourceIterator = m_poSourceFactory->sourceVector.begin();
      sourceIterator != m_poSourceFactory->sourceVector.end(); ++sourceIterator)
         {
      if(((*sourceIterator)->u16GetUCID() == UCID))
      {
      ETG_TRACE_USR4(("Source : %d",ETG_ENUM(AudioSourceNo,(*sourceIterator)->u8GetSourceID())));
      return ((*sourceIterator)->u8GetSourceID());
      }
     else
     {
            //do nothing
     }
     }
  }
  return ((tU8)midw_fi_tcl_e8_AudSource::FI_EN_NONE);
}

std::vector<tU8> fc_audioroutemgr_tclresourcemanager::u8UCIDtoSourceAll(tU16 UCID)
{
    ETG_TRACE_USR4(("Entered u8UCIDtoSourceAll"));
    vector<source*>::iterator sourceIterator;
    vector<tU8> allSources;

    //we might find several sources for one UCID, e.g. Diag has same UCID
    if( OSAL_NULL != m_poSourceFactory)
    {
        for(sourceIterator = m_poSourceFactory->sourceVector.begin();
                sourceIterator != m_poSourceFactory->sourceVector.end(); ++sourceIterator)
        {
            if(((*sourceIterator)->u16GetUCID() == UCID))
            {
                ETG_TRACE_USR4(("Found Source : %d",ETG_ENUM(AudioSourceNo,(*sourceIterator)->u8GetSourceID())));
                allSources.push_back((*sourceIterator)->u8GetSourceID());
            }
        }
    }
    return allSources;
}
/*******************************************************************************
*
* FUNCTION:stateController* fc_audioroutemgr_tclresourcemanager:: pGetStateControllerPtrFromUCID(tU16 UCID)
*
* DESCRIPTION: Converts UCID to corresponding statecontroller Pointer.
*
* PARAMETER:
*
* RETURNVALUE: stateController.
*
*******************************************************************************/
stateController* fc_audioroutemgr_tclresourcemanager:: pGetStateControllerPtrFromUCID(tU16 UCID)
{
  ETG_TRACE_USR4(("Entered UCIDtoStateControllerPtr"));
  vector<source*>::iterator sourceIterator;

  if( OSAL_NULL != m_poSourceFactory)
  {
     for(sourceIterator = m_poSourceFactory->sourceVector.begin();
      sourceIterator != m_poSourceFactory->sourceVector.end(); ++sourceIterator)
         {
      if(((*sourceIterator)->u16GetUCID() == UCID))
      {
      if((*sourceIterator)->u8GetSourceID() == (tU8)midw_fi_tcl_e8_AudSource::FI_EN_NAVI)
        return postateControllerMix;
      else
        return postateControllerEnt;
      }
     else
     {
            //do nothing
     }
     }
  }
  return NULL;
}
/*******************************************************************************
*
* FUNCTION: tU8 fc_audioroutemgr_tclresourcemanager::
*                 bCheckValidSrcState(tU8 src, stateController::enEvent event)
*
* DESCRIPTION: Checks for valid source state.
*
* PARAMETER:
*
* RETURNVALUE: tBool.
*
*******************************************************************************/
tBool fc_audioroutemgr_tclresourcemanager::bCheckValidSrcState(tU8 src, stateController::enEvent event)
{
  ETG_TRACE_USR4(("bCheckValidSrcState"));

  tBool tValidSrcState = FALSE;
  if( OSAL_NULL != m_poSourceFactory && m_poSourceFactory->poSourcePtr(src) != NULL)
  {
    source::enSrcState state = m_poSourceFactory->poSourcePtr(src)->enGetState();

    ETG_TRACE_USR4(("Aux Source State: %d",m_poSourceFactory->poSourcePtr(src)->enGetState()));

    if((state == source::SRC_STATE_OFF_IP ) &&
      ((event == stateController::EVENT_RESULT_DEALLOCATE) ||
         (event == stateController::EVENT_RESULT_SRCACTIVITY_OFF)))
    {
      tValidSrcState = TRUE;
    }
    else if((state == source::SRC_STATE_ON_IP ) &&
           ((event == stateController::EVENT_RESULT_ALLOCATE) ||
          (event == stateController::EVENT_RESULT_SRCACTIVITY_ON)))
    {
      tValidSrcState = TRUE;
    }
    else
    {
      //do nothing
    }
  }
  return tValidSrcState;
}

/*******************************************************************************
*
* FUNCTION:    tU8 fc_audioroutemgr_tclresourcemanager::
*                               u16getSourceActivityStatus()
*
* DESCRIPTION: Returns the source activity status
*
* PARAMETER: none
*
* RETURNVALUE: tU16
*
*******************************************************************************/
tU16 fc_audioroutemgr_tclresourcemanager::u16getSourceActivityStatus() const
{
  tU16 RetVal = (tU16)stateController::OFF;
  if(postateControllerEnt != OSAL_NULL)
  {
    return postateControllerEnt->QueueSrcActivityCall.front().Activity;
  }
  return RetVal;
}

/*******************************************************************************
*
* FUNCTION:    tU8 fc_audioroutemgr_tclresourcemanager::
*                              vNotifySourceState(tU8 src, enSrcState state)
*
* DESCRIPTION: Notifies Source state.
*
* PARAMETER:  tU8 src, enSrcState state
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclresourcemanager::vNotifySourceState(tU8 src, tU8 state)
{
  ETG_TRACE_USR4(("vNotifySourceState src %d, state %d",ETG_ENUM(AudioSourceNo,src), ETG_CENUM(stateController::enState,state)));
  source* poSourcePtr = OSAL_NULL;

  if(OSAL_NULL != m_poSourceFactory)
    poSourcePtr = m_poSourceFactory->poSourcePtr(src);

  if(OSAL_NULL != poSourcePtr)
    poSourcePtr->vSetState((source::enSrcState)state);
}
/*******************************************************************************/
tVoid fc_audioroutemgr_tclresourcemanager::vSendAmpDeviceAudioRoute(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink)
{
   ETG_TRACE_USR4(("vSendAmpDeviceAudioRoute CurSrc %d, POsNextSrc %d, SubSrc %d, Sink %d",CurSrc, PosNextSrc, SubSource,  Sink));

   m_poCcaMainApp->poGetAudioFuncClientHandler()->vSendAmpDeviceAudioRoute(CurSrc,SubSource,Sink);
}
/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclresourcemanager::vTraceRx(tPCUChar pcu8Data)
*
* DESCRIPTION: Receives TTFis Trace Commands.
*
* PARAMETER:   tPCUChar pcu8Data.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclresourcemanager::vTraceRx(tU32 size, tPCUChar pcu8Data)
{
   ETG_TRACE_USR4(("fc_audioroutemgr_tclresourcemanager vTraceRx() entered."));

   if(pcu8Data==0) return;
   // pcu8Data[0] == my file number
   // pcu8Data[1] == the command
   // pcu8Data[2] == the 1. parameter
   // rest is defined here

   ETG_TRACE_USR4(("vTraceRx() size=%u",size));
   if (size > 1)
   {
    ETG_TRACE_USR4(("vTraceRx() pcu8Data[0] [1] =%u %u",(tU16)pcu8Data[0],(tU16)pcu8Data[1]));
      switch ( pcu8Data[1] )
      {
         case TRC::Resource_Mgr_Snapshot:
          {
            ETG_TRACE_USR4(("TTFis Rx Resource_Mgr_Snapshot"));
           vGetSnapshot();
            break;
          }

         default:
           ETG_TRACE_USR4(("default"));
           break;
      }
   }
}
/*******************************************************************************
*
* FUNCTION:    stateController::stateController(fc_audioroutemgr_tclApp* pCcaMainApp)
*
*
* DESCRIPTION: Constructor.
*
* PARAMETER:   pCcaMainApp- Pointer to Main App.
*
* RETURNVALUE: None.
*
*******************************************************************************/
stateController::stateController(fc_audioroutemgr_tclApp* pCcaMainApp,fc_audioroutemgr_tclresourcemanager* poResourceMgr,fc_audioroutemgr_tclsourcefactory* poSourceFactory)
{
  ETG_TRACE_USR4(("Entered stateController() constructor"));

  m_u16State = (tU16) DEALLOCATED;
  m_u16Event = (tU16) EVENT_UNDEF;
  m_poCcaMainApp = pCcaMainApp;
    u8activity = (tU16) OFF;
    u8curSrc = (tU8)midw_fi_tcl_e8_AudSource::FI_EN_NONE;
    u8posNextSrc = (tU8)midw_fi_tcl_e8_AudSource::FI_EN_NONE;
    u16SubSource = 0;
  u16Sink = 1;  //coverity fix;
    m_poSourceFactory = poSourceFactory;
    m_poResourceMgr = poResourceMgr;
    QueueSrcActivityCall.clear();
  if(stateControlVector.empty())
  {
    #define AUDIO_RESOURCE_MGR_STATES_CONFIG
      #define statecontroller(State,Trigger,NextState,GuardFun,GuardResult,Operation,StateStability) stateControlVector.push_back(OSAL_NEW stateControl((tU16)State,(tU16)Trigger,(tU16)NextState,GuardFun,(tU16)GuardResult,Operation,(tU16)StateStability,pCcaMainApp,poResourceMgr,poSourceFactory));
        #include "../Config/fc_audioroutemgr_statemachine.conf"
      #undef statecontroller
    #undef AUDIO_RESOURCE_MGR_STATES_CONFIG
  }
  else
  {
    ETG_TRACE_ERR(("Source Control Vector Not Empty"));
  }

  if(muteConfigCheckVector.empty())
  {
    #define AUDIO_SOURCES_SRCCHG_MUTING_CONFIG
      #define sourceMute(Src,PosNxtSrc) muteConfigCheckVector.push_back(OSAL_NEW muteConfigCheck((tU8)Src,(tU8)PosNxtSrc));
        #include "../Config/fc_audioroutemgr_audiosources.conf"
      #undef sourceMute
    #undef AUDIO_SOURCES_SRCCHG_MUTING_CONFIG
  }
  else
  {
    ETG_TRACE_ERR(("MuteConfigCheckVector Not Empty"));
  }
  Activitymap.insert(make_pair(stateController::PAUSE, stateController::EVENT_SET_SRCROUTEACTIVITTY_PAUSE));
  Activitymap.insert(make_pair(stateController::ON, stateController::EVENT_SET_SRCROUTEACTIVITTY_ON));
  Activitymap.insert(make_pair(stateController::OFF, stateController::EVENT_SET_SRCROUTEACTIVITTY_OFF));
}

/*******************************************************************************
*
* FUNCTION:    tU16 stateController::tU16GetState(tVoid) const
*
*
* DESCRIPTION: Returns the current state of the Resource Manager.
*
* PARAMETER:   None.
*
* RETURNVALUE: tU16 m_u16State.
*
*******************************************************************************/
tU16 stateController::tU16GetState(tVoid) const
{
  return m_u16State;
}
/*******************************************************************************
*
* FUNCTION:    tU16 stateController::vResetState(tU16 SM_state)
*
*
* DESCRIPTION: Resets the Resource Manager state.
*
* PARAMETER:   tU16 SM_state.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid stateController::vResetState(tU16 SM_state,tU16 Sink)
{
  m_u16State = (tU16)SM_state;
  u16SetSinkState(Sink,SM_state);
}

/*******************************************************************************
*
* FUNCTION:    tU16 stateController::bCheckIfSrcSameasSrcInFrontofQueue(tU8 Src)
*
*
* DESCRIPTION: Returns True if source is same as Front source in Queue.
*
* PARAMETER:   tU8 Src.
*
* RETURNVALUE: tBool.
*
*******************************************************************************/
tBool stateController::bCheckIfSrcSameasSrcInFrontofQueue(tU8 Src)
{
  if((!this->QueueSrcActivityCall.empty()) && (this->QueueSrcActivityCall.front().Source != (tU8)midw_fi_tcl_e8_AudSource::FI_EN_NONE) &&
          (Src == this->QueueSrcActivityCall.front().Source))
  {
    return TRUE;
  }
  else
  {
    return FALSE;
  }
}

/*******************************************************************************
*
* FUNCTION:    tU16 stateController::u8GetFrontCurSourceInQueue()
*
*
* DESCRIPTION: Returns Front source in Queue.
*
* PARAMETER:   None
*
* RETURNVALUE: tU8.
*
*******************************************************************************/
tU8 stateController::u8GetFrontCurSourceInQueue()
{
  return this->QueueSrcActivityCall.front().Source;
}

//pick front element with this source
tU8 stateController::u8GetFrontCurSourceInQueue(tU8 u8Source)
{
    for(unsigned int i=0;i<this->QueueSrcActivityCall.size();i++)
    {
        if(this->QueueSrcActivityCall[i].Source == u8Source)
            return u8Source;
    }
    ETG_TRACE_ERR(("u8GetFrontCurSourceInQueue: No activity for this source %d found",u8Source));
    return 0;
}

//pick front element with this source based on Resource tU16 u8GetFrontCurResourceSourceInQueue(tU16 Resource);
tU16 stateController::u8GetFrontCurResourceSourceInQueue(tU16 Resource)
{
    for(unsigned int i=0;i<this->QueueSrcActivityCall.size();i++)
    {
        if(this->QueueSrcActivityCall[i].Resource == Resource)
            return this->QueueSrcActivityCall[i].Source;
    }
    ETG_TRACE_ERR(("u8GetFrontCurSourceInQueue: No activity for this Resource %d found",Resource));
    return 0;
}
/*******************************************************************************
*
* FUNCTION:    tU16 stateController::u8GetFrontPossibleNextSourceInQueue()
*
*
* DESCRIPTION: Returns Front Possible Next source in Queue.
*
* PARAMETER:   None
*
* RETURNVALUE: tU8.
*
*******************************************************************************/
tU8 stateController::u8GetFrontPossibleNextSourceInQueue()
{
  return this->QueueSrcActivityCall.front().PossibleNextSource;
}

tU8 stateController::u8GetFrontPossibleNextSourceInQueue(tU8 u8Source)
{
    for(unsigned int i=0;i<this->QueueSrcActivityCall.size();i++)
    {
        if(this->QueueSrcActivityCall[i].Source == u8Source)
            return this->QueueSrcActivityCall[i].PossibleNextSource;
    }
    ETG_TRACE_ERR(("u8GetFrontPossibleNextSourceInQueue: No activity for this source %d found",u8Source));
    return 0;
}

/*******************************************************************************
*
* FUNCTION:    tU16 stateController::u16GetFrontActivityInQueue()
*
*
* DESCRIPTION: Returns Front Activity in Queue.
*
* PARAMETER:   None
*
* RETURNVALUE: tU8.
*
*******************************************************************************/
tU16 stateController::u16GetFrontActivityInQueue()
{
  return this->QueueSrcActivityCall.front().Activity;
}

tU16 stateController::u16GetFrontActivityInQueue(tU8 u8Source)
{
    for(unsigned int i=0;i<this->QueueSrcActivityCall.size();i++)
    {
        if(this->QueueSrcActivityCall[i].Source == u8Source)
            return this->QueueSrcActivityCall[i].Activity;
    }
    ETG_TRACE_ERR(("u16GetFrontActivityInQueue: No activity for this source %d found",u8Source));
    return 0;
}

/*******************************************************************************
*
* FUNCTION:    tU16 stateController::u16GetFrontSubSourceInQueue()
*
*
* DESCRIPTION: Returns Front SubSource in Queue.
*
* PARAMETER:   None
*
* RETURNVALUE: tU8.
*
*******************************************************************************/
tU16 stateController::u16GetFrontSubSourceInQueue()
{
  return this->QueueSrcActivityCall.front().SubSource;
}

tU16 stateController::u16GetFrontSubSourceInQueue(tU8 u8Source)
{
    for(unsigned int i=0;i<this->QueueSrcActivityCall.size();i++)
    {
        if(this->QueueSrcActivityCall[i].Source == u8Source)
            return this->QueueSrcActivityCall[i].SubSource;
    }
    ETG_TRACE_ERR(("u16GetFrontSubSourceInQueue: No activity for this source %d found",u8Source));
    return 0;
}

/*******************************************************************************/
tU16 stateController::u16GetFrontSinkInQueue()
{
  return this->QueueSrcActivityCall.front().Resource;
}

tU16 stateController::u16GetFrontSinkInQueue(tU8 u8Source)
{
    for(unsigned int i=0;i<this->QueueSrcActivityCall.size();i++)
    {
        if(this->QueueSrcActivityCall[i].Source == u8Source)
            return this->QueueSrcActivityCall[i].Resource;
    }
    ETG_TRACE_ERR(("u16GetFrontSinkInQueue: No activity for this source %d found",u8Source));
    return 1; //return the default sink instead of 0 which is invalid
}

tU16 stateController::u16GetSinkInQueueForActivityOn(tU8 u8Source)
{
    for(unsigned int i=0;i<this->QueueSrcActivityCall.size();i++)
    {
        if( (this->QueueSrcActivityCall[i].Source == u8Source) && (this->QueueSrcActivityCall[i].Activity  == 1) ) // only if ON
            return this->QueueSrcActivityCall[i].Resource;
    }
    ETG_TRACE_ERR(("u16GetFrontSinkInQueue: No activity for this source %d found",u8Source));
    return 0; //return invalid sink if not found
}

/*******************************************************************************/
void stateController::dumpQueueSrcActivityCall()
{
     ETG_TRACE_USR4(("dumpQueueSrcActivityCall QueueSrcActivityCall.size = %d",QueueSrcActivityCall.size()));
     for(unsigned int i=0;i<QueueSrcActivityCall.size();i++)
     {
       ETG_TRACE_USR4(("Source[%d] %d",i,QueueSrcActivityCall[i].Source));
       ETG_TRACE_USR4(("PossibleNextSource[%d] %d",i,QueueSrcActivityCall[i].PossibleNextSource));
       ETG_TRACE_USR4(("Activity[%d] %d",i,QueueSrcActivityCall[i].Activity));
       ETG_TRACE_USR4(("SubSource[%d] %d",i,QueueSrcActivityCall[i].SubSource));
       ETG_TRACE_USR4(("Resource[%d] %d",i,QueueSrcActivityCall[i].Resource));
     }
     return;
}

void stateController::u16SetSinkState(tU16 Sink, tU16 enState)
{
	ETG_TRACE_USR4(("u16SetSinkState Sink %d State %d",Sink,enState));
  if(Sink == 1)
	  stateController::enState_Sink1 = enState;
  else if(Sink == 2)
	  stateController::enState_Sink2 = enState;
  else if(Sink == 17)
	  stateController::enState_Sink17 = enState;
}

tU16 stateController::u16GetSinkState(tU16 Sink)
{
	ETG_TRACE_USR4(("u16GetSinkState Sink %d",Sink));
  if(Sink == 1)
	  return stateController::enState_Sink1;
  else if(Sink == 2)
	  return stateController::enState_Sink2;
  else if(Sink == 17)
	  return stateController::enState_Sink17;
}

/*******************************************************************************
* FUNCTION:    stateControl::vChangeState(stateController::enEvent Event, tU8 CurSrc, tU8 PosNextSrc)
*
*
* DESCRIPTION: Changes State of Resource Manager based on Events received.
*
* PARAMETER:   stateController::enEvent Event, tU8 Source1, tU8 Source2
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid stateController::vChangeState(stateController::enEvent inEvent, tU8 Source1, tU8 Source2, tU16 SubSource)
{
  // do something with Sink
  ETG_TRACE_USR4(("Entered Change State set Sink to 1"));
  vChangeState(inEvent, Source1, Source2, SubSource, 1);
}
/*******************************************************************************/
tVoid stateController::vChangeState(stateController::enEvent inEvent, tU8 Source1, tU8 Source2, tU16 SubSource, tU16 Sink)
{
  ETG_TRACE_USR4(("Entered Change State Event:%d Source: %d SubSource: %d PosNextSrc: %d  Current state: %d, Sink %d  SinkState = %d",
      ETG_CENUM(stateController::enEvent,inEvent),
      ETG_ENUM(AudioSourceNo,Source1), SubSource, ETG_ENUM(AudioSourceNo,Source2), ETG_CENUM(stateController::enState,m_u16State),Sink,u16GetSinkState(Sink)));


  vector<stateControl*>::iterator stateIterator;

  for(stateIterator = stateControlVector.begin();
    stateIterator != stateControlVector.end();
    ++stateIterator)
  {
    if((*stateIterator) ==  OSAL_NULL) continue;
    ETG_TRACE_USR4(("Checking Guard: %d, %d, %d",m_u16State,(*stateIterator)->event,(*stateIterator)->state));
    /* Checking for the received State and Event with StateMachine Configuration */
    if(((*stateIterator)->state == m_u16State) && ((tU16)inEvent == (*stateIterator)->event))
    {
      if((*stateIterator)->guard != OSAL_NULL)
      {
        ETG_TRACE_USR4(("Checking Guard"));

        tU16 guard = (tU16)((*stateIterator)->*((*stateIterator)->guard))(Source1, Source2);

        if( guard == (*stateIterator)->guardResult)
        {
          ETG_TRACE_USR4(("Guard %d Matched",ETG_CENUM(stateController::enGuardResult,(*stateIterator)->guardResult)));

          m_u16State = (*stateIterator)->nextState;
          u16SetSinkState(Sink,m_u16State);
          m_mapLastStateOfSink[Sink] = (enState)(stateController::enState)((*stateIterator)->nextState);
          ETG_TRACE_USR4(("After setting m_mapLastStateOfSink[%d]=%d, size is %d",
                  Sink,(*stateIterator)->nextState,m_mapLastStateOfSink.size()));

          ETG_TRACE_USR4(("Next state %d ", ETG_CENUM(stateController::enState,m_u16State)));
                    /* Based on the GUARD Result corresponding action in the configuration is performed */
          if((*stateIterator)->action != OSAL_NULL)
          {
            ETG_TRACE_USR4(("Performing action Source1 =%d, Source2 =%d, SubSource =%d, Sink =%d",Source1, Source2, SubSource, Sink));
            //((*stateIterator)->*((*stateIterator)->action))(Source1, Source2);
            ((*stateIterator)->*((*stateIterator)->action))(Source1, Source2, SubSource, Sink);
          }
          else
          {
            ETG_TRACE_USR4(("No Action to be performed"));
          }
          break;
        }
      }

      // No guard condition to be checked... always perform certain action
      else
      {
        ETG_TRACE_USR4(("No guard to be checked"));

        m_u16State = (*stateIterator)->nextState;
        u16SetSinkState(Sink,m_u16State);
        m_mapLastStateOfSink[Sink] = (enState)(stateController::enState)((*stateIterator)->nextState);

        ETG_TRACE_USR4(("Next state:%d ",ETG_CENUM(stateController::enState,m_u16State)));

        if((*stateIterator)->action != OSAL_NULL)
        {
          ETG_TRACE_USR4(("Performing action"));

          //((*stateIterator)->*((*stateIterator)->action))(Source1, Source2);
          ((*stateIterator)->*((*stateIterator)->action))(Source1, Source2, SubSource, Sink);
        }
        else
        {
          ETG_TRACE_USR4(("No Action to be performed"));
        }
        break;
      }
    }
  }
}

/*******************************************************************************
*
* FUNCTION:    stateController* fc_audioroutemgr_tclresourcemanager::
*                                                poselStateController(tU8 Src)
*
* DESCRIPTION:  Returns the corrsponding StateController's pointer
*               based on the Src.
*
* PARAMETER:    tU8 Src
*
* RETURNVALUE:  Pointer.
*
*******************************************************************************/
stateController* fc_audioroutemgr_tclresourcemanager::poselStateController(tU8 Src)
{
  source* poSourcePtr = OSAL_NULL;

  if(OSAL_NULL != m_poSourceFactory)
   poSourcePtr = m_poSourceFactory->poSourcePtr(Src);

    if (OSAL_NULL != poSourcePtr)
  {
  switch(poSourcePtr->u8GetSourceSupportedStream())
  {
    case source::STREAM_MIX1 :
    {
    return postateControllerMix;
    break;
    }
    case source::STREAM_MIX2 :
    {
    return postateControllerMix2;
      break;
    }
		// for permanent microphone
		case source::STREAM_MIX3 :
		{
			return postateControllerMix3;
			break;
		}
    default :
    {
    return postateControllerEnt;
    break;
    }
  }
  }
  return OSAL_NULL;
}

/*******************************************************************************
*
* FUNCTION:    stateControl::stateControl(tU16 tUState, tU16 tUevent, tU16 tUnextState, tU16 (behavior::*someguard) (tU8,tU8) ,
*              tU16 tUguardResult, tVoid (behavior::*someaction) (tU8,tU8) , tU16 tUstateStability, stateController* pstateController)
*
*
* DESCRIPTION: Constructor.
*
* PARAMETERS:   tU16 tUState, tU16 tUevent, tU16 tUnextState, tU16 (behavior::*someguard) (tU8,tU8) ,
*               tU16 tUguardResult, tVoid (behavior::*someaction) (tU8,tU8) , tU16 tUstateStability, stateController* pstateController.
*
* RETURNVALUE: None.
*
*******************************************************************************/
stateControl::stateControl(tU16 tUState, tU16 tUevent, tU16 tUnextState, tU16 (stateControl::*someguard) (tU8,tU8),
         tU16 tUguardResult, tVoid (stateControl::*someaction) (tU8,tU8,tU16,tU16) const, tU16 tUstateStability,
     fc_audioroutemgr_tclApp* pCcaMainapp, fc_audioroutemgr_tclresourcemanager* poResourceMgr,fc_audioroutemgr_tclsourcefactory* posourcefactory)
{
  ETG_TRACE_USR4(("Entered stateControl() Constructor"));

  state = tUState;
  event = tUevent;
  nextState = tUnextState;
  guardResult = tUguardResult;
  stateStability = tUstateStability;
  action = someaction;
  guard = someguard;
  m_poCcaMainApp = pCcaMainapp;
  m_poResourceMgr = poResourceMgr;
  m_posourcefactory = posourcefactory;
}

/*******************************************************************************
*
* FUNCTION:   stateControl::vSendPerformMute(tU8 CurSrc,tU8 PosNextSrc)
*
*
* DESCRIPTION: Call to Audio Func Client Handler to perform Mute
*
* PARAMETER:   tU8 CurSrc, tU8 PosNextSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid stateControl::vSendPerformMute(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource) const
{
  ETG_TRACE_USR4(("Entered vSendPerformMute() use Sink 1"));
  vSendPerformMute(CurSrc, PosNextSrc, SubSource, 1);
}
/*******************************************************************************/
tVoid stateControl::vSendPerformMute(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink) const
{
    (tVoid)SubSource;
  ETG_TRACE_USR4(("Entered vSendPerformMute() for Sink %d",Sink));
    if(OSAL_NULL != m_poCcaMainApp && m_poResourceMgr != OSAL_NULL)
    {
      m_poResourceMgr->vNotifySourceState(CurSrc, (tU8)source::SRC_STATE_OFF_IP);
      m_poCcaMainApp->poGetAudioFuncClientHandler()->vPerformMute_Ramp(CurSrc, PosNextSrc, Sink);
      m_poCcaMainApp->poGetAudioFuncClientHandler()->vPerformMute(CurSrc, PosNextSrc, SubSource, Sink);
      ETG_TRACE_USR4(("Entered vSendPerformMute remove Sink from m_Sink"));
      (void)m_poResourceMgr->bRemoveSinkFromSource(CurSrc, Sink);
    }
}

/*******************************************************************************
 *
 * FUNCTION:   stateControl::vSendPerformSrcActOff(tU8 CurSrc,tU8 PosNextSrc)
 *
 *
 * DESCRIPTION: Call to SrcRoute Client Handler to perform Source Activity Off
 *
 * PARAMETER:  tU8 CurSrc, tU8 PosNextSrc
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/

tVoid stateControl::vSendPerformSrcActOff(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource) const
{
  ETG_TRACE_USR4(("Entered vSendPerformSrcActOff() called without sink use Sink 1"));
  vSendPerformSrcActOff(CurSrc, PosNextSrc, SubSource, 1);
}
/*******************************************************************************/
tVoid stateControl::vSendPerformSrcActOff(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink) const
{
   ETG_TRACE_USR4(("Entered vSendPerformSrcActOff() CurSrc %d, SubSrc %d, PosNextSrc %d, Sink %d",CurSrc,SubSource,PosNextSrc,Sink));

   source* poSourcePtr = OSAL_NULL;

   if(OSAL_NULL != m_posourcefactory)
      poSourcePtr = m_posourcefactory->poSourcePtr(CurSrc);

   if(OSAL_NULL != m_poResourceMgr)
      m_poResourceMgr->vNotifySourceState(CurSrc, (tU8)source::SRC_STATE_OFF_IP);

   if(OSAL_NULL != poSourcePtr)
      poSourcePtr->vSrcActOff(CurSrc,PosNextSrc,SubSource);
 }

/*******************************************************************************
 *
 * FUNCTION:   stateControl::vSendPerformSrcActPause(tU8 CurSrc,tU8 PosNextSrc)
 *
 *
 * DESCRIPTION: Call to SrcRoute Client Handler to perform Source Activity Off
 *
 * PARAMETER:  tU8 CurSrc, tU8 PosNextSrc
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/

tVoid stateControl::vSendPerformSrcActPause(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource) const
{
  ETG_TRACE_USR4(("Entered vSendPerformSrcActPause() use Sink 1"));
  vSendPerformSrcActPause(CurSrc,PosNextSrc,SubSource,1);
}
/*******************************************************************************/
tVoid stateControl::vSendPerformSrcActPause(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink) const
{
   ETG_TRACE_USR4(("Entered vSendPerformSrcActPause() Src=%d, POsNext %d, SubSrc =%d, Sink =%d",CurSrc,PosNextSrc,SubSource,Sink));

   source* poSourcePtr = OSAL_NULL;

   if(OSAL_NULL != m_posourcefactory)
      poSourcePtr = m_posourcefactory->poSourcePtr(CurSrc);

   if(OSAL_NULL != m_poResourceMgr)
    m_poResourceMgr->vNotifySourceState(CurSrc, (tU8)source::SRC_STATE_PAUSE_IP);

   if(OSAL_NULL != poSourcePtr)
    poSourcePtr->vSrcActPause(CurSrc,PosNextSrc,SubSource);
 }
/*******************************************************************************
*
* FUNCTION:    stateControl::vSendPerformDemute(tU8 CurSrc, tU8 PosNextSrc)
*
*
* DESCRIPTION: Audio Func Client Handler to perform Demute
*
* PARAMETER:   tU8 CurSrc, tU8 PosNextSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid stateControl::vSendPerformDemute(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource) const
{
  vSendPerformDemute(CurSrc, PosNextSrc, SubSource, 1);
}
/*******************************************************************************/
tVoid stateControl::vSendPerformDemute(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink) const
{
    (tVoid)SubSource;
    ETG_TRACE_USR4(("Entered vSendPerformDemute()"));
  source* poSourcePtr = OSAL_NULL;
  source::enVolumeLockType locktype = source::VOLUMELOCK_OFF;

  if(OSAL_NULL != m_posourcefactory)
      poSourcePtr = m_posourcefactory->poSourcePtr(CurSrc);

  if(OSAL_NULL != poSourcePtr)
      locktype = poSourcePtr->enGetVolLockType();

    if(OSAL_NULL != m_poCcaMainApp && m_poCcaMainApp->poGetAudioFuncClientHandler() != OSAL_NULL)
    {
      m_poCcaMainApp->poGetAudioFuncClientHandler()->vSetVolumeLock(locktype);
      m_poCcaMainApp->poGetAudioFuncClientHandler()->vPerformDeMute(CurSrc, PosNextSrc,Sink);
    }
}

/****************************************** *************************************
*
* FUNCTION:    stateControl::vSendPerformDeallocate(tU8 CurSrc, tU8 PosNextSrc)
*
*
* DESCRIPTION: Call to Source Factory to perform DeAllocation of Stream.
*
* PARAMETER:   tU8 CurSrc, tU8 PosNextSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid stateControl::vSendPerformDeallocate(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource) const
{
  ETG_TRACE_USR4(("Entered vSendPerformDeallocate called withouth sink using Sink 1"));
  vSendPerformDeallocate(CurSrc,PosNextSrc,SubSource,1);
}
/*******************************************************************************/
tVoid stateControl::vSendPerformDeallocate(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink) const
{
  ETG_TRACE_USR4(("Entered vSendPerformDeallocate CurSrc %d, SubSource %d, PosNextSrc %d, Sink %d",CurSrc,SubSource,PosNextSrc,Sink));
  source* poSourcePtr = OSAL_NULL;

  if(OSAL_NULL != m_posourcefactory)
     poSourcePtr = m_posourcefactory->poSourcePtr(CurSrc);

  if(OSAL_NULL != poSourcePtr)
     poSourcePtr->vSendDeAllocate(CurSrc,PosNextSrc,SubSource);
}

/*******************************************************************************
*
* FUNCTION:    stateControl::vSendPerformSrcActOn(tU8 CurSrc,tU8 PosNextSrc)
*
*
* DESCRIPTION: Call to SrcRoute Client Handler to perform Source Activity On
*
* PARAMETER:   tU8 CurSrc, tU8 PosNextSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid stateControl::vSendPerformSrcActOn(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource) const
{
  ETG_TRACE_USR4(("Entered vSendPerformSrcActOn set Sink to 1"));
  vSendPerformSrcActOn(CurSrc,PosNextSrc,SubSource,1);
}
/*******************************************************************************/
tVoid stateControl::vSendPerformSrcActOn(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink) const
{
   ETG_TRACE_USR4(("Entered vSendPerformSrcActOn CurSrc %d, PosNextSrc %d, SubSrc %d, Sink %d",CurSrc, PosNextSrc, SubSource, Sink));
   source* poSourcePtr = OSAL_NULL;

   if(OSAL_NULL != m_posourcefactory)
      poSourcePtr = m_posourcefactory->poSourcePtr(CurSrc);

   ETG_TRACE_USR4(("bIsSourceAllocated Src is in state Added = %d ",poSourcePtr->enGetState()));

   if(OSAL_NULL != poSourcePtr)
   {
       ETG_TRACE_USR4(("bIsSourceAllocated Src is in state Added = %d ",poSourcePtr->enGetState()));
       if(poSourcePtr->enGetState() == source::SRC_STATE_ON)
       {
           ETG_TRACE_USR4(("bIsSourceAllocated Src is in state ON, no Action"));
       }
       else
       {
           if(OSAL_NULL != m_poResourceMgr)
           m_poResourceMgr->vNotifySourceState(CurSrc, (tU8)source::SRC_STATE_ON_IP);
           ETG_TRACE_USR4(("bIsSourceAllocated Src is in state %d",poSourcePtr->enGetState()));
           poSourcePtr->vSrcActOn(CurSrc,PosNextSrc,SubSource);
       }
   }
}
/*******************************************************************************/
tVoid stateControl::vSendPerformAmpDevAudioRoute(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink) const
{
    ETG_TRACE_USR4(("Entered vSendPerformAmpDevAudioRoute CurSrc %d, PosNextSrc %d, SubSrc %d, Sink %d",CurSrc, PosNextSrc, SubSource, Sink));

    if(OSAL_NULL != m_poResourceMgr)
      m_poResourceMgr->vSendAmpDeviceAudioRoute(CurSrc,PosNextSrc,SubSource,Sink);
}
/*******************************************************************************
*
* FUNCTION:    stateControl::vPerformDemuteAndNotifyHMI(tU8 CurSrc, tU8 PosNextSrc)
*
*
* DESCRIPTION: Call to Audio Func Client Handler to perform DeMute and
*                to RouteMgr service Handler to send back the Status of Source Route Activity On back to HMI
*
* PARAMETER:   tU8 CurSrc, tU8 PosNextSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid stateControl::vPerformDemuteAndNotifyHMI(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource) const
{
  vPerformDemuteAndNotifyHMI(CurSrc,PosNextSrc,SubSource,1);
}
/*******************************************************************************/
tVoid stateControl::vPerformDemuteAndNotifyHMI(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink) const
{
  ETG_TRACE_USR4(("Entered vPerformDemuteAndNotifyHMI"));
  if(OSAL_NULL != m_poCcaMainApp)
  {
    // add the sink to this Src
    (void)m_poResourceMgr->bAddSinkToSource(CurSrc, Sink);
    // done
    m_poCcaMainApp->poGetAudioFuncClientHandler()->vPerformDeMute(CurSrc,PosNextSrc,Sink);
    /* send back CCA message to HMI.. service handler */
    vNotifyHMIOn(CurSrc,PosNextSrc,SubSource,Sink);
  }
}

/*******************************************************************************
*
* FUNCTION:    stateControl::vNotifyHMIOn(tU8 CurSrc,tU8 PosNextSrc)
*
*
* DESCRIPTION: Call to RouteMgr Service Handler to send back the Status of Source Route Activity On to HMI
*
* PARAMETER:   tU8 CurSrc, tU8 PosNextSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid stateControl::vNotifyHMIOn(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource) const
{
  ETG_TRACE_USR4(("Entered vNotifyHMIOn set Sink to 1"));
  vNotifyHMIOn(CurSrc,PosNextSrc,SubSource,1);
}
/*******************************************************************************/
tVoid stateControl::vNotifyHMIOn(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink) const
{
  ETG_TRACE_USR4(("Entered vNotifyHMIOn Src=%d, PosNextSrc=%d, SubSrc=%d, Sink=%d",CurSrc,PosNextSrc,SubSource,Sink));

  if((OSAL_NULL != m_poCcaMainApp) && (OSAL_NULL != m_poResourceMgr) && m_poResourceMgr->poselStateController(CurSrc) != OSAL_NULL)
   {
    // add the sink to this Source
    (void)m_poResourceMgr->bAddSinkToSource(CurSrc, Sink);
    m_poCcaMainApp->poGetAudioRouteMgrServiceHandler()->vSendSourceRouteActivityStatusOn(CurSrc,PosNextSrc, SubSource, static_cast<tU8>(Sink));
    m_poResourceMgr->vNotifySourceState(CurSrc, (tU8)source::SRC_STATE_ON);
    vProcessSrcActivityCallsInQueue(CurSrc, Sink, (tU8)source::SRC_STATE_ON);
     }
}

/*******************************************************************************
*
* FUNCTION:    stateControl::vNotifyHMIOff(tU8 CurSrc,tU8 PosNextSrc)
*
*
* DESCRIPTION: Call to RouteMgr Service Handler to send back the Status of Source Route Activity Off to HMI
*
* PARAMETER:   tU8 CurSrc, tU8 PosNextSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid stateControl::vNotifyHMIOff(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource) const
{
  ETG_TRACE_USR4(("Entered vNotifyHMIOff set Sink to 1"));
  vNotifyHMIOff(CurSrc,PosNextSrc,SubSource,1);
}
/*******************************************************************************/
tVoid stateControl::vNotifyHMIOff(tU8 CurSrc, tU8 PosNextSrc, tU16 SubSource, tU16 Sink) const
{
  ETG_TRACE_USR4(("Entered vNotifyHMIOff Src=%d, PosNextSrc=%d, SubSrc=%d, Sink=%d",CurSrc,PosNextSrc,SubSource,Sink));

  if((OSAL_NULL != m_poCcaMainApp) && (OSAL_NULL != m_poResourceMgr) && m_poResourceMgr->poselStateController(CurSrc) != OSAL_NULL)
  {
    // remove the sink from this Source
    (void)m_poResourceMgr->bRemoveSinkFromSource(CurSrc, Sink);
    m_poCcaMainApp->poGetAudioRouteMgrServiceHandler()->vSendSourceRouteActivityStatusOff(CurSrc,PosNextSrc, SubSource, static_cast<tU8>(Sink));
    m_poResourceMgr->vNotifySourceState(CurSrc, (tU8)source::SRC_STATE_OFF);
    vProcessSrcActivityCallsInQueue(CurSrc, Sink, (tU8)source::SRC_STATE_OFF);
   }
}

/*******************************************************************************
*
* FUNCTION:    stateControl::vNotifyHMIPause(tU8 CurSrc,tU8 PosNextSrc)
*
*
* DESCRIPTION: Call to RouteMgr Service Handler to send back the Status of Source Route Activity Off to HMI
*
* PARAMETER:   tU8 CurSrc, tU8 PosNextSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid stateControl::vNotifyHMIPause(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource) const
{
  ETG_TRACE_USR4(("Entered vNotifyHMIPause set Sink to 1"));
  vNotifyHMIPause(CurSrc,PosNextSrc,SubSource,1);
}
/*******************************************************************************/
tVoid stateControl::vNotifyHMIPause(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink) const
{
  ETG_TRACE_USR4(("Entered vNotifyHMIPause Src=%d, PosNextSrc=%d, SubSrc=%d, Sink=%d",CurSrc,PosNextSrc,SubSource,Sink));

  if((OSAL_NULL != m_poCcaMainApp) && (OSAL_NULL != m_poResourceMgr) && m_poResourceMgr->poselStateController(CurSrc) != OSAL_NULL)
  {
    // remove the sink from this Source
    (void)m_poResourceMgr->bRemoveSinkFromSource(CurSrc, Sink);
    m_poCcaMainApp->poGetAudioRouteMgrServiceHandler()->vSendSourceRouteActivityStatusPause(CurSrc,PosNextSrc,SubSource,static_cast<tU8>(Sink));
    m_poResourceMgr->vNotifySourceState(CurSrc,(tU8) source::SRC_STATE_PAUSE);
    vProcessSrcActivityCallsInQueue(CurSrc, Sink, (tU8) source::SRC_STATE_PAUSE);
  }
}

/*******************************************************************************
*
* FUNCTION:    stateControl::vProcessSrcActivityCallsInQueue(tU8 Src) const
*
*
* DESCRIPTION: Processes the SourceRouteActivity OFF call Received
*
* PARAMETER:   tU8 CurSrc, tU8 PosNextSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid stateControl::vProcessSrcActivityCallsInQueue(tU8 Src, tU16 SinkID, tU8 Activity) const
{
  tU8 u8Source = 0;
  if(OSAL_NULL != m_poResourceMgr)
   {
  stateController *postateController = m_poResourceMgr->poselStateController(Src);
  if(postateController != OSAL_NULL && m_posourcefactory != OSAL_NULL)
   {
    /* Removing Processed Source Request from Queue*/

    ETG_TRACE_USR4(("Removing Processed Source : %d Request from Queue, Activity: %d", Src, Activity));

    /* Removing FI_EN_PHONE from queue during Phone call actifity processing when VR also under process to PAUSE,
     * Else it leads to remove VR from Queue some times in Private_mode_2 
     * For Bug_1426433*/
     if(!(postateController->QueueSrcActivityCall.empty()) && ((Src == (tU8)midw_fi_tcl_e8_AudSource::FI_EN_PHONE)
		    ||(Src == (tU8)midw_fi_tcl_e8_AudSource::FI_EN_INTERCOM)||(Src == (tU8)midw_fi_tcl_e8_AudSource::FI_EN_VRU)
        ||(Src == (tU8)midw_fi_tcl_e8_AudSource::FI_EN_NAVI_BY_SDS)))
     {
      deque<SrcActivityCall>::iterator it = postateController->QueueSrcActivityCall.begin();

      for(;it != postateController->QueueSrcActivityCall.end();)
      {
       if((it->Source == Src) && (it->Activity == Activity))
       {
         ETG_TRACE_USR4(("vProcessSrcActivityCallsInQueue: Src : %d/%d for sink %d request removed", it->Source, it->SubSource, it->Resource));
         it = postateController->QueueSrcActivityCall.erase(it);
         break;
       }
       else
       {
         ++it;
       }
       u8Source = it->Source;
      }
     }
     else if(!postateController->QueueSrcActivityCall.empty())
     {
        ETG_TRACE_USR4((" Removing source %d from queue", Src));
        postateController->QueueSrcActivityCall.pop_front();
     }

     /* Process the next request in Queue if any */

    if(!postateController->QueueSrcActivityCall.empty() && postateController->u8GetFrontCurSourceInQueue() != (tU8)midw_fi_tcl_e8_AudSource::FI_EN_NONE)
    {
      ETG_TRACE_USR4(("Processed Next Request"));
      postateController->u8curSrc = postateController->u8GetFrontCurSourceInQueue();
      postateController->u8activity = (tU8)postateController->u16GetFrontActivityInQueue();
      source* poSourcePtr = OSAL_NULL;

      if(OSAL_NULL != m_posourcefactory)
      {
         poSourcePtr = m_posourcefactory->poSourcePtr(postateController->u8curSrc);
         ETG_TRACE_USR4(("ADDED Yes,Next u8curSrc in Queue =%d has in sinks %d state = %d u8activity %d", postateController->u8curSrc, poSourcePtr->pGetNumberOfSinks(),poSourcePtr->enGetState(),postateController->u8activity));
         if((postateController->u8curSrc == u8Source)&& (postateController->u8activity == 0))
         {
          // BUGS:RTC1-2038555,RTC1-2113528,RTC1-2184831 Intercom and Telephony during mode change
           ETG_TRACE_USR4(("postateController->u8curSrc is equal to SOURCE AND ACTIVITY == 0"));
           return;
         }
      }

      postateController->u8posNextSrc = postateController->u8GetFrontPossibleNextSourceInQueue();
      postateController->u8activity = (tU8)postateController->u16GetFrontActivityInQueue();
      postateController->u16SubSource = postateController->u16GetFrontSubSourceInQueue();
      postateController->u16Sink = postateController->u16GetFrontSinkInQueue();

      auto itr = postateController->Activitymap.find((stateController::enSrcAct)postateController->u8activity);
      if(itr != postateController->Activitymap.end())
      {//Below States Corrected based on Requirement when Both Cabin and Cockpit has Same media Sources which gets triggered via VR
          if((poSourcePtr->pGetNumberOfSinks() == 0) && ((poSourcePtr->enGetState() == source::SRC_STATE_OFF_IP) || poSourcePtr->enGetState() == source::SRC_STATE_OFF) && (postateController->u8activity != 1))
          {
            tU16 sinkState = postateController->u16GetSinkState(postateController->u16Sink);
            if(((postateController->u16Sink == SINK1) || (postateController->u16Sink == SINK2)) &&
                ((sinkState == stateController::SRC_ACT_OFF_IP) ||
                (sinkState == stateController::MUTE_IP) ||
                (postateController->u8curSrc == (tU8)midw_fi_tcl_e8_AudSource::FI_EN_VRU) ||
                (postateController->u8curSrc == (tU8)midw_fi_tcl_e8_AudSource::FI_EN_NAVI) ||
                (postateController->u8curSrc == (tU8)midw_fi_tcl_e8_AudSource::FI_EN_INTERCOM)))
            {
                ETG_TRACE_USR4(("Exc Channel--Mute: Skipping mute for VRU/NAVI/INTERCOM source %d", postateController->u8curSrc));
                return;
            }
            if((postateController->u16Sink == SINK1) && (sinkState == stateController::SRC_ACT_OFF_IP || sinkState == stateController::MUTE_IP))
            {
                ETG_TRACE_USR4(("vProcessSrcActivityCallsInQueue: SRC_ACT_OFF_IP or MUTE_IP in progress for sink %d, returning", postateController->u16Sink));
                return;
            }

            ETG_TRACE_USR4(("For sinks 0 in Queue =%d has in sinks %d u8activity %d", postateController->u8curSrc, poSourcePtr->pGetNumberOfSinks(),postateController->u8activity));
            postateController->vResetState(stateController::DEALLOCATE_IP);
            postateController->vChangeState( stateController::EVENT_RESULT_DEALLOCATE, postateController->u8curSrc, postateController->u8posNextSrc, postateController->u16SubSource, postateController->u16Sink);
          }
         /* else if((poSourcePtr->pGetNumberOfSinks() == 0) && (poSourcePtr->enGetState() == source::SRC_STATE_ON_IP) && (postateController->u8activity == 1))
          {
            ETG_TRACE_USR4(("ADDED_SPL for MIC1 AUX(17) For sinks 0 in Queue =%d has in sinks %d u8activity %d", postateController->u8curSrc, poSourcePtr->pGetNumberOfSinks(),postateController->u8activity));
            postateController->vResetState(stateController::DEMUTED);
            postateController->vChangeState( stateController::EVENT_SET_SRCROUTEACTIVITTY_ON, postateController->u8curSrc, postateController->u8posNextSrc, postateController->u16SubSource, postateController->u16Sink);
          }*/
          else if((poSourcePtr->pGetNumberOfSinks() == 1) && (poSourcePtr->enGetState() == source::SRC_STATE_PAUSE && postateController->u8activity != 1))
          {
              ETG_TRACE_USR4(("Next Current Source in Queue =%d has in sinks %d u8activity %d", postateController->u8curSrc, poSourcePtr->pGetNumberOfSinks(),postateController->u8activity));
              postateController->vChangeState( stateController::EVENT_SET_SRCROUTEACTIVITTY_PAUSE_NO_DEALLOC, postateController->u8curSrc, postateController->u8posNextSrc, postateController->u16SubSource, postateController->u16Sink);
          }
          else if((poSourcePtr->enGetState() == source::SRC_STATE_OFF_IP) && ((tU16)postateController->m_mapLastStateOfSink[postateController->u16Sink] == stateController::MUTE_IP))
          {
              postateController->vResetState(stateController::MUTE_IP);
              ETG_TRACE_USR4(("Source =%d has in sinks %d", postateController->u8curSrc, poSourcePtr->pGetNumberOfSinks()));
              postateController->vChangeState( stateController::EVENT_RESULT_MUTE_ON, postateController->u8curSrc, postateController->u8posNextSrc, postateController->u16SubSource, postateController->u16Sink);
          }
          else if(poSourcePtr->enGetState() == source::SRC_STATE_PAUSE)
          {
              ETG_TRACE_USR4(("Source =%d has in sinks %d", postateController->u8curSrc, poSourcePtr->pGetNumberOfSinks()));
	      if(poSourcePtr->pGetNumberOfSinks() == 0)
              postateController->vChangeState( stateController::EVENT_SET_SRCROUTEACTIVITTY_OFF, postateController->u8curSrc, postateController->u8posNextSrc, postateController->u16SubSource, postateController->u16Sink);
	     else
            postateController->vChangeState( stateController::EVENT_SET_SRCROUTEACTIVITTY_ON, postateController->u8curSrc, postateController->u8posNextSrc, postateController->u16SubSource, postateController->u16Sink);
          }
          else if(poSourcePtr->enGetState() == source::SRC_STATE_OFF && postateController->u8activity == 1)
          {
             ETG_TRACE_USR4(("Source =%d has in sinks %d", postateController->u8curSrc, poSourcePtr->pGetNumberOfSinks()));
             postateController->vResetState(stateController::DEMUTED);
             postateController->vChangeState( stateController::EVENT_SET_SRCROUTEACTIVITTY_ON, postateController->u8curSrc, postateController->u8posNextSrc, postateController->u16SubSource, postateController->u16Sink);
          }
          else if((poSourcePtr->enGetState() == source::SRC_STATE_ALLOCATE_IP) && ((tU16)postateController->m_mapLastStateOfSink[postateController->u16Sink] == stateController::DEALLOCATED))
          {
              ETG_TRACE_USR4(("Source =%d has in sinks %d", postateController->u8curSrc, poSourcePtr->pGetNumberOfSinks()));
              postateController->vChangeState( stateController::EVENT_SET_SRCROUTEACTIVITTY_ON, postateController->u8curSrc, postateController->u8posNextSrc, postateController->u16SubSource, postateController->u16Sink);
          }
	  else if(((poSourcePtr->enGetState() == source::SRC_STATE_ON) || (poSourcePtr->enGetState() == source::SRC_STATE_ON_IP)) && (postateController->u8activity == 1))
	  {//RTC1-2444855 To avoid multiple request to Application,RTC1-2566176
             ETG_TRACE_USR4(("Return To Avoid multiple request to Application"));
             postateController->vResetState(stateController::SRC_ACT_ON_IP);
             postateController->vChangeState( stateController::EVENT_RESULT_SRCACTIVITY_ON, postateController->u8curSrc, postateController->u8posNextSrc, postateController->u16SubSource, postateController->u16Sink);
             return;
	  }
          else
            postateController->vChangeState( itr->second, postateController->u8curSrc, postateController->u8posNextSrc, postateController->u16SubSource, postateController->u16Sink);
      }
     }
    }
  }
}

/*******************************************************************************
*
* FUNCTION:   stateControl::vPerformAllocateAndSetSource(tU8 CurSrc,tU8 PosNextSrc)
*
*
* DESCRIPTION: Call to Source Factory to Allocate Stream and
*                to Audio Func Client Handler to Set Audio Source.
*
* PARAMETER:   tU8 CurSrc, tU8 PosNextSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid stateControl::vPerformAllocateAndSetSource(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource) const
{
  ETG_TRACE_USR4(("Entered vPerformAllocateAndSetSource set Sink to 1"));
  vPerformAllocateAndSetSource(CurSrc, PosNextSrc, SubSource, 1);
}
/*******************************************************************************/
tVoid stateControl::vPerformAllocateAndSetSource(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink) const
{
  ETG_TRACE_USR4(("Entered vPerformAllocateAndSetSource Src=%d, PosNext=%d, SubSrc=%d, Sink=%d",CurSrc, PosNextSrc, SubSource, Sink));
   source* poSourcePtr = OSAL_NULL;

   if(OSAL_NULL != m_posourcefactory)
      poSourcePtr = m_posourcefactory->poSourcePtr(CurSrc);

   if(OSAL_NULL != m_poResourceMgr)
     m_poResourceMgr->vNotifySourceState(CurSrc, source::SRC_STATE_ALLOCATE_IP);

   if(OSAL_NULL != poSourcePtr)
    poSourcePtr->vSendAllocate(CurSrc,PosNextSrc,SubSource,Sink);

  if((OSAL_NULL != m_poCcaMainApp) && (OSAL_NULL !=  m_poCcaMainApp->poGetAudioFuncClientHandler()))
        m_poCcaMainApp->poGetAudioFuncClientHandler()->vStartAudioSource(CurSrc, PosNextSrc,Sink);
}

/*******************************************************************************
*
* FUNCTION:    stateControl::vPerformSrcActOnAndSetSource(tU8 CurSrc,tU8 PosNextSrc)
*
*
* DESCRIPTION: Call SrcRoute Client Handler to perform Source Activity On and
*                to Audio Func to  Set Audio Source.
*
* PARAMETER:   tU8 CurSrc, tU8 PosNextSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid stateControl::vPerformSrcActOnAndSetSource(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource) const
{
  vPerformSrcActOnAndSetSource( CurSrc, PosNextSrc, SubSource, 1);
}

/*******************************************************************************/
tVoid stateControl::vPerformSrcActOnAndSetSource(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 /*Sink*/) const
{
  ETG_TRACE_USR4(("Entered vPerformSrcActOnAndSetSource"));
  source* poSourcePtr = OSAL_NULL;

  if(OSAL_NULL != m_posourcefactory)
     poSourcePtr = m_posourcefactory->poSourcePtr(CurSrc);

   if(OSAL_NULL != m_poResourceMgr)
     m_poResourceMgr->vNotifySourceState(CurSrc, source::SRC_STATE_ON_IP);

  if(OSAL_NULL != poSourcePtr)
     poSourcePtr->vSrcActOn(CurSrc,PosNextSrc,SubSource);

  if((OSAL_NULL != m_poCcaMainApp) && (OSAL_NULL !=  m_poCcaMainApp->poGetAudioFuncClientHandler()))
     m_poCcaMainApp->poGetAudioFuncClientHandler()->vStartAudioSource(CurSrc, PosNextSrc);
}
/*******************************************************************************/
tVoid stateControl::vSetRouteDemuteAndNotifyHMI(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink) const
{
  // here we need the sink to set the route
  ETG_TRACE_USR4(("Entered vSetRouteDemuteAndNotifyHMI Src=%d, PosNextSrc=%d, SubSrc=%d, Sink=%d",CurSrc,PosNextSrc,SubSource,Sink));
  m_poCcaMainApp->poGetAudioFuncClientHandler()->vStartAudioSource(CurSrc,PosNextSrc,Sink);
  m_poCcaMainApp->poGetAudioFuncClientHandler()->vSendAmpDeviceAudioRoute(CurSrc, SubSource, Sink);

  if(false == m_poResourceMgr->bAddSinkToSource(CurSrc,Sink))
  {
    ETG_TRACE_USR4(("ERROR adding Sink %d to Source %d successful",CurSrc,Sink));
  }
  else
  {
    ETG_TRACE_USR4(("Entered vSetRouteDemuteAndNotifyHMI added Sink %d to Source %d successful",CurSrc,Sink));
  }

  vSendPerformDemute(CurSrc, PosNextSrc, SubSource, Sink);

  stateController *postateController = m_poResourceMgr->poselStateController(CurSrc);
  if(!postateController->QueueSrcActivityCall.empty())
  {
    ETG_TRACE_USR4(("Remove Entry from Queue, size before = %d",postateController->QueueSrcActivityCall.size()));
    postateController->QueueSrcActivityCall.pop_front();
    ETG_TRACE_USR4(("Remove Entry from Queue, size after = %d",postateController->QueueSrcActivityCall.size()));

  }
  else
  {
    ETG_TRACE_USR4(("Remove Entry from Queue not possible, queue is empty"));
  }

  m_poCcaMainApp->poGetAudioRouteMgrServiceHandler()->vSendSourceRouteActivityStatusOn(CurSrc, PosNextSrc, SubSource,
      static_cast<tU8>(Sink), (tU8)midw_fi_tcl_e8_SrcActivity::FI_EN_ON);

}
/*******************************************************************************
*
* FUNCTION:    stateControl::vSendPerformSrcActOffAndRemoveReqFromQueue(tU8 CurSrc,tU8 PosNextSrc)
*
*
* DESCRIPTION:  Call SrcRoute Client Handler to perform Source Activity OFF and
                remove the already existing On Request from Queue.
*
* PARAMETER:   tU8 CurSrc, tU8 PosNextSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid stateControl::vSendPerformSrcActOffAndRemoveReqFromQueue(tU8 CurSrc,tU8 PosNextSrc, tU16 SubSource) const
{
  ETG_TRACE_USR4(("Entered vSendPerformSrcActOffAndRemoveReqFromQueue set Sink to 1"));
  vSendPerformSrcActOffAndRemoveReqFromQueue(CurSrc, PosNextSrc, SubSource, 1);
}
/*******************************************************************************/
tVoid stateControl::vSendPerformSrcActOffAndRemoveReqFromQueue(tU8 CurSrc,tU8 PosNextSrc, tU16 SubSource, tU16 /*Sink*/) const
{
  ETG_TRACE_USR4(("Entered vSendPerformSrcActOffAndRemoveReqFromQueue"));
  source* poSourcePtr = OSAL_NULL;

  if(OSAL_NULL != m_posourcefactory)
     poSourcePtr = m_posourcefactory->poSourcePtr(CurSrc);

  if(OSAL_NULL != poSourcePtr)
    poSourcePtr->vSrcActOff(CurSrc,PosNextSrc,SubSource);

   if(OSAL_NULL != m_poResourceMgr)
   {
    if(!m_poResourceMgr->poselStateController(CurSrc)->QueueSrcActivityCall.empty())
        m_poResourceMgr->poselStateController(CurSrc)->QueueSrcActivityCall.pop_front();

       m_poResourceMgr->vNotifySourceState(CurSrc, (tU8)source::SRC_STATE_OFF_IP);
   }
}


/*******************************************************************************
*
* FUNCTION:    stateControl::vSendPerformSrcActPauseAndRemoveReqFromQueue(tU8 CurSrc,tU8 PosNextSrc)
*
*
* DESCRIPTION:  Call SrcRoute Client Handler to perform Source Activity Pause and
                remove the already existing On Request from Queue.
*
* PARAMETER:   tU8 CurSrc, tU8 PosNextSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid stateControl::vSendPerformSrcActPauseAndRemoveReqFromQueue(tU8 CurSrc,tU8 PosNextSrc, tU16 SubSource) const
{
  ETG_TRACE_USR4(("Entered vSendPerformSrcActPauseAndRemoveReqFromQueue set Sink to 1"));
  vSendPerformSrcActPauseAndRemoveReqFromQueue(CurSrc, PosNextSrc, SubSource, 1);
}
/*******************************************************************************/
tVoid stateControl::vSendPerformSrcActPauseAndRemoveReqFromQueue(tU8 CurSrc,tU8 PosNextSrc, tU16 SubSource, tU16 /*Sink*/) const
{

  ETG_TRACE_USR4(("Entered vSendPerformSrcActPauseAndRemoveReqFromQueue"));
  source* poSourcePtr = OSAL_NULL;

  if(OSAL_NULL != m_poResourceMgr)
  {
     stateController* pStateCtrl = m_poResourceMgr->poselStateController(CurSrc);
     if(OSAL_NULL !=pStateCtrl)
     {
       if(!pStateCtrl->QueueSrcActivityCall.empty())
        pStateCtrl->QueueSrcActivityCall.pop_front();

        m_poResourceMgr->vNotifySourceState(CurSrc, (tU8)source::SRC_STATE_PAUSE_IP);
     }
  }

  if(OSAL_NULL != m_posourcefactory)
     poSourcePtr = m_posourcefactory->poSourcePtr(CurSrc);

  if(OSAL_NULL != poSourcePtr)
     poSourcePtr->vSrcActPause(CurSrc,PosNextSrc,SubSource);
}

/*******************************************************************************
*
* FUNCTION:    stateControl::vGuardIsMuteRequired(tU8 CurSrc, tU8 PosNextSrc)
*
*
* DESCRIPTION: Guard Check for Mute
*
* PARAMETER:   tU8 CurSrc, tU8 PosNextSrc
*
* RETURNVALUE: tU16.
*
*******************************************************************************/
tU16 stateControl::vGuardIsMuteRequired(tU8 CurSrc, tU8 PosNextSrc)
{

  ETG_TRACE_USR4(("Entered GuardIsMuteRequired---cursrc:%d----nextsource:%d",ETG_ENUM(AudioSourceNo,CurSrc),
                                                                         ETG_ENUM(AudioSourceNo,PosNextSrc)));
  tU16 RetValue = (tU16)stateController::GUARD_MUTE_REQUIRED;
  vector<muteConfigCheck*>::iterator muteConfigCheckIterator;

  if(OSAL_NULL != m_poResourceMgr)
  {
    stateController* poStateControllr = m_poResourceMgr->poselStateController(CurSrc);

		//MIC_PERMANENT only. We do not need a mute
		if(poStateControllr == m_poResourceMgr->postateControllerMix3)
		{
			ETG_TRACE_USR4(("No Mute for MIC_PERMANENT (Mix3)"));
			return (tU16)stateController::GUARD_MUTE_NOT_REQUIRED;
		}
    if(poStateControllr != OSAL_NULL)
    {
        if(poStateControllr->muteConfigCheckVector.begin() != poStateControllr->muteConfigCheckVector.end())
      {
        for( muteConfigCheckIterator = poStateControllr->muteConfigCheckVector.begin();
           muteConfigCheckIterator != poStateControllr->muteConfigCheckVector.end();
           ++muteConfigCheckIterator)
         {
        /* Stream is not Muted for Source changes from FM->FM_TA , DAB->DAB_TA and vice-versa*/
        if((((*muteConfigCheckIterator)->src1 == CurSrc) &&
          ((*muteConfigCheckIterator)->src2 == PosNextSrc)) ||
          (((*muteConfigCheckIterator)->src1 == PosNextSrc) &&
           ((*muteConfigCheckIterator)->src2 == CurSrc)))
          {
          RetValue = (tU16)stateController::GUARD_MUTE_NOT_REQUIRED;
          break;
          }
         }
      }
       }

      RetValue = u16ReturnGuardBasedOnSrcCompMuteState(CurSrc, RetValue);
      RetValue = u16ReturnGuardBasedOnSrcState(CurSrc,PosNextSrc, RetValue);
    }
  return RetValue;
}

/*******************************************************************************
*
* FUNCTION:    stateControl::u16ReturnGuardBasedOnSrcCompMuteState(tU8 CurSrc) const
*
*
* DESCRIPTION: Returns Mute Guard Value based on Src Component Mute State
*
* PARAMETER:   tU8 CurSrc
*
* RETURNVALUE: tU16.
*
*******************************************************************************/
tU16 stateControl::u16ReturnGuardBasedOnSrcCompMuteState(tU8 CurSrc, tU16 MuteValue) const
{
   /* If there has been a Component Mute applied, Stream is not Muted Again*/
  tU16 RetValue = MuteValue;
  source* poSourcePtr = OSAL_NULL;

  if(OSAL_NULL != m_posourcefactory)
     poSourcePtr = m_posourcefactory->poSourcePtr(CurSrc);

  if(OSAL_NULL != poSourcePtr)
  {
      if(poSourcePtr->enGetCompMuteState() == source::SRC_MUTE)
      {
      ETG_TRACE_USR4(("Mute Required"));
      RetValue = (tU16)stateController::GUARD_MUTE_REQUIRED;
      }
   }
  return RetValue;
}

/*******************************************************************************
*
* FUNCTION:    stateControl::u16ReturnGuardBasedOnSrcTypeAndMuteState(tU8 CurSrc,
*                                                           tU8 PosNextSrc) const
*
*
* DESCRIPTION: Returns Mute Guard Value based on Src Type and SourceChange Mute
*              State of the source
*
* PARAMETER:   tU8 CurSrc
*
* RETURNVALUE: tU16.
*
*******************************************************************************/
tU16 stateControl::u16ReturnGuardBasedOnSrcState(tU8 CurSrc,tU8 PosNextSrc, tU16 MuteGuardValue) const
{
  (tVoid)PosNextSrc;
    tU16 RetValue = MuteGuardValue;
  source* poSourcePtr = OSAL_NULL;

  if(OSAL_NULL != m_posourcefactory)
     poSourcePtr = m_posourcefactory->poSourcePtr(CurSrc);

  if(OSAL_NULL != poSourcePtr)
  {
#if defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_INF4CV)
    if( (poSourcePtr->enGetState() != source::SRC_STATE_ON) && (poSourcePtr->pGetNumberOfSinks() == 0) )
    {
      ETG_TRACE_USR4(("Mute Not Required"));
      RetValue = (tU16)stateController::GUARD_MUTE_NOT_REQUIRED;
    }
#else
    if(poSourcePtr->enGetState() != source::SRC_STATE_ON)
    {
      ETG_TRACE_USR4(("u16ReturnGuardBasedOnSrcState() Mute Not Required"));
      RetValue = (tU16)stateController::GUARD_MUTE_NOT_REQUIRED;
    }
#endif
  }

	return RetValue;
}

/*******************************************************************************
*
* FUNCTION:    stateControl::vGuardIsDeMuteRequired(tU8 CurSrc, tU8 PosNextSrc)
*
* DESCRIPTION: Guard Check for DeMute
*
* PARAMETER:   tU8 CurSrc, tU8 PosNextSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/
tU16 stateControl::vGuardIsDeMuteRequired(tU8 CurSrc, tU8 PosNextSrc)
{
  ETG_TRACE_USR4(("Entered GuardIsDeMuteRequired---cursrc:%d----nextsource:%d",CurSrc,PosNextSrc));

  tU16 RetValue = (tU16)stateController::GUARD_DEMUTE_REQUIRED;
  source* poSourcePtr = OSAL_NULL;
  stateController *postateController = OSAL_NULL;

  if(OSAL_NULL != m_poResourceMgr)
    postateController = m_poResourceMgr->poselStateController(CurSrc);

  if(OSAL_NULL != m_posourcefactory)
     poSourcePtr = m_posourcefactory->poSourcePtr(CurSrc);

  if(OSAL_NULL != poSourcePtr)
  {
       if(poSourcePtr->enGetCompMuteState() == source::SRC_MUTE)
       {
        ETG_TRACE_USR4(("DeMute Not Required"));
        RetValue = (tU16)stateController::GUARD_DEMUTE_NOT_REQUIRED;


     if(OSAL_NULL != m_poCcaMainApp && OSAL_NULL != m_poCcaMainApp->poGetAudioFuncClientHandler() && OSAL_NULL != postateController )
                             {
                                m_poCcaMainApp->poGetAudioFuncClientHandler()->vPerformMute(CurSrc, PosNextSrc, postateController->u16GetFrontSubSourceInQueue(),
                                               postateController->u16GetFrontSinkInQueue());
                             }
     }
     if ((CurSrc == (tU8)midw_fi_tcl_e8_AudSource::FI_EN_SPI_TTS) ||
       (CurSrc == (tU8)midw_fi_tcl_e8_AudSource::FI_EN_NAVI)    ||
             (CurSrc == (tU8)midw_fi_tcl_e8_AudSource::FI_EN_SMS)    ||
       (CurSrc == (tU8)midw_fi_tcl_e8_AudSource::FI_EN_VRU))
     {
       ETG_TRACE_USR4(("Current source : %d",ETG_ENUM(AudioSourceNo,CurSrc)));
       RetValue = (tU16)stateController::GUARD_DEMUTE_NOT_REQUIRED;
     }
  }
  return RetValue;
}

/*******************************************************************************
*
* FUNCTION:    stateControl::vGuardIsSrcActOfforPause(tU8 CurSrc, tU8 PosNextSrc)
*
* DESCRIPTION: Guard to check if CurSrc equal to PosNextSource
*
* PARAMETER:   tU8 CurSrc, tU8 PosNextSrc
*
* RETURNVALUE: tU16.
*
*******************************************************************************/
tU16 stateControl::vGuardIsSrcActOfforPause(tU8 CurSrc, tU8 PosNextSrc)
{
  ETG_TRACE_USR4(("Entered vGuardIsSrcActOfforPause"));

  (tVoid) PosNextSrc;

  tU16 RetValue = (tU16)stateController::GUARD_SRCACT_OFF;
  stateController* postateController = m_poResourceMgr->poselStateController(CurSrc);

  if (postateController == nullptr)
  {
    ETG_TRACE_ERR(("postateController is NULL in vGuardIsSrcActOfforPause"));
    return RetValue;
  }

  deque<SrcActivityCall>::iterator iter = postateController->QueueSrcActivityCall.begin();
  for(;iter != postateController->QueueSrcActivityCall.end();++iter)
  {
    ETG_TRACE_USR4(("Src : %d SubSource : %d, Sink: %d, Activity : %d ", iter->Source, iter->SubSource, iter->Resource,iter->Activity));
    if(iter->Source == CurSrc)
    {
      ETG_TRACE_USR4(("Found matching source in Queue: Src=%d, SubSource=%d, Activity=%d, Resource=%d", iter->Source, iter->SubSource, iter->Activity, iter->Resource));
      if(iter->Activity == stateController::PAUSE)
      {
        RetValue = (tU16)stateController::GUARD_SRCACT_PAUSE;
      }
        break;
    }
  }
  return RetValue;
}

/*******************************************************************************
*
* FUNCTION:    stateControl::vGuardIsSpeechSrc(tU8 CurSrc, tU8 PosNextSrc)
*
* DESCRIPTION: Guard to check if CurSrc equal to SpeechSource
*
* PARAMETER:   tU8 CurSrc, tU8 PosNextSrc
*
* RETURNVALUE: tU16.
*
*******************************************************************************/
tU16 stateControl::vGuardIsSpeechSrc(tU8 CurSrc, tU8 PosNextSrc)
{
  ETG_TRACE_USR4(("Entered vGuardIsSpeechSrc Current= %d , PosNext = %d",CurSrc,PosNextSrc));

  (tVoid)PosNextSrc;
  tU16 RetValue = (tU16)stateController::GUARD_NOT_A_SPEECH_SRC;

    switch(CurSrc)
  {
    case (tU8)midw_fi_tcl_e8_AudSource::FI_EN_NAVI:
    case (tU8)midw_fi_tcl_e8_AudSource::FI_EN_SPI_TTS:
    case (tU8)midw_fi_tcl_e8_AudSource::FI_EN_SMS:
    case (tU8)midw_fi_tcl_e8_AudSource::FI_EN_VRU:
    {
    RetValue = (tU16)stateController::GUARD_SPEECH_SRC;
    break;
    }
   default:
    {
    if((CurSrc == PosNextSrc) && (CurSrc !=0))
    {
        if((m_poResourceMgr->bIsSourceAllocated(CurSrc)))
        {
            ETG_TRACE_USR4(("Entered vGuardIsSpeechSrc Equal sources but Allocated"));
            RetValue = (tU16)stateController::GUARD_NOT_A_SPEECH_SRC_BUT_ALLOCATED;
        }
    }
    else if((CurSrc == (tU8)midw_fi_tcl_e8_AudSource::FI_EN_INTERCOM) || (CurSrc == (tU8)midw_fi_tcl_e8_AudSource::FI_EN_PHONE))
    {
      // BUGS:RTC1-2038555,RTC1-2113528,RTC1-2184831 Intercom and Telephony during mode change
      ETG_TRACE_USR4(("Not Speect Source but allocated only for INTERCOM and PHONE Sources"));
      RetValue = (tU16)stateController::GUARD_NOT_A_SPEECH_SRC_BUT_ALLOCATED;
    }
    else
    RetValue = (tU16)stateController::GUARD_NOT_A_SPEECH_SRC;
    break;
     }
  }
  return RetValue;
}

/*******************************************************************************
*
* FUNCTION:    stateControl::vGuardIsAllocateInitiated(tU8 CurSrc, tU8 PosNextSrc) const
*
* DESCRIPTION: Guard to check if Allocate call was initiated.
*
* PARAMETER:   tU8 CurSrc, tU8 PosNextSrc
*
* RETURNVALUE: tU16.
*
*******************************************************************************/
tU16 stateControl::vGuardIsAllocateInitiated(tU8 CurSrc, tU8 PosNextSrc)
{
  ETG_TRACE_USR4(("Entered vGuardIsAllocateInitiated"));

  (tVoid)PosNextSrc;
  tU16 RetValue = (tU16)stateController::GUARD_ALLOCATE_NOT_INITIATED;
  source* poSourcePtr = OSAL_NULL;

  if(OSAL_NULL != m_posourcefactory)
     poSourcePtr = m_posourcefactory->poSourcePtr(CurSrc);

  if(OSAL_NULL != poSourcePtr)
  {
      if(poSourcePtr->enGetState() == source::SRC_STATE_ALLOCATE_IP)
     RetValue = (tU16)stateController::GUARD_ALLOCATE_INITIATED;
  }
  return RetValue;
}
/*******************************************************************************
*
* FUNCTION:    stateControl::u16GuardIsOffReqForSameSrc(tU8 CurSrc, tU8 PosNextSrc) const
*
* DESCRIPTION: Guard to check if OFF is requested for Currently Executing Source.
*
* PARAMETER:   tU8 CurSrc, tU8 PosNextSrc
*
* RETURNVALUE: tU16.
*
*******************************************************************************/
tU16 stateControl::u16GuardIsOffReqForSameSrc(tU8 CurSrc, tU8 PosNextSrc)
{
  ETG_TRACE_USR4(("Entered u16GuardIsOffRequestedForSameSource"));
  (tVoid)PosNextSrc;
  source* poSourcePtr = OSAL_NULL;
  tU16 RetValue = (tU16)stateController::GUARD_UNDEF;

  if(OSAL_NULL != m_posourcefactory)
     poSourcePtr = m_posourcefactory->poSourcePtr(CurSrc);

  if(OSAL_NULL != m_poResourceMgr && OSAL_NULL != poSourcePtr)
  {
    if(m_poResourceMgr->u8GetCurSrcinSM(poSourcePtr->u8GetSourceSupportedStream()) == CurSrc && CurSrc != (tU8)midw_fi_tcl_e8_AudSource::FI_EN_CPRA2)
    {
      RetValue = (tU16)stateController::GUARD_OFF_REQ_SAME_SOURCE;
    }
  }

  return RetValue;
}

/*******************************************************************************
*
* FUNCTION:    stateControl::u16GuardIsTunerSource(tU8 CurSrc, tU8 PosNextSrc) const
*
* DESCRIPTION: Guard to check if Source is Tuner.
*
* PARAMETER:   tU8 CurSrc, tU8 PosNextSrc
*
* RETURNVALUE: tU16.
*
*******************************************************************************/
tU16 stateControl::u16GuardIsTunerSource(tU8 CurSrc, tU8 PosNextSrc)
{
  ETG_TRACE_USR4(("Entered u16GuardIsTunerSource"));
  (tVoid)PosNextSrc;
  source* poSourcePtr = OSAL_NULL;
  tU16 RetValue = (tU16)stateController::GUARD_UNDEF;

  if(OSAL_NULL != m_posourcefactory)
     poSourcePtr = m_posourcefactory->poSourcePtr(CurSrc);

  if(OSAL_NULL != m_poResourceMgr && OSAL_NULL != poSourcePtr)
  {
    if(m_poResourceMgr->u8GetCurSrcinSM(poSourcePtr->u8GetSourceSupportedStream()) == CurSrc &&
       (CurSrc == (tU8)midw_fi_tcl_e8_AudSource::FI_EN_FM ||CurSrc == (tU8)midw_fi_tcl_e8_AudSource::FI_EN_AM))
    {
      RetValue = (tU16)stateController::GUARD_TUNER_SOURCE;
    }
  }

  return RetValue;
}

// daw2hi: check if compatible
/*******************************************************************************/
tU16 stateControl::u16GuardIsNewSink(tU8 CurSrc, tU8 PosNextSrc)
{
  ETG_TRACE_USR4(("Entered u16GuardIsNewSink Src %d, PosNextSrc %d",CurSrc, PosNextSrc));
  if(m_poResourceMgr->bIsSourceAllocated(CurSrc)==true)
  {
        // if the source is not allocated, we have to respond different
      ETG_TRACE_USR4(("u16GuardIsNewSink GUARD_NEW_SINK"));
      return (tU16)stateController::GUARD_NEW_SINK;
  }
  else
  {
      ETG_TRACE_USR4(("u16GuardIsNewSink GUARD_NEW_SINK_OTHERSOURCE"));
      return (tU16)stateController::GUARD_NEW_SINK_OTHERSOURCE;
  }

}
/*******************************************************************************
*
* FUNCTION:    stateControl::vResetDQueueSrcActivityCall()
*
* DESCRIPTION: function to clear all DQueueSrcActivityCall
*         vdu1kor - fix issue (SUZUKI-22943)
*
* PARAMETER:   NULL
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid stateController::vResetDQueueSrcActivityCall()
{
  ETG_TRACE_USR4(("Entered vResetDQueueSrcActivityCall"));

  if(!QueueSrcActivityCall.empty())
  {
    deque<SrcActivityCall>::iterator iter = QueueSrcActivityCall.begin();
    while(iter != QueueSrcActivityCall.end())
    {
      ETG_TRACE_USR4(("vResetDQueueSrcActivityCall,Src : %d SubSource : %d Activity : %d", iter->Source, iter->SubSource, iter->Activity));
      iter = QueueSrcActivityCall.erase(iter);
    }
  }
  else
  {
    ETG_TRACE_USR4(("vResetDQueueSrcActivityCall, QueueSrcActivityCall is Empty ! "));
  }

}

/*******************************************************************************
*
* FUNCTION:    stateControl::vResetDQueueSrcActivityCall()
*
* DESCRIPTION: function to check if source is found in QueueSrcActivityCall
*
* PARAMETER:   NULL
*
* RETURNVALUE: None.
*
*******************************************************************************/
tBool fc_audioroutemgr_tclresourcemanager::bIsSourceFoundInQueue(stateController* postateControllr, tU8 CurSrc, tU16 SubSource)
{
    if (!postateControllr)
    {
        ETG_TRACE_ERR(("bIsSourceFoundInQueue: postateControllr is NULL"));
        return false;
    }

    for (auto it = postateControllr->QueueSrcActivityCall.begin(); it != postateControllr->QueueSrcActivityCall.end(); ++it)
    {
        if (it->Source == CurSrc)
        {
            if (CurSrc == midw_fi_tcl_e8_AudSource::FI_EN_CPRA2)
            {
                if (it->SubSource == SubSource)
                {
                    ETG_TRACE_USR4(("Source found media Src : %d/%d for sink %d ", it->Source, it->SubSource, it->Resource));
                    return true;
                }
            }
            else
            {
                ETG_TRACE_USR4(("Source found not media Src : %d/%d for sink %d ", it->Source, it->SubSource, it->Resource));
                return true;
            }
        }
    }
    return false;
}
