/*******************************************************************************
*
* FILE:          FC_AudioRouteMgr_audiosource.h
*
* SW-COMPONENT:  FC_AudioRouteMgr application
*
* PROJECT:       NISSAN LCN2KAI
*
* DESCRIPTION:   Audio Sources Class
*
* AUTHOR:        Vaijayanti Vadiraj (RBEI/ECV4), Ravindra Kumar Rajendran (RBEI/ECV4)
*
* COPYRIGHT:    (c) 2012 RBEI
*
*******************************************************************************/


/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

# ifndef _FC_AUDIOROUTEMGR_AUDIOSOURCE_H
# define _FC_AUDIOROUTEMGR_AUDIOSOURCE_H

#include "../fc_audioroutemgr_main.h"
#include "midw_fi_if.h"
#include "fc_audioroutemgr_sourcefactory.h"
#include "fc_audioroutemgr_sourceif.h"
/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION --- Source                                                */
/*                                                                            */
/******************************************************************************/
class source
{
   public:

/******************************************************************************/
/*                                                                            */
/* ENUMS                                                                    */
/*                                                                            */
/******************************************************************************/
enum enRoutingIf
{
  SRCROUTE_INTERFACE = 0,
  STREAMROUTER_INTERFACE = 1
};

enum enSrcMuteState
{
  SRC_MUTE_NONE = 0,
    SRC_MUTE = 1,
    SRC_DEMUTE = 2,
    SRC_DEMUTE_RUNNING = 3
};

enum enSrcState
{
  SRC_STATE_OFF = 0,
  SRC_STATE_OFF_IP = 3,
  SRC_STATE_ON = 1,
  SRC_STATE_ON_IP = 4,
  SRC_STATE_PAUSE_IP = 5,
  SRC_STATE_PAUSE = 2,
  SRC_STATE_ALLOCATE_IP = 6
};

enum enActivity
{
  ACT_PAUSE = 2,
  ACT_ON = 1,
  ACT_OFF = 0
};

enum enStreamSupported
{
  STREAM_MAIN = 1,
  STREAM_MIX1 = 2,
  STREAM_MIX2 = 3,
  STREAM_MIX3 = 4
};

typedef enum
{
  VOLUMELOCK_OFF = 0,
  VOLUMELOCK_TOTAL = 1,
  VOLUMELOCK_INCREASING = 2
}enVolumeLockType;
  //Constructor
  source(tU8 src, tU8 srctype, tU16 ramp, tBool mutereq, source::enSrcMuteState muteState, source::enSrcState srcState, tU16 RtIf,tU16 ucid, tU16 AppID, tU16 srcactivity, tU8 reason, source::enSrcMuteState srcchngmutestate, tU16 subsrc, tU8 srcavailability, tU8 srcavailreason, enVolumeLockType vollocktype, fc_audioroutemgr_tclApp* poCcaMainApp);
  //Destructor
  virtual ~ source();

    tVoid vSendAllocate(tU8 CurSrc, tU8 PosNextSrc, tU16 SubSource=0);
    tVoid vSendAllocate(tU8 CurSrc, tU8 PosNextSrc, tU16 SubSource, tU16 Sink);
    tVoid vSendDeAllocate(tU8 CurSrc, tU8 PosNextSrc, tU16 SubSource=0);
    tVoid vSrcActOn(tU8 CurSrc, tU8 PosNextSrc, tU16 SubSource);
    tVoid vSrcActOn(tU8 CurSrc, tU8 PosNextSrc, tU16 SubSource, tU16 Sink);
    tVoid vSrcActOff(tU8 CurSrc, tU8 PosNextSrc, tU16 SubSource);
    tVoid vSrcActPause(tU8 CurSrc, tU8 PosNextSrc, tU16 SubSource);
    tU16  u16GetMuteRamp() const;
    tU8   u8GetSourceSupportedStream() const;
    tU16  u16GetUCID() const;
    tU16  u16GetAppID() const;
    tU16  u16GetRoutingIf() const;
    tU8   u8GetSourceID() const;
    tVoid vSetSrcChngMuteState(source::enSrcMuteState MuteState);
    source::enSrcMuteState enGetSrcChngMuteState() const;
    tVoid vSetState(source::enSrcState state);
    tU16  u16GetActivity() const;
    tU8   u8GetReason() const;
    tVoid vSetCompMuteState(source::enSrcMuteState MuteState);
    source::enSrcState enGetState() const;
    source::enSrcMuteState enGetCompMuteState() const;
    tU16 u16GetSubSrc() const;
    tU8 u8GetSrcAvailReason() const;
    tU8 u8GetSrcAvailability() const;
    tVoid vSetVolLockType(enVolumeLockType);
    enVolumeLockType enGetVolLockType() const;
    source_If* pogetClientHandler();
    tU8 isComponentMuteActive(tU8 Resource);
    tVoid vSetisComponentMuteActive(tU8 Resource,bool State);

    tBool bAddSink(tU16 Sink);
    tBool bRemoveSink(tU16 Sink);
    tBool bIsSinkVectorEmpty();
    tU32 pGetNumberOfSinks();
    std::vector<tU16> getSinkList();

    tU8 m_u8CompMuteSink1;
    tU8 m_u8CompMuteSink2;
    tU8 m_u8CompMuteSink17;

   private:

    tU8 m_u8SrcID;
    tU8 m_u8StreamSupported;
    tU16 m_u16MuteRamp;
    tBool m_bMuteReq;

    source::enSrcMuteState m_enMuteState;
    source::enSrcState m_enSrcState;
    tU16 m_u16RoutingIf;
    tU16 m_u16SrcUCID;
    tU16 m_u16AppID;
    tU16 m_u16SrcActivity;
    tU8 m_u8Reason;
    source::enSrcMuteState m_enSrcChngMuteState;
    tU16 m_u16SubSrc;
    tU8 m_u8SrcAvailability;
    tU8 m_u8SrcAvailReason;

    enVolumeLockType m_enVolLockType;

  fc_audioroutemgr_tclApp* m_poCcaMainApp;
  vector<tU16>m_Sinks;
};

#endif
