/*******************************************************************************
*
* FILE:          FC_AudioRouteMgr_clienthandler_AudioRouteMgr_StreamRouter.cpp
*
* SW-COMPONENT:  FC_AudioRouteMgr application
*
* PROJECT:       NISSAN LCN2KAI
*
* DESCRIPTION:   CCA client-handler for the service AudioRouteMgr_StreamRouter.
*
* AUTHOR:        Ravindra Kumar Rajendran (RBEI/ECV4)
*
* COPYRIGHT:    (c) 2012 RBEI.
*
*******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#include "../fc_audioroutemgr_main.h"
#include "fc_audioroutemgr_clienthandler_streamrouter.h"
#include "../ResourceMgmt/fc_audioroutemgr_audiosource.h"
#include "../fc_audioroutemgr_service_audioroutemgr.h"
#include "../ResourceMgmt/fc_audioroutemgr_resourcemanager.h"

                             // Include message framework interface (AMT, msgfw)
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

                                          //Include FI interface of used service
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_STREAMROUTERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_STREAMROUTERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_STREAMROUTERFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_STREAMROUTERFI_SERVICEINFO

#include "midw_fi_if.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#include "../Trace/fc_audioroutemgr_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOROUTEMGR_CLIENTHANDLER_STREAMROUTER
#include "trcGenProj/Header/fc_audioroutemgr_clienthandler_streamrouter.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

                                             // Version defines for used service
#define AUDIOROUTEMGR_STREAMROUTER_FI_MAJOR_VERSION  1
#define AUDIOROUTEMGR_STREAMROUTER_FI_MINOR_VERSION  0

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter, ahl_tclBaseWork)

  // Add your ON_MESSAGE_SVCDATA() macros here to define which corresponding
  // method should be called on receiving a specific message.
ON_MESSAGE_SVCDATA(MIDW_STREAMROUTERFI_C_U16_ALLOCATEROUTE, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, vHandleAllocateRoute_MethodResult)
ON_MESSAGE_SVCDATA(MIDW_STREAMROUTERFI_C_U16_ALLOCATEROUTE, AMT_C_U8_CCAMSG_OPCODE_ERROR, vHandleAllocateRoute_Error)
ON_MESSAGE_SVCDATA(MIDW_STREAMROUTERFI_C_U16_DEALLOCATEROUTE, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, vHandleDeAllocateRoute_MethodResult)
ON_MESSAGE_SVCDATA(MIDW_STREAMROUTERFI_C_U16_DEALLOCATEROUTE, AMT_C_U8_CCAMSG_OPCODE_ERROR, vHandleDeAllocateRoute_Error)
ON_MESSAGE_SVCDATA(MIDW_STREAMROUTERFI_C_U16_SETPLAY, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, vHandleSetPlay_MethodResult)
ON_MESSAGE_SVCDATA(MIDW_STREAMROUTERFI_C_U16_SETPLAY, AMT_C_U8_CCAMSG_OPCODE_ERROR, vHandleSetPlay_Error)
ON_MESSAGE_SVCDATA(MIDW_STREAMROUTERFI_C_U16_SETSTOP, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, vHandleSetStop_MethodResult)
ON_MESSAGE_SVCDATA(MIDW_STREAMROUTERFI_C_U16_SETSTOP, AMT_C_U8_CCAMSG_OPCODE_ERROR, vHandleSetStop_Error)
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::
*             fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter(fc_audioroutemgr_tclApp* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::
  fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter(fc_audioroutemgr_tclApp* poMainAppl, fc_audioroutemgr_tclresourcemanager* poResourceMgr)
    : ahl_tclBaseOneThreadClientHandler(
      /* Application Pointer          */ poMainAppl,
      /* ID of used Service           */ CCA_C_U16_SRV_STREAMROUTER,
      /* MajorVersion of used Service */ AUDIOROUTEMGR_STREAMROUTER_FI_MAJOR_VERSION,
      /* MinorVersion of used Service */ AUDIOROUTEMGR_STREAMROUTER_FI_MINOR_VERSION
                                       )
{
  m_poResourceMgr = poResourceMgr;
  m_poMainAppl = poMainAppl;
  m_u8Source = (tU8)midw_fi_tcl_e8_AudSource::FI_EN_NONE;
  m_u8pendingRequest = REQUEST_NONE;
  m_u8pendingRequestSrc = (tU8)midw_fi_tcl_e8_AudSource::FI_EN_NONE;
    ETG_TRACE_USR4(("fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter() entered."));
}

/*******************************************************************************
*
* FUNCTION: fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::
*             ~fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::
  ~fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter(tVoid)
{
  ETG_TRACE_USR4(("~fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter() entered."));
  m_poResourceMgr = NULL;
  m_poMainAppl = NULL;
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::vOnServiceAvailable()
{
  ETG_TRACE_USR4(("vOnServiceAvailable() entered. AppID = %u.",
                  u16GetServerAppID()));

  vCheckforPendingRequests();
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::vOnServiceUnavailable()
{
  ETG_TRACE_USR4(("vOnServiceUnavailable() entered. AppID = %u.",
                  u16GetServerAppID()));
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::vProcessTimer(tU16 u16TimerId)
*
* DESCRIPTION: This function is called from the superior application of this
*              client-handler in case of the expiration of a timer.
*
* PARAMETER: [IN] u16TimerId = Identifier of the expired timer.
*
* RETURNVALUE: -
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::vProcessTimer(tU16 u16TimerId) const
{
  ETG_TRACE_USR4(("vProcessTimer() entered. TimerID = %u.",u16TimerId));
  if(TRUE == bIfServiceAvailable())
  {
    // Create message for used service.
  }

}
/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::vProcessTimer(tU16 u16TimerId)
*
* DESCRIPTION: Receives TTFis Trace Commands.
*
* PARAMETER:   tPCUChar pcu8Data.
*
* RETURNVALUE: -
*
*******************************************************************************/

tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::vTraceRx(tU32 size, tPCUChar pcu8Data)
{
   ETG_TRACE_USR4(("vTraceRx() entered."));

   if(pcu8Data == OSAL_NULL) return;
   // pcu8Data[0] == my file number
   // pcu8Data[1] == the command
   // pcu8Data[2] == the 1. parameter
   // rest is defined here

   ETG_TRACE_USR4(("vTraceRx() size=%u",size));
   if (size > 2)
   {
    ETG_TRACE_USR4(("vTraceRx() pcu8Data[0] [1] =%u %u",(tU16)pcu8Data[0],(tU16)pcu8Data[1]));
      switch ( pcu8Data[1] )
      {
        case TRC::NotifyAllocateRoute:
        if(m_poResourceMgr != OSAL_NULL)
          {
          m_poResourceMgr->vNotifyAllocateRoute(pcu8Data[2]);
          }
        else
          ETG_TRACE_USR4(("NotifyAllocateRoute too few params %u",size));
         break;

        case TRC::NotifyDeAllocateRoute:
      if(m_poResourceMgr != OSAL_NULL)
      {
      m_poResourceMgr->vNotifyDeAllocateRoute(pcu8Data[2]);
      }
      else
        ETG_TRACE_USR4(("NotifyDeAllocateRoute too few params %u",size));
       break;

        case TRC::NotifySetPlay:
     if(m_poResourceMgr != OSAL_NULL)
      {
       m_poResourceMgr->vNotifySetPlay(pcu8Data[2]);
      }
     else
       ETG_TRACE_USR4(("NotifyDeAllocateRoute too few params %u",size));
       break;

        case TRC::NotifySetStop:
            if(m_poResourceMgr != OSAL_NULL)
               {
              m_poResourceMgr->vNotifySetStop(pcu8Data[2]);
               }
             else
                ETG_TRACE_USR4(("NotifyDeAllocateRoute too few params %u",size));
                break;

      default:
        ETG_TRACE_USR4(("default"));
         break;
      }
   }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::
*               vHandleAllocateRoute_MethodResult(amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the AllocateRoute Method Result.
*
* PARAMETER:   poMessage- Pointer to the CCA Message
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::vHandleAllocateRoute_MethodResult(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("vHandleAllocateRoute_MethodResult() entered."));

  if(poMessage)
     {
       fi_tclVisitorMessage oVisitorMsg(poMessage);
       midw_streamrouterfi_tclMsgAllocateRouteMethodResult oMethodResult;

       if (oVisitorMsg.s32GetData(oMethodResult, AUDIOROUTEMGR_STREAMROUTER_FI_MAJOR_VERSION) != OSAL_ERROR)
       {
            ETG_TRACE_USR4(("received Allocate Route MethodResult for UCID %d",oMethodResult.u16UCID));
       }

      tU16 u16UCID = oMethodResult.u16UCID;

      if(m_poResourceMgr != OSAL_NULL)
       {
        m_poResourceMgr->vNotifyAllocateRoute(u16UCID);
       }
      else
       {
               //do nothing
       }
      oMethodResult.vDestroy();
   }
   else
   {
         //My message is a NULL Pointer
    ETG_TRACE_USR4(("vHandleAllocateRoute_MethodResult() message is NULL"));
      NORMAL_M_ASSERT_ALWAYS();
   }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::
*               vHandleAllocateRoute_Error(amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the AllocateRoute Error.
*
* PARAMETER:   poMessage- Pointer to the CCA Message
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::vHandleAllocateRoute_Error(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("vHandleAllocateRoute_Error() entered."));

   amt_tclServiceDataError oErrorMsg( poMessage );
   tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();

   ETG_TRACE_ERR(("vHandleAllocateRoute_Error::Error Code:%d",u16ErrorCode));
   if((OSAL_NULL != m_poMainAppl) && (OSAL_NULL != m_poResourceMgr) && OSAL_NULL != m_poMainAppl->poGetAudioRouteMgrServiceHandler())
   {
    /* Resetting the state to Stable state*/
     m_poResourceMgr->poselStateController(m_u8Source)->vResetState((tU16)stateController::DEALLOCATED);
     m_poResourceMgr->vNotifySourceState(m_u8Source, (tU8)source::SRC_STATE_OFF);
    /* Forwarding the Error Msg to HMI*/
     m_poMainAppl->poGetAudioRouteMgrServiceHandler()->vSendErrorMsg(poMessage, (tU16)ALLOCATE_ERROR);
   }
}
/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::
*               vHandleDeAllocateRoute_MethodResult(amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the DeAllocateRoute Method Result.
*
* PARAMETER:   poMessage- Pointer to the CCA Message
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::vHandleDeAllocateRoute_MethodResult(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("vHandleDeAllocateRoute_MethodResult() entered."));

  if(poMessage)
     {
      fi_tclVisitorMessage oVisitorMsg(poMessage);
      midw_streamrouterfi_tclMsgDeAllocateRouteMethodResult oMethodResult;

      if (oVisitorMsg.s32GetData(oMethodResult, AUDIOROUTEMGR_STREAMROUTER_FI_MAJOR_VERSION) != OSAL_ERROR)
         {
           ETG_TRACE_USR4(("received DeAllocate Route MethodResult for UCID %d",oMethodResult.u16UCID));
         }
      tU16 u16UCID = oMethodResult.u16UCID;

       if(m_poResourceMgr != OSAL_NULL)
       {
         m_poResourceMgr->vNotifyDeAllocateRoute(u16UCID);
       }
       else
       {
               //do nothing
       }
       oMethodResult.vDestroy();
   }
   else
    {
                    //My message is a NULL Pointer
          ETG_TRACE_USR4(("vHandleDeAllocateRoute_MethodResult() message is NULL"));
       NORMAL_M_ASSERT_ALWAYS();
      }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::
*               vHandleDeAllocateRoute_Error(amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the DeAllocateRoute Error.
*
* PARAMETER:   poMessage- Pointer to the CCA Message
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::vHandleDeAllocateRoute_Error(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("vHandleDeAllocateRoute_Error() entered."));

   amt_tclServiceDataError oErrorMsg( poMessage );
   tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();

   ETG_TRACE_ERR(("vHandleDeAllocateRoute_Error::Error Code:%d",u16ErrorCode));
   if((OSAL_NULL != m_poMainAppl) && (OSAL_NULL != m_poResourceMgr) && OSAL_NULL != m_poMainAppl->poGetAudioRouteMgrServiceHandler())
   {
    /* Resetting the state to Stable state*/
     m_poResourceMgr->poselStateController(m_u8Source)->vResetState((tU16)stateController::DEALLOCATED);
     m_poResourceMgr->vNotifySourceState(m_u8Source, (tU8)source::SRC_STATE_OFF);
    /* Forwarding the Error Msg to HMI*/
     m_poMainAppl->poGetAudioRouteMgrServiceHandler()->vSendErrorMsg(poMessage, (tU16)DEALLOCATE_ERROR);
   }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::
*               vHandleSetPlay_MethodResult(amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the SetPlay Method Result.
*
* PARAMETER:   poMessage- Pointer to the CCA Message
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::vHandleSetPlay_MethodResult(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("vHandleSetPlay_MethodResult() entered."));

  if(poMessage)
    {
     fi_tclVisitorMessage oVisitorMsg(poMessage);

      midw_streamrouterfi_tclMsgSetPlayMethodResult oMethodResult;

      if (oVisitorMsg.s32GetData(oMethodResult, AUDIOROUTEMGR_STREAMROUTER_FI_MAJOR_VERSION) != OSAL_ERROR)
         {
           ETG_TRACE_USR4(("received SetPlay MethodResult for UCID: %d",oMethodResult.u16UCID));
         }

       tU16 u16UCID = oMethodResult.u16UCID;

       if(m_poResourceMgr != OSAL_NULL)
        {
         m_poResourceMgr->vNotifySetPlay(u16UCID);
        }
       else
       {
               //do nothing
        }
       oMethodResult.vDestroy();
   }
   else
    {
                    //My message is a NULL Pointer
          ETG_TRACE_USR4(("vHandleSetPlay_MethodResult() message is NULL"));
       NORMAL_M_ASSERT_ALWAYS();
      }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::
*               vHandleSetPlay_Error(amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the SetPlay Error.
*
* PARAMETER:   poMessage- Pointer to the CCA Message
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::vHandleSetPlay_Error(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("vHandleSetPlay_Error() entered."));

   amt_tclServiceDataError oErrorMsg( poMessage );
   tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();

   ETG_TRACE_ERR(("vHandleSetPlay_Error::Error Code:%d",u16ErrorCode));
   if((OSAL_NULL != m_poMainAppl) && (OSAL_NULL != m_poResourceMgr) && OSAL_NULL != m_poMainAppl->poGetAudioRouteMgrServiceHandler())
   {
    /* Resetting the state to Stable state*/
     m_poResourceMgr->poselStateController(m_u8Source)->vResetState((tU16)stateController::DEALLOCATED);
     m_poResourceMgr->vNotifySourceState(m_u8Source, (tU8)source::SRC_STATE_OFF);
    /* Forwarding the Error Msg to HMI*/
     m_poMainAppl->poGetAudioRouteMgrServiceHandler()->vSendErrorMsg(poMessage, (tU16)SRCACTIVITY_ERROR);
   }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::
*               vHandleSetStop_MethodResult(amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the SetStop Method Result.
*
* PARAMETER:   poMessage- Pointer to the CCA Message
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::vHandleSetStop_MethodResult(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("vHandleSetStop_MethodResult() entered."));

  if(poMessage)
  {
      fi_tclVisitorMessage oVisitorMsg(poMessage);

        midw_streamrouterfi_tclMsgSetStopMethodResult oMethodResult;

      if (oVisitorMsg.s32GetData(oMethodResult, AUDIOROUTEMGR_STREAMROUTER_FI_MAJOR_VERSION) != OSAL_ERROR)
      {
           ETG_TRACE_USR4(("received SetStop MethodResult for UCID: %d",oMethodResult.u16UCID));
      }

      tU16 u16UCID = oMethodResult.u16UCID;

      if(m_poResourceMgr != OSAL_NULL)
        {
        m_poResourceMgr->vNotifySetStop(u16UCID);
      }
       else
        {
               //do nothing
         }
      oMethodResult.vDestroy();
  }
   else
    {
                    //My message is a NULL Pointer
          ETG_TRACE_USR4(("vHandleSetStop_MethodResult() message is NULL"));
       NORMAL_M_ASSERT_ALWAYS();
      }

}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::
*               vHandleSetStop_Error(amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the SetPlay Error.
*
* PARAMETER:   poMessage- Pointer to the CCA Message
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::vHandleSetStop_Error(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("vHandleSetStop_Error() entered."));

   amt_tclServiceDataError oErrorMsg( poMessage );
   tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();

   ETG_TRACE_ERR(("vHandleSetStop_Error::Error Code:%d",u16ErrorCode));
   if((OSAL_NULL != m_poMainAppl) && (OSAL_NULL != m_poResourceMgr) && OSAL_NULL != m_poMainAppl->poGetAudioRouteMgrServiceHandler())
   {
    /* Resetting the state to Stable state*/
     m_poResourceMgr->poselStateController(m_u8Source)->vResetState((tU16)stateController::DEALLOCATED);
     m_poResourceMgr->vNotifySourceState(m_u8Source, (tU8)source::SRC_STATE_OFF);
    /* Forwarding the Error Msg to HMI*/
     m_poMainAppl->poGetAudioRouteMgrServiceHandler()->vSendErrorMsg(poMessage, (tU16)SRCACTIVITY_ERROR);
   }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::
*                              vPerformAllocateRoute(tU8 CurSrc,tU8 PosNextSrc)
*
* DESCRIPTION: Sends the CCA Message to AllocateRoute for the New source
*
* PARAMETER:   tU8 CurSrc,tU8 PosNextSrc
*
* RETURNVALUE: None.
*
***********************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::vPerformAllocate(tU8 CurSrc,tU8 PosNextSrc, tU16 SubSource)
{
  ETG_TRACE_USR4(("clh STR vPerformAllocateRoute set Sink to 1, CurSrc %d, PosNextSrc %d, SubSource %d",CurSrc,PosNextSrc,SubSource));
}
/***********************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::vPerformAllocate(tU8 CurSrc,tU8 PosNextSrc, tU16 SubSource, tU16 Sink)
{
  ETG_TRACE_USR4(("Entered fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::vPerformAllocateRoute %d, Sink %d",CurSrc,Sink));

  (tVoid)CurSrc; // Lint
  (tVoid)SubSource;

  source* poSourcePtr = OSAL_NULL;

  if(OSAL_NULL != poSourceFactory())
    poSourcePtr = poSourceFactory()->poSourcePtr(CurSrc);

  if((OSAL_NULL != _poMainAppl) && OSAL_NULL != poSourcePtr)
  {
    midw_streamrouterfi_tclMsgAllocateRouteMethodStart oallocateRoute;
    m_u8Source = PosNextSrc;
    oallocateRoute.u16UCID = poSourcePtr->u16GetUCID();
    oallocateRoute.s32STM_MsgBufID = (tS32)0xffff;  //default Value
    oallocateRoute.u16Sink = Sink;

    fi_tclVisitorMessage oCCaMsg(oallocateRoute);
    oCCaMsg.vInitServiceData( _poMainAppl->u16GetAppId(),   // Source AppID
                   CCA_C_U16_APP_STREAMROUTER,  // Target AppID
                   AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
                   0,
                   u16GetRegID(),
                   0,
                   CCA_C_U16_SRV_STREAMROUTER,
                   MIDW_STREAMROUTERFI_C_U16_ALLOCATEROUTE,
                   AMT_C_U8_CCAMSG_OPCODE_METHODSTART
                  );

      if(bIfServiceAvailable())
      {
           tU16 u16ErrCode = (tU16)_poMainAppl->enPostMessage(&oCCaMsg,TRUE);
         if(u16ErrCode == (tU16)AIL_EN_N_NO_ERROR)
         {
            ETG_TRACE_USR4(("Sending Allocate Route Successful"));
         }
        else
        {
           ETG_TRACE_USR4(("Sending AllocateRoute not Successful, ErrCode:%d Regid: %d",u16ErrCode,u16GetRegID()));
        }
      }
      else
      {
        ETG_TRACE_ERR(("Service AllocateRoute not available"));
        /* IF service is not available Store the Request and the Source Requested, to send calls again when service becomes available */
        //Resetting the state to DeAllocated to allow further Source changes.
        if(m_poResourceMgr != OSAL_NULL)
        {
         m_poResourceMgr->poselStateController(PosNextSrc)->vResetState((tU16)stateController::DEALLOCATED);
        }
        this->m_u8pendingRequest = REQUEST_ALLOCATEROUTE;
        this->m_u8pendingRequestSrc = (tU8)(midw_fi_tcl_e8_AudSource::tenType)PosNextSrc;
      }
      oallocateRoute.vDestroy();
   }
  else
  {
        ETG_TRACE_ERR(("Fatal Error: poCcaMainApp = NULL"));
      ETG_TRACE_USR4(("Sending AllocateRoute ERROR !!!!"));
  }

}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::
*                              vPerformDeallocateRoute(tU8 CurSrc,tU8 PosNextSrc)
*
* DESCRIPTION: Sends the CCA Message to Deallocate Route for the current source
*
* PARAMETER:   tU8 CurSrc,tU8 PosNextSrc
*
* RETURNVALUE: None.
*
***********************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::vPerformDeAllocate(tU8 CurSrc,tU8 PosNextSrc, tU16 SubSource)
{
  ETG_TRACE_USR4(("Entered fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::vPerformDeallocateRoute"));

  (tVoid)PosNextSrc;  // Lint
  (tVoid)SubSource;
  source* poSourcePtr = OSAL_NULL;

  if(OSAL_NULL != poSourceFactory())
    poSourcePtr = poSourceFactory()->poSourcePtr(CurSrc);

  if((OSAL_NULL != _poMainAppl) && OSAL_NULL != poSourcePtr)
  {
    midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart oDeallocateRoute;
    m_u8Source = CurSrc;
    oDeallocateRoute.u16UCID = poSourcePtr->u16GetUCID();

    fi_tclVisitorMessage oCCaMsg(oDeallocateRoute);
    oCCaMsg.vInitServiceData( _poMainAppl->u16GetAppId(),   // Source AppID
                   CCA_C_U16_APP_STREAMROUTER,  // Target AppID
                   AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
                   0,
                   u16GetRegID(),
                   0,
                   CCA_C_U16_SRV_STREAMROUTER,
                   MIDW_STREAMROUTERFI_C_U16_DEALLOCATEROUTE,
                   AMT_C_U8_CCAMSG_OPCODE_METHODSTART
                 );

      if(bIfServiceAvailable())
      {
        if (_poMainAppl->enPostMessage(&oCCaMsg, TRUE) !=  AIL_EN_N_NO_ERROR)
        {
          ETG_TRACE_ERR(("Error Sending DeallocateRoute"));
          ETG_TRACE_USR4(("regId = %d",u16GetRegID()));
          NORMAL_M_ASSERT_ALWAYS();
        }
        else
        {
          ETG_TRACE_USR4(("Sending DeallocateRoute Successful"));
        }

      }
      else
      {
        ETG_TRACE_ERR(("Service DeallocateRoute not available"));
         /* IF StreamRouter Service is not available, Answer DeAllocate immmediately as per ErrorHandlingConcept */
        if(m_poResourceMgr != OSAL_NULL)
        {
         m_poResourceMgr->vNotifyDeAllocateRoute((tU16)oDeallocateRoute.u16UCID);
        }
      }
      oDeallocateRoute.vDestroy();
    }
    else
    {
         ETG_TRACE_ERR(("Fatal Error: poCcaMainApp = NULL"));
        ETG_TRACE_USR4(("Sending DeallocateRoute ERROR !!!!"));
    }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::
*                              vPerformSetPlay(tU8 CurSrc,tU8 PosNextSrc)
*
* DESCRIPTION: Sends the CCA Message to Play the New source
*
* PARAMETER:   tU8 CurSrc,tU8 PosNextSrc
*
* RETURNVALUE: None.
*
***********************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::vPerformPlay(tU8 CurSrc,tU8 PosNextSrc, tU16 SubSource)
{
  ETG_TRACE_USR4(("Entered fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::vPerformSetPlay"));

  (tVoid)CurSrc;  // Lint
  (tVoid)SubSource;

  source* poSourcePtr = OSAL_NULL;

  if(OSAL_NULL != poSourceFactory())
    poSourcePtr = poSourceFactory()->poSourcePtr(CurSrc);

  if((OSAL_NULL != _poMainAppl) && OSAL_NULL != poSourcePtr)
  {
    midw_streamrouterfi_tclMsgSetPlayMethodStart oSetPlay;
    m_u8Source = PosNextSrc;
    oSetPlay.u16UCID = poSourcePtr->u16GetUCID();
    oSetPlay.eRampType.enType = midw_fi_tcl_e8_streamrouter_ramptype::FI_EN_MEDIUM;   //hard coded value. Value not used by StreamRouter

    fi_tclVisitorMessage oCCaMsg(oSetPlay);
    oCCaMsg.vInitServiceData( _poMainAppl->u16GetAppId(),   // Source AppID
                   CCA_C_U16_APP_STREAMROUTER,  // Target AppID
                   AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
                   0,
                   u16GetRegID(),
                   0,
                   CCA_C_U16_SRV_STREAMROUTER,
                   MIDW_STREAMROUTERFI_C_U16_SETPLAY,
                   AMT_C_U8_CCAMSG_OPCODE_METHODSTART
                    );
      if(bIfServiceAvailable())
      {
        if (_poMainAppl->enPostMessage(&oCCaMsg, TRUE) !=  AIL_EN_N_NO_ERROR)
        {
          ETG_TRACE_ERR(("Error Sending SetPlay"));
          ETG_TRACE_USR4(("regId = %d",u16GetRegID()));
          NORMAL_M_ASSERT_ALWAYS();
        }
        else
        {
          ETG_TRACE_USR4(("Sending SetPlay Successful"));
        }

      }
      else
      {
        ETG_TRACE_ERR(("Service SetPlay not available"));
        /* IF service is not available Store the Request and the Source Requested, to send calls again when service becomes available */
        //Resetting the state to Allocated to allow further Source changes.
        if(m_poResourceMgr != OSAL_NULL)
        {
         m_poResourceMgr->poselStateController(PosNextSrc)->vResetState((tU16)stateController::ALLOCATED);
        }
        this->m_u8pendingRequest = REQUEST_SETPLAY;
        this->m_u8pendingRequestSrc = (tU8)(midw_fi_tcl_e8_AudSource::tenType)PosNextSrc;
      }
      oSetPlay.vDestroy();
    }
    else
    {
         ETG_TRACE_ERR(("Fatal Error: poCcaMainApp = NULL"));
    }
}
/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::
*                              vPerformPause(tU8 CurSrc,tU8 PosNextSrc)
*
* DESCRIPTION: Sends the CCA Message to Stop the current source
*
* PARAMETER:   tU8 CurSrc,tU8 PosNextSrc
*
* RETURNVALUE: None.
*
***********************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::vPerformPause(tU8 CurSrc,tU8 PosNextSrc, tU16 SubSource)
{
  ETG_TRACE_USR4(("Entered PerformPause"));
  vPerformStop(CurSrc,PosNextSrc, SubSource);
}

/*******************************************************************************
*
*                              vPerformSetStop(tU8 CurSrc,tU8 PosNextSrc)
*
* DESCRIPTION: Sends the CCA Message to Stop the current source
*
* PARAMETER:   tU8 CurSrc,tU8 PosNextSrc
*
* RETURNVALUE: None.
*
***********************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::vPerformStop(tU8 CurSrc,tU8 PosNextSrc, tU16 SubSource)
{
  ETG_TRACE_USR4(("Entered fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::vPerformSetStop"));

  (tVoid)PosNextSrc;  // Lint
  (tVoid)SubSource;

  source* poSourcePtr = OSAL_NULL;

  if(OSAL_NULL != poSourceFactory())
    poSourcePtr = poSourceFactory()->poSourcePtr(CurSrc);

  if((OSAL_NULL != _poMainAppl) && OSAL_NULL != poSourcePtr)
  {
    midw_streamrouterfi_tclMsgSetStopMethodStart oSetStop;
    m_u8Source = CurSrc;
    oSetStop.u16UCID = poSourcePtr->u16GetUCID();
    oSetStop.eRampType.enType = midw_fi_tcl_e8_streamrouter_ramptype::FI_EN_MEDIUM;  //hard coded value. Value not used by StreamRouter

    fi_tclVisitorMessage oCCaMsg(oSetStop);
    oCCaMsg.vInitServiceData( _poMainAppl->u16GetAppId(),   // Source AppID
                   CCA_C_U16_APP_STREAMROUTER,  // Target AppID
                   AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
                   0,
                   u16GetRegID(),
                   0,
                   CCA_C_U16_SRV_STREAMROUTER,
                   MIDW_STREAMROUTERFI_C_U16_SETSTOP,
                   AMT_C_U8_CCAMSG_OPCODE_METHODSTART
                 );
      if(bIfServiceAvailable())
      {
        if (_poMainAppl->enPostMessage(&oCCaMsg, TRUE) !=  AIL_EN_N_NO_ERROR)
        {
          ETG_TRACE_ERR(("Error Sending SetStop"));
          ETG_TRACE_USR4(("regId = %d",u16GetRegID()));
          NORMAL_M_ASSERT_ALWAYS();
        }
        else
        {
          ETG_TRACE_USR4(("Sending SetStop Successful"));
        }

      }
      else
      {
         /* IF StreamRouter Service is not available, Answer SetStop immmediately as per ErrorHandlingConcept */
        ETG_TRACE_ERR(("SetStop Service not available "));
        if(m_poResourceMgr != OSAL_NULL)
        {
          m_poResourceMgr->vNotifySetStop((tU16)oSetStop.u16UCID);
        }
      }
      oSetStop.vDestroy();
    }
    else
    {
         ETG_TRACE_ERR(("Fatal Error: poCcaMainApp = NULL"));
    }
}

/*!***********************************************************************
* METHOD:      fc_audioroutemgr_tclsourcefactory*
*                    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::
*                                                    poSourceFactory() const
*
* DESCRIPTION:     Returns Source Factory class Pointer
*
* RETURNVALUE:     fc_audioroutemgr_tclsourcefactory
*
* PARAMETER  :     None
*************************************************************************/
fc_audioroutemgr_tclsourcefactory* fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::poSourceFactory() const
{
    fc_audioroutemgr_tclsourcefactory *poSrcFactory = NULL;

  if(m_poMainAppl != OSAL_NULL)
     {
    return m_poMainAppl->poGetSourceFactory();
   }
  else
  {
    return poSrcFactory;
  }
}

/*******************************************************************************
*
* FUNCTION:    tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::
*                                                  vCheckIfAnyPendingRequests(tVoid)
*
* DESCRIPTION: Checks for any pending Requests to ARL.
*
* PARAMETER:   None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter::vCheckforPendingRequests(tVoid)
{
  if(m_poResourceMgr != OSAL_NULL && m_poResourceMgr->postateControllerEnt != OSAL_NULL)
  {
     switch(this->m_u8pendingRequest)
     {
    case REQUEST_ALLOCATEROUTE:
        vPerformAllocate(m_u8pendingRequestSrc,m_u8pendingRequestSrc);
      break;
    case REQUEST_SETPLAY:
           vPerformPlay(m_u8pendingRequestSrc,m_u8pendingRequestSrc);
      break;
    default:
      break;
      }
  }
  else
  {
     ETG_TRACE_USR4(("m_poResourceMgr is NULL"));
  }
}
