/*******************************************************************************
*
* FILE:          FC_AudioRouteMgr_clienthandler_AudioRouteMgr_SrcRoute.h
*
* SW-COMPONENT:  FC_AudioRouteMgr application
*
* PROJECT:       NISSAN LCN2KAI
*
* DESCRIPTION:   CCA client-handler for the service AudioRouteMgr_SrcRoute.
*
* AUTHOR:        Ravindra Kumar Rajendran (RBEI/ECV4)
*
* COPYRIGHT:    (c) 2012 RBEI.
*
*******************************************************************************/

#ifndef _FC_AUDIOROUTEMGR_CLIENTHANDLER_AUDIOROUTEMGR_SRCROUTE_H_
#define _FC_AUDIOROUTEMGR_CLIENTHANDLER_AUDIOROUTEMGR_SRCROUTE_H_

#include "../ResourceMgmt/fc_audioroutemgr_sourceif.h"
#include "../ResourceMgmt/fc_audioroutemgr_resourcemanager.h"
#include "../ResourceMgmt/fc_audioroutemgr_statecontroller.h"
#include "../ResourceMgmt/fc_audioroutemgr_statecontrol.h"

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class ahl_tclBaseOneThreadClientHandler;

class fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute
      : public ahl_tclBaseOneThreadClientHandler, public fc_audioroutemgr_tclTraceInput, public source_If
{
  public:

    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute(tVoid);
    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute(fc_audioroutemgr_tclApp* poMainAppl, tU16 u16AppID, fc_audioroutemgr_tclsourcefactory* posourcefactory);
    virtual ~fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute();
    /**************************************************************************
    * Assingment Operater, will not be implemented.
    * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class
    * 'fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute' which has no assignment operator.
    * NOTE: This is a technique to disable the assignment operator for this
    * class. So if an attempt for the assignment is made compiler complains.
    **************************************************************************/
    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute& operator=
      (const fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute &oClientHandler);

    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
    tVoid vProcessTimer(tU16 u16TimerId) const;

    /***************************************************************************
    * Overriding ahl_tclBaseOneThreadClientHandler methods.
    ***************************************************************************/
    virtual tVoid vOnServiceAvailable();
    virtual tVoid vOnServiceUnavailable();
    virtual tVoid vPerformAllocate(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink);
    virtual tVoid vPerformAllocate(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource=0);
    virtual tVoid vPerformDeAllocate(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource=0);
    virtual tVoid vPerformStop(tU8 CurSrc,tU8 PosNextSrc, tU16 SubSource=0);
    virtual tVoid vPerformPlay(tU8 CurSrc,tU8 PosNextSrc, tU16 SubSource=0);
    virtual tVoid vPerformPause(tU8 CurSrc,tU8 PosNextSrc, tU16 SubSource=0);
  virtual tVoid vPerformPause(tU8 CurSrc,tU8 PosNextSrc, tU16 SubSource, tU16 Sink);
    tVoid vPerformSetMuteState(tU8 Source,tU8 SrcMuteState);
    tVoid vTraceInputMuteRequestStatus(tU8,tU8,tU16);
    tVoid vTraceInputRequestAudioRoute(tU8,tU16);
    tVoid vTraceInputRequestSrcAvailability(tU8,tU8);
    tVoid vTraceInputSetAudioRoute(tU8, tU8, tS32);
  // inbox for TTFis
    virtual tVoid vTraceRx(tU32 size, tPCUChar pcu8Data);

    tVoid vPerformRouteRequestReject(tU8 Source,tU16 SubSource);
    /***************************************************************************
    * Handler function declarations used by message map.
    ***************************************************************************/

    // Add your CCA message handler function prototypes here.

    /***************************************************************************
    * Message map definition macro
    ***************************************************************************/

   DECLARE_MSG_MAP(fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute)

  private:
    tU16 m_u16ServerAppID;
    tU8  m_u8currentSrc;
    tU8  m_u8pendingRequest;
    tU8  m_u8pendingRequestSrc;
    tU16 m_u16pendingsubSource;
    tU16 m_u16pendingSink;
  fc_audioroutemgr_tclApp* m_poCcaMainApp;
  fc_audioroutemgr_tclsourcefactory* m_poSourceFactory;


    tVoid vHandleAllocate_MethodResult(amt_tclServiceData* poMessage) const;
    tVoid vHandleAllocate_Error(tU8 src, tU16 subsrc) const;
    tVoid vHandleDeAllocate_MethodResult(amt_tclServiceData* poMessage) const;
    tVoid vHandleDeallocate_Error(tU8 src, tU16 subsrc) const;
    tVoid vHandleSourceActivity_MethodResult(amt_tclServiceData* poMessage) const;
    tVoid vHandleSourceActivity_Error(tU8 src, tU16 subsrc) const;
    tVoid vHandleMuteRequest_Status(amt_tclServiceData* poMessage);
    tVoid vHandleSetAudioPropertyStatus(amt_tclServiceData* poMessage);
    tVoid vHandleRequestAudioRouteStatus(amt_tclServiceData* poMessage);
    tVoid vHandleSrcAvailabilityInfo(amt_tclServiceData* poMessage);
    tVoid vCheckIfAnyPendingRequests(tVoid);
    fc_audioroutemgr_tclresourcemanager* poResourceMgr() const;
    tVoid vProcessSrcActivityCallsInQueue(stateController*) const;
    tVoid vCheckNxtSrcAndSendProcessSrcActivityCalls(tU8 Src, tU16 subsrc, stateController*) const;
  tVoid vSendErrorMessage(midw_fi_tcl_e8_AudSource::tenType Source, tU16 SubSource, tU16 Error) const;
};

#endif // _FC_AUDIOROUTEMGR_CLIENTHANDLER_AUDIOROUTEMGR_SRCROUTE_H_

